#ifndef __G2TreeMeasure_h__
#define __G2TreeMeasure_h__

namespace BIOS {
	
  /**
     @memo G2TreeMeasure
     @doc
     Definition:
	Modification of 2G algorithm to use prior information. It adds 1 to the transmission or non-transmission frequencies depending on whether the closest haplotype to the crrent one is in G1 or G2 respectively. It start with the haplotype with the largest difference and continues from top to down in differences

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class G2TreeMeasure: public G2Measure {

private:

double s;

    
		public:
	

		/**
		*	Constructor
		*/		
		G2TreeMeasure(SampleGeneticCounts* tuCounts, double s=2, double minFreq=10, int testMode=2, SampleGeneticCounts** partialTuCountsTraining=NULL, SampleGeneticCounts** partialTuCountsTest=NULL, bool useDistance=true, bool lengthDistance=false);
		
		G2TreeMeasure(double s, double minFreq, int testMode, bool useDistances=true, bool lengthDistance=false);

				G2TreeMeasure(G2TreeMeasure& other);

double getWeightedTotalCounts(GeneticUnitVector * g, SampleGeneticCounts* aTUCounts, intSet* hapPos, doubleList* posteriors);

double getTotalCounts(GeneticUnitVector * g, GeneticUnitCountsVector* hapCountsVector, intSet* hapPos);

double getReliability(GeneticUnitVector * g, GeneticUnitCountsVector* hapCountsVector, intSet* hapPos, doubleList* posteriors);

		/**
		*	Destructor
		*/		
virtual		~G2TreeMeasure();

//void setAll();

	// virtual	TDTtable<T>*  set(SampleGeneticCounts<T>* aTUCounts=NULL);

//void set(TDTtable* aTDTtable);

virtual G2TreeMeasure* clone();

//virtual  bool getOneSide();

//virtual double getStatistic();

//virtual double getFreq ( double counts, double totalCounts,  Container<vector<T*>, T*> * groups );

  virtual G2TreeMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);

virtual GeneticUnitCountsSample* getPartition (GeneticUnitCountsVector* hapCountsVector, double totalFirst, double totalSecond);
  


FreqAndKeyVector* getOrderedHaplotypes ( GeneticUnitCountsVector* hapCountsVector);

		/**
		*	Calculate statistic from the tables 
		*/


string getName();//{return string("mTDT2G");};

// stringList* getFreqsResults();

//friend ostream& operator<<(ostream& out, G2TreeMeasure& l);


//void onePrint( ostream&, SampleTUCounts* aTuCounts, TDTtable* aTDTtable);

	};




};

#endif
