#ifndef __GroupBasedTDTMeasure_cpp__
#define __GroupBasedTDTMeasure_cpp__




namespace BIOS
{



		GroupBasedTDTMeasure::GroupBasedTDTMeasure ( SampleGeneticCounts* tuCounts, double minFreq, int testMode, SampleGeneticCounts** partialTuCountsTraining, SampleGeneticCounts** partialTuCountsTest, bool permutations, bool useDistances, bool lengthDistance ) :Chi2TDTMeasure ( tuCounts, minFreq, permutations )
	{
		try
		{
			totalMultipleTest=1;
			this->testMode=testMode;
			totalFolds=testMode;
			// if (testMode==1) totalFolds=2; // holdout
			this->lengthDistance=lengthDistance;
			this->partialTuCountsTraining=partialTuCountsTraining;
			this->partialTuCountsTest=partialTuCountsTest;
			this->useDistances=useDistances;
			partialTdtTables=NULL;
			partialTrainingTdtTables=NULL;
			totalUsedHaplotypes=0;
			totalUsedDifferentHaplotypes=0;
			if ( this->tdtTable!=NULL )
			{
//cout << "initableis:" << *tdtTable <<"\n";
				totalUsedHaplotypes= ( int ) this->tdtTable->getTotalRowCount ( 2 );
				totalUsedDifferentHaplotypes=this->tdtTable->getYDim();
			}
			//cout << "end GroupBasec constructor\n";
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GroupBasedTDTMeasure::GroupBasedTDTMeasure(TUCounts* tuCounts, double minFreq..." ); throw;};
	};

	/*_________________________________________________________________*/

		GroupBasedTDTMeasure::GroupBasedTDTMeasure ( double minFreq, int testMode, bool permutations, bool useDistances, bool lengthDistance ) :Chi2TDTMeasure ( minFreq, permutations )
	{
		totalMultipleTest=1;
		totalUsedHaplotypes=0;
		totalUsedDifferentHaplotypes=0;
		this->testMode=testMode;
		totalFolds=testMode;
//  if (testMode==1) totalFolds=2; // holdout
		this->useDistances=useDistances;
		this->lengthDistance=lengthDistance;
		partialTdtTables=NULL;
		partialTrainingTdtTables=NULL;
		partialTuCountsTraining=NULL;
		partialTuCountsTest=NULL;
	};




	/*_________________________________________________________________*/

			GroupBasedTDTMeasure::GroupBasedTDTMeasure ( GroupBasedTDTMeasure& other ) :Chi2TDTMeasure ( other )
	{
		totalMultipleTest=other.totalMultipleTest;
		testMode=other.testMode;
		totalFolds=other.totalFolds;
		partialTuCountsTraining=other.partialTuCountsTraining;
		partialTuCountsTest=other.partialTuCountsTest;
		partialTdtTables=NULL;
		partialTrainingTdtTables=NULL;
		totalUsedHaplotypes=other.totalUsedHaplotypes;
		totalUsedDifferentHaplotypes=other.totalUsedDifferentHaplotypes;
		this->useDistances=other.useDistances;
		this->lengthDistance=other.lengthDistance;
		if ( testMode>=1 && other.partialTrainingTdtTables!=NULL )
		{
			totalUsedDifferentHaplotypes=other.totalUsedDifferentHaplotypes;
			partialTrainingTdtTables=other.partialTrainingTdtTables->clone();
		}
		if ( testMode>=1 && other.partialTdtTables!=NULL )
		{
			totalUsedDifferentHaplotypes=other.totalUsedDifferentHaplotypes;
			partialTdtTables=(AssociationTableVector*) other.partialTdtTables->clone();
		}
	};


	/*_________________________________________________________________*/

			GroupBasedTDTMeasure::~GroupBasedTDTMeasure()
	{
		if ( testMode>=1 )
		{
//cout << "there are: \n";
//if (partialTdtTables!=NULL) cout << partialTdtTables->size() << "\n";
//else cout <<"0\n";

//cout << "test is:" << *partialTdtTables <<"\n";
			zap ( partialTdtTables );

//cout << "training is:" << *partialTrainingTdtTables <<"\n";

//cout << "fff\n";
			zap ( partialTrainingTdtTables );

//cout << "ddd\n";
		}
//else cout <<"hett\n";
	};

	/*___________________________________________________________________________________*/


			GroupBasedTDTMeasure*	GroupBasedTDTMeasure::inferMeasure ( SampleGeneticCounts* tuCounts )
	{
		GroupBasedTDTMeasure* result=NULL;

		if ( testMode<1 ) // testMode is 0 if usual testing (low specificity because of ad-hoc grouping)
// testMode is -1 when Bonferroni correction is used (low power because it is an overcorrection)
		{
			result= ( GroupBasedTDTMeasure* )  Chi2TDTMeasure::inferMeasure ( tuCounts );
			return result;
		}
		if ( tuCounts==NULL )
			throw NullValue ( "GroupBasedTDTMeasure*	GroupBasedTDTMeasure::inferMeasure(TUCounts* tuCounts)" );
		result= ( GroupBasedTDTMeasure* ) this->clone();

		if ( testMode==1 ) // holdout
		{
			zap ( result->tdtTable );
			if ( partialTrainingTdtTables!=NULL && partialTrainingTdtTables->getFirstElement() !=NULL )
				result->tdtTable=partialTrainingTdtTables->getFirstElement()->clone();
		}

		if ( result->tdtTable!=NULL )
		{
			result->tdtTable->update (tuCounts, true, false, -1, false );
			if ( result->tdtTable!=NULL && result->tdtTable->partition==NULL ) zap ( result->tdtTable );
		}
		result->counts = tuCounts;

		if ( result->partialTrainingTdtTables!=NULL )
			zap ( result->partialTrainingTdtTables );
		if ( result->partialTdtTables!=NULL )
			zap ( result->partialTdtTables );
		result->testMode=0;
		return result;
	}


	/*_________________________________________________________________*/
	/*
				void GroupBasedTDTMeasure::removeSemiHomo ( TDTtable* tdtTable, SampleGeneticCounts* tuCounts )
		{
			//.........
			try
			{
				if ( tdtTable!=NULL && tuCounts!=NULL )
					tdtTable->removeSemiHomo ( tuCounts );//->parentalHaplotypesList );
			}
			catch ( BasicException& be ) {be.addMessage ( "\ncalled from void GroupBasedTDTMeasure::removeSemiHomo()2" ); throw;};
		};



		/*_________________________________________________________________*/

			void GroupBasedTDTMeasure::removeNotUsed ( AssociationTable* tdtTable, SampleGeneticCounts* tuCounts )
	{
		//.........
		try
		{
			if ( tdtTable!=NULL && tuCounts!=NULL )
			tdtTable->removeSemiHomo ( tuCounts );//->parentalHaplotypesList );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void GroupBasedTDTMeasure::removeSemiHomo()2" ); throw;};
	};

	/*_________________________________________________________________*/
/*
	template<>		void  GroupBasedTDTMeasure<HaplotypeCaseControlCountsVector>::removeNotUsed ( TDTtable<HaplotypeCaseControlCountsVector>* tdtTable, SampleGeneticCounts<HaplotypeCaseControlCountsVector>* tuCounts )
	{
		//.........
		try
		{
			if ( tdtTable!=NULL && tuCounts!=NULL )
				tdtTable->keepOnlyBothInFirstColumn ( tuCounts );//->parentalHaplotypesList );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void GroupBasedTDTMeasure::removeSemiHomo()2" ); throw;};
	};

	/*_________________________________________________________________*/

			int GroupBasedTDTMeasure::getTestMode()
	{
		return testMode;
	}

	/*_________________________________________________________________*/

			void GroupBasedTDTMeasure::setTestMode ( int testMode )
	{
		this->testMode=testMode;
	}


	/*_________________________________________________________________*/

			void GroupBasedTDTMeasure::setAll()
	{
		//.........
		try
		{
			int position=0;
			if ( lengthDistance ) position=-1;
			AssociationTable* aTdtTable, *aTrainingTdtTable=NULL, *aTrainingTdtTableTemp=NULL;

//for (int i=0; i<1000;i++)
			
//if (i%50==0) cout <<"cont " << i <<"\n";
				zap ( this->tdtTable );

				if ( ( ( SampleGeneticCounts* ) this->counts )->countsVector->size() ==0 )
 this->tdtTable=NULL;


				else 		
				{
		//		  cout << "before set\n";
	this->tdtTable=set ( ( SampleGeneticCounts* ) this->counts );
//	cout << "after set\n";
	//cout <<*this->tdtTable <<"\n";
				}

//for (int j=0; j<100000;j++)
//for (int k=0; k<5;k++);
		//	cout << "before removing\n";
			if ( this->tdtTable!=NULL ) removeNotUsed ( this->tdtTable, ( SampleGeneticCounts* ) this->counts );
		//	cout << "after removing\n";
			if ( testMode<1 ) return;
			this->partialTdtTables=NULL;
			this->partialTrainingTdtTables=NULL;
//return;
//cout <<"setall\n";
			this->partialTdtTables=new AssociationTableVector();
			this->partialTrainingTdtTables=new AssociationTableVector();
//cout << "all:" << *this->tdtTable <<"\n";
			for ( int i=0; i<totalFolds; i++ )
			{
				if ( this->partialTuCountsTraining[i]==NULL ) throw NullValue ( "void GroupBasedTDTMeasure::setAll()" );
//cout << "training part: \n";
//cout << "countstrain:" << *this->partialTuCountsTraining[i] <<"\n";

				if ( ( ( SampleGeneticCounts* ) this->partialTuCountsTraining[i] )->countsVector->size() ==0 ) aTdtTable=NULL;
				else aTdtTable=set ( this->partialTuCountsTraining[i] );
//cout << "is:" << *aTdtTable <<"\n";
				if ( aTdtTable!=NULL && ( aTdtTable->getTotalRowCount () ==0 ) ) zap ( aTdtTable );
				if ( this->partialTuCountsTest[i]==NULL ) throw NullValue ( "void GroupBasedTDTMeasure::setAll()-2" );
				if ( aTdtTable!=NULL )
				{
					removeNotUsed ( aTdtTable, this->partialTuCountsTraining[i] );
					aTrainingTdtTable=aTdtTable->clone();
//cout << "test part before:\n";
//cout <<"is:" << *aTdtTable <<"\n";
					aTdtTable->update ( this->partialTuCountsTest[i], useDistances, false, position, false );
//cout << "test part after updating with:\n";

//cout << *this->partialTuCountsTest[i] <<":\n";
//cout <<"is:" << *aTdtTable <<"\n";
					if ( aTdtTable!=NULL && ( aTdtTable->getTotalRowCount (  ) ==0 ) ) zap ( aTdtTable );
					if ( aTdtTable!=NULL && aTdtTable->partition==NULL )
					{
//cout <<"removing inside GroupbasedTDTMeasure\n";
					  zap ( aTdtTable );
						zap ( aTrainingTdtTable );
					}
				}
				else aTrainingTdtTable=NULL;
				this->partialTrainingTdtTables->insertElement ( aTrainingTdtTable );
				this->partialTdtTables->insertElement ( aTdtTable );
			}
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void GroupBasedTDTMeasure::setAll()" ); throw;};
	};


	/*____________________________________________________________ */
/*
			void GroupBasedTDTMeasure::update ( AssociationTable* aTdtTable, SampleGeneticCounts* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft )
	{
		try
		{
			aTdtTable->update ( hapCounts, useDistances, treeDT, position, toLeft );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void void GroupBasedTDTMeasure::update ( TDTtable* aTdtTable, SampleGeneticCounts* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft  )" ); throw;};
		//   cout <<"table after semi:\n" << *tdtTable <<"\n";
	}

	/*____________________________________________________________ */
/*
	void GroupBasedTDTMeasure<HaplotypeCaseControlCountsVector>::update ( TDTtable<HaplotypeCaseControlCountsVector>* aTdtTable, SampleGeneticCounts<HaplotypeCaseControlCountsVector>* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft )
	{
		try
		{
			aTdtTable->update ( hapCounts, useDistances, treeDT, position, toLeft );
			aTdtTable->keepOnlyBothInFirstColumn ( hapCounts );
			//   cout <<"table after semi:\n" << *tdtTable <<"\n";
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void GroupBasedTDTMeasure<HaplotypeCaseControlCountsVector>::update ( TDTtable<HaplotypeCaseControlCountsVector>* aTdtTable, SampleGeneticCounts<HaplotypeCaseControlCountsVector>* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft  )" ); throw;};

	}

	
/*_____________________________________________________________*/

AssociationTable* GroupBasedTDTMeasure::set ( SampleGeneticCounts* aTUCounts )
	{
// It creates and return a new TDTtable with only two columns, one for each group in 2G algorithm
// T will be HaplotypeTUCountsVector, which inherits from HaplotypeTUCountsList, or HaplotypeCaseControlCountsList
// so both T inherits from HaplotypeCountsList
		try
		{
			if ( aTUCounts==NULL ) return NULL;

			return aTUCounts->createAssociationTable(this);


		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2Measure::set()" ); throw;};
	}
	/*_____________________________________________________________*/


		double GroupBasedTDTMeasure::getPVal ( int position, int subsample )
	{
		try
		{
				if ( subsample==0 ) if ( this->tdtTable==NULL ) return 1; else return   this->tdtTable->getPVal();
			Vector<AssociationTable*>::Class*tables=partialTdtTables;

			if ( subsample==2 ) tables=partialTrainingTdtTables;
			if ( tables==NULL ) throw BadFormat ( "double GroupBasedTDTMeasure::getPVal(int position, bool testing)" );
			if ( tables->getElement ( position ) ==NULL )
				return 1; //throw BadFormat ( "double GroupBasedTDTMeasure::getPVal(int position, bool testing)" );
			else

			{
//cout << "Method name: " << this->getName() <<"\n";
//cout << "pval is: " << pdfTestChiSquare ( tables->getElement ( position )->getStatistic(), tables->getElement ( position )->getYDim()-1 ) <<"\n";
//cout << "pval in training is: " << pdfTestChiSquare ( partialTrainingTdtTables->getElement ( position )->getStatistic(), partialTrainingTdtTables->getElement ( position )->getYDim()-1 ) <<"\n";
//exit(0);
				return tables->getElement ( position )->getPVal();




			}
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GroupBasedTDTMeasure::getPVal(int position, bool testing)" ); throw;};
	}
	/*_____________________________________________________________*/


			double GroupBasedTDTMeasure::getPVal()
	{
		try
		{
			int minDF;
			double result=0, totalOutcomes=0;


			if ( partialTdtTables==NULL || partialTdtTables->size() ==0 ) // testMode<1
				return Chi2TDTMeasure::getPVal();

//  if (testMode>=2) return pdfTestChiSquare ( getStatistic(),testMode );

// for holdout (testMode=1) and cross validation
			result=1;
			for ( Vector<AssociationTable*>::Class::iterator it=partialTdtTables->begin(); it<partialTdtTables->end(); it++ )
				if ( partialTdtTables->getElement ( it ) !=NULL )
				{
					//cout <<*partialTdtTables->getElement ( it ) <<"\n";
//cout <<"statistic is: " << partialTdtTables->getElement ( it )->getStatistic() << " and p val is: " << pdfTestChiSquare ( partialTdtTables->getElement ( it )->getStatistic(), partialTdtTables->getElement ( it )->getYDim()-1 ) <<"\n";
					result=result*getPVal ( partialTdtTables->getPosition ( it ), true );;// using sum of chi squares 1 df
					totalOutcomes++;
				}
//cout <<"final meausre inside:" << result <<"\n";
//cout <<"pval result is: " <<pdfTestqfast(result,totalOutcomes) <<"\n";
			if ( totalOutcomes>0 ) return pdfTestqfast ( result,totalFolds ); else return 1;


//if  (partialTdtTables->size()==2 && sumOfHalves) return getPValSumOfHalfNormal(getStatistic());
			//		return pdfTestChiSquare ( getStatistic(),testMode );

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GroupBasedTDTMeasure::getPVal()" ); throw;};
	}
	/*_________________________________________________________________*/

			double GroupBasedTDTMeasure::getTotalMultipleTest()
	{
		return totalMultipleTest;
	};


	/*_________________________________________________________________*/

			void GroupBasedTDTMeasure::print ( ostream& out )
	{
//out << "\nFirstprintcommonall\n";

		try
		{

//cout << "testmode is:" << this->testMode <<"\n";
//exit(0);
			if ( this->testMode!=1 ) // no holdout
			{
//cout << "testmode in print is: " << testMode <<"\n";
				onePrint ( out, ( SampleGeneticCounts* ) this->counts, this->tdtTable, 0 );
			}
			if ( this->testMode>=1 ) // holdout or crossvalidation with testMode folds
				for ( int i=0; i<this->totalFolds; i++ )
				{
					if ( this->testMode!=1 )	out <<"\n";
					if ( this->partialTdtTables!=NULL && this->partialTdtTables->size() >0 && this->partialTdtTables->getElement ( i ) !=NULL )
					{
						onePrint ( out, this->partialTuCountsTest[i], this->partialTdtTables->getElement ( i ), 1, i );
					}
					else
					{
						onePrint ( out, NULL, NULL, 1, -1 );
					}
				}
// now training
			if ( 0==1 )
				if ( this->testMode==1 )
				{
					out <<"\n";
					if ( this->partialTrainingTdtTables!=NULL &&  this->partialTrainingTdtTables->size() >0 && this->partialTrainingTdtTables->size() >=1 )
						onePrint ( out, this->partialTuCountsTraining[0], this->partialTrainingTdtTables->getElement ( 0 ), 2, 0 );
					else 					onePrint ( out, NULL, NULL, 2, -1 );
				};
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GroupBasedTDTMeasure::print(ostream& out)" ); throw;};
	}

	/*_________________________________________________________________________________________________*/

			void GroupBasedTDTMeasure::onePrint ( ostream& out, SampleGeneticCounts* aTuCounts, AssociationTable* aTdtTable, int subsample, int position )
	{
		try
		{
			doubleList* tl, *ul, *homol;
			if ( aTdtTable!=NULL && aTdtTable->partition!=NULL )
			{
//cout <<*tdtTable;
//cout <<"--------------";
				aTdtTable->partition->setDelimiters ( '\0', '\n' );
				aTdtTable->partition->setOutputSeparator ( '\0' );
				aTdtTable->partition->setOutputSeparatorForInternalContainers ( ' ' );
				aTdtTable->partition->setDelimitersForInternalContainers ( '\0', ' ' );
				if ( aTuCounts==NULL ) throw NullValue ( "GroupBasedTDTMeasure::onePrint(ostream& out,...)" );
				if ( aTuCounts->getParentalGenotypes() ==NULL ) throw NullValue ( "GroupBasedTDTMeasure::onePrint(ostream& out,...)A" );
				if ( aTuCounts->getParentalGenotypes()->getPositions() ==NULL ) throw NullValue ( "GroupBasedTDTMeasure::onePrint(ostream& out,...)C" );
				if ( aTuCounts->getPositions() ==NULL ) throw NullValue ( "GroupBasedTDTMeasure::onePrint(ostream& ou,...t)-2" );


				if ( aTuCounts!=NULL ) out << aTuCounts->getParentalGenotypes()->getPositions() [aTuCounts->getPositions() [0]] <<": ";
				else out <<  "-1\t";
				out << getPVal ( position, subsample ) <<"\t";//Chi2TDTMeasure::getPVal();

				out << " Haplotypes: " << *aTdtTable->partition;
				tl=aTdtTable->getCounts ( 0 );
				ul=aTdtTable->getCounts ( 1 );
				out <<"T: " << *tl <<"U: " << *ul;
				if (aTdtTable->getXDim()==3) 
				{
				homol=((TDTtable*)aTdtTable)->getHomoCounts();
				homol->setDelimiters ( '\0', '\0' );
				out <<"H: " << *homol;
				}
				zap ( ul );zap ( tl ); zap ( homol );
			}
			else out <<"null tdt table\n\n\n";
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GroupBasedTDTMeasure::onePrint(ostream& out,...)" ); throw;};
	};

	/*_____________________________________________________________*/

	/*
		double GroupBasedTDTMeasure::getPVal()
	  {
	  try
	{
	return Chi2TDTMeasure::getPVal();
	}
	catch (BasicException& be) {be.addMessage ("\ncalled from GroupBasedTDTMeasure::getPVal()"); throw;};

	  }


	/*_________________________________________________________________________________________________*/
	/*
	double GroupBasedTDTMeasure::getStatistic()
	{
	return Chi2TDTMeasure::getStatistic();
	}
	/*_________________________________________________________________________________________________*/

			double GroupBasedTDTMeasure::getStatistic()
	{
		double result=0;
		if ( this->partialTdtTables==NULL || this->partialTdtTables->size() ==0 ) return Chi2TDTMeasure::getStatistic();
		for ( Vector<AssociationTable*>::Class::iterator it=partialTdtTables->begin(); it<partialTdtTables->end(); it++ )
		{
			if ( partialTdtTables->getElement ( it ) !=NULL )
				result=result+partialTdtTables->getElement ( it )->getStatistic();// using sum of chi squares 1 df
		}
		if ( testMode>1 ) return result/totalFolds;
		return result; //partialTdtTables->size();
	}

	/*___________________________________________________________________________________*/
/*

			double	GroupBasedTDTMeasure::getGenotypeCount ( GeneticUnit*a, GeneticUnit*b, int position, int subsample )
	{
		SampleGeneticCounts* c= ( SampleTUCounts* ) this->counts;
		if ( subsample==1 ) c=partialTuCountsTest[position];
		if ( subsample==2 ) c=partialTuCountsTraining[position];
		if ( c==NULL ) throw NullValue ( "void GroupBasedTDTMeasure::getGenotypeCount(Haplotype*a, Haplotype*b, int position, int subsample)" );

		double total=0;
		ParentalHaplotypesUsingPointers* p;
		for ( ParentalHaplotypesUsingPointersList::iterator it=c->getParentalHaplotypesList()->begin();it<c->getParentalHaplotypesList()->end();it++ )
		{
			p=*it;
			if ( p->getHap ( 0,t ) !=NULL && * ( Haplotype* ) ( p->getHap ( 0,t ) ) ==*a && p->getHap ( 0,u ) !=NULL && * ( Haplotype* ) ( p->getHap ( 0,u ) ) ==*b ) total+=p->freq;
			if ( p->getHap ( 1,t ) !=NULL && * ( Haplotype* ) ( p->getHap ( 1,t ) ) ==*a && p->getHap ( 1,u ) !=NULL && * ( Haplotype* ) ( p->getHap ( 1,u ) ) ==*b ) total+=p->freq;
		}
		return total;
	};
	/*_________________________________________________________________________________________________*/


	/*_____________________________________________________________________________________________________________*/

	/*
			ostream& GroupBasedTDTMeasure::print(ostream& out){
	   out << *this;
	   return out;
			};
	/*_____________________________________________________________*/


};

#endif
