#ifndef __GroupBasedTDTMeasure_h__
#define __GroupBasedTDTMeasure_h__

namespace BIOS {
	
  /**
     @memo GroupBasedTDTMeasure
     @doc
     Definition:
	  Abstract class generalizing all Chi2-based TDT measures

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	


typedef Vector<AssociationTable*>::Class AssociationTableVector;

class GroupBasedTDTMeasure: public Chi2TDTMeasure {
    

		public:
	
double totalMultipleTest;
int testMode, totalFolds;
SampleGeneticCounts** partialTuCountsTraining, **partialTuCountsTest;
AssociationTableVector  * partialTdtTables, *partialTrainingTdtTables;
int totalUsedHaplotypes;
int totalUsedDifferentHaplotypes;
bool useDistances, lengthDistance;// if lengthDistance is false, biosDistance is used, otherwise legth distance (TZeng at al. 2004) is used

//VectorOfParentalHaplotypes* parentalHaplotypesListAdhoc;

		/**
		*	Constructor
		*/		
//		GroupBasedTDTMeasure(bool permutations=false);

		/**
		*	Destructor
		*/		
	virtual	~GroupBasedTDTMeasure();


		/**
		*	Constructor 
		*	@param tuCounts Hapcounts to be used
		*/		
		GroupBasedTDTMeasure(SampleGeneticCounts* tuCounts, double minFreq=0, int testMode=2, SampleGeneticCounts** partialTuCountsTraning=NULL, SampleGeneticCounts** partialTuCountsTest=NULL, bool permutations=false, bool useDistances=true, bool lengthDistance=false);


// testMode is 0 if usual testing (low specificity because of ad-hoc grouping)
// testMode is -1 when Bonferroni correction is used (low power because it is an overcorrection)
// testMode is = 1 when holdout is used
// testMode is > 1 when cross-validation with testMode folds is used

//		GroupBasedTDTMeasure(TUCounts* tuCounts, Transmission transmission=ut, double minFreq=0, bool left=true);

		GroupBasedTDTMeasure(double minFreq=0, int testMode=2, bool permutations=false, bool useDistances=true, bool lengthDistance=false);
		
	 GroupBasedTDTMeasure(GroupBasedTDTMeasure& other);
	 
//	 void removeSemiHomo(AssociationTable* tdtTable, SampleGeneticCounts<T>* tuCounts);

	 void removeNotUsed(AssociationTable* tdtTable, SampleGeneticCounts* tuCounts);
	 
	 virtual	AssociationTable*  set(SampleGeneticCounts* aTUCounts=NULL);

//virtual 	void update ( AssociationTable* aTdtTable, SampleGeneticCounts* hapCounts, bool useDistances=true, bool treeDT=false, int position=-1, bool toLeft=false );
	 
virtual int getTestMode();

virtual GroupBasedTDTMeasure*	inferMeasure(SampleGeneticCounts* tuCounts);

virtual void setTestMode(int testMode);

virtual	double getPVal(int position, int subsample);
	 //void setFinal();
	 
	 void setAll();
	 
	 virtual void onePrint( ostream&, SampleGeneticCounts* aTuCounts, AssociationTable* aTDTtable, int subsample, int position=-1);

virtual double getPVal();	

 virtual double getTotalMultipleTest();
  //virtual GroupBasedTDTMeasure* getNewMeasure(TUCounts* tuCounts, int iniPos=0, int length=-1)=0;

	virtual double getStatistic();
//virtual GroupBasedTDTMeasure* clone();

		/**
		*	Calculate statistic from the tables 
		*/

 virtual void print( ostream&);

double	getGenotypeCount(GeneticUnit*a, GeneticUnit*b, int position, int subsample);

//bool consistent(bool first, bool second);

//int consistent(bool first, bool second, bool third);
//		void oneHapPrint(ostream& out);
//virtual ostream& print( ostream&);
 
//virtual stringList*  getHeadFile();


//friend ostream& operator<<(ostream& out, GroupBasedTDTMeasure& l);

};
/*{
out << (TUMeasure&)l <<"\n";

out << *l.getTDTtable() <<"\n";
}
*/

};

#endif
