#ifndef __HWEMeasure_cpp__
#define __HWEMeasure_cpp__





namespace BIOS {

HWEMeasure::HWEMeasure(TUCounts* tuCounts, double minFreq, bool permutations, bool left):Chi2TDTMeasure(minFreq, permutations, left)
{
try
{
this->counts=counts;
tdtTable=new TDTtable(tuCounts->haplotypeTUCountsVector, NULL, 0, minFreq, true);//true for HWE
if (tdtTable->partition==NULL) zap(tdtTable);
}
catch (BasicException& be){be.addMessage("\ncalled from HWEMeasure::HWEMeasure(TUCounts* tuCounts, double minFreq, bool permutations, bool left):Chi2TDTMeasure(minFreq, permutations, left)) "); throw;};

};
/*_________________________________________________________________*/

		HWEMeasure::HWEMeasure(double minFreq, bool permutations, bool left):Chi2TDTMeasure(minFreq, permutations, left)
{
};
/*_________________________________________________________________*/

		HWEMeasure::HWEMeasure(HWEMeasure& other):Chi2TDTMeasure(other)
{
		};
/*_________________________________________________________________*/
/*

		HWEMeasure::HWEMeasure(bool permutations):Chi2TDTMeasure(permutations)
{
		};

/*_____________________________________________________________________________________________________________*/


		void HWEMeasure::print(ostream& out){
 if (tdtTable!=NULL)  out << *tdtTable; else out <<"Null homo table\n";
		};

/*_____________________________________________________________*/

stringList*  HWEMeasure::getHeadFile()
 {

stringList *result=new stringList();
result->insertElement(string("Pos: pVal"));
return result;
};
/*___________________________________________________________________________________*/


HWEMeasure*		HWEMeasure::clone(){
return new HWEMeasure(*this);
			}
		/*_________________________________________________________________*/

HWEMeasure*		HWEMeasure::getNewMeasure(GenericCounts* tuCounts, GenericCounts** training, GenericCounts** test)
{
try
{
return new HWEMeasure((TUCounts*)tuCounts, minFreq, permutations);
}
catch (BasicException& be){be.addMessage("\ncalled from HWEMeasure*		HWEMeasure::getNewMeasure(TUCounts* tuCounts)) "); throw;};

		};
/*_________________________________________________________________*/

		HWEMeasure::~HWEMeasure(){
zap(tdtTable);
		};
/*_________________________________________________________________*/

		double HWEMeasure::getStatistic()
		{
     return tdtTable->getStatistic(true);
		};

	/*___________________________________________________________________________________*/
 
 
 string HWEMeasure::getName()
 {
 string result=string("HWE");
  if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
 if (permutations) result=result+addPermutationsInName();
 return result;
 };
/*_____________________________________________________________*/
/*
	double HWEMeasure::getPVal()
  {
throw NonImplemented("HWEMeasure::getPVal()");
  }
/*_____________________________________________________________*/

  HWEMeasure* HWEMeasure::fromString(string s){throw NonImplemented("HWEMeasure::fromString(string s)");};


};

#endif
