#ifndef __HWEMeasure_h__
#define __HWEMeasure_h__

namespace BIOS {
	
  /**
     @memo HWEMeasure
     @doc
     Definition:
	
An abstract class for measure computed from T/U counts of trio samples

     @author María Mar Abad Grau
     @version 1.0
	
	*/	
	

class HWEMeasure: public Chi2TDTMeasure{
    


		public:
	

		/**
		*	Constructor
		*/		
	//	HWEMeasure(bool permutations=false);

	HWEMeasure(TUCounts* tuCounts, double minFreq=10, bool permutations=false, bool left=true);

	HWEMeasure(double minFreq=10, bool permutations=false, bool left=true);
	
		HWEMeasure(HWEMeasure& other);

		/**
		*	Destructor
		*/		
		virtual ~HWEMeasure();

virtual HWEMeasure* clone();

  virtual HWEMeasure* getNewMeasure(GenericCounts* tuCounts, GenericCounts** training=NULL, GenericCounts** test=NULL);


		/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		virtual double getStatistic();

	//	virtual double getPVal();

//  virtual double getPValWithPermutations()=0;

 // virtual stringList* getFreqsResults()=0;

  virtual string getName();

  virtual stringList* getHeadFile();

  TUCounts* getTUCounts();

  HWEMeasure* fromString(string s);

//friend ostream& operator<<(ostream& out, HWEMeasure& l) {l.print(out);};

virtual void print(ostream&);

	};



/*
{

}
*/

};

#endif
