#ifndef __LengthContrastMeasure_cpp__
#define __LengthContrastMeasure_cpp__







/*_____________________________________________________________*/


namespace BIOS {

LengthContrastMeasure::LengthContrastMeasure(SampleGeneticUnitCounts* tuCounts, bool left):SimpleTUMeasure (tuCounts, left, true)
{
measure=-MAXFLOAT;
DList=NULL;
if (tuCounts!=NULL)
setStatistic();
totalCounts=0;
};

/*______________________________________________________________________________________*/

LengthContrastMeasure::LengthContrastMeasure(bool left):SimpleTUMeasure (0, true)
{
DList=NULL;
totalCounts=0;
measure=-MAXFLOAT;
};

/*______________________________________________________________________________________*/

		LengthContrastMeasure::LengthContrastMeasure(LengthContrastMeasure& other):SimpleTUMeasure (other)
{
DList=other.DList->clone();
measure=other.measure;
totalCounts=other.totalCounts;
		};

/*_________________________________________________________________*/

  LengthContrastMeasure* LengthContrastMeasure::getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test)
{
return new LengthContrastMeasure((TUCounts*)tuCounts);
}

/*_________________________________________________________________*/

  LengthContrastMeasure* LengthContrastMeasure::inferMeasure(SampleGeneticUnitCounts* tuCounts)
{
//throw NonImplemented(" LengthContrastMeasure::inferMeasure(TUCou...");
//cout <<"have to think how to keep the model\n";
return new LengthContrastMeasure(tuCounts);
}


/*___________________________________________________________________________*/


		LengthContrastMeasure::~LengthContrastMeasure(){
		zap(DList);
			};


	string LengthContrastMeasure::getName(){return string("LengthContrastTest");};
/*___________________________________________________________________________*/


		LengthContrastMeasure* LengthContrastMeasure::clone(){
		 return new LengthContrastMeasure(*this);
			};
	

/*___________________________________________________________________________________*/


double LengthContrastMeasure::getStatistic()
{
if (measure==MAXFLOAT) setStatistic();
return measure;
}


/*___________________________________________________________________________________*/


void LengthContrastMeasure::setStatistic()
{
measure=0;
totalCounts=0;
if (counts==NULL) throw BadFormat("LengthContrastMeasure::setStatistic()");
DList=new Container<vector<Pair<double>*>, Pair<double> *>();
ParentalHaplotypesUsingPointersList* haplotypeCounts=counts->getParentalHaplotypesList();
double D, freqs, freqs2;
Pair<double> *DPair;
ParentalHaplotypesUsingPointers *parentalHaplotypes, *parentalHaplotypes2;
int *pos, ind;
for (int i=0; i<haplotypeCounts->size(); i++)
{
parentalHaplotypes=(ParentalHaplotypesUsingPointers*)haplotypeCounts->getElement(i);
for (int i2=i+1; i2<haplotypeCounts->size(); i2++)
{
parentalHaplotypes2=(ParentalHaplotypesUsingPointers*)haplotypeCounts->getElement(i2);
freqs=parentalHaplotypes->freq*parentalHaplotypes2->freq;
if (parentalHaplotypes2->trioCount!=parentalHaplotypes->trioCount)
for (int parent1=0; parent1<2; parent1++) // for each parent it computes length measure within parents
if (parentalHaplotypes->getHap(parent1, t)!=NULL && parentalHaplotypes->getHap(parent1, u)!=NULL)
for (int parent2=0; parent2<2; parent2++)
if (parentalHaplotypes->getHap(parent2, t)!=NULL && parentalHaplotypes->getHap(parent2, u)!=NULL)
{
D=getLengthMeasure(parentalHaplotypes->getHap(parent1, t)->getHaplotypeArray(), parentalHaplotypes2->getHap(parent2, t)->getHaplotypeArray(), parentalHaplotypes->getHap(parent1, u)->getHaplotypeArray(), parentalHaplotypes2->getHap(parent1, u)->getHaplotypeArray());
measure=measure+D*freqs;
totalCounts=totalCounts+freqs;
DPair=new Pair<double>(fabs(D*freqs), D*freqs); 
DList->insertElement(DPair);
}
}
}
measure=measure/(double)totalCounts;
DList->sort(false);
};

/*___________________________________________________*/

double LengthContrastMeasure::getLengthMeasure (base* p1T, base* p2T, base* p1U, base* p2U) 
{
try
{
// it is defined as the difference between the transmitted haplotypes of a pair of individuals minus the differences in their non transmitted haplotypes

int resultT=0, resultU=0, maxResultT=0, maxResultU=0;
for (int i=0; i<counts->getTotalPos(); i++)
{
if (p1T[i]==p2T[i]) {resultT++;} else {if (resultT>maxResultT) maxResultT=resultT; resultT=0;};
if (p1U[i]==p2U[i]) {resultU++;} else {if (resultU>maxResultU) maxResultU=resultU; resultU=0;};
}
if (resultT>maxResultT) maxResultT=resultT; 
if (resultU>maxResultU) maxResultU=resultU; 

return (maxResultT-maxResultU)/(double)counts->getTotalPos();
}
catch (ORLLI & e) {e.addMessage("\ncalled from TrioCountersHapUAndT::getLengthMeasure"); throw; }
catch (BasicException & be) {be.addMessage("\ncalled from TrioCountersHapUAndT::getLengthMeasure"); throw; };
};


/*_____________________________________________________________*/

stringList*  LengthContrastMeasure::getHeadFile()
 {
stringList *result=new stringList();
result->insertElement(string("Pos: pVal Haplotypes: "));
return result;
};

/*_________________________________________________________________*/

		void LengthContrastMeasure::print(ostream& out){
   out << "pVal: " << getPVal() <<"\n";
		};


/*_____________________________________________________________*/

/*
	doubleList* LengthContrastMeasure::getHapFreqs()
  {
  doubleList* results=new doubleList();
  for (int i=0; i<getYDim(); i++) 
   results->insertElement((getValue(0,i)+getValue(1,i))/(double)getTotalCounts());
  return results;
  }



/*_____________________________________________________________*/

/*
	double LengthContrastMeasure::getPVal()
  {
  return pdfTestChiSquare(getStatistic(),getYDim()-1); 
  }

*/
	
};

#endif
