#ifndef __MeasureBuilder_h__
#define __MeasureBuilder_h__

#define _PERMUTATIONS_TREEDT_ 100

namespace BIOS {

template <class T> class MeasureBuilder{
		
		public:

		TUMeasure* build(string measureName){

			if ( measureName == "TreeDT0"){
					TreeDTMeasure *t = new TreeDTMeasure();
					t->testMode = 0;
					t->setPermutations( _PERMUTATIONS_TREEDT_ );	
					return t;
			}

			if ( measureName == "TreeDT1"){
					TreeDTMeasure *t = new TreeDTMeasure();
					t->testMode = 1;
					t->setPermutations( _PERMUTATIONS_TREEDT_ );	
					return t;
			}

			if ( measureName == "TreeDTp"){
					TreeDTMeasure *t = new TreeDTMeasure();
					t->testMode = -2;
					t->setPermutations( _PERMUTATIONS_TREEDT_ );	
					return t;
			}

			if ( measureName == "TreeDTp2"){
					TreeDTMeasure *t = new TreeDTMeasure();
					t->testMode = -3;
					t->setPermutations( _PERMUTATIONS_TREEDT_ );	
					return t;
			}

			else if ( measureName == "TreeDT0.P2"){
					TreeDTMeasure *t = new TreeDTMeasure();
					t->testMode = 0;
					t->setPermutations( 2 );	
					return t;				
			}

			else if ( measureName == "TreeDT1.P2"){
					TreeDTMeasure *t = new TreeDTMeasure();
					t->testMode = 1;
					t->setPermutations( 2 );	
					return t;				
			}
			else if ( measureName == "TreeDT0.Sq"){
					TreeDTMeasure *t = new TreeDTMeasure();
					t->testMode = 0;
					t->setPermutations( _PERMUTATIONS_TREEDT_ );
					t->statisticUsed = 1;
					return t;				
			}			
			else if ( measureName == "TDT1.Bonferroni"){
					return new TDT1Measure(0, 0.0, -1);				
			}
			else if ( measureName == "TDT1h"){
				return new TDT1Measure(0, 0.0, 1, true);				
			}			
			else if ( measureName == "mTDT"){
					return new TDTMeasure(0.0f);				
			}
			else if ( measureName == "TDTs"){
					return new ScoreTDTMeasure(false,  0);				
			}
			else if ( measureName == "2G"){
				return new G2Measure(0,  1, true);				
			}
			else if ( measureName == "2GTree"){
				return new G2TreeMeasure(2, 0,  1, true);				
			}
			


			return NULL;

		}

		
};

};

#endif

