#ifndef __ScoreTDTMeasure_cpp__
#define __ScoreTDTMeasure_cpp__




/*_____________________________________________________________*/
/*
void print(BIOS::ScoreTDTMeasure *t){
	cout << *t << endl;
}
*/

/*_____________________________________________________________*/


namespace BIOS {		






template <class T> ScoreTDTMeasure<T>::ScoreTDTMeasure(SampleGeneticCounts<T>* tuCounts, bool HWE, double minFreq, int testMode, SampleGeneticCounts<T>** partialTuCountsTraining, SampleGeneticCounts<T>** partialTuCountsTest, bool useDistance, bool lengthDistance):GroupBasedTDTMeasure<T> (tuCounts, minFreq, testMode, partialTuCountsTraining, partialTuCountsTest, false, useDistance, lengthDistance)
{
try
{
marginalDiscrepancies=NULL;
marginalDiscrepanciesTranspose=NULL;
covMatrix=NULL;
invOfCovMatrix=NULL;
partialMarginalDiscrepancies=NULL;
partialMarginalDiscrepanciesTranspose=NULL;
partialCovMatrix=NULL;
partialInvOfCovMatrix=NULL;

partialTrainingMarginalDiscrepancies=NULL;
partialTrainingMarginalDiscrepanciesTranspose=NULL;
partialTrainingCovMatrix=NULL;
partialTrainingInvOfCovMatrix=NULL;

this->HWE=HWE;
//if (tuCounts==NULL || tdtTable==NULL || tdtTable->partition==NULL) {zap(tdtTable); cout <<"table us null\n"; return;}
if (this->testMode==-1) this->totalMultipleTest=this->tdtTable->partition->size(); // Bonferroni correction
this->setAll();



//cout << *tuCounts->haplotypeTUCountsVector <<"\n";

//if (tdtTable!=NULL) cout <<"totaldis:" << tdtTable->getYDim() <<"\n";
//if (tdtTable!=NULL) cout <<"getYDim:" << tdtTable->getYDim() <<"\n";
//else cout <<"nulltable\n";


//if (tdtTable!=NULL) cout <<"tutable is:" << *tdtTable <<"\n";
setMatrices();













}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::ScoreTDTMeasure(TUCounts* tuCounts, bool HWE, double minFreq, bool left):Chi2TDTMeasure (tuCounts, minFreq, false, left)"); throw;};
};
/*___________________________________________________________________________________*/


template <class T> void ScoreTDTMeasure<T>::setMatrices()

{
try
{
setMatrices(this->tdtTable, marginalDiscrepancies, marginalDiscrepanciesTranspose, covMatrix, invOfCovMatrix, -1, 0);
this->partialMarginalDiscrepancies=NULL;
this->partialMarginalDiscrepanciesTranspose=NULL;
partialCovMatrix=NULL;
partialInvOfCovMatrix=NULL;
this->partialTrainingMarginalDiscrepancies=NULL;
this->partialTrainingMarginalDiscrepanciesTranspose=NULL;
partialTrainingCovMatrix=NULL;
partialTrainingInvOfCovMatrix=NULL;
if (this->partialTdtTables!=NULL)
{
partialMarginalDiscrepancies=new dv2d*[this->partialTdtTables->size()];
partialMarginalDiscrepanciesTranspose=new dv2d*[this->partialTdtTables->size()];
partialCovMatrix=new dv2d*[this->partialTdtTables->size()];
partialInvOfCovMatrix=new dv2d*[this->partialTdtTables->size()];

for (int i=0; i<this->partialTdtTables->size(); i++ )
 setMatrices(this->partialTdtTables->getElement(i), partialMarginalDiscrepancies[i], partialMarginalDiscrepanciesTranspose[i], partialCovMatrix[i], partialInvOfCovMatrix[i], i, 1);
}


if (this->partialTrainingTdtTables!=NULL)
{
partialTrainingMarginalDiscrepancies=new dv2d*[this->partialTrainingTdtTables->size()];
partialTrainingMarginalDiscrepanciesTranspose=new dv2d*[this->partialTrainingTdtTables->size()];
partialTrainingCovMatrix=new dv2d*[this->partialTrainingTdtTables->size()];
partialTrainingInvOfCovMatrix=new dv2d*[this->partialTrainingTdtTables->size()];

for (int i=0; i<this->partialTdtTables->size(); i++ )
 setMatrices(this->partialTrainingTdtTables->getElement(i), partialTrainingMarginalDiscrepancies[i], partialTrainingMarginalDiscrepanciesTranspose[i], partialTrainingCovMatrix[i], partialTrainingInvOfCovMatrix[i], i, 2);
}

}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::setMatrices()"); throw;};

}

/*___________________________________________________________________________________*/


template <class T> void ScoreTDTMeasure<T>::zapMatrices(dv2d* marginalDiscrepanciesN, dv2d* marginalDiscrepanciesTransposeN, dv2d* covMatrixN, dv2d* invOfCovMatrixN)
{
zap(marginalDiscrepanciesN);
zap(marginalDiscrepanciesTransposeN);
zap(covMatrixN);
zap(invOfCovMatrixN);
}


/*___________________________________________________________________________________*/


template <class T> void ScoreTDTMeasure<T>::setMatrices(TDTtable<T>*& tdtTableN, dv2d* &marginalDiscrepanciesN, dv2d*& marginalDiscrepanciesTransposeN, dv2d*& covMatrixN, dv2d*& invOfCovMatrixN, int position, int subsample)

{
try
{
marginalDiscrepanciesN=NULL;
covMatrixN=NULL;
invOfCovMatrixN=NULL;
marginalDiscrepanciesTransposeN=NULL;

if (tdtTableN!=NULL && tdtTableN->partition->size()==1) zap(tdtTableN);
if (this->counts==NULL || tdtTableN==NULL ) return;
marginalDiscrepanciesN=new dv2d(tdtTableN->getYDim(),1);//-1

for (int i=0; i<(tdtTableN->getYDim());i++)//-1
marginalDiscrepanciesN->vec()[i][0]=(tdtTableN->getValue(0,i)-tdtTableN->getValue(1,i));
//cout <<"here4\n";
double cell, pi,pj;

covMatrixN=new dv2d(tdtTableN->getYDim(),tdtTableN->getYDim());//-1,-1
for (int i=0; i<(tdtTableN->getYDim());i++)//-1
{
//cout <<"i is: " << i <<"\n";
covMatrixN->vec()[i][i]=tdtTableN->getValue(0,i)+tdtTableN->getValue(1,i);
for (int j=i+1; j<(tdtTableN->getYDim());j++)//-1
{
//cout <<"j is: " << j <<"\n";
//cout <<"HWE is:" << HWE <<"\n";
//if (!HWE)//n_{ij}, which is N_{ij}+N_{ji}
{
cell=this->getGenotypeCount(tdtTableN->partition->getElement(i)->getElement(0), tdtTableN->partition->getElement(j)->getElement(0), position, subsample);
cell+=this->getGenotypeCount(tdtTableN->partition->getElement(j)->getElement(0), tdtTableN->partition->getElement(i)->getElement(0), position, subsample);
}
if (HWE)
{ // under HWE, n_{ij}, i.e. genotype {i/j} count is asymptotically 2 n p_iU p_jU, witn n being the total number of genotypes 
//pi=(tdtTable->getHeteroHapCount(i)+tdtTable->getValue(2,i))/(double) tdtTable->getTotalCounts();
//pj=(tdtTable->getHeteroHapCount(j)+tdtTable->getValue(2,j))/(double) tdtTable->getTotalCounts();
pi=(tdtTableN->getHeteroHapCount(i,u)+tdtTableN->getValue(2,i)/2)/(double)(tdtTableN->getTotalCounts()/2);
pj=(tdtTableN->getHeteroHapCount(j,u)+tdtTableN->getValue(2,j)/2)/(double)(tdtTableN->getTotalCounts()/2);
cell=cell-pi*pj*tdtTableN->getTotalCounts();
//cout <<"pi:" << pi <<", pj:" << pj <<"\n";
}
//cell=tdtTable->getTotalTransmissionCount(ut)/(double)(tdtTable->getYDim()*(tdtTable->getYDim()-1));
//cell=0;
covMatrixN->vec()[i][j]=-cell;
covMatrixN->vec()[j][i]=-cell;
}
}
marginalDiscrepanciesTransposeN=(marginalDiscrepanciesN->transpose()).clone();
//cout <<"covmatr:\n";
//cout <<*covMatrix <<"\n";
if (covMatrixN->zeroInverse())
{
zap (marginalDiscrepanciesN);
zap (marginalDiscrepanciesTransposeN);
zap(covMatrixN);
}
else invOfCovMatrixN=new dv2d(covMatrixN->inv());
}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::setMatrices()"); throw;};
}
/*___________________________________________________________________________________*/



template <class T> ScoreTDTMeasure<T>::ScoreTDTMeasure(ScoreTDTMeasure<T>& other):GroupBasedTDTMeasure<T> (other)
{
this->HWE=other.HWE;
covMatrix=NULL;
invOfCovMatrix=NULL;
marginalDiscrepancies=NULL;
marginalDiscrepanciesTranspose=NULL;
if (other.covMatrix!=NULL) covMatrix=other.covMatrix->clone();
if (other.invOfCovMatrix!=NULL) invOfCovMatrix=other.invOfCovMatrix->clone();
if (other.marginalDiscrepancies!=NULL) marginalDiscrepancies=other.marginalDiscrepancies->clone();
if (other.marginalDiscrepanciesTranspose!=NULL) marginalDiscrepanciesTranspose=other.marginalDiscrepanciesTranspose->clone();

partialMarginalDiscrepancies=NULL;
partialMarginalDiscrepanciesTranspose=NULL;
partialCovMatrix=NULL;
partialInvOfCovMatrix=NULL;
if (this->partialTdtTables!=NULL)
{
partialMarginalDiscrepancies=new dv2d*[this->partialTdtTables->size()];
partialMarginalDiscrepanciesTranspose=new dv2d*[this->partialTdtTables->size()];
partialCovMatrix=new dv2d*[this->partialTdtTables->size()];
partialInvOfCovMatrix=new dv2d*[this->partialTdtTables->size()];

for (int i=0; i<other.partialTdtTables->size(); i++ )
 if (other.partialTdtTables->getElement(i)!=NULL)
{
partialMarginalDiscrepancies[i]=other.partialMarginalDiscrepancies[i]->clone();
partialMarginalDiscrepanciesTranspose[i]=other.partialMarginalDiscrepanciesTranspose[i]->clone();
partialCovMatrix[i]=other.partialCovMatrix[i]->clone();
partialInvOfCovMatrix[i]=other.partialInvOfCovMatrix[i]->clone();
}
else
{
partialMarginalDiscrepancies[i]=NULL;
partialMarginalDiscrepanciesTranspose[i]=NULL;
partialCovMatrix[i]=NULL;
partialInvOfCovMatrix[i]=NULL;
}
}


partialTrainingMarginalDiscrepancies=NULL;
partialTrainingMarginalDiscrepanciesTranspose=NULL;
partialTrainingCovMatrix=NULL;
partialTrainingInvOfCovMatrix=NULL;
if (this->partialTrainingTdtTables!=NULL)
{
partialTrainingMarginalDiscrepancies=new dv2d*[this->partialTrainingTdtTables->size()];
partialTrainingMarginalDiscrepanciesTranspose=new dv2d*[this->partialTrainingTdtTables->size()];
partialTrainingCovMatrix=new dv2d*[this->partialTrainingTdtTables->size()];
partialTrainingInvOfCovMatrix=new dv2d*[this->partialTrainingTdtTables->size()];

for (int i=0; i<other.partialTrainingTdtTables->size(); i++ )
 if (other.partialTrainingTdtTables->getElement(i)!=NULL)
{
partialTrainingMarginalDiscrepancies[i]=other.partialTrainingMarginalDiscrepancies[i]->clone();
partialTrainingMarginalDiscrepanciesTranspose[i]=other.partialTrainingMarginalDiscrepanciesTranspose[i]->clone();
partialTrainingCovMatrix[i]=other.partialTrainingCovMatrix[i]->clone();
partialTrainingInvOfCovMatrix[i]=other.partialTrainingInvOfCovMatrix[i]->clone();
}
else
{
partialTrainingMarginalDiscrepancies[i]=NULL;
partialTrainingMarginalDiscrepanciesTranspose[i]=NULL;
partialTrainingCovMatrix[i]=NULL;
partialTrainingInvOfCovMatrix[i]=NULL;
}
}

}

/*___________________________________________________________________________________*/

	

template <class T> ScoreTDTMeasure<T>::ScoreTDTMeasure(bool HWE, double minFreq, int testMode, bool useDistances, bool lengthDistance):GroupBasedTDTMeasure<T> (minFreq, testMode, false, useDistances, lengthDistance)
{
marginalDiscrepancies=NULL;
covMatrix=NULL;
invOfCovMatrix=NULL;
marginalDiscrepanciesTranspose=NULL;
this->HWE=HWE;

partialMarginalDiscrepancies=NULL;
partialMarginalDiscrepanciesTranspose=NULL;
partialCovMatrix=NULL;
partialInvOfCovMatrix=NULL;

partialTrainingMarginalDiscrepancies=NULL;
partialTrainingMarginalDiscrepanciesTranspose=NULL;
partialTrainingCovMatrix=NULL;
partialTrainingInvOfCovMatrix=NULL;
//(cout <<"HWE at the beginninh is: " << this->HWE <<"\n";
}



/*___________________________________________________________________________________*/


template <class T> 		ScoreTDTMeasure<T>::~ScoreTDTMeasure(){

zapMatrices(marginalDiscrepancies, marginalDiscrepanciesTranspose, covMatrix, invOfCovMatrix);

zapPartialMatrices();




			}

/*___________________________________________________________________________________*/


template <class T> 	void	ScoreTDTMeasure<T>::zapPartialMatrices(){


if (this->partialTdtTables!=NULL)
for (int i=0; i<this->partialTdtTables->size(); i++)
zapMatrices(partialMarginalDiscrepancies[i], partialMarginalDiscrepanciesTranspose[i], partialCovMatrix[i], partialInvOfCovMatrix[i]);

if (this->partialTrainingTdtTables!=NULL)
for (int i=0; i<this->partialTrainingTdtTables->size(); i++)
zapMatrices(partialTrainingMarginalDiscrepancies[i], partialTrainingMarginalDiscrepanciesTranspose[i], partialTrainingCovMatrix[i], partialTrainingInvOfCovMatrix[i]);

}


/*___________________________________________________________________________________*/


template <class T> GroupBasedTDTMeasure<T>*	ScoreTDTMeasure<T>::inferMeasure(SampleGeneticCounts<T>* tuCounts)
{
int totalPartials=0;
if (this->partialTdtTables!=NULL) totalPartials=this->partialTdtTables->size();
ScoreTDTMeasure<T>* result=(ScoreTDTMeasure<T>*)GroupBasedTDTMeasure<T>::inferMeasure(tuCounts);
		result->zapPartialMatrices();
/*
if (testMode==1) // holdout
{
zap(result->covMatrix);
zap(result->invOfCovMatrix);
zap(result->marginalDiscrepancies);
zap(result->marginalDiscrepanciesTranspose);
if (partialCovMatrix!=NULL && partialCovMatrix[0]!=NULL) result->covMatrix=partialCovMatrix[0]->clone();
if (partialInvOfCovMatrix!=NULL && partialInvOfCovMatrix[0]!=NULL) result->invOfCovMatrix=partialInvOfCovMatrix[0]->clone();
if (partialMarginalDiscrepancies!=NULL && partialMarginalDiscrepancies[0]!=NULL) result->marginalDiscrepancies=partialMarginalDiscrepancies[0]->clone();
if (partialMarginalDiscrepanciesTranspose!=NULL && partialMarginalDiscrepanciesTranspose[0]!=NULL) result->marginalDiscrepanciesTranspose=partialMarginalDiscrepanciesTranspose[0]->clone();
}
*/

result->setMatrices();
//result->setMatrices();
return result;
}

/*____________________________________________________________ */
/*
TDTtable<T>* ScoreTDTMeasure::set(TUCounts* aTUCounts)
{
TDTtable<T>* result=new TDTtable<T>(aTUCounts->haplotypeTUCountsVector, NULL, 0, minFreq);
if (result==NULL || result->partition==NULL || result->getTotalHeteroGenotypes()==0) {zap(result);return NULL;}

return result;
  //   cout <<"table after semi:\n" << *tdtTable <<"\n";
}	
			
	/*___________________________________________________________________________________*/
 
 
template <class T>  string ScoreTDTMeasure<T>::getName()
 {
 string result=string("ScoreTDT");



if (this->testMode==-1) result=result+string("_Bonferroni");
 if ( this->testMode==0 ) result=result+string ( "_noCorrection" );
 if (this->testMode==1) result=result+string("_holdout");
 if (this->testMode>=2) result=result+string("_cv")+tos(this->testMode);
if ( this->useDistances ) 
  if (this->lengthDistance) result=result+string ( "_useLengthDistances" );
  else result=result+string ( "_useBiosDistances" );





 if (HWE) result+=string("-HWE");
 if (this->minFreq!=0) result=result+string("_minFreq")+tos(this->minFreq);
 return result;
 };


/*___________________________________________________________________________________*/


template <class T> ScoreTDTMeasure<T>*		ScoreTDTMeasure<T>::clone(){
return new ScoreTDTMeasure<T>(*this);
			}
/*___________________________________________________________________________________*/



template <class T> ScoreTDTMeasure<T>*		ScoreTDTMeasure<T>::getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test){
try
{
//cout <<"we are in getNewMeasure and HWE is: " << this->HWE <<"\n";
ScoreTDTMeasure* result=new ScoreTDTMeasure((SampleGeneticCounts<T>*)tuCounts, this->HWE, this->minFreq, this->testMode, (SampleGeneticCounts<T>**)training, (SampleGeneticCounts<T>**)test, this->useDistances, this->lengthDistance);
//cout <<"we are in getNewMeasure and result HWE is: " << result->HWE <<"\n";
//if (result->tdtTable==NULL || tuCounts==NULL) zap(result);
//cout <<"we are in getNewMeasure and result->HWE is: " << result->HWE <<"\n";
return result;
}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::getNewMeasure(TUCounts* tuCounts)"); throw;};
			}
/*___________________________________________________________________________________*/

/*
ScoreTDTMeasure* ScoreTDTMeasure::inferMeasure(TUCounts* tuCounts)
{
//if (tdtTable==NULL) throw NullValue("Chi2TDTMeasure::inferMeasure(TUCounts* tuCounts)");
try
{
if (tuCounts==NULL) 
throw NullValue("ScoreTDTMeasure* ScoreTDTMeasure::inferMeasure(TUCounts* tuCounts)");
ScoreTDTMeasure* result=this->clone();
result->tuCounts=tuCounts;
if (tdtTable!=NULL)
{
result->tdtTable->update(tuCounts->parentalHaplotypesList);
if (result->tdtTable->partition==NULL || result->tdtTable->getTotalHeteroGenotypes()==0) zap (result->tdtTable);

//if (tdtTable!=NULL) cout <<"totaldisifer:" << tdtTable->getYDim() <<"\n";



zap(result->marginalDiscrepancies);
zap(result->marginalDiscrepanciesTranspose);
//cout << "original covmatrix:" << *this->covMatrix <<"\n";
zap(result->covMatrix);
zap(result->invOfCovMatrix);
zaparr(result->partialMarginalDiscrepancies);
zaparr(result->partialMarginalDiscrepanciesTranspose);
zaparr(result->partialCovMatrix);
zaparr(result->partialInvOfCovMatrix);
result->setMatrices();
}
return result;
}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::inferMeasure(TUCounts* tuCounts)"); throw;};
			}
			
			/*___________________________________________________________________________________*/


template <class T> double ScoreTDTMeasure<T>::getStatistic(TDTtable<T>* aTdtTable, dv2d* aMarginalDiscrepancies, dv2d* aMarginalDiscrepanciesTranspose, dv2d* aCovMatrix, dv2d* aInvOfCovMatrix)
{
double result=0;
if (aMarginalDiscrepancies==NULL || aMarginalDiscrepanciesTranspose==NULL) return 0;
dv2d partialResult=*aMarginalDiscrepanciesTranspose**aInvOfCovMatrix;
dv2d finalResult=partialResult**aMarginalDiscrepancies;
if (finalResult.get_width()!=1 || finalResult.get_height()!=1)
{
cout <<"\nfinal results is: "  << finalResult;
cout <<"\nmarginaltranspose is: " << *aMarginalDiscrepanciesTranspose;
//basicPrint(cout);
//thisPrint(cout, tdtTable);
throw BadFormat("ScoreTDTMeasure::getStatistic()");
}
result=finalResult[0][0];
if (result<0 || isNAN(result)) result=0;
if (isNAN(result)) 
{
cout << *aTdtTable <<"\n";
cout <<"covMatrix: " << *aCovMatrix <<"\n"; //<<", and invOfCovMatrix: " << *invOfCovMatrix <<"\n";
cout <<"totalheteros:" << aTdtTable->getTotalHeteroGenotypes()<<"\n";
throw NanValue("ScoreTDTMeasure::getStatistic()");
}
//cout <<"the statistic value is: " << result;

return result;
}

	/*_________________________________________________________________________________________________*/

template <class T> 	double ScoreTDTMeasure<T>::getStatistic()
	{
		double result=0;
		if ( this->partialTdtTables==NULL || this->partialTdtTables->size() ==0 ) return getStatistic(this->tdtTable, marginalDiscrepancies, marginalDiscrepanciesTranspose, covMatrix, invOfCovMatrix);
		for ( int i=0; i<this->partialTdtTables->size(); i++ )
		{
			if ( this->partialTdtTables->getElement ( i ) !=NULL )
				result=result+getStatistic(this->partialTdtTables->getElement ( i ), partialMarginalDiscrepancies[i], partialMarginalDiscrepanciesTranspose[i], partialCovMatrix[i], partialInvOfCovMatrix[i]);// using sum of chi squares 1 df
		}
		return result/this->totalFolds;
	}
			/*___________________________________________________________________________________*/


template <class T> double ScoreTDTMeasure<T>::getPVal(TDTtable<T>* tdtTableN, dv2d* marginalDiscrepanciesN, dv2d* marginalDiscrepanciesTransposeN, dv2d* covMatrixN, dv2d* invOfCovMatrixN)
{
double result=0, statistic=getStatistic(tdtTableN, marginalDiscrepanciesN, marginalDiscrepanciesTransposeN, covMatrixN, invOfCovMatrixN);

//thisPrint(cout, NULL, tdtTableN, marginalDiscrepanciesN, marginalDiscrepanciesTransposeN, covMatrixN, invOfCovMatrixN);

return pdfTestChiSquare(statistic,tdtTableN->getYDim()-1);

}
/*_____________________________________________________________*/


template <class T> 	double ScoreTDTMeasure<T>::getPVal(int position, int subsample)
	{
// subsample is 0 for all, 1 for testing and 2 for training
try
{
if (subsample==0) return getPVal(this->tdtTable, marginalDiscrepancies, marginalDiscrepanciesTranspose, covMatrix, invOfCovMatrix);


typename Vector<TDTtable<T>*>::Class*tables=this->partialTdtTables;

dv2d** md=partialTrainingMarginalDiscrepancies, **mdt=partialTrainingMarginalDiscrepanciesTranspose, **cm=partialTrainingCovMatrix, **icm=partialTrainingInvOfCovMatrix;
if (subsample==1) 
{
md=partialMarginalDiscrepancies;
mdt=partialMarginalDiscrepanciesTranspose;
cm=partialCovMatrix;
icm=partialInvOfCovMatrix;
}
if (subsample=2) 
tables=this->partialTrainingTdtTables;

if (tables==NULL || tables->getElement(position)==NULL)
throw BadFormat("double ScoreTDTMeasure::getPVal(int position, bool testing)");
return this->getPVal(tables->getElement ( position ), md[position], mdt[position], cm[position], icm[position]);
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from ScoreTDTMeasure::getPVal(int position, bool testing)" ); throw;};
}
	/*_____________________________________________________________*/


template <class T> 	double ScoreTDTMeasure<T>::getPVal()
	{
		try
		{
			double result=1;
if (this->tdtTable==NULL) return 1;

			if ( this->partialTdtTables==NULL || this->partialTdtTables->size() ==0 )
			return this->getPVal(this->tdtTable, marginalDiscrepancies, marginalDiscrepanciesTranspose, covMatrix, invOfCovMatrix);

int totalOutcomes=0;
for ( int i=0; i< this->partialTdtTables->size(); i++ )
		{
			if ( this->partialTdtTables->getElement ( i ) !=NULL )
{
				result=result*this->getPVal(i, 1);// using sum of chi squares 1 df
totalOutcomes++;		
}
}
if ( totalOutcomes>0 ) return pdfTestqfast(result,this->totalFolds); else return 1;

		





//if  (partialTdtTables->size()==2 && sumOfHalves) return getPValSumOfHalfNormal(getStatistic());
	//		return pdfTestChiSquare ( getStatistic(),testMode );

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GroupBasedTDTMeasure::getPVal()" ); throw;};

	}


/*_________________________________________________________________*/
/*
		void ScoreTDTMeasure::basicPrint(ostream& out){

if (tdtTable!=NULL) out <<*tdtTable <<"\n";
}
/*_________________________________________________________________*/
/*

		void ScoreTDTMeasure::Chi2Print(ostream& out){

 Chi2TDTMeasure::print(out);
 out  <<"\n";
}
/*_________________________________________________________________*/


template <class T> 		void ScoreTDTMeasure<T>::thisPrint(ostream& out, SampleGeneticCounts<T>* aTuCounts, TDTtable<T>* aTDTtable, dv2d* aMarginalDiscrepancies, dv2d* aMarginalDiscrepanciesTranspose, dv2d* aCovMatrix, dv2d* aInvOfCovMatrix){

if (aMarginalDiscrepancies!=NULL)
{
out << "Marginal discrepancies:\n";
out << *aMarginalDiscrepancies <<"\n";
}
if (aMarginalDiscrepanciesTranspose!=NULL)
{
out << "Marginal discrepancies transpose:\n";
out << *aMarginalDiscrepanciesTranspose <<"\n";
}
else out <<"\n\n";
if (aCovMatrix!=NULL)
{
    out <<"Covariance matrix:\n";
out << *aCovMatrix <<"\n";
    out <<"Inv of covariance matrix:\n";
out << *aInvOfCovMatrix <<"\n";
		}
else out <<"\n\n\n\n";
}
/*_________________________________________________________________*/

template <class T> 			void ScoreTDTMeasure<T>::onePrint(ostream& out, SampleGeneticCounts<T>* aTuCounts, TDTtable<T>* aTDTtable, int subsample, int position)
{
GroupBasedTDTMeasure<T>::onePrint(out, aTuCounts, aTDTtable, subsample, position);
/*
if (subsample==0) 
{
thisPrint(out, (TUCounts*)counts, tdtTable, marginalDiscrepancies, marginalDiscrepanciesTranspose, covMatrix, invOfCovMatrix);
return;
}


TDTtableVector*tables=partialTdtTables;

dv2d** md=partialTrainingMarginalDiscrepancies, **mdt=partialTrainingMarginalDiscrepanciesTranspose, **cm=partialTrainingCovMatrix, **icm=partialTrainingInvOfCovMatrix;
if (subsample==1) 
{
md=partialMarginalDiscrepancies;
mdt=partialMarginalDiscrepanciesTranspose;
cm=partialCovMatrix;
icm=partialInvOfCovMatrix;
}
if (subsample==2) tables=partialTrainingTdtTables;
if (tables==NULL || tables->getElement(position)==NULL)
throw BadFormat("double ScoreTDTMeasure::getPVal(int position, bool testing)");

thisPrint(out, aTuCounts, tables->getElement ( position ), md[position], mdt[position], cm[position], icm[position]);

*/
}

/*_____________________________________________________________*/

/*
ostream& operator<<(ostream& out, ScoreTDTMeasure& l)
{
cout <<"GGGE\n";
out << (Chi2TDTMeasure&)l <<"\n";

out << *l.covMatrix <<"\n";
    
out << *l.marginalDiscrepancies <<"\n";

return out;
}
*/





};

#endif
