#ifndef __ScoreTDTMeasure_h__
#define __ScoreTDTMeasure_h__

namespace BIOS {
	
  /**
     @memo ScoreTDTMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
 class ScoreTDTMeasure: public GroupBasedTDTMeasure {
    
    private:
    

    




    
    private:
    
    void setMatrices();



void setMatrices(AssociationTable* &tdtTableN, dv2d* &marginalDiscrepanciesN, dv2d*& marginalDiscrepanciesTransposeN, dv2d*& covMatrixN, dv2d*& invOfCovMatrixN, int position, int subsample);


protected:

    dv2d* marginalDiscrepancies;

dv2d* marginalDiscrepanciesTranspose;
    bool HWE;

    dv2d* covMatrix;
    
		dv2d* invOfCovMatrix;

dv2d** partialMarginalDiscrepancies, **partialMarginalDiscrepanciesTranspose, **partialCovMatrix, **partialInvOfCovMatrix;

dv2d** partialTrainingMarginalDiscrepancies, **partialTrainingMarginalDiscrepanciesTranspose, **partialTrainingCovMatrix, **partialTrainingInvOfCovMatrix;

    
		public:
	

		/**
		*	Constructor
		*/		
	//	ScoreTDTMeasure();

		/**
		*	Destructor
		*/		
	virtual	~ScoreTDTMeasure();

virtual ScoreTDTMeasure* clone();


//	 virtual	TDTtable<T>*  set(TUCounts* aTUCounts=NULL);

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		ScoreTDTMeasure(SampleGeneticCounts* tuCounts, bool HWE=false, double minFreq=10, int testMode=2, SampleGeneticCounts** partialTuCountsTraining=NULL, SampleGeneticCounts** partialTuCountsTest=NULL, bool useDistance=true, bool lengthDistance=false);

	ScoreTDTMeasure(ScoreTDTMeasure& other);

		ScoreTDTMeasure(bool HWE=false, double minFreq=10, int testMode=2, bool useDistances=true, bool lengthDistance=false);





// stringList* getFreqsResults();

		/**
		*	Calculate statistic from the tables 
		*/


virtual ScoreTDTMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);

	virtual double getPVal(int position, int subsample);


virtual GroupBasedTDTMeasure* inferMeasure(SampleGeneticCounts* tuCounts);

//virtual stringList*  getHeadFile();

	//	void Chi2Print(ostream& out);
				void thisPrint(ostream& out, SampleGeneticCounts* aTuCounts, AssociationTable* aTDTtable, dv2d* marginalDiscrepancies, dv2d* marginalDiscrepanciesTranspose, dv2d* covMatrix, dv2d* invOfCovMatrix);
	//					void basicPrint(ostream& out);

virtual string getName();//{return string("mTDT");};

virtual double getStatistic();

	virtual double getPVal();

double getStatistic(AssociationTable* tdtTable, dv2d* marginalDiscrepancies, dv2d* marginalDiscrepanciesTranspose, dv2d* covMatrix, dv2d* invOfCovMatrix);




double getPVal(AssociationTable* tdtTable, dv2d* marginalDiscrepancies, dv2d* marginalDiscrepanciesTranspose, dv2d* covMatrix, dv2d* invOfCovMatrix);

//void print(ostream&);
//friend ostream& operator<<(ostream& out, ScoreTDTMeasure& l);

	void	zapPartialMatrices();

void zapMatrices(dv2d* marginalDiscrepanciesN, dv2d* marginalDiscrepanciesTransposeN, dv2d* covMatrixN, dv2d* invOfCovMatrixN);


virtual		void onePrint(ostream& out, SampleGeneticCounts* aTuCounts, AssociationTable* aTDTtable, int subsample, int position=-1);
	};





};

#endif
