#ifndef __SignedRankMeasure_h__
#define __SignedRankMeasure_h__

namespace BIOS {
	
  /**
     @memo SignedRankMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class SignedRankMeasure: public LengthContrastMeasure {

private:

bool Wilcoxon;
    
		public:
	

		/**
		*	Constructor
		*/		
	//	SignedRankMeasure();

		/**
		*	Destructor
		*/		
virtual		~SignedRankMeasure();

SignedRankMeasure* clone();

  virtual SignedRankMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);
  
	virtual SignedRankMeasure* inferMeasure(SampleGeneticCounts* tuCounts);

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		SignedRankMeasure(SampleGeneticCounts* tuCounts, bool Wilcoxon=true, bool left=true);

		SignedRankMeasure(bool Wilcoxon=true, bool left=true);
		
  	SignedRankMeasure(LengthContrastMeasure& other, bool Wilcoxon=true);


  	SignedRankMeasure(SignedRankMeasure& other);

virtual  string getName();//{return string("mTDT1T");};
		/**
		*	Calculate statistic from the tables 
		*/

virtual	double getStatistic();

//	double getPVal();


virtual void print(ostream&);

//friend ostream& operator<<(ostream& out, SignedRankMeasure& l){return out << (TUMeasure&)l;};
	};




};

#endif
