#ifndef __TDT1Measure_cpp__
#define __TDT1Measure_cpp__




/*_____________________________________________________________*/
/*
void print(BIOS::TDT1Measure *t){
	cout << *t << endl;
}
*/

/*_____________________________________________________________*/


namespace BIOS {

	
		TDT1Measure::TDT1Measure(int trans, double minFreq, int testMode, bool useDistances, bool lengthDistance):GroupBasedTDTMeasure (minFreq, testMode, false, useDistances, lengthDistance)
{
if (trans<0 || trans>3) throw BadFormat("TDT1Measure::TDT1Measure(TUCounts* tuCounts, int transmission, double minFreq,):GroupBasedTDTMeasure (tuCounts, minFreq)");
transmission=(Transmission) trans;
		};

/*______________________________________________________________________________________*/

				TDT1Measure::TDT1Measure(TDT1Measure& other):GroupBasedTDTMeasure (other)
{
transmission=other.transmission;
		};
	
/*____________________________________________________________ */

		TDT1Measure::TDT1Measure(SampleGeneticCounts* tuCounts, int trans, double minFreq, int testMode, SampleGeneticCounts** partialTuCountsTraning, SampleGeneticCounts** partialTuCountsTest, bool useDistances, bool lengthDistance): GroupBasedTDTMeasure(tuCounts, minFreq, testMode, partialTuCountsTraning, partialTuCountsTest, false, useDistances, lengthDistance)
{
if (trans<0 || trans>3) throw BadFormat("TDT1Measure::TDT1Measure(TUCounts* tuCounts, int transmission, double minFreq, bool left):GroupBasedTDTMeasure (tuCounts, minFreq, left)");
transmission=(Transmission) trans;
//totalMultipleTest=1;
if (tuCounts==NULL || this->tdtTable==NULL || this->tdtTable->partition==NULL) {zap(this->tdtTable);return;}
if (testMode==-1) this->totalMultipleTest=this->tdtTable->partition->size(); // Bonferroni correction
this->setAll();
}
/*____________________________________________________________ */

		AssociationTable* TDT1Measure::set(SampleGeneticCounts* aTUCounts)
{
try
{
AssociationTable* whole=new TDTtable(aTUCounts->countsVector, this->minFreq);

if (whole==NULL || whole->partition==NULL || ((TDTtable*)whole)->getTotalHeteroGenotypes()==0) {zap(whole);return NULL;}

AssociationTable* result;
result=new TDTtable(2);
result->partition=whole->partition->clone();
result->partition->empty();
result->partition->insertElement(new GeneticUnitVector(' ', '[',']'));
result->partition->insertElement(new GeneticUnitVector(' ', '[',']'));
   double max=-1, a, b, diff, totalUsedHaplotypes=whole->getTotalRowCount(2);
 int pos=-1;
 			for(int i=0;i<whole->getYDim(); i++)
   {
   a=whole->getValue(0,i);
   b=whole->getValue(1,i);
   diff=std::pow((float)a-b,2)/(double)(a+b)+std::pow(a-b,2)/(double)(totalUsedHaplotypes-a-b);
   if (diff>max && (((transmission==t || transmission==ut) && a>b) || ((transmission==u || transmission==ut) && a<b)))
   {max=diff; pos=i;}
   }
   if (pos==-1) {zap(this->tdtTable); zap(whole); return NULL;}
 // cout <<"pos is:" << pos <<"\n";   
 // cout <<"table before:\n" << *tdtTable <<"\n";
 for(int i=0;i<whole->getYDim(); i++)
   if (i==pos)
   {
   result->partition->getElement(1)->insertHardElement(whole->partition->getElement(i)->getElement(0));
   result->setValue(0,1,whole->getValue(0,pos));
   result->setValue(1,1,whole->getValue(1,pos));
	 result->setValue(2,1,whole->getValue(2,pos));
   }  
 else result->partition->getElement(0)->insertHardElement(whole->partition->getElement(i)->getElement(0));
	 result->setValue(0,0,whole->getTotalRowCount(0)-whole->getValue(0,pos));
   result->setValue(1,0,whole->getTotalRowCount(1)-whole->getValue(1,pos));
   if (whole->getXDim()==3) result->setValue(2,0,((TDTtable*)whole)->getTotalHomoGenotypes()*2-whole->getValue(2,pos));  
  //   cout <<"table beforesemi:\n" << *tdtTable <<"\n";
zap(whole);
return result;
	}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TDT1Measure::set(SampleGeneticCounts* aTUCounts)" ); throw;};
  //   cout <<"table after semi:\n" << *tdtTable <<"\n";
}



/*_________________________________________________________________*/

		  TDT1Measure* TDT1Measure::getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** tuCountsTraining, SampleGenericCounts** tuCountsTest)
{
return new TDT1Measure((SampleGeneticCounts*)tuCounts,(int)transmission, this->minFreq, this->testMode, (SampleGeneticCounts**)tuCountsTraining, (SampleGeneticCounts**)tuCountsTest, this->useDistances, this->lengthDistance);
}


/*___________________________________________________________________________*/


				TDT1Measure::~TDT1Measure(){
			};

/*___________________________________________________________________________*/

			string TDT1Measure::getName()
	{
	 string result=string("mTDT1");
 if (this->transmission==u) result=result+tos('U');
 if (this->transmission==t) result=result+tos('T');
 if (this->testMode==-1) result=result+string("_Bonferroni");
 if ( this->testMode==0 ) result=result+string ( "_noCorrection" );
 if (this->testMode==1) result=result+string("_holdout");
 if (this->testMode>=2) result=result+string("_cv")+tos(this->testMode);
if ( this->useDistances ) 
  if (this->lengthDistance) result=result+string ( "_useLengthDistances" );
  else result=result+string ( "_useBiosDistances" );
 if (this->minFreq!=0) result=result+string("_minFreq")+tos(this->minFreq);
	return result;
	};
/*___________________________________________________________________________*/


				TDT1Measure* TDT1Measure::clone(){
		 return new TDT1Measure(*this);
			};
	
/*_________________________________________________________________________________________________*/

				void TDT1Measure::onePrint(ostream& out, SampleGeneticCounts* aTuCounts, AssociationTable* aTDTtable, int subsample, int position)
{
try
{
if (aTuCounts==NULL) 
{
out << "null position"; 
return;
}

out << "Positions: " << "[" << aTuCounts->getParentalGenotypes()->getPositions()[aTuCounts->getPositions()[0]] <<"-";
out << aTuCounts->getParentalGenotypes()->getPositions()[aTuCounts->getPositions()[aTuCounts->getTotalPos()-1]] <<"]\t";
out << this->getPVal(position, subsample) <<"\t"; 
if (aTDTtable!=NULL && aTDTtable->partition!=NULL) 
{
if (aTDTtable->partition->size()!=2)
throw BadFormat("TDT1Measure::onePrint"); 



	for ( int i=1; i<3; i++ )
			{
				aTDTtable->partition->getElement ( i-1 )->setDelimiters ( '\0', '\0' );
//if (i==2) out <<"\n";
   out << this->getPVal(position, subsample) << "\t";
				out << "G" << i <<":\t" << *aTDTtable->partition->getElement ( 2-i );
				out <<"\tT:\t" << aTDTtable->getValue ( 0,2-i ) << "\tU: \t" << aTDTtable->getValue ( 1,2-i );
				if ( i==1 ) out <<"\t";
				aTDTtable->partition->getElement ( i-1 )->setDelimiters ( '[', ']' );
			}
}
else out <<"nullTable";
}
catch (BasicException& be){be.addMessage("\ncalled from void TDT1Measure::print(ostream& out)"); throw;};
		};

/*___________________________________________________________________________________*/

/*

		double TDT1Measure::getStatistic()
		{
		if (transmission==ut) return Chi2TDTMeasure::getStatistic();
		else return Chi2TDTMeasure::getStatistic()/2;
   // if (tdtTable==NULL) return 0;
   // return std::pow(tdtTable->getValue(0,1)-tdtTable->getValue(1,1),2)/tdtTable->getHeteroHapCount (1,ut);
		};

/*_____________________________________________________________*/

/*
	doubleList* TDT1Measure::getHapFreqs()
  {
  doubleList* results=new doubleList();
  for (int i=0; i<getYDim(); i++) 
   results->insertElement((getValue(0,i)+getValue(1,i))/(double)getTotalCounts());
  return results;
  }



/*_____________________________________________________________*/

/*
	double TDT1Measure::getPVal()
  {
 try
{
double result;
//  if (transmission==ut) return Chi2TDTMeasure::getPVal();
if (tdtTable==NULL) return 1;
if (permutations) return SimpleTUMeasure::getPVal();
result=pdfTestChiSquare(getStatistic(),2);
if (isNAN(result)) 
{
cout << *tdtTable <<"\n";
cout <<"totalheteros:" << tdtTable->getTotalHeteroGenotypes()<<"\n";
cout << "statistic is: " << getStatistic();
throw NanValue(" Chi2TDTMeasure::getPVal()");
}
return result;
} 
catch (BasicException& be) {be.addMessage ("\ncalled from TDT1Measure::getPVal()"); throw;};

  }

/*_____________________________________________________________*/

	
};

#endif
