#ifndef __TDTMeasure_cpp__
#define __TDTMeasure_cpp__




/*_____________________________________________________________*/

void print(BIOS::TDTMeasure *t){
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS {		



/*_____________________________________________________________*/


TDTMeasure::TDTMeasure(TUCounts* tuCounts, double minFreq, bool permutations, int testMode, TUCounts** partialTuCountsTraining, TUCounts** partialTuCountsTest, bool useDistance, bool lengthDistance):GroupBasedTDTMeasure (tuCounts, minFreq, testMode, partialTuCountsTraining, partialTuCountsTest, permutations, useDistances, lengthDistance)
{
//if (tuCounts==NULL || tdtTable==NULL || tdtTable->partition==NULL) {zap(tdtTable);return;}
if (testMode==-1) totalMultipleTest=tdtTable->partition->size(); // Bonferroni correction
setAll();

		};




	
/*___________________________________________________________________________________*/

TDTMeasure::TDTMeasure(double minFreq, bool permutations, int testMode, bool useDistances, bool lengthDistances):GroupBasedTDTMeasure (minFreq, testMode, permutations, useDistances, lengthDistances)
{
		};

/*___________________________________________________________________________________*/


		TDTMeasure::~TDTMeasure(){
//cout <<"qqqqqqqqqq\n";
			}
			
/*____________________________________________________________ */
/*
TDTtable* TDTMeasure::set(TUCounts* aTUCounts)
{
TDTtable* result=new TDTtable(aTUCounts->haplotypeTUCountsVector, NULL, 0, minFreq);
if (result==NULL || result->partition==NULL || result->getTotalHeteroGenotypes()==0) {zap(result);return NULL;}

return result;
  //   cout <<"table after semi:\n" << *tdtTable <<"\n";
}	
/*___________________________________________________________________________________*/
 
 
 string TDTMeasure::getName()
 {
 string result=string("mTDT");




if (testMode==-1) result=result+string("_Bonferroni");
 if ( testMode==0 ) result=result+string ( "_noCorrection" );
 if (testMode==1) result=result+string("_holdout");
 if (testMode>=2) result=result+string("_cv")+tos(testMode);
if ( useDistances ) 
  if (lengthDistance) result=result+string ( "_useLengthDistances" );
  else result=result+string ( "_useBiosDistances" );




 if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
 if (permutations) result=result+addPermutationsInName();
 return result;
 };
/*___________________________________________________________________________________*/


TDTMeasure*		TDTMeasure::clone(){
return new TDTMeasure(*this);
			}

/*___________________________________________________________________________________*/



TDTMeasure*		TDTMeasure::getNewMeasure(GenericCounts* tuCounts, GenericCounts** training, GenericCounts** test){
return new TDTMeasure((TUCounts*)tuCounts, minFreq, permutations, testMode, (TUCounts**)training, (TUCounts**)test, useDistances, lengthDistance);
			}
	/*_________________________________________________________________________________________________*/

	double TDTMeasure::getStatistic()
	{
		double result=0;
		if ( partialTdtTables==NULL || partialTdtTables->size() ==0 ) return Chi2TDTMeasure::getStatistic();
		for ( TDTtableVector::iterator it=partialTdtTables->begin(); it<partialTdtTables->end(); it++ )
		{
			if ( partialTdtTables->getElement ( it ) !=NULL )
				result=result+partialTdtTables->getElement ( it )->getStatistic();// using sum of chi squares 1 df
		}
  return result/totalFolds; 
	}
	/*_____________________________________________________________*/
/*

	double TDTMeasure::getPVal()
	{
		try
		{
		int minDF;
			double result=0, totalOutcomes=0;


			if ( partialTdtTables==NULL || partialTdtTables->size() ==0 ) // testMode<1
			return Chi2TDTMeasure::getPVal();

 // if (testMode>=2) return pdfTestChiSquare ( getStatistic(),testMode );

// for holdout (testMode=1)
result=totalFolds;
for ( TDTtableVector::iterator it=partialTdtTables->begin(); it<partialTdtTables->end(); it++ )
			if ( partialTdtTables->getElement ( it ) !=NULL )
{
//cout << "statistic in tdt is:" << partialTdtTables->getElement ( it )->getStatistic() << "\n";
				result=result+pdfTestChiSquare(partialTdtTables->getElement ( it )->getStatistic(), partialTdtTables->getElement ( it )->getYDim()-1)-1;// using sum of chi squares 1 df
}
		return result/totalFolds;

	}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TDTMeasure::getPVal()" ); throw;};

}





/*____________________________________________________________ */
/*
TDTtable* TDTMeasure::set(TUCounts* aTUCounts)
{
TDTtable* result=new TDTtable(aTUCounts->haplotypeTUCountsVector, NULL, 0, minFreq);
if (result==NULL || result->partition==NULL || result->getTotalHeteroGenotypes()==0) {zap(result);return NULL;}

return result;
  //   cout <<"table after semi:\n" << *tdtTable <<"\n";
}



/*_________________________________________________________________________________________________*/
/*
		void TDTMeasure::onePrint(ostream& out, TUCounts* aTuCounts, TDTtable* aTDTtable)
{
try
{
doubleList* tl, *ul, *homol;
if (aTdtTable!=NULL && aTdtTable->partition!=NULL)
{
//cout <<*tdtTable;
//cout <<"--------------";
aTdtTable->partition->setDelimiters('\0', '\n');
aTdtTable->partition->setOutputSeparator('\0');
aTdtTable->partition->setOutputSeparatorForInternalContainers(' ');
aTdtTable->partition->setDelimitersForInternalContainers('\0', ' ');
if (aTuCounts==NULL) throw NullValue("Chi2TDTMeasure::print(ostream& out)A");
if (aTuCounts->getParentalGenotypes()==NULL) throw NullValue("Chi2TDTMeasure::print(ostream& out)");
if (aTuCounts->getParentalGenotypes()->getPositions()==NULL) throw NullValue("Chi2TDTMeasure::print(ostream& out)C");
if (aTuCounts->getPositions()==NULL) throw NullValue("Chi2TDTMeasure::print(ostream& out)-2");
out << aTuCounts->getParentalGenotypes()->getPositions()[aTuCounts->getPositions()[0]] <<": ";
out << getPVal();
out << " Haplotypes: " << *aTdtTable->partition;
tl=aTdtTable->getCounts(t);
ul=aTdtTable->getCounts(u);
homol=aTdtTable->getHomoCounts();
out <<"T: " << *tl <<"U: " << *ul <<"H: " << *homol;
 zap(ul);zap(tl); zap(homol);
}
else out <<"null tdt table\n\n\n";
}
catch (BasicException& be){be.addMessage("\ncalled from Chi2TDTMeasure::print(ostream& out)"); throw;};
		};

	*/
};

#endif
