#ifndef __TDTMeasure_h__
#define __TDTMeasure_h__

namespace BIOS {
	
  /**
     @memo TDTMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class TDTMeasure: public GroupBasedTDTMeasure {
    
		public:
	

		/**
		*	Constructor
		*/		

	//	TDTMeasure(int minFreq=10, bool permutations=false);

		/**
		*	Destructor
		*/	
	
	virtual	~TDTMeasure();

virtual TDTMeasure* clone();

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		


	
TDTMeasure(SampleGeneticCounts* tuCounts, double minFreq=10, bool permutations=false, int testMode=2, SampleGeneticCounts** partialTuCountsTraining=NULL, SampleGeneticCounts** partialTuCountsTest=NULL, bool useDistance=true, bool lengthDistance=false);


//virtual TDTtable* set(TUCounts* aTUCounts);


TDTMeasure(double minFreq=10, bool permutations=false, int testMode=2, bool useDistances=true, bool lengthDistance=false);





// stringList* getFreqsResults();

		/**
		*	Calculate statistic from the tables 
		*/

virtual TDTMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);


//virtual stringList*  getHeadFile();

virtual string getName();//{return string("mTDT");};
//		virtual void printOne(ostream& out, SampleTUCounts* aTuCounts, TDTtable* aTDTtable);

virtual double getStatistic();

	//virtual double getPVal();
//virtual ostream& print(ostream&);
	};


//ostream& operator<<(ostream& out, TDTMeasure& l);


};

#endif
