#ifndef __TDTPMeasure_cpp__
#define __TDTPMeasure_cpp__





namespace BIOS
{

	TDTPMeasure::TDTPMeasure ( SampleGeneticCounts* tuCounts, double minFreq, bool independentCols, bool permutations, int testMode, SampleGeneticCounts** partialTuCountsTraining, SampleGeneticCounts** partialTuCountsTest, bool useDistance, bool lengthDistance ) :GroupBasedTDTMeasure ( tuCounts, minFreq, testMode, partialTuCountsTraining, partialTuCountsTest, permutations, useDistance, lengthDistance )
	{

		weights=NULL;
		partialWeights=NULL;

		//if ( tuCounts==NULL || tdtTable==NULL || tdtTable->partition==NULL ) {zap ( tdtTable );return;}
		if ( this->testMode==-1 && this->tdtTable!=NULL )this-> totalMultipleTest=this->tdtTable->partition->size(); // Bonferroni correction
		this->setAll();




		if ( this->tdtTable!=NULL ) weights=this->tdtTable->getFreqs();

		if ( this->partialTrainingTdtTables!=NULL )
		{
			partialWeights=new doubleList*[this->partialTrainingTdtTables->size() ];
			for ( Vector<AssociationTable*>::Class::iterator it=this->partialTrainingTdtTables->begin(); it<this->partialTrainingTdtTables->end(); it++ )
			{
				if ( this->partialTrainingTdtTables->getElement ( it ) !=NULL )
					partialWeights[this->partialTrainingTdtTables->getPosition ( it ) ]=this->partialTrainingTdtTables->getElement ( it )->getFreqs();
				else partialWeights[this->partialTrainingTdtTables->getPosition ( it ) ]=NULL;
			}
		}

		this->independentCols=independentCols;
	};

	/*_________________________________________________________________*/

		TDTPMeasure::TDTPMeasure ( double minFreq, bool independentCols, bool permutations, int testMode, bool useDistances, bool lengthDistance ) :GroupBasedTDTMeasure ( minFreq, testMode, permutations, useDistances, lengthDistance )
	{
		weights=NULL;
		partialWeights=NULL;
		this->independentCols=independentCols;

//cout <<"test mode is: " << testMode <<"\n";
	};

	/*_________________________________________________________________*/

		TDTPMeasure::TDTPMeasure ( TDTPMeasure& other ) :GroupBasedTDTMeasure ( other )
	{
		weights=NULL;
		partialWeights=NULL;
		this->independentCols=other.independentCols;

		if ( other.weights!=NULL ) 
{
weights=other.weights->clone();
//cout << "copying weights:\n";
//cout << *weights <<"\n";
}

		if ( other.partialTdtTables!=NULL )
		{
			partialWeights=new doubleList*[this->partialTdtTables->size() ];
			for ( int i=0; i<this->partialTdtTables->size();i++ )
				if ( other.partialWeights[i]!=NULL ) partialWeights[i]=other.partialWeights[i]->clone();
				else partialWeights[i]=NULL;
		}

//cout <<"test mode2 is: " << this->testMode <<"\n";
	};

	/*_________________________________________________________________*/

		TDTPMeasure::~TDTPMeasure()
	{
		zap ( weights );
		if ( this->partialTrainingTdtTables!=NULL )
			zaparr ( partialWeights,this->partialTrainingTdtTables->size() );
// zap(tdtTable);
	};

	/*___________________________________________________________________________________*/


		TDTPMeasure*	TDTPMeasure::inferMeasure ( SampleGeneticCounts* tuCounts )
	{
		int totalPartials=0;
		if ( partialWeights!=NULL ) totalPartials=this->partialTdtTables->size();
		TDTPMeasure* result= ( TDTPMeasure* ) GroupBasedTDTMeasure::inferMeasure ( tuCounts );
		if ( result->partialWeights!=NULL )
			zaparr ( result->partialWeights, totalPartials );

//cout << "results weights size is:" << result->weights->size() <<"\n";
if (this->testMode==1) 		zap ( result->weights );

		if (this->testMode==1  && partialWeights!=NULL && partialWeights[0]!=NULL) result->weights=partialWeights[0]->clone();

//cout << "results weights size now is:" << result->weights->size() <<"\n";

//cout <<"test mode3 is: " << result->testMode <<"\n";
		return result;
	}
	/*___________________________________________________________________________________*/

	/*
	TDTPMeasure*	TDTPMeasure::inferMeasure(TUCounts* tuCounts)
	{
	if (tuCounts==NULL)
	throw NullValue("Chi2TDTMeasure*	Chi2TDTMeasure::inferMeasure(TUCounts* tuCounts)");


	//if (tdtTable==NULL) throw NullValue("Chi2TDTMeasure::inferMeasure(TUCounts* tuCounts)");
	TDTPMeasure* result=this->clone();
	//zap(result->tuCounts);
	//cout <<"current:\n";
	//cout << *this <<"\n";
	//cout << *this->tuCounts->haplotypeTUCountsVector <<"\n";
	if (result->tdtTable!=NULL)
	{
	result->tdtTable->update(tuCounts->parentalHaplotypesList);
	//cout <<"afterudating:\n";
	//cout << *result <<"\n";
	if (result->tdtTable!=NULL && result->tdtTable->partition==NULL) zap(result->tdtTable);
	}
	result->tuCounts = tuCounts;

	//cout << *tuCounts->haplotypeTUCountsVector <<"\n";
	//cout <<"new:\n" << *result;

	// SampleTUCounts* other=tuCounts->clone();
	// zap(other);

	return result;
	}

		/*_________________________________________________________________*/

		TDTPMeasure* TDTPMeasure::clone()
	{
		return new TDTPMeasure ( *this );
	};

	/*____________________________________________________________ */
	/*
	TDTtable* TDTPMeasure::set(TUCounts* aTUCounts)
	{
	TDTtable* result=new TDTtable(aTUCounts->haplotypeTUCountsVector, NULL, 0, minFreq);
	if (result==NULL || result->partition==NULL || result->getTotalHeteroGenotypes()==0) {zap(result);return NULL;}

	return result;
	  //   cout <<"table after semi:\n" << *tdtTable <<"\n";
	}

	/*_________________________________________________________________*/

		string TDTPMeasure::getName()
	{
		string result=string ( "mTDTP" );



		if ( this->testMode==-1 ) result=result+string ( "_Bonferroni" );
		if ( this->testMode==0 ) result=result+string ( "_noCorrection" );
		if ( this->testMode==1 ) result=result+string ( "_holdout" );
		if ( this->testMode>=2 ) result=result+string ( "_cv" ) +tos ( this->testMode );
		if ( this->useDistances )
			if ( this->lengthDistance ) result=result+string ( "_useLengthDistances" );
			else result=result+string ( "_useBiosDistances" );



		if ( this->independentCols ) result=result+string ( "_indep" );
		if ( this->minFreq!=0 ) result=result+string ( "_minFreq" ) +tos ( this->minFreq );
		if ( this->permutations ) result=result+this->addPermutationsInName();
		return result;

	};
	/*_______________________________________________________________________________*/


		double TDTPMeasure::getStatistic()
	{






		double result=0;
		if ( this->partialTdtTables==NULL || this->partialTdtTables->size() ==0 )



			if ( weights!=NULL ) 
{
if (this->tdtTable->getYDim()!=weights->size())  throw OutOfBounds ( this->tdtTable->getYDim(), weights->size(), "TDTPMeasure::getStatistic())" );
return ((TDTtable*)this->tdtTable)->getWeightedStatistic ( weights );
}
			else return 0;



		for ( int i=0; i<this->partialTdtTables->size(); i++ )
		{
			if ( this->partialTdtTables->getElement ( i ) !=NULL )


				if ( partialWeights[i]!=NULL )
{
if (this->partialTdtTables->getElement ( i )->getYDim()!=partialWeights[i]->size())  throw OutOfBounds ( this->partialTdtTables->getElement ( i )->getYDim(), partialWeights[i]->size(), "TDTPMeasure::getStatistic()-B)" );
					result=result+((TDTtable*)this->partialTdtTables->getElement ( i ))->getWeightedStatistic ( partialWeights[i] );
}

		}
		return result/this->totalFolds;


	};



	/*_________________________________________________________________*/

		TDTPMeasure* TDTPMeasure::getNewMeasure ( SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test )
	{
		return new TDTPMeasure ( ( SampleGeneticCounts* ) tuCounts, this->minFreq, independentCols, this->permutations, this->testMode, ( SampleGeneticCounts** ) training, ( SampleGeneticCounts** ) test, this->useDistances, this->lengthDistance );
	}
	/*_____________________________________________________________________________________________________________*/



		doubleList* TDTPMeasure::getWeights()
	{
		return weights;
	};


	/*____________________________________________________________ */
	/*
	TDTtable* TDTPMeasure::set(TUCounts* aTUCounts)
	{
	TDTtable* result=new TDTtable(aTUCounts->haplotypeTUCountsVector, NULL, 0, minFreq);
	if (result==NULL || result->partition==NULL || result->getTotalHeteroGenotypes()==0) {zap(result);return NULL;}

	return result;
	  //   cout <<"table after semi:\n" << *tdtTable <<"\n";
	}


	/*_____________________________________________________________*/
	/*
		double TDTPMeasure::getPVal()
	  {
	  if (weights!=NULL)
	  {
	   if (tdtTable==NULL) throw NullValue("double TDTPMeasure::getPVal()");
	  if (!independentCols) return pdfTestWeightedChiSquareTDT(getStatistic(), weights);
	  else return pdfTestWeightedChiSquareTDT2(getStatistic()*(tdtTable->getYDim()-1)/(double)tdtTable->getYDim(), weights);
	  }
	  else return 1;
	  }

		/*_____________________________________________________________*/



		double TDTPMeasure::getPVal ( int position, int subsample )
	{
//cout <<"subsample is:" << subsample << "\n";
//if (weights==NULL) cout <<"null weights\n"; else cout << *weights <<"\n";

double statistic;
if (subsample==0) // all 
{
if (this->tdtTable==NULL) return 1; 

if (this->tdtTable->getYDim()!=weights->size())  throw OutOfBounds ( this->tdtTable->getYDim(), weights->size(), "TDTPMeasure::getPVal ( int position, int subsample ))" );
statistic=((TDTtable*)this->tdtTable)->getWeightedStatistic ( weights );
	if ( !independentCols ) 	
return pdfTestWeightedChiSquareTDT ( statistic, weights );
		else  
return pdfTestWeightedChiSquareTDT2 ( statistic * ( this->tdtTable->getYDim()-1 ) / ( double ) this->tdtTable->getYDim(), weights );
}
		AssociationTableVector*tables=this->partialTdtTables; // subsample=1, test


		if (subsample==2 ) tables=this->partialTrainingTdtTables; // training
		if ( tables==NULL || tables->getElement ( position ) ==NULL )
			throw BadFormat ( "double TDTPMeasure::getPVal(int position, bool testing)" );

		if ( partialWeights[position ]==NULL && this->partialTrainingTdtTables->getElement ( position ) !=NULL )
			partialWeights[position]=this->partialTrainingTdtTables->getElement ( position )->getFreqs();


if (tables->getElement ( position )->getYDim()!= partialWeights[position]->size())  throw OutOfBounds ( tables->getElement ( position )->getYDim(),  partialWeights[position]->size(), "TDTPMeasure::getPVal ( int position, int subsample ))-B" );
statistic=((TDTtable*)tables->getElement ( position ))->getWeightedStatistic ( partialWeights[position] );

		if ( !independentCols ) 	return pdfTestWeightedChiSquareTDT ( statistic, partialWeights[position ] );
		else  return pdfTestWeightedChiSquareTDT2 ( statistic * ( tables->getElement ( position )->getYDim()-1 ) / ( double ) tables->getElement ( position )->getYDim(), partialWeights[position ] );

	}
	/*_____________________________________________________________*/


		double TDTPMeasure::getPVal()
	{
		try
		{
			double result=1;
//cout << "here\n";
//cout << "total folds:" << totalFolds <<"\n";
//cout << "independent tablesr:" << independentCols <<"\n";
			if ( this->partialTdtTables==NULL || this->partialTdtTables->size() ==0 )
			{
				if ( this->tdtTable==NULL ) return 1;
				if ( weights==NULL ) weights=this->tdtTable->getFreqs();
//cout <<"weights basic: " << *weights <<"\n";
//cout <<*tdtTable <<"\n";
				if ( !independentCols ) return pdfTestWeightedChiSquareTDT ( getStatistic(), weights );
				else return pdfTestWeightedChiSquareTDT2 ( getStatistic() * ( this->tdtTable->getYDim()-1 ) / ( double ) this->tdtTable->getYDim(), weights );
			}
			int totalOutcomes=0;
//cout << "now total folds:" << totalFolds <<"\n";
//cout << "independent tablesr:" << independentCols <<"\n";
//cout << "total tables:" << partialTdtTables->size() <<"\n";
//			for ( typename Container<vector<TDTtable >, TDTtable >::iterator it=this->partialTdtTables->begin(); it<this->partialTdtTables->end(); it++ )


for (Vector<AssociationTable*>::Class::iterator it=this->partialTdtTables->begin(); it<this->partialTdtTables->end(); it++)


			{
				if ( this->partialTdtTables->getElement ( it ) !=NULL )
				{
//cout << "result before substracting is:" << result << "\n";

					result=result*this->getPVal ( this->partialTdtTables->getPosition ( it ), true );

//cout << "statistic in tdtP is:" << partialTdtTables->getElement ( it )->getWeightedStatistic(partialWeights[partialTdtTables->getPosition ( it ) ]) << "\n";
					totalOutcomes++;
				}
			}
//cout << "result before is:" << result << " and no wis:" << result/totalFolds <<"\n";


			if ( totalOutcomes>0 ) return pdfTestqfast ( result,this->totalFolds ); else return 1;




//if  (partialTdtTables->size()==2 && sumOfHalves) return getPValSumOfHalfNormal(getStatistic());
			//		return pdfTestChiSquare ( getStatistic(),testMode );

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TDTPMeasure::getPVal()" ); throw;};

	}



	/*_____________________________________________________________*/


		void TDTPMeasure::onePrint ( ostream& out, SampleGeneticCounts* aTuCounts, AssociationTable* aTDTtable, int subsample, int position)
	{
		if ( weights!=NULL )
			out <<"Hap freqs:" << *getWeights() <<"\n";
		GroupBasedTDTMeasure::onePrint ( out, aTuCounts, aTDTtable, subsample, position);
	}

};

#endif
