#ifndef __TDTPMeasure_h__
#define __TDTPMeasure_h__

namespace BIOS
{

	/**
	   @memo TDTPMeasure
	   @doc
	   Definition:
	   Class to compute TDTP statistic, which weighs each summand in the mTDT by haplotype frequencies and its null distribution is a weighted chi2

	   @author María del Mar Abad Grau
	   @version 1.0
	  
	  */
	class TDTPMeasure: public GroupBasedTDTMeasure
	{


		private:

			doubleList* weights;



			doubleList**partialWeights;




			bool independentCols;

		public:


			/**
			*	Constructor
			*/
//		TDTPMeasure();

			/**
			*	Destructor
			*/
			virtual	~TDTPMeasure();

			virtual TDTPMeasure* clone();


			/**
			*	Constructor
			*	@param p
			*/
			TDTPMeasure ( SampleGeneticCounts* tuCounts, double minFreq=10, bool independentCols=false, bool permutations=false, int testMode=2, SampleGeneticCounts** partialTuCountsTraining=NULL, SampleGeneticCounts** partialTuCountsTest=NULL, bool useDistance=true, bool lengthDistance=false );

			TDTPMeasure ( double minFreq=10, bool independentCols=false, bool permutations=false, int testMode=2, bool useDistances=true, bool lengthDistance=false );

			TDTPMeasure ( TDTPMeasure& other );



			virtual TDTPMeasure* getNewMeasure ( SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL );

			virtual string getName(); //{return string("mTDTP");};

			/**
			*	Calculate statistic from the tables
			*/

			virtual	double getStatistic();

			//doubleList* getHapFreqs();

//virtual TDTtable* set(TUCounts* aTUCounts);

		virtual double getPVal ( int position, int subsample );

			virtual double getPVal();


			doubleList* getWeights();

virtual TDTPMeasure* inferMeasure(SampleGeneticCounts* tuCounts);

//virtual void print(ostream& out);

	virtual void onePrint ( ostream& out, SampleGeneticCounts* aTuCounts, AssociationTable* aTDTtable, int subsample, int position=-1);

	};


};

#endif
