#ifndef __TDTbranchCompositeMeasure_cpp__
#define __TDTbranchCompositeMeasure_cpp__


namespace BIOS {

template <class T>	TDTbranchCompositeMeasure<T>::TDTbranchCompositeMeasure(SampleGeneticCounts<T>* tuCounts, int k, double minFreq):
	  CompositeTUMeasure<T>(tuCounts, 
		new TDTbranchSimpleMeasure<T>(NULL, k), // Left Measure
		new TDTbranchSimpleMeasure<T>(NULL, k)) // Right Measure
	{
		this->k = k;	
	};

/*_________________________________________________________________*/

template <class T>		TDTbranchCompositeMeasure<T>::TDTbranchCompositeMeasure(int k, double minFreq):
 	  CompositeTUMeasure<T>( 
 		new TDTbranchSimpleMeasure<T>(NULL, k), // Left Measure
 		new TDTbranchSimpleMeasure<T>(NULL, k)) // Right Measure
	{
		this->k = k;
	};

/*_________________________________________________________________*/

template <class T>		TDTbranchCompositeMeasure<T>::TDTbranchCompositeMeasure(TDTbranchCompositeMeasure<T> & other)
	:CompositeTUMeasure<T>(other)
	{
		this->k = other.k;
	}

/*_________________________________________________________________*/

template <class T>		string TDTbranchCompositeMeasure<T>::getName(){
		return string("TDTbranch-"  + tos(k) );
	};

/*_________________________________________________________________*/

template <class T>		string TDTbranchCompositeMeasure<T>::getShortName(){
		return string("TDTB"  + tos(k) );
	};

/*_________________________________________________________________*/

template <class T>	  TDTbranchCompositeMeasure<T>* TDTbranchCompositeMeasure<T>::getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test)
{
	return new TDTbranchCompositeMeasure((TUCounts*)tuCounts, k, this->minFreq);
}
/*_________________________________________________________________*/

/*
		TDTbranchCompositeMeasure::TDTbranchCompositeMeasure()
{
		};
		*/
/*_________________________________________________________________*/

template <class T>			TDTbranchCompositeMeasure<T>::~TDTbranchCompositeMeasure(){
  //tuCounts=NULL;
		};
/*_________________________________________________________________*/

template <class T>			double TDTbranchCompositeMeasure<T>::getStatistic(){
			throw NonImplemented("TDTbranchCompositeMeasure::getStatistic()");
		};
/*_________________________________________________________________*/

template <class T>			stringList* TDTbranchCompositeMeasure<T>::getHeadFile(){
throw NonImplemented("TDTbranchCompositeMeasure::getHeadFile()");
		};
/*_________________________________________________________________*/

template <class T>			TDTbranchCompositeMeasure<T>* TDTbranchCompositeMeasure<T>::clone(){
 			return new TDTbranchCompositeMeasure<T>(*this);
		};

/*
		TDTbranchCompositeMeasure* TDTbranchCompositeMeasure::inferMeasure(TUCounts *t){
 			//return (TDTbranchCompositeMeasure *) CompositeTUMeasure::inferMeasure(t);
	
			TDTbranchCompositeMeasure * compositeMeasure = new TDTbranchCompositeMeasure(tuCounts,k, minFreq);
			
			// Replace left and right measures 
			compositeMeasure->measureLeft = measureLeft->inferMeasure( measureLeft->tuCounts->clone() );
			compositeMeasure->measureRight = measureRight->inferMeasure( measureRight->tuCounts->clone() );
	
			return compositeMeasure;

		};
*/
/*_________________________________________________________________*/



/*_________________________________________________________________*/

template <class T>			SampleGenericCounts* TDTbranchCompositeMeasure<T>::getTUCounts(){
  return this->counts;
		};

/*_____________________________________________________________*/


	template <class T>		void TDTbranchCompositeMeasure<T>::print(ostream& out){
 throw NonImplemented(" TDTbranchCompositeMeasure::print(ostream& out)");
		};

/*_____________________________________________________________*/

 template <class T>	 TDTbranchCompositeMeasure<T>* TDTbranchCompositeMeasure<T>::fromString(string s){throw NonImplemented("TDTbranchCompositeMeasure::fromString(string s)");};


};

#endif
