#ifndef __TDTbranchCompositeMeasure_h__
#define __TDTbranchCompositeMeasure_h__

namespace BIOS {
	
	/**
		@memo TDTbranchCompositeMeasure
		@doc
		Definition:

		TreeDT algorithm inspired in Sevon et al. "TreeDT: Tree Pattern Mining for Gene Mapping" (2006)

		@author Jose J. Moreno
		@version 1.0
	*/	
	


	template <class T> class TDTbranchCompositeMeasure: public CompositeTUMeasure<T>{

		int k;
		//TUCounts* tuCounts;
		//! haplotype vector
		//HaplotypeTUCountsVector* v;
		

		//virtual double getMinPVal(HaplotypeTUCountsVector *v, bool toLeft=false);

		public:
		/**
		*	Constructor
		*/		
		TDTbranchCompositeMeasure();


		/**
		 * Copy constructor
		 * @param other Measure to clone
		 */
		TDTbranchCompositeMeasure(TDTbranchCompositeMeasure<T> & other);

		/**
		*	Constructor
		*	@param maxK Maximum level k
		*/	

		TDTbranchCompositeMeasure(SampleGeneticCounts<T>* tuCounts, int k, double minFreq=10);

		TDTbranchCompositeMeasure(int k, double minFreq=10);

		/**
		*	Destructor
		*/		
		virtual ~TDTbranchCompositeMeasure();

		virtual TDTbranchCompositeMeasure* clone();

// 		virtual TDTbranchCompositeMeasure* inferMeasure(TUCounts *t);


		/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		virtual double getStatistic();

		/**
		*	Calculates the p-value of the sample set as the minimum p_k. 
		*	A p_k value is calculated for each k.
		*	@see getPvalueForK()
		*	@return p-value		
		*/

		//virtual double getPVal();


		virtual string getName();
		virtual string getShortName();

		virtual stringList* getHeadFile();

		virtual TDTbranchCompositeMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);

		SampleGenericCounts* getTUCounts();

		TDTbranchCompositeMeasure* fromString(string s);
		
		virtual void print(ostream&);

		//friend ostream& operator<<(ostream& out, TDTbranchCompositeMeasure& l){};

	};



/*
{

}
*/

};

#endif
