#ifndef __TDTbranchSimpleMeasure_h__
#define __TDTbranchSimpleMeasure_h__

namespace BIOS {
	
	/**
		@memo TDTbranchSimpleMeasure
		@doc
		Definition:

		TreeDT algorithm inspired in Sevon et al. "TreeDT: Tree Pattern Mining for Gene Mapping" (2006)

		@author Jose J. Moreno
		@version 1.0
	*/	
	


class TDTbranchSimpleMeasure: public Chi2TDTMeasure{

		int k;
		//! If true, analyze k={2,3,...,k-1,k}. If false, analyze k={k}
		bool useMaxK;
		//TUCounts* tuCounts;

		//int side;

		//virtual double getMinPVal(HaplotypeTUCountsVector *v, bool toLeft=false);

		public:

		/**
		*	Constructor
		*/		
		TDTbranchSimpleMeasure();

		/**
		 * Copy constructor
		 * @param other Measure to clone
		 */
		TDTbranchSimpleMeasure(TDTbranchSimpleMeasure & other);



		/**
		 * 
		 * @param tuCounts 
		 * @param k 
		 * @param useMaxK If true, analyze k={2,3,...,k-1,k}. If false, analyze k={k}
		 * @param minFreq 
		 */
		TDTbranchSimpleMeasure(SampleGeneticCounts* tuCounts, int k, bool useMaxK=false, double minFreq=10);

		/**
		*	Destructor
		*/		
		virtual ~TDTbranchSimpleMeasure();

		virtual TDTbranchSimpleMeasure* clone();



		/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		//virtual double getStatistic();

		/**
		*	Calculates the p-value of the sample set as the minimum p_k. 
		*	A p_k value is calculated for each k.
		*	@see getPvalueForK()
		*	@return p-value		
		*/

		//virtual double getPVal();

		//virtual TDTbranchSimpleMeasure* clone();

		virtual string getName();

		virtual stringList* getHeadFile();

		virtual TDTbranchSimpleMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);

		
		//virtual TDTbranchSimpleMeasure* inferMeasure(TUCounts* tuCounts);

		TUCounts* getTUCounts();
		
		void setTUCounts(TUCounts* tuCounts);

		TDTbranchSimpleMeasure* fromString(string s);
		
		virtual void print(ostream&);

		//friend ostream& operator<<(ostream& out, TDTbranchSimpleMeasure& l){};

	};



/*
{

}
*/

};

#endif
