#ifndef __TUMeasure_h__
#define __TUMeasure_h__

namespace BIOS {
	
  /**
     @memo TUMeasure
     @doc
     Definition:
	
An abstract class for measure computed from T/U counts of trio samples

     @author María Mar Abad Grau
     @version 1.0
	
	*/	
	
class HapExtractionConfiguration;

class SampleTUCounts;
class TUMeasure;

typedef  Vector<TUMeasure*>::Class ListOfTUMeasures;

class TUMeasure: public GenericMeasure{

    
  protected:

// bool permutations;
 

 


		public:

 double minFreq;
//int* positions;

//int length;	
// SampleTUCounts* tuCounts;

		/**
		*	Constructor
		*/		
	//	TUMeasure(bool permutations=false);

	TUMeasure(SampleGeneticCounts* tuCounts, double minFreq=0, bool permutations=false);

	TUMeasure(double minFreq, bool permutations=false);

	TUMeasure();
	
		TUMeasure(TUMeasure& other);
		
		string addPermutationsInName();

		/**
		*	Destructor
		*/		
		virtual ~TUMeasure();

virtual TUMeasure* clone()=0;

  virtual GenericMeasure* getNewGenericMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);
  
  virtual TUMeasure* inferGenericMeasure(SampleGenericCounts* tuCounts);
  
  
//  	virtual TUMeasure* getNewMeasure(TUCounts* tuCounts, SampleTUCounts** training=NULL, SampleTUCounts** test=NULL);
	
	
  	virtual TUMeasure* inferMeasure(SampleGeneticCounts* tuCounts);

  virtual MeasureResults* getResults();

 
 virtual double getTotalMultipleTest();
 
 
virtual GeneticUnitCountsSample* getPartition (GeneticUnitCountsVector* hapCountsVector, double totalFirst, double totalSecond ){throw NonImplemented("GeneticUnitCountsSample* getPartition (GeneticUnitCountsVector* hapCountsVector, double totalFirst, double totalSecond )");};
  
 // virtual SampleGenericCounts* getCounts(char* fileSample, int totalPermutations, int* pos, int size);


/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		virtual double getStatistic()=0;

		//virtual double getPVal()=0;

//  virtual double getPValWithPermutations()=0;

 // virtual stringList* getFreqsResults()=0;

  virtual string getName()=0;
	

  virtual stringList* getHeadFile()=0;

  SampleGenericCounts* getTUCounts();

	virtual void setTUCounts(SampleTUCounts *t);

  TUMeasure* fromString(string s);

//friend ostream& operator<<(ostream& out, TUMeasure& l) {cout <<"isss\n"; return l.print(out); cout <<"after\n";};

virtual void print(ostream&)=0;

	};



/*
{

}
*/

};

#endif
