#ifndef __TreeDTMeasure_cpp__
#define __TreeDTMeasure_cpp__
#include "TreeDTMeasure.h"
#include "../HaplotypeTUCounts.h"
#include "../../SNP.h"
#include "../../../commonc++/basic.h"

//#define debug_TreeDTMeasure_translateTree

//#define PRINT_HISTOGRAM_LEVEL1 1
//#define PRINT_HISTOGRAM_LEVEL2 1
//#define PRINT_HISTOGRAM_LEVEL3 1
int HISTOGRAM_K=0;

namespace BIOS {


/*
		TreeDTMeasure::TreeDTMeasure()
{
		};
	*/
// 	template <class T>
	void TreeDTMeasure::copyVector( vector<TreeOfHaplotypeTUCounts *> & original, vector<TreeOfHaplotypeTUCounts *> &copy )
	{
	  	//copy = new vector<T*>();
		for(int i=0; i< original.size(); i++){
			//copy.push_back( (T *)original[i]->clone() );
			copy.push_back( (TreeOfHaplotypeTUCounts *) new TreeOfHaplotypeTUCounts( *original[i] ) );
		}
	}

/*_________________________________________________________________*/

	void TreeDTMeasure::copyTableVector(vector<TDTtable> & original, vector<TDTtable> &copy )
	{
		for(int i=0; i< original.size(); i++){
		   TDTtable *t = original[i].clone();
			copy.push_back(  *t );
			delete t;
		}
	}

/*_________________________________________________________________*/

	TreeDTMeasure::TreeDTMeasure(TreeDTMeasure & other):GroupBasedTDTMeasure(other){
// 	  cout << "calling TreeDTMeasure(TreeDTMeasure & other) " << endl;

	  	this->tuCounts = other.tuCounts;
		this->npermu = other.npermu;
		this->implementation = other.implementation;
		this->minFreq = other.minFreq;
// 		this->copyHaplotypeTUCountsVector = other.copyHaplotypeTUCountsVector->clone();
		//this->expandedHaplotypeVector = other.expandedHaplotypeVector->clone();
		this->sumFrequencyT = other.sumFrequencyT;
		this->sumFrequencyU = other.sumFrequencyU;
		this->nchromoF = other.nchromoF;
		mdata = NULL;
		status = NULL;
		maxallele = NULL;
		mutation = NULL;
		this->nchromo = other.nchromo;
		this->fixed_k = other.fixed_k;
		this->closest_mk = -1;

		this->nmarkers = other.nmarkers;
		this->na = other.na;
		this->nc= other.nc;
		this->nmuta= other.nmuta;

		this->npermu = other.npermu;
		this->seed = other.seed;

		this->correct_locus = other.correct_locus;

		this->statisticUsed = other.statisticUsed;
/*
		location = (double *)malloc(nmarkers * sizeof(double));
		for(int i=0; i<nmarkers;i++){
			this->location[i] = other.location[i];
		}*/

		// copy treeEmtpyNodes
// 		this->treeEmtpyNodes = other.treeEmtpyNodes;
		//copyVector<HaplotypeTUCounts>(other.treeEmtpyNodes, this->treeEmtpyNodes);


// 		copyVector(other.vectorOfTrees1, this->vectorOfTrees1); // copy vectorOfTrees1
// 		copyVector(other.vectorOfTrees2, this->vectorOfTrees2); // copy vectorOfTrees2

		for(int i=0; i< other.leftTrees.size(); i++){
			this->leftTrees.push_back( new HaplotypeTUCountsTree( *(other.leftTrees[i]) ) );
			this->rightTrees.push_back( new HaplotypeTUCountsTree( *(other.rightTrees[i]) ) );
		}


		copyTableVector(other.vectorOfTables1, this->vectorOfTables1);
		copyTableVector(other.vectorOfTables2, this->vectorOfTables2);
		
		this->posMinPlevel3 = other.posMinPlevel3;
		this->totalMultipleTest = other.totalMultipleTest;
		
		if(other.model != NULL)
			this->model = other.model->clone();
		else
			this->model = NULL;



	}

/*_________________________________________________________________*/


	TreeDTMeasure::TreeDTMeasure(TUCounts* tuCounts, int npermu, int implementation, double minFreq, int testMode, TUCounts** partialTuCountsTraning, TUCounts** partialTuCountsTest)
// 	:GroupBasedTDTMeasure(tuCounts)
:GroupBasedTDTMeasure(tuCounts, minFreq, testMode, partialTuCountsTraning, partialTuCountsTest, false, false)
	{
	 try
{
		 table2 = NULL;
		 this->posMinPlevel3=-1;

		first_free_node=NULL;
		first_free_listnode = NULL;
		first_npool = NULL;
		first_lnpool = NULL;
		
		this->model = NULL;

		this->npermu = npermu;
		overall_p=-1;
		this->implementation=implementation;
		this->minFreq = minFreq;
		this->closest_mk = -1;
		this->fixed_k = 0;
		
		this->totalMultipleTest=1;
		this->statisticUsed=0;
		
		if( testMode == 0 || testMode == -1 ){
			if ( tuCounts != NULL){
				setTUCounts(tuCounts);
			}
			
		}

		  if (  testMode == 1 || testMode==-2){
			if (partialTuCountsTraning != NULL)
			  	setTUCounts(partialTuCountsTraning[0]);
		  }
	}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TreeDTMeasure::TreeDTMeasure(TUCounts* tuCounts, int npermu, int implementation, double minFreq, int testMode, TUCounts** partialTuCountsTraning, TUCounts** partialTuCountsTest)" ); throw;};
	};

/*_________________________________________________________________*/

	void TreeDTMeasure::setPermutations(int npermu)
	{
	  this->npermu = npermu;
	}

/*_________________________________________________________________*/


	int TreeDTMeasure::getPermutations()
	{
	  return this->npermu;
	}

/*_________________________________________________________________*/

	void TreeDTMeasure::setTUCounts(TUCounts* tuCounts)
	{
try
{
		this->tuCounts = tuCounts;
		if( tuCounts->expandedHaplotypeVector == NULL){
			tuCounts->expandedHaplotypeVector = tuCounts->haplotypeTUCountsVector->expand();
			//tuCounts->expandedHaplotypeVector = tuCounts->haplotypeTUCountsVector->clone();
			tuCounts->copyHaplotypeTUCountsVector = tuCounts->expandedHaplotypeVector->clone();
		}
		// Calculate number of chromosomes
		nchromo = tuCounts->expandedHaplotypeVector->size();
		//nchromo = tuCounts->expandedHaplotypeVector->getFreqSum();

		// Calculate number of markers
		nmarkers = tuCounts->getTotalPos();

		
		if (nchromo == 0)
		{
			model = NULL;
			return;
		}

		
		createTrees();
		createModel0();
		
	
		
		// create tdt tables with haplotypes
		if ( this->tdtTable != NULL)
			delete this->tdtTable;
		this->tdtTable = new TDTtable(tuCounts->haplotypeTUCountsVector);

		// update it with training set

		model->leftTable = tdtTable->clone();
		model->rightTable = tdtTable->clone();


		//HaplotypeTUCountsTree * hapT1 = leftTrees[3]->getCloneDuplicatingLeaves( );
		//delete hapT1;
		
		int m;
		model->posMinPlevel3 = this->posMinPlevel3;
		if(model->posMinPlevel3 > 0)
		{
			m = model->posMinPlevel3-1;
			//model->leftTree = new HaplotypeTUCountsTree( *leftTrees[m] ); // copy left tree
			resetFrequencies(leftTrees[m]);
			model->leftTree = leftTrees[m]->getCloneDuplicatingLeaves();
			model->leftTree->collapse();
		}
		if(model->posMinPlevel3 < nmarkers)
		{
			m = model->posMinPlevel3;  
			//model->rightTree = new HaplotypeTUCountsTree( *rightTrees[nmarkers - 1 - m] ); // copy left tree
			resetFrequencies(rightTrees[nmarkers - 1 - m]);
			model->rightTree = rightTrees[nmarkers - 1 - m]->getCloneDuplicatingLeaves();
			model->rightTree->collapse();
		}			
		
		if(testMode==1 || testMode==-2){
		
			if(model->posMinPlevel3 > 0)
				model->leftTable->update( partialTuCountsTest[0]->parentalHaplotypesList, true, true, model->posMinPlevel3-1, true ); // update table
			
			if(model->posMinPlevel3 < nmarkers)
				model->rightTable->update( partialTuCountsTest[0]->parentalHaplotypesList, true, true, model->posMinPlevel3, false ); // update table
		

		}
		/*
		if(model->leftTree !=NULL){
			cout << "Best k left = " << model->leftTree->best_k << endl;
			model->leftTree->print();
			model->leftTree->printBestNodes();
			cout << endl;
		}
		if(model->rightTree !=NULL){
			cout << "Best k right = " << model->rightTree->best_k << endl;
			model->rightTree->print();
			model->rightTree->printBestNodes();
			cout << endl;
		}
		*/
		//model->printDistro(model->distributionLevel1right);
		
//		model->leftTable->twice();
//		model->rightTable->twice();
		
//		if( testMode == 1){
//			// needed to find the best sub-trees
//			getPVal_mode0();
//
//
//			// ////////// CREATE MODEL ***********************
//			
//					
//					
//					// create tdt tables with haplotypes
//					if ( this->tdtTable != NULL)
//						delete this->tdtTable;
//					this->tdtTable = new TDTtable(tuCounts->haplotypeTUCountsVector);
//					
//					// update it with training set
//					
//					model->leftTable = tdtTable->clone();
//					model->rightTable = tdtTable->clone();
//					
//					
//					int m;
//					model->posMinPlevel3 = this->posMinPlevel3;
//					if(model->posMinPlevel3 > 0)
//					{
//						m = model->posMinPlevel3-1;
//						model->leftTable->update( partialTuCountsTest[0]->parentalHaplotypesList, true, true, m, true ); // update table
//						model->leftTree = new HaplotypeTUCountsTree( *leftTrees[m] ); // copy left tree				
//					}
//					if(model->posMinPlevel3 < nmarkers)
//					{
//						m = model->posMinPlevel3;  
//						model->rightTable->update( partialTuCountsTest[0]->parentalHaplotypesList, true, true, m, false ); // update table
//						model->rightTree = new HaplotypeTUCountsTree( *rightTrees[m] ); // copy left tree				
//
//					
//					}	
//					
//			//tdtTable->update( partialTuCountsTest[0]->parentalHaplotypesList, true, true, m, true ); // update table
//
//		}
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void TreeDTMeasure::setTUCounts(TUCounts* tuCounts)" ); throw;};
	}

/*_________________________________________________________________*/

	void TreeDTMeasure::createTDTtables()
	{
		// For each marker
		for (int m = 0; m < nmarkers; m++){
			// Create left table
			{
				PartitionHaplotypeTUCountsVector * p = vectorOfTrees1[m]->getBestLeaves(); // Create partition of vectors from tree
				TDTtable *t = new TDTtable(p); // create table from partition of vectors
				vectorOfTables1.push_back(*t); // Insert table in array
				delete p; // free memory
				delete t;
			}
			// Create right table
			{
				PartitionHaplotypeTUCountsVector * p = vectorOfTrees2[m]->getBestLeaves();
				TDTtable *t = new TDTtable(p);
				vectorOfTables2.push_back(*t);
				delete p;
				delete t;

			}
		}
	}

/*_________________________________________________________________*/

	TreeDTModel * TreeDTMeasure::createModel(HaplotypeTUCountsVector *v)
	{
		
	}
	
	
	void TreeDTMeasure::createTrees()
	{
try
{
		if ( tuCounts == NULL){
			cerr << " Not TUCounts present [ TreeDTMeasure::createModel() ]... " << endl;
			return;
		}

		read_data();
		allocate_sortlist();
		init_left_sort();
		
		for (int m = 0; m < nmarkers; m++)
		{
			left_update();  // 			print_tree(root, 0);
			//current_location = location[m] + 0.5;
			HaplotypeTUCountsTree * t=translateTree_b(root);
			leftTrees.push_back(t);
		}
		
		finalize_sort();
		init_right_sort();
		for (int m = 0; m < nmarkers; m++)
		{
			right_update();
			//current_location = location[nmarkers - m] - 0.5;
			HaplotypeTUCountsTree * t2=translateTree_b(root);
			rightTrees.push_back(t2);

		}
		finalize_sort();
		free_sortlist();
		dispose_data();
	}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	void TreeDTMeasure::createModel()" ); throw;};
	}
	 /*_________________________________________________________________*/

	double TreeDTMeasure::getPVal()
	{
		if (testMode == -2)
			return getPValFromModel2(this->model);
		else
			if (testMode==-3)
				return getPValFromModel3(this->model);
			else
				return getPValFromModel(this->model);
		
	}

 /*_________________________________________________________________*/

	HaplotypeTUCountsVector * TreeDTMeasure::inferVector( HaplotypeTUCountsVector * v1, HaplotypeTUCountsVector * v2)
	{
	  HaplotypeTUCountsVector * result;

	  result = v1->clone();

	  // update frecuencies using v2


	  return result;
	}

/*_________________________________________________________________*/

	double TreeDTMeasure::getPVal(TreeDTModel *model)
	{

		double best_score;

		if (npermu > 0) alloc_permu();
		seed = 0;

		if(model->posMinPlevel3 > 0){
			best_score = getStatistic( model->leftTable, model->leftTree);
			permu_best_score2(0, model->posMinPlevel3-1, model->leftTree, best_score);
		}

		if(model->posMinPlevel3 < nmarkers)
		{			
			best_score = getStatistic( model->rightTable, model->rightTree);
			permu_best_score2(1, model->posMinPlevel3, model->rightTree, best_score);

		}

		permu_phase2(model->posMinPlevel3);

		overall_p = obs_pval2[model->posMinPlevel3];
		free_permu();

		return overall_p;		
		
		
	}
	
	double TreeDTMeasure::getPVal_mode2()
	{
	  double best_score;

		if (npermu > 0) alloc_permu();
		seed = 0;

		if(model->posMinPlevel3 > 0){
			best_score = getStatistic( model->leftTable, model->leftTree);
			permu_best_score2(0, model->posMinPlevel3-1, model->leftTree, best_score);
		}
		
		if(model->posMinPlevel3 < nmarkers)
		{			
			best_score = getStatistic( model->rightTable, model->rightTree);
			permu_best_score2(1, model->posMinPlevel3, model->rightTree, best_score);
			
		}
		
		// left to right ** 1 *
		//for (int m = 0; m < nmarkers; m++)
/*
		int m;
		if(this->posMinPlevel3 > 0)
		{
			m = this->posMinPlevel3-1;
			TDTtable * tableClone = this->tdtTable->clone(); // copy tdtable
			tableClone->update( partialTuCountsTest[0]->parentalHaplotypesList, true, true, m, true ); // update table
			best_score = getStatistic( tableClone, leftTrees[m]);			
			delete tableClone;			
			
			

			//best_score = getStatistic( this->tdtTable, vectorOfTrees1[m]);
// 			cerr << "M"<< m << "S0" << "Best score in pval2: " << best_score<<endl;
// 			cerr << *this->tdtTable<< endl;
// 			cerr << *vectorOfTrees1[m]<<endl;
			permu_best_score2(0, m, leftTrees[m], best_score);
		}// BIOS::printArray(obs_score2, 2*nmarkers );
*/

		// right to left *** 2 ***
		//for (int m = 0; m < nmarkers; m++)
		
		/*
		m = this->posMinPlevel3;
		if(m < nmarkers)
		{
			m = this->posMinPlevel3;
			TDTtable * tableClone = this->tdtTable->clone(); // copy tdtable
			tableClone->update( partialTuCountsTest[0]->parentalHaplotypesList, true, true, m, false ); // update table
			//best_score = getStatistic( tableClone, rightTrees[m]);
			delete tableClone;
			//best_score = getStatistic( tdtTable, rightTrees[m]);
			
// 			best_score = getStatistic( this->tdtTable, vectorOfTrees2[m]);
// 			cerr << "M"<< m << "S1" << "Best score in pval2: " << best_score<<endl;
			//permu_best_score2(1, m, rightTrees[m], best_score);
		} // BIOS::printArray(obs_score2, 2*nmarkers); cout << endl;
*/
		//for (int m = 0; m < nmarkers + 1; m++) 
		permu_phase2(model->posMinPlevel3); //BIOS::printArray(obs_pval2, nmarkers + 1);

		//write_power(stdout);
		
		overall_p = obs_pval2[model->posMinPlevel3];
		free_permu();

		return overall_p;

	}

/*_________________________________________________________________*/
	void TreeDTMeasure::allocate_distribution(double ** &d){
		d = new double*[nmarkers];
		for(int i=0; i<nmarkers+1; i++){
			d[i] = new double[npermu];
		}		
	}
	
	void TreeDTMeasure::free_distribution(double ** &d){
		for(int i=0; i<nmarkers+1; i++){
			delete [] d[i];
		}
		delete d;
		d=NULL;		
	}	
	
	void TreeDTMeasure::createModel0()
	{
		
		
		model = new TreeDTModel();
		

		if (npermu > 0) alloc_permu();
		seed = 0;

		
		double **distributionsLeft;		
		allocate_distribution(distributionsLeft);

		double **distributionsRight; 		
		allocate_distribution(distributionsRight);				
		
		
		double *bestDistribution = new double[npermu];
		// left to right ** 1 **
		for (int m = 0; m < nmarkers; m++)
		{
			//current_location = location[m] + 0.5;
			resetFrequencies(leftTrees[m]);
			calculate_scores( leftTrees[m] , obs_score1, true);
			
			
			
			
			permu_phase1(0, m, bestDistribution);
			
			// store best distribution for marker
			for(int i=0; i<npermu; i++) distributionsLeft[m][i] = bestDistribution[i];

		}
		
		

		// right to left *** 2 ***
		for (int m = 0; m < nmarkers; m++){
		  //current_location = location[nmarkers - m] - 0.5;
		  resetFrequencies( rightTrees[m] );
		  calculate_scores(rightTrees[m], obs_score1, true);
		  permu_phase1(1, nmarkers - m - 1, bestDistribution);
		  
			// store best distribution for marker
			for(int i=0; i<npermu; i++) distributionsRight[nmarkers - m - 1][i] = bestDistribution[i];
		}
		
		delete [] bestDistribution;
		
		double **distributions; // Store all distribution, and pick the best later	
		allocate_distribution(distributions);
//		distributions = new double*[nmarkers];
//		for(int i=0; i<nmarkers+1; i++){
//			distributions[i] = new double[npermu];
//		}
		
		for (int m = 0; m < nmarkers + 1; m++) permu_phase2(m, distributions);
		

		

		model->fillDistributionLevel3(min_permu_pval2, npermu);

		write_power(stdout);
		
		
		// Store distribution for level 2
		model->fillDistributionLevel2(distributions[model->posMinPlevel3], npermu);	
		
		// store distributions for level 1
		if(model->posMinPlevel3 > 0)
			model->fillDistributionLevel1(distributionsLeft[model->posMinPlevel3-1], npermu, 0);
		model->fillDistributionLevel1(distributionsRight[model->posMinPlevel3], npermu, 1);
		
		
		free_distribution(distributions);
		free_distribution(distributionsLeft);
		free_distribution(distributionsRight);
//		for(int i=0; i<nmarkers+1; i++){
//			delete [] distributions[i];
//		}
//		delete distributions;
//		distributions=NULL;		
		
		
		free_permu();

	}	
	
	double TreeDTMeasure::getPValFromModel2(TreeDTModel *model){
		
		if (model == NULL)
			return 1;

		if (npermu > 0) alloc_permu();
		seed = 0;
		
		
		// create permutations
		partialTuCountsTest[0]->totalPermutations = npermu;
		partialTuCountsTest[0]->getPermutations();
		
		
		double best_score, tmp_score, p_value_left=1, p_value_right=1;
		bool toLeft, useDistances=true, treeDT=true;
		
		// left part
		
		if(model->posMinPlevel3 > 0){
			best_score = getStatistic(model->leftTable, model->leftTree);
			
			
			// Create distribution
			RandomizationDistribution * rd = new RandomizationDistribution();
			
			for(int i1=0; i1<npermu; i1++){
				
			  	TDTtable * tableClone = model->leftTable->clone(); // copy tdtable
				TUCounts * permutation = (TUCounts*) partialTuCountsTest[0]->getPermutations()[i1]; // Create a permutation of the tuCountsTest
				tableClone->update( permutation->parentalHaplotypesList, useDistances, treeDT, model->posMinPlevel3-1, toLeft=true ); // update table
				tmp_score = getStatistic(tableClone, model->leftTree);
				delete tableClone;				
				rd->values->push_back(tmp_score);				
			}

			rd->sort();
			p_value_left = rd->getPvalue(best_score);
			
			delete rd;
			
		}
		
		
		// right part
		
		if(model->posMinPlevel3 < nmarkers){
			best_score = getStatistic(model->rightTable, model->rightTree);
			
			// Create distribution
			RandomizationDistribution * rd = new RandomizationDistribution();
			
			for(int i1=0; i1<npermu; i1++){
				
			  	TDTtable * tableClone = model->rightTable->clone(); // copy tdtable
				TUCounts * permutation = (TUCounts*) partialTuCountsTest[0]->getPermutations()[i1]; // Create a permutation of the tuCountsTest
				tableClone->update( permutation->parentalHaplotypesList, useDistances, treeDT, model->posMinPlevel3, toLeft=false ); // update table
				tmp_score = getStatistic(tableClone, model->rightTree);
				delete tableClone;				
				rd->values->push_back(tmp_score);				
			}

			rd->sort();
			p_value_right = rd->getPvalue(best_score);
			
			delete rd;
			
			
		}		
		//return p_value_right;
		return combinePvalues(p_value_left, p_value_right);
	}
	
	
	
	double TreeDTMeasure::getPValFromModel3(TreeDTModel *model){

		if (model == NULL)
			return 1;

		if (npermu > 0) alloc_permu();
		seed = 0;
		
		
		// create permutations
		partialTuCountsTest[0]->totalPermutations = npermu;
		partialTuCountsTest[0]->getPermutations();
		
		
		double best_score, tmp_score, p_value=1;
		bool toLeft, useDistances=true, treeDT=true;
		
		
		best_score = getStatistic(model->leftTable, model->leftTree, model->rightTable, model->rightTree);
			
			
		// Create distribution
		RandomizationDistribution * rd = new RandomizationDistribution();
			
		for(int i1=0; i1<npermu; i1++){
		
			TUCounts * permutation = (TUCounts*)partialTuCountsTest[0]->getPermutations()[i1]; // Create a permutation of the tuCountsTest
			
			TDTtable * leftTable, *rightTable; 
			HaplotypeTUCountsTree * leftTree=NULL, * rightTree=NULL;
			if(model->posMinPlevel3 > 0){
			  	leftTable = model->leftTable->clone(); // copy tdtable
				leftTable->update( permutation->parentalHaplotypesList, useDistances, treeDT, model->posMinPlevel3-1, toLeft=true ); // update table
				leftTree=model->leftTree;
			}	
			
			
			if(model->posMinPlevel3 < nmarkers){
				rightTable = model->rightTable->clone(); // copy tdtable
				rightTable->update( permutation->parentalHaplotypesList, useDistances, treeDT, model->posMinPlevel3, toLeft=false ); // update table
				rightTree=model->rightTree;
			}
			
			tmp_score = getStatistic(leftTable, leftTree, rightTable, rightTree);
			
				
			delete leftTable;
			delete rightTable;				
			rd->values->push_back(tmp_score);				
		}

		rd->sort();
		p_value = rd->getPvalue(best_score);
			
		delete rd;
			
		
		return p_value;
			
	}	
	
	
	double TreeDTMeasure::combinePvalues(double pL, double pR)
	{
		//return 	(pL*pR)/(   pL*pR + (1-pL)*pR + pL*(1-pR) + (1-pL)*(1-pR)   );
		return sqrt(pL*pR);
	}
	
	double TreeDTMeasure::getPValFromModel(TreeDTModel *model){
		if (model == NULL)
			return 1;
		
	
		if (npermu > 0) alloc_permu();
		seed = 0;
		// left to right ** 1 **
		double best_score;
		if(model->posMinPlevel3 > 0){
//			resetFrequencies(model->leftTree);
//			best_score = model->leftTree->getBestScore(sumFrequencyT, sumFrequencyU);
			
			
			// permutation way
			best_score = getStatistic(model->leftTable, model->leftTree);
			level1Distribution(0, model->posMinPlevel3-1, best_score, model->distributionLevel1left);
			// Minimum left p-value stored in obs_score2[model->posMinPlevel3-1]
			
			// binomial way
//			obs_score2[model->posMinPlevel3-1] = calculatePvalFromBinomial(model->leftTable, model->leftTree);
			
		}		
		
		
//		if(model->posMinPlevel3 < nmarkers){
//			int m=nmarkers - model->posMinPlevel3 -1;
//		  resetFrequencies( rightTrees[m] );
//		  calculate_scores(rightTrees[m], obs_score1, true);
//		  permu_phase1(1, model->posMinPlevel3);
//
//		}
		
		if(model->posMinPlevel3 < nmarkers){
//			resetFrequencies(model->rightTree);
//			best_score = model->rightTree->getBestScore(sumFrequencyT, sumFrequencyU);
			
			// permutation way
			best_score = getStatistic(model->rightTable, model->rightTree);
			level1Distribution(1, model->posMinPlevel3, best_score, model->distributionLevel1right);
			// Minimum right p-value stored in obs_score2[nmarkers + model->posMinPlevel3]
			
//			cout << "before: " << obs_score2[nmarkers + model->posMinPlevel3] << endl;
			// binomial way
//			obs_score2[nmarkers + model->posMinPlevel3] = calculatePvalFromBinomial(model->rightTable, model->rightTree);
			
//			cout << "after: " << obs_score2[nmarkers + model->posMinPlevel3] << endl;
			
		}

		
		
		
		double local_p;
		
		local_p = permu_phase2_fromModel(model);
		//for (int m = 0; m < nmarkers + 1; m++) permu_phase2(m); // Calcula el valor p y la distribucion
		//level3Pvalue = obs_pval2[model->posMinPlevel3]; // valor local_p (que debe ser corregido). Obtenido desde permu_phase2

		
		model->exportDistributionLevel3(min_permu_pval2); // recover distribution for level 3
		
		if (testMode==0){
			overall_p = total_p(local_p);	// correct local_p value
			//cout << "correcting ..." << endl;
		}
		else{
			overall_p = local_p;
			// cout << "not correcting ..." << endl;
		}
		
		//cout << overall_p << ", ";
		free_permu();

		return overall_p;		
		
	}

	double TreeDTMeasure::getPVal_mode0()
	{
		
		
		model = new TreeDTModel();
		

		if (npermu > 0) alloc_permu();
		seed = 0;

		#ifdef PRINT_HISTOGRAM_LEVEL1
		cout << "par(mfcol=c(2,5) )" << endl;
		#endif
		// left to right ** 1 **
		for (int m = 0; m < nmarkers; m++)
		{
			//current_location = location[m] + 0.5;
			//vectorOfTrees1[m]->print();
 			//resetFrequencies( vectorOfTrees1[m] );
			resetFrequencies(leftTrees[m]);
// 			if ( m==0)
// 			  	vectorOfTrees1[m]->print();

			//calculate_scores( vectorOfTrees1[m] , obs_score1, true);
			calculate_scores( leftTrees[m] , obs_score1, true);

			//cout << endl;
  			//write_subscores(stdout, m);

			permu_phase1(0, m);
 			//write_sub_pvalues(stdout, m);

		}

		#ifdef PRINT_HISTOGRAM_LEVEL1
		cout << "dev2bitmap(\"k" << HISTOGRAM_K+1 << "-s0.pdf\", type=\"pdfwrite\", width=24, height=12)" << endl;
		cout << "par(mfcol=c(2,5) )" << endl;
		#endif
// 		BIOS::printArray(obs_score2, 2*nmarkers );

		// right to left *** 2 ***
		for (int m = 0; m < nmarkers; m++){
// 		  current_location = location[nmarkers - m] - 0.5;
// 		  resetFrequencies( vectorOfTrees2[m] );
// 		  calculate_scores(vectorOfTrees2[m], obs_score1, true);
// //  		  write_subscores(stdout, m);
// 		  permu_phase1(1, nmarkers - m - 1);
// // 		  write_sub_pvalues(stdout, nmarkers - m - 1);

		  //current_location = location[nmarkers - m] - 0.5;
		  resetFrequencies( rightTrees[m] );
		  calculate_scores(rightTrees[m], obs_score1, true);
//  		  write_subscores(stdout, m);
		  permu_phase1(1, nmarkers - m - 1);
// 		  write_sub_pvalues(stdout, nmarkers - m - 1);

		}
		#ifdef PRINT_HISTOGRAM_LEVEL1
		cout << "dev2bitmap(\"k" << HISTOGRAM_K+1 << "-s1.pdf\", type=\"pdfwrite\", width=24, height=12)" << endl;
		#endif


		#ifdef PRINT_HISTOGRAM_LEVEL2
		cout << "par(mfcol=c(2,6) )" << endl;
		#endif
		for (int m = 0; m < nmarkers + 1; m++) permu_phase2(m);
#ifdef PRINT_HISTOGRAM_LEVEL2
cout << "dev2bitmap(\"level2.pdf\", type=\"pdfwrite\", width=24, height=12)" << endl;
#endif

//  		BIOS::printArray(obs_pval2, nmarkers + 1);


		model->fillDistributionLevel3(min_permu_pval2, npermu);

		write_power(stdout);
		free_permu();

		
		
		
	
		
		
		
		
		
		
		

// 		cout << "Final-p = " << overall_p << endl;
		return overall_p;

	}

/*_________________________________________________________________*/


	double TreeDTMeasure::getPVal1()
	{
		if ( tuCounts == NULL){
			cerr << " Not TUCounts present (double TreeDTMeasure::getPVal())... " << endl;
			return -1;
		}

		read_data();
		allocate_sortlist();
		if (npermu > 0) alloc_permu();
		seed = 0;

		/* left to right pass */
		init_left_sort();


		for (int m = 0; m < nmarkers; m++)
// 		for (int m = 0; m < 2; m++)
		{
			left_update();
// 			print_tree(root, 0);
			//current_location = location[m] + 0.5;
			if ( implementation == 0){
				calculate_scores(status, obs_score1);
// 				BIOS::printArray(obs_score1, 3);

			}
			else{
			   TreeOfHaplotypeTUCounts * t=NULL;

				t= translateTree(root);
// 				printa(t);
// 				cout << *copyHaplotypeTUCountsVector << endl;
// 				print_tree(root, 0);
// 				cout << *t << endl;

				calculate_scores(t, obs_score1);
				vectorOfTrees1.push_back(t);
// 				BIOS::printArray(obs_score1, 3);
			}

// 			cout << "org: [" << obs_score1[0] << ", " << obs_score1[1] << ", " << obs_score1[2] << "]" <<endl;
// 			double obs_score_test[MAX_SUBTREES];
// 			cout << "new: [" << obs_score_test[0] << ", " << obs_score_test[1] << ", " << obs_score_test[2] << "]" <<endl << endl;
// 			cout << * t << endl;
// 			write_subscores(stdout, m);

			if (npermu > 0)
			{
				permu_phase1(0, m);
// 				write_sub_pvalues(stdout, m);

			}
// 			write_subscores(stdout, m);
			//else if (mode == 't' && m + 1 == tree_mk) write_left_tree(stdout, root, m);
			//write_left_tree(stdout, root, m);
		}
		finalize_sort();

		/* right to left pass */
		init_right_sort();
// 		printf("\nRight to Left pass\n");
		//fprintf(stderr, "at marker ");
		for (int m = 0; m < nmarkers; m++)
// for (int m = 0; m < 0; m++)
		{
			//fprintf(stderr, "%ld ", nmarkers - m);
// 			printf("\nat marker %ld: \n", nmarkers - m);
			right_update();
// 			print_tree(root, 0);
			//current_location = location[nmarkers - m] - 0.5;
// 			calculate_scores(status, obs_score1);

// 			TreeOfHaplotypeTUCounts * t2= translateTree(root);
// 			double obs_score_test[MAX_SUBTREES];
// 			calculate_scores(t2, obs_score1);
// 			cout << "org: [" << obs_score1[0] << ", " << obs_score1[1] << ", " << obs_score1[2] << "]" <<endl;
// 			cout << "new: [" << obs_score_test[0] << ", " << obs_score_test[1] << ", " << obs_score_test[2] << "]" <<endl << endl;
// 			delete t2;

			if ( implementation == 0){
				calculate_scores(status, obs_score1);
			}
			else{
			   TreeOfHaplotypeTUCounts * t2= translateTree(root);;
				calculate_scores(t2, obs_score1);
				vectorOfTrees2.push_back(t2);
// 				delete t2;

			}


// 			write_subscores(stdout, m);
			if (npermu > 0)
			{
				permu_phase1(1, nmarkers - m - 1);
// 				write_sub_pvalues(stdout, nmarkers - m - 1);

			}
			//write_subscores(stdout, nmarkers - m - 1);
			//if (mode == 't' && nmarkers - m == tree_mk) write_right_tree(stdout, root, nmarkers - m - 1);
		}
// 		fprintf(stderr, "done.\n");
		finalize_sort();

		if (npermu > 0)
		{
// 			if (mode == 'p' || mode == 'P' || mode == 'k' || mode == 'K')
// 			{
// 				fprintf(stderr, "Permutation phase 2\n");
				for (int m = 0; m < nmarkers + 1; m++) permu_phase2(m);
// 				fprintf(stderr, "done\n");
				write_power(stdout);
// 			}
			free_permu();
		}

		free_sortlist();
		dispose_data();


		 return overall_p;


/*
		double minPvalue = 9999;

		for ( int i=2; i<=maxK; i++){
			TreeDTKMeasure * measure = tuCounts->getTreeDTKMeasure(i);
			double pValue = measure->getPVal();
			if ( pValue < minPvalue )
				minPvalue = pValue;
			delete measure;
		}

		return minPvalue;
*/

	}


	string TreeDTMeasure::getName(){
		return string("TreeDTh" + tos(testMode) );
	};


/*_________________________________________________________________*/

	TreeDTMeasure* TreeDTMeasure::getNewMeasure(GenericCounts* tuCounts, GenericCounts** training, GenericCounts** test)
	{
try
{
		return new TreeDTMeasure((TUCounts*)tuCounts, this->npermu, this->implementation, this->minFreq, testMode, (TUCounts**)training, (TUCounts**)test);
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	TreeDTMeasure* TreeDTMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)" ); throw;};
	}

/*_________________________________________________________________*/

		TreeDTMeasure::~TreeDTMeasure(){
//   			for(int i=0; i<treeEmtpyNodes.size(); i++){
// 				delete treeEmtpyNodes[i];
// 			}
 			//if ( location != NULL)
 			  //	free(location);

//   			for(int i=0; i<vectorOfTrees1.size(); i++){
// 				delete vectorOfTrees1[i];
// 			}
//
//   			for(int i=0; i<vectorOfTrees2.size(); i++){
// 				delete vectorOfTrees2[i];
// 			}


  			for(int i=0; i<leftTrees.size(); i++){
				delete leftTrees[i];
			}

  			for(int i=0; i<rightTrees.size(); i++){
				delete rightTrees[i];
			}
  			
  			if (model != NULL)
  				delete model;


// 			if ( expandedHaplotypeVector !=NULL)
// 			  HaplotypeTUCountsVector::Delete(expandedHaplotypeVector);

// 			if ( copyHaplotypeTUCountsVector != NULL)
// 				HaplotypeTUCountsVector::Delete(copyHaplotypeTUCountsVector);

		};
/*_________________________________________________________________*/

		double TreeDTMeasure::getStatistic(){
			throw NonImplemented("TreeDTMeasure::getStatistic()");
		};
/*_________________________________________________________________*/

		stringList* TreeDTMeasure::getHeadFile(){
throw NonImplemented("TreeDTMeasure::getHeadFile()");
		};
/*_________________________________________________________________*/

		TreeDTMeasure* TreeDTMeasure::clone(){
 return new TreeDTMeasure(*this);
		};


/*_________________________________________________________________*/

		TUCounts* TreeDTMeasure::getTUCounts(){
  return tuCounts;
		};


/*_____________________________________________________________*/

  TreeDTMeasure* TreeDTMeasure::fromString(string s){throw NonImplemented("TreeDTMeasure::fromString(string s)");};

/*_________________________________________________________________*/

		void TreeDTMeasure::print(ostream& out){
   // out << *this;
   throw NonImplemented(" TreeDTMeasure::print(ostream& out)");
		};


 /*_________________________________________________________________*/

	void TreeDTMeasure::read_data()
	{
		//int nmarkers=0;
		//int nchromo;

		char *ptr;

		/* memory allocation */
		//location = (double *)malloc(nmarkers * sizeof(double));
		location = NULL;
		mdata = (char *)malloc(nmarkers * nchromo * sizeof(char));
		status = (char *)malloc(nchromo * sizeof(char));
		mutation = (char *)malloc(nchromo * sizeof(char));
		maxallele = (char *)calloc(nmarkers, sizeof(char));
		first_apool = (struct AllelePool **)calloc(nmarkers, sizeof(struct AllelePool));
		for (int j = 0; j < nmarkers; j++) first_apool[j] = NULL;
		//for (int j = 0; j < nmarkers; j++) location[j] = j + 1.0;

//sortlist = (long *)malloc(nchromo * nmarkers * sizeof(long));
		ptr = mdata;
		na=0; nc=0;
		sumFrequencyT=sumFrequencyU=0;
		for(int i=0; i<nchromo; i++){
			HaplotypeTUCounts *hap = (*tuCounts->expandedHaplotypeVector)[i];
			if( hap->isTransmitted() ){
				status[i] = 'a';
				na++;

			}
			else{
				status[i]= 'c';
				nc++;

			}
			sumFrequencyT += hap->frequencyT;
			sumFrequencyU += hap->frequencyU;

			for (int j = 0; j < nmarkers; j++){
				int a= (*hap)[j];
				*ptr++ =  map_allele(j, a); //tuCounts->haplotypeTUCountsVector[i]
			}
		}

		nchromoF = sumFrequencyT + sumFrequencyU;
		// For haplotipos
			//status[i] = *r;  //estado

			// for (j = 0; j < nmarkers; j++)
			//*ptr++ = map_allele(j, a);
	}
 /*_________________________________________________________________*/

	void TreeDTMeasure::alloc_permu(void)
	{
		long i;

		tmp_ptr = (long *)malloc((npermu + 1) * sizeof(long));
		tmp_score = (double *)malloc((npermu + 1) * sizeof(double));

		permu_score1 = (double *)malloc(npermu * NSUBSCORES * sizeof(double));
		permu_score2 = (double *)malloc(2 * nmarkers * npermu * sizeof(double));

		pval1 = (double *)malloc(npermu * NSUBSCORES * sizeof(double));

		obs_score2 = (double *)malloc(2 * nmarkers * sizeof(double));
		obs_pval2 = (double *)malloc((nmarkers + 1) * sizeof(double));

		min_permu_pval2 = (double *)malloc(npermu * sizeof(double));
		for (i = 0; i < npermu; i++) min_permu_pval2[i] = 1.0;

		permu_status = (char *)malloc(nchromo * sizeof(char));
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::init_left_sort(void)
	{
		init_sort();
		pos = 0;
		root->loc = 0;
	}

 /*_________________________________________________________________*/


	void TreeDTMeasure::init_sort(void)
	{
		long i;

		/* printf("Initializing sort..\n"); */
		root = allocate_node();
		root->depth = 0; root->min = 0; root->max = nchromo - 1; root->nchr = nchromo;
		root->shared_length = 0; root->chromo = 0;
		for (i = 0; i < nchromo; i++)
		{
			struct NodeTreeDT *n = allocate_node();
			treelink(root, n);
			n->min = n->max = n->chromo = i; n->nchr = 1;
			n->depth = 1; n->shared_length = 0;
			n->mean_shared = 0; n->loc = 0;
		}
		/* printf("done\n"); */
	}
 /*_________________________________________________________________*/

	struct NodeTreeDT *TreeDTMeasure::allocate_node(void)
	{

		struct NodeTreeDT *n;

		if (first_free_node == NULL)
		{
			struct NodePool *np = (struct NodePool *)malloc(sizeof(struct NodePool));
			long i;


			np->next = first_npool; first_npool = np;

			for (i = 0; i < POOLSIZE - 1; i++) np->node[i].next = &(np->node[i+1]);
			np->node[POOLSIZE-1].next = NULL;
			first_free_node = &(np->node[0]);
		}
		n = first_free_node; first_free_node = first_free_node->next;
		n->first_child = n->last_child = NULL; n->father = n->next = NULL;
		return n;

	}
 /*_________________________________________________________________*/

	/**
	 * Links n1 to n2 (n1->n2)
	 * @param n1 Father
	 * @param n2 Child
	 */
	void TreeDTMeasure::treelink(struct NodeTreeDT *n1, struct NodeTreeDT *n2)
	{

		register struct ListNodeTreeDT *l1 = allocate_listnode();

		n2->father = n1;
		l1->ptr = n2;
		l1->prev = n1->last_child;
		if (n1->last_child)
			n1->last_child->next = l1;
		else
			n1->first_child = l1;
		n1->last_child = l1;

	}

 /*_________________________________________________________________*/

	struct ListNodeTreeDT *TreeDTMeasure::allocate_listnode(void)
	{
		struct ListNodeTreeDT *ln;

		if (first_free_listnode == NULL)
		{
			struct ListNodePool *lnp = (struct ListNodePool *)malloc(sizeof(struct ListNodePool));
			long i;

			/*printf("ALLOCATING LNPOOL\n");*/
			lnp->next = first_lnpool; first_lnpool = lnp;

			for (i = 0; i < POOLSIZE - 1; i++) lnp->listnode[i].next = &(lnp->listnode[i+1]);
			lnp->listnode[POOLSIZE-1].next = NULL;
			first_free_listnode = &(lnp->listnode[0]);
		}
		ln = first_free_listnode; first_free_listnode = first_free_listnode->next;
		ln->next = ln->prev = NULL; ln->ptr = NULL;
		return ln;
	}
 /*_________________________________________________________________*/

	void TreeDTMeasure::left_update(void)
	{
		update();
		//root->loc = location[pos];
		pos++;
	}
	 /*_________________________________________________________________*/

	void TreeDTMeasure::update(void)
	{
		long k;
		int n = 0;

		/* printf("update %ld, maxa = %d\n", pos, maxallele[pos]); */

		for (k = 0; k <= maxallele[pos]; k++) root_a[k] = last_node[k] = NULL;

		/* printf("Recursively updating..\n"); */
		(void)rec_update(root);
		/* printf("done\n"); */

		/* printf("Freeing old tree..\n"); */
		free_subtree(root, 0);
		/* printf("done\n"); */

		root = allocate_node();

		for (k = 0; k <= maxallele[pos]; k++)
			if (root_a[k])
			{
				treelink(root, root_a[k]);
				n++;
			}

		if (n == 1) // solo hemos hecho un enlace
		{
			struct NodeTreeDT *n = root;
			root = root->first_child->ptr;
			free_node(n);
// 			fprintf(stderr, "Marker %ld is monomorphic\n", pos + 1);
		}

		sortlistbase = pos * nchromo;

		/* printf("Finalizing new tree..\n"); */
		(void)finalize_subtree(root, 0, 0);
		/* printf("done\n"); */

	}

 /*_________________________________________________________________*/

	int TreeDTMeasure::rec_update(struct NodeTreeDT *n)
	{
		struct ListNodeTreeDT *ln = n->first_child;

		if (ln == NULL) /* leaf */
		{

			//debug_dump_chromo( n->chromo + 1 ); //jj

			char c = mdata[pos+nmarkers*n->chromo]; // allele according to the new codification
			struct NodeTreeDT *n2 = last_node[c], *n1 = n;	/* n1: current source node, n2: most recent new node for allele c */
			struct NodeTreeDT *nn1 = allocate_node(), *nn2;   /* nn1: new leaf node, nn2: possible new internal node */
			long last_chr, next_chr = n->min;			/* in source order */

			/* printf("chr: %ld, allele: %d, ", n->chromo, (int)c); */

			if (n2)
				last_chr = n2->min;
			else
				last_chr = next_chr;
			nn1->min = nn1->max = next_chr;
			nn1->depth = n->depth;
			nn1->chromo = n->chromo;
			nn1->shared_length = n->shared_length + 1;
			nn1->loc = n->loc;

			/* find the lowest common ancestor of last_chr & next_chr in the source tree */
			while (n1->min > last_chr)
				n1 = n1->father;

			while (n2 && n2->depth > n1->depth)
				n2 = n2->father;

			if (root_a[c] == NULL)
				root_a[c] = nn1;  /* first chromosome */
			else
			if (n2 && n2->depth == n1->depth)
					treelink(n2, nn1); /* new leaf only */
			else /* new internal node & leaf */
			{
				nn2 = allocate_node();
				nn2->min = n1->min; nn2->max = n1->max; nn2->depth = n1->depth; nn2->chromo = n->chromo;
				nn2->shared_length = n1->shared_length + 1; nn2->loc = n1->loc;
				if (n2 == NULL) /* new internal node = root */
				{
					/* printf("new root "); */
					treelink(nn2, root_a[c]);
					root_a[c] = nn2;
				}
				else
				{
					struct ListNodeTreeDT *l = n2->last_child;
					treelink(nn2, l->ptr);
					n2->last_child = l->prev;		/* unlink */
					n2->last_child->next = NULL;
					free_listnode(l);
					treelink(n2, nn2);
				}
				/* printf("I&L\n"); */
				treelink(nn2, nn1);
			}

			last_node[c] = nn1;
			return c;
		}

		else /* internal node */
		{
			int c, c_ret = 0, c_cmp = rec_update(ln->ptr);

			if (c_cmp == -1)
				c_ret = -1;
			ln = ln->next;

			/* debug */ if (ln == NULL) { fprintf(stderr, "Malformed tree\n"); exit(-1); }

			while (ln)
			{
				c = rec_update(ln->ptr);
				if (c == -1 || c != c_cmp)
					c_ret = -1;
				ln = ln->next;
			}
			if (c_ret == -1) add_pattern(n); /* n is closed */
			return c_ret;
		}
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::free_subtree(struct NodeTreeDT *n, int last)
	{
		struct ListNodeTreeDT *ln = n->first_child;

		if (last && n->shared_length > 0) add_pattern(n);

		while (ln)
		{
			struct ListNodeTreeDT *ln2 = ln->next;
			free_subtree(ln->ptr, last);
			free_listnode(ln);
			ln = ln2;
		}
		free_node(n);
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::free_node(struct NodeTreeDT *n)
	{
		n->next = first_free_node; first_free_node = n;
	}

 /*_________________________________________________________________*/

	long TreeDTMeasure::finalize_subtree(struct NodeTreeDT *n, long min, long depth)
	{
		struct ListNodeTreeDT *ln = n->first_child;

		n->min = min; n->depth = depth;
		if (ln) /* internal node */
		{
			while (ln)
			{
				min = finalize_subtree(ln->ptr, min, depth+1) + 1;
				ln = ln->next;
			}
			n->max = min - 1; n->nchr = n->max - n->min + 1;
		}
		else
		{
			sortlist[min + sortlistbase] = n->chromo;
			n->max = min; n->nchr = 1;
		}
		return n->max;
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::free_listnode(struct ListNodeTreeDT *ln)
	{
		ln->next = first_free_listnode; first_free_listnode = ln;
	}

 /*_________________________________________________________________*/

	int TreeDTMeasure::print_tree(struct NodeTreeDT *n, int level)
	{


		struct ListNodeTreeDT *ln = n->first_child;


		if (ln) /* internal node */
		{

			int i;
			for(i=0; i<level; i++)
				printf("\t");
			printf("L%d [%i::d%i::m%i]\n", level, n->chromo, n->depth, n->min );
			while (ln)
			{
				print_tree(ln->ptr, level+1);
				ln = ln->next;
			}

		}
		else
		{
			int i;
			for(i=0; i<level; i++)
				printf("\t");
			printf("[%i::d%i::m%i]", n->chromo, n->depth, n->min);
			debug_dump_chromo( n->chromo + 1 );

		}


	}
 /*_________________________________________________________________*/

	void TreeDTMeasure::debug_dump_chromo(long i)
	{
		long j = 0;
		i--;
		printf("%c ", status[i]);
		for (j = 0; j < nmarkers; j++) printf(" %d", original_allele(j, mdata[i*nmarkers+j]));
		printf("\n");
	}

	/**
	* Find allele in AllelePool

	* For each marker we have a list of "AllelePool".
	* Each AllelePool has APOOLSIZE(16) caracters.
	* When an AllelePool is filled another one is created.

	* @param m Marker
	* @param c Character allele
	* @return
	*/
 /*_________________________________________________________________*/

	int TreeDTMeasure::original_allele(long m, char c)
	{
		int ix = 0;
		struct AllelePool *ap = first_apool[m];

		//printf("Mk = %ld, mapped: %d; ", m, (int)c);

		if (c == 0) return 0;
		c--;
		while (c >= ix + APOOLSIZE)
		{
			ap = ap->next;
			ix += APOOLSIZE;
		}

	// 	 printf("orig: %d\n", ap->key[c-ix] + 1);
		return ap->key[c - ix] + 1;
	}
	 /*_________________________________________________________________*/

	void TreeDTMeasure::resetFrequencies(TreeOfHaplotypeTUCounts *t)
	{
	  	tuCounts->copyHaplotypeTUCountsVector->copyFrequencies( tuCounts->expandedHaplotypeVector );
		t->updateTreeDTScore();
	}

	void TreeDTMeasure::resetFrequencies(HaplotypeTUCountsTree *t)
	{
	  	tuCounts->copyHaplotypeTUCountsVector->copyFrequencies( tuCounts->expandedHaplotypeVector );
		t->updateFrequenciesFromLeaves();
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::resetFrequencies(TreeOfHaplotypeTUCounts *t, HaplotypeTUCountsVector * vector)
	{
	  	tuCounts->copyHaplotypeTUCountsVector->copyFrequencies( vector );
		t->updateTreeDTScore();
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::calculate_scores(char *status, double *table)
	{
		rec_calc_scores(root, status, table);
	}

 /*_________________________________________________________________*/

	double TreeDTMeasure::calculate_best_score(TreeOfHaplotypeTUCounts *t){

	  switch( t->best_k ){
// 		 case 0:
// 			break;
// 		 case 2:
//
// 			break;
		 default:
			return 0.5;
			break;
	  }
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::calculate_scores(HaplotypeTUCountsTree *t, double *table, bool updateBestNodes)
	{
	  	if( updateBestNodes )
	   	t->resetBestNodes();

		recTreeScore(t, t->begin(), table, updateBestNodes);
	}

	void TreeDTMeasure::calculate_scores(TreeOfHaplotypeTUCounts *t, double *table, bool updateBestNodes)
	{
	  	if( updateBestNodes )
	   	t->resetBestNodes();
		recTreeScore(t, t->getRoot(), table, updateBestNodes);

		// Aqui tenemos que tener el modelo generado.
		//best_model_simulation();
// 		PNode best_nodes[6];
// 		bool best_nodes_found[6]={false,false,false,false,false,false};

// 		t->best_nodes[0] = t->getRoot();

// 		t->best_nodes_found[0] = true;
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::recTreeScore(TreeOfHaplotypeTUCounts *t, PNode node, double *table, bool updateBestNodes)
	{
	   // variables used to store the best subtrees
	  	PNode current_best_nodes[6], max_best_nodes[6];
		bool current_best_nodes_found[6] = {false}, max_best_nodes_found[6] = {false};

		double max_scoretable[MAX_SUBTREES], scoretable[MAX_SUBTREES];
		int i;

  vector<PNode> * v = t->getChildrenIterators(node);

		if( v->empty() ){
			// leaf
			for (i = 0; i < MAX_SUBTREES; i++) tmp_scoretable[i] = -FLT_MAX;

// 			if( (*node)->frequencyT > 1 || (*node)->frequencyU > 1 ){
// 				double new_component = new_score( (*node)->frequencyT , (*node)->frequencyU); // z_i statistic
// 				tmp_scoretable[0] = new_component;
//
// 			}

		}
		else
		{

			// initial values
			recTreeScore(t, (*v)[0], NULL, updateBestNodes);
			for (i = 0; i < MAX_SUBTREES; i++) scoretable[i] = max_scoretable[i] = tmp_scoretable[i];

			if (updateBestNodes){
			  for(int i=0; i<6; i++){
				 max_best_nodes_found[i] = current_best_nodes_found[i] = t->best_nodes_found[i];
				 max_best_nodes[i] = current_best_nodes[i] = t->best_nodes[i];
			  }
			}


			// analyze the rest of the children
			for(int i=1; i<v->size(); i++){
				recTreeScore(t, (*v)[i], NULL, updateBestNodes);

				double x;
				for (int i = 0; i < MAX_SUBTREES - 1; i++)
					for (int j = 0; j < MAX_SUBTREES - i - 1; j++)
						if (tmp_scoretable[i] > -FLT_MAX && max_scoretable[j] > -FLT_MAX)
							if ((x = tmp_scoretable[i] + max_scoretable[j]) > scoretable[i + j + 1]){
								scoretable[i + j + 1] = x;

								// update best nodes
								if(updateBestNodes){
								  if( i== 0 && j==0){ // copy node 0 from i
									 current_best_nodes[1] = t->best_nodes[0];
									 current_best_nodes[2] = max_best_nodes[0];
									 current_best_nodes_found[1] = current_best_nodes_found[2] = true;
								  }

								  if( (i+j)==1){

									 if ( i == 0 ){
									 current_best_nodes[3] = t->best_nodes[0];
									 current_best_nodes[4] = max_best_nodes[1];
									 current_best_nodes[5] = max_best_nodes[2];
									 }
									 else{
									 current_best_nodes[3] = max_best_nodes[0];
									 current_best_nodes[4] = t->best_nodes[1];
									 current_best_nodes[5] = t->best_nodes[2];
									 }

									 current_best_nodes_found[3] = current_best_nodes_found[4] = current_best_nodes_found[5]= true;
								  }
								}


							}

				for (int i = 0; i < MAX_SUBTREES; i++)
				{
					if (tmp_scoretable[i] > max_scoretable[i]){
						max_scoretable[i] = tmp_scoretable[i];

						if ( updateBestNodes ){
						  if(i==0){
							 max_best_nodes[0] = t->best_nodes[0];
							 max_best_nodes_found[0] = true;
						  }
						  if(i==1){
							 max_best_nodes[1] = t->best_nodes[1];
							 max_best_nodes_found[1] = true;
							 max_best_nodes[2] = t->best_nodes[2];
							 max_best_nodes_found[2] = true;
						  }
						  if(i==2){
							 max_best_nodes[3] = t->best_nodes[3];
							 max_best_nodes_found[3] = true;
							 max_best_nodes[4] = t->best_nodes[4];
							 max_best_nodes_found[4] = true;
							 max_best_nodes[5] = t->best_nodes[5];
							 max_best_nodes_found[5] = true;
						  }
						}

					}
					if (tmp_scoretable[i] > scoretable[i]){
						scoretable[i] = tmp_scoretable[i];

						if (updateBestNodes){
						  if(i==0){
							 current_best_nodes[0] = t->best_nodes[0];
							 current_best_nodes_found[0] = true;
						  }
						  if(i==1){
							 current_best_nodes[1] = t->best_nodes[1];
							 current_best_nodes_found[1] = true;
							 current_best_nodes[2] = t->best_nodes[2];
							 current_best_nodes_found[2] = true;
						  }
						  if(i==2){
							 current_best_nodes[3] = t->best_nodes[3];
							 current_best_nodes_found[3] = true;
							 current_best_nodes[4] = t->best_nodes[4];
							 current_best_nodes_found[4] = true;
							 current_best_nodes[5] = t->best_nodes[5];
							 current_best_nodes_found[5] = true;
						  }
						}
					}
				}
			}
			double new_component = new_score( (int) (*node)->frequencyT , (int) (*node)->frequencyU); // z_i statistic
			if (new_component > scoretable[0])
			{
			  	scoretable[0] = new_component;

				if(updateBestNodes){
				  current_best_nodes[0] = node;
				  current_best_nodes_found[0] = true;
				}
			}

			for (int i = 0; i < MAX_SUBTREES; i++) tmp_scoretable[i] = scoretable[i];

				if(updateBestNodes){
				  for(int i=0; i<6; i++){
					 t->best_nodes_found[i] = current_best_nodes_found[i];
					 t->best_nodes[i] = current_best_nodes[i];
				  }
				}

		}

		if (table)
			for (int i = 0; i < MAX_SUBTREES; i++) table[i] = scoretable[i];

		delete v;
	}
 /*_________________________________________________________________*/


 /*_________________________________________________________________*/

	void TreeDTMeasure::recTreeScore(HaplotypeTUCountsTree *t, HaplotypeTUCountsTree::iterator node, double *table, bool updateBestNodes)
	{
	  HaplotypeTUCountsTree::sibling_iterator iChildren;
	   // variables used to store the best subtrees
	  	tree<HaplotypeTUCounts *>::iterator current_best_nodes[6], max_best_nodes[6];
		bool current_best_nodes_found[6] = {false}, max_best_nodes_found[6] = {false};

		double max_scoretable[MAX_SUBTREES], scoretable[MAX_SUBTREES];
		int i;


		if( t->number_of_children(node) == 0 ){
			// leaf
			for (i = 0; i < MAX_SUBTREES; i++) tmp_scoretable[i] = -FLT_MAX;
		}
		else
		{

			// initial values
			iChildren = t->begin(node);
			recTreeScore(t, iChildren, NULL, updateBestNodes);
			for (i = 0; i < MAX_SUBTREES; i++) scoretable[i] = max_scoretable[i] = tmp_scoretable[i];

			if (updateBestNodes){
			  for(int i=0; i<6; i++){
				 max_best_nodes_found[i] = current_best_nodes_found[i] = t->best_nodes_found[i];
				 max_best_nodes[i] = current_best_nodes[i] = t->best_nodes[i];
			  }
			}


			// analyze the rest of the children
			iChildren++;
			while ( iChildren != t->end(node) ){
			//for(int i=1; i<v->size(); i++){
				recTreeScore(t, iChildren, NULL, updateBestNodes);

				double x;
				for (int i = 0; i < MAX_SUBTREES - 1; i++)
					for (int j = 0; j < MAX_SUBTREES - i - 1; j++)
						if (tmp_scoretable[i] > -FLT_MAX && max_scoretable[j] > -FLT_MAX)
							if ((x = tmp_scoretable[i] + max_scoretable[j]) > scoretable[i + j + 1]){
								scoretable[i + j + 1] = x;

								// update best nodes
								if(updateBestNodes){
								  if( i== 0 && j==0){ // copy node 0 from i
									 current_best_nodes[1] = t->best_nodes[0];
									 current_best_nodes[2] = max_best_nodes[0];
									 current_best_nodes_found[1] = current_best_nodes_found[2] = true;
								  }

								  if( (i+j)==1){

									 if ( i == 0 ){
									 current_best_nodes[3] = t->best_nodes[0];
									 current_best_nodes[4] = max_best_nodes[1];
									 current_best_nodes[5] = max_best_nodes[2];
									 }
									 else{
									 current_best_nodes[3] = max_best_nodes[0];
									 current_best_nodes[4] = t->best_nodes[1];
									 current_best_nodes[5] = t->best_nodes[2];
									 }

									 current_best_nodes_found[3] = current_best_nodes_found[4] = current_best_nodes_found[5]= true;
								  }
								}


							}

				for (int i = 0; i < MAX_SUBTREES; i++)
				{
					if (tmp_scoretable[i] > max_scoretable[i]){
						max_scoretable[i] = tmp_scoretable[i];

						if ( updateBestNodes ){
						  if(i==0){
							 max_best_nodes[0] = t->best_nodes[0];
							 max_best_nodes_found[0] = true;
						  }
						  if(i==1){
							 max_best_nodes[1] = t->best_nodes[1];
							 max_best_nodes_found[1] = true;
							 max_best_nodes[2] = t->best_nodes[2];
							 max_best_nodes_found[2] = true;
						  }
						  if(i==2){
							 max_best_nodes[3] = t->best_nodes[3];
							 max_best_nodes_found[3] = true;
							 max_best_nodes[4] = t->best_nodes[4];
							 max_best_nodes_found[4] = true;
							 max_best_nodes[5] = t->best_nodes[5];
							 max_best_nodes_found[5] = true;
						  }
						}

					}
					if (tmp_scoretable[i] > scoretable[i]){
						scoretable[i] = tmp_scoretable[i];

						if (updateBestNodes){
						  if(i==0){
							 current_best_nodes[0] = t->best_nodes[0];
							 current_best_nodes_found[0] = true;
						  }
						  if(i==1){
							 current_best_nodes[1] = t->best_nodes[1];
							 current_best_nodes_found[1] = true;
							 current_best_nodes[2] = t->best_nodes[2];
							 current_best_nodes_found[2] = true;
						  }
						  if(i==2){
							 current_best_nodes[3] = t->best_nodes[3];
							 current_best_nodes_found[3] = true;
							 current_best_nodes[4] = t->best_nodes[4];
							 current_best_nodes_found[4] = true;
							 current_best_nodes[5] = t->best_nodes[5];
							 current_best_nodes_found[5] = true;
						  }
						}
					}
				}

				iChildren++;
			}
			double new_component;
			if ( statisticUsed == 1)
				new_component = new_score2( (int) (*node)->frequencyT , (int) (*node)->frequencyU); // z_i statistic
			else
				new_component = new_score( (int) (*node)->frequencyT , (int) (*node)->frequencyU); // z_i statistic
			if (new_component > scoretable[0])
			{
			  	scoretable[0] = new_component;

				if(updateBestNodes){
				  current_best_nodes[0] = node;
				  current_best_nodes_found[0] = true;
				}
			}

			for (int i = 0; i < MAX_SUBTREES; i++) tmp_scoretable[i] = scoretable[i];

				if(updateBestNodes){
				  for(int i=0; i<6; i++){
					 t->best_nodes_found[i] = current_best_nodes_found[i];
					 t->best_nodes[i] = current_best_nodes[i];
				  }
				}

		}

		if (table)
			for (int i = 0; i < MAX_SUBTREES; i++) table[i] = scoretable[i];


	}
 /*_________________________________________________________________*/




	void TreeDTMeasure::rec_calc_scores(struct NodeTreeDT *n, char *status, double *table)
	{
		struct ListNodeTreeDT *ln = n->first_child;
		// scoretable: Scores for the current node [ Z_k(S) = Sum(z_i) ]
		// max scores for the children of current node
		double max_scoretable[MAX_SUBTREES], scoretable[MAX_SUBTREES];
		int i;

		if (ln) /* internal */
		{
			long a = 0, c = 0;
			double new_component;

			rec_calc_scores(ln->ptr, status, NULL);
			a += ln->ptr->na; c += ln->ptr->nc;
			for (i = 0; i < MAX_SUBTREES; i++) scoretable[i] = max_scoretable[i] = tmp_scoretable[i];

			ln = ln->next;
			if (ln == NULL) { printf("calc_scores: malformed tree\n"); exit(-1); }

			while (ln)
			{
				int j;
				double x;

				rec_calc_scores(ln->ptr, status, NULL);
				a += ln->ptr->na; c += ln->ptr->nc;

				for (i = 0; i < MAX_SUBTREES - 1; i++)
					for (j = 0; j < MAX_SUBTREES - i - 1; j++)
						if (tmp_scoretable[i] > -FLT_MAX && max_scoretable[j] > -FLT_MAX)
							if ((x = tmp_scoretable[i] + max_scoretable[j]) > scoretable[i + j + 1])
								scoretable[i + j + 1] = x;

				for (i = 0; i < MAX_SUBTREES; i++)
				{
					if (tmp_scoretable[i] > max_scoretable[i])
						max_scoretable[i] = tmp_scoretable[i];
					if (tmp_scoretable[i] > scoretable[i])
						scoretable[i] = tmp_scoretable[i];
				}

				ln = ln->next;
			}

			new_component = new_score(a, c); // z_i statistic
			if (new_component > scoretable[0]) scoretable[0] = new_component;

			for (i = 0; i < MAX_SUBTREES; i++) tmp_scoretable[i] = scoretable[i];
			n->na = a; n->nc = c;
		}
		else /* leaf */
		{
			for (i = 0; i < MAX_SUBTREES; i++) tmp_scoretable[i] = -FLT_MAX;
			if (status[n->chromo] == 'a') {
				n->na = 1; n->nc = 0;
			}
			else {
				n->na = 0; n->nc = 1;
			}
		}
		if (table)
			for (i = 0; i < MAX_SUBTREES; i++) table[i] = scoretable[i];
	}

 /*_________________________________________________________________*/
	/**
	* z_i statistic as in equation 1 of "TreeDT: Tree Pattern Mining for Gene Mapping" 2006.
	* @param a Number of case (affected) individuals in subtree i.
	* @param c Number of control (unaffected individuals in subtree i.
	* @return z statistic
	*/
	double TreeDTMeasure::new_score(long a, long c)
	{
	  	//cout << " new_score(" << a << ", " << c << ") - " ;
		//printf(" new_score(%i, %i) - ",a,c) ;
	  	float na = sumFrequencyT;
		float nc = sumFrequencyU;

		double p = (a + c) / (double)nchromoF, pa = na / (double)nchromoF;
		double ea = na * p, ec = nc * p;
		double x = (a - ea) / sqrt((a + c) * pa * (1 - pa));
		return x;

	/*	double p = (a + c) / (double)nchromo;
		double ea = na * p, ec = nc * p;
		double x = (a - ea) / sqrt(ea * (1-p)) + (ec - c) / sqrt(ec * (1-p));
		double x = (a - ea) / sqrt(ea) + (ec - c) / sqrt(ec);
		return x;*/
	}
	
	
	double TreeDTMeasure::new_score2(long a, long c)
	{
	  	float na = sumFrequencyT;
		float nc = sumFrequencyU;

		double p = (a + c) / (double)nchromoF, pa = na / (double)nchromoF;
		double ea = na * p, ec = nc * p;
		double x = (a - ea) / sqrt((a + c) * pa * (1 - pa));
		return x*x;

	}	
	 /*_________________________________________________________________*/

	void TreeDTMeasure::write_subscores(FILE *f, long m)
	{
		int i;

		fprintf(f, "M[%li]", m+1);
		for (i = 0; i < MAX_SUBTREES; i++)
			if (obs_score1[i] > -FLT_MAX) fprintf(f, " %f", obs_score1[i]);
			else fprintf(f, " -");
		fprintf(f, "\n");
	}

 /*_________________________________________________________________*/

// From permu_i.c


	void TreeDTMeasure::free_permu(void)
	{
		free(tmp_ptr); free(tmp_score);
		free(permu_score1); free(permu_score2);
		free(pval1);
		free(obs_pval2); free(obs_score2);
		free(permu_status);
		free(min_permu_pval2);
	}
 /*_________________________________________________________________*/

	
	double TreeDTMeasure::permu_phase1_fromModel(TreeDTModel* model)
	{

		int side=0; 
		int m= model->posMinPlevel3;





		for (int j = 0; j < NSUBSCORES; j++) // Line 6. Algorithm NestedPermutationTest
		{
			for (int i2 = 0; i2 < npermu; i2++) { tmp_ptr[i2] = i2; tmp_score[i2] = permu_score1[i2*NSUBSCORES+j]; }
			tmp_ptr[npermu] = npermu; tmp_score[npermu] = obs_score1[j];

			qsort(tmp_ptr, npermu + 1, sizeof(long), cmp_sort);



			for (int i3 = 0; i3 < npermu + 1; i3++) // Line 7. Algorithm NestedPermutationTest
			{
				long k = i3;
				double p, sc = tmp_score[tmp_ptr[i3]];

				while (k < npermu && tmp_score[tmp_ptr[k+1]] == sc) k++;

				p = 1.0 - pvalue(i3-1, k+1);
				while (i3 <= k)
				{
					if (tmp_ptr[i3] == npermu) obs_pval1[j] = p;
					else pval1[tmp_ptr[i3]*NSUBSCORES+j] = p;
					i3++;
				}
				i3--;
			}
		}



		
}	
	
	
	
	
	void TreeDTMeasure::permu_phase1(int side, long m, double *bestDistribution)
	{
		double original_distribution[npermu*NSUBSCORES];
	  //#define debug_TreeDTMeasure_permu_phase1 1

		long i1, j;


				//vector<TreeOfHaplotypeTUCounts *> vT;
				vector<HaplotypeTUCountsTree *> vT;
				int marker;

				if(side==0){
				  vT = leftTrees;
				  marker=m;
				}
				else{
				  vT = rightTrees;
				  marker=nmarkers-1-m;
				}

		phase = 1;
		srand(seed);
// 		cerr <<"M"<<m<<"S"<<side<<"->";
		for (i1 = 0; i1 < npermu; i1++)
		{
// 		  cerr << ".";
			float a = na, c = nc;
			long j;
// 			printf(" \n permutation %i\n", i1);

			if(implementation==0){
				#ifdef debug_TreeDTMeasure_permu_phase1
			   cout << "\na/c sequence 1 (p:"<< i1 << "): [";
				#endif
				for (j = 0; j < nchromo; j++){
					if (rand() / (RAND_MAX + 1.0) < a / (double)(a+c)) {
					  	permu_status[j] = 'a';
						a--;
						#ifdef debug_TreeDTMeasure_permu_phase1
						cout << "a";
						#endif
					}
					else {
					  permu_status[j] = 'c'; c--;
					  #ifdef debug_TreeDTMeasure_permu_phase1
					  cout << "c";
					  #endif
					}
				}
// 				cout << "]" << endl;

				calculate_scores(permu_status, permu_score1 + i1 * NSUBSCORES);
			}
			else
			{ // Implementation with haplotype trees
				a = sumFrequencyT;
				c = sumFrequencyU;

				#ifdef debug_TreeDTMeasure_permu_phase1
				cout << "\na/c sequence 2 (p:"<< i << "): [";
				#endif

				for(int hi=0; hi<tuCounts->copyHaplotypeTUCountsVector->size(); hi++){ // for each different haplotype
				  HaplotypeTUCounts * h = (*tuCounts->copyHaplotypeTUCountsVector)[hi];
				  double nodeTotalFreq = h->frequencyT + h->frequencyU;

				  double node_a = 0;
				  double node_c = 0;


				  // for each single haplotype
				  for(int j=0; j<nodeTotalFreq; j++){
						if (rand() / (RAND_MAX + 1.0) < a / (double)(a+c)) {
						  node_a += 1;
							a--;
							#ifdef debug_TreeDTMeasure_permu_phase1
							cout << "a";
							#endif
						}
						else{
							node_c += 1;
							c--;
							#ifdef debug_TreeDTMeasure_permu_phase1
							cout << "c";
							#endif
						}
				  }


				  h->frequencyT = node_a;
				  h->frequencyU = node_c;


				}
// 				cout << "]" << endl;

// 				cout << "Permutation ("<< i << "):"<<endl << *copyHaplotypeTUCountsVector << endl;

// 				vector<TreeOfHaplotypeTUCounts *> vT;
// 				int marker;
//
// 				if(side==0){
// 				  vT = vectorOfTrees1;
// 				  marker=m;
// 				}
// 				else{
// 				  vT = vectorOfTrees2;
// 				  marker=nmarkers-1-m;
// 				}



				vT[marker]->updateFrequenciesFromLeaves();
				calculate_scores(vT[marker], permu_score1 + i1 * NSUBSCORES);
// 				cout << i1 << endl;

			}

		}
		for(int i=0; i<npermu*NSUBSCORES;i++){
			original_distribution[i] = permu_score1[i];
			
		}

// 		BIOS::print(permu_score1, 10, cout);
// 		cout << endl;

		#ifdef PRINT_HISTOGRAM_LEVEL1
		//for (int k=0; k<1; k++){
		int k=HISTOGRAM_K;
			stringstream appendix;
			appendix << "S" << side << "M" << m << "_k"<< k+1;

			cout << "dist" << appendix.str() << " = c(";
			for(int i=0; i<npermu;i++){
				cout << permu_score1[i*MAX_SUBTREES+k];
				if (i==npermu-1)
					cout << ")";
				else
					cout << " ,";
			}

			cout << "; z" << appendix.str() << " = " << obs_score1[k];
			cout << "; hist(distS" << side << "M" << m << "_k"<< k+1 << ", xlim=c( min(" << "dist" << appendix.str() << ", " << "z" << appendix.str() << "), max("<< "dist" << appendix.str() << ", " << "z" << appendix.str() << ") ))";
			cout << "; lines(c(z" << appendix.str() << ", z" << appendix.str() << "), c(0, 100),  col=\"red\")";
			cout << endl;
		#endif

		//}
 		//BIOS::print(permu_score1, npermu*MAX_SUBTREES, cout);

// 		BIOS::print(pval1, npermu * NSUBSCORES, cout);
// 		cout << endl;


		for (j = 0; j < NSUBSCORES; j++) // Line 6. Algorithm NestedPermutationTest
		{
			for (int i2 = 0; i2 < npermu; i2++) { tmp_ptr[i2] = i2; tmp_score[i2] = permu_score1[i2*NSUBSCORES+j]; }
			tmp_ptr[npermu] = npermu; tmp_score[npermu] = obs_score1[j];

			qsort(tmp_ptr, npermu + 1, sizeof(long), cmp_sort);

// 			BIOS::printArray(tmp_ptr, npermu+1, cout);
// 			cout << endl;

// 			if(j==0){
// 			BIOS::printArray(tmp_score+10, 10, cout);
// 			cout << endl;
// 			}

			/*if (j == 0){
				printf("mk %ld\n", m);
				for (i = 0; i < npermu + 1; i++)
				{ printf("%f\n", tmp_score[i]); }
			}*/

			for (int i3 = 0; i3 < npermu + 1; i3++) // Line 7. Algorithm NestedPermutationTest
			{
				long k = i3;
				double p, sc = tmp_score[tmp_ptr[i3]];

				while (k < npermu && tmp_score[tmp_ptr[k+1]] == sc) k++;

				p = 1.0 - pvalue(i3-1, k+1);
				while (i3 <= k)
				{
					if (tmp_ptr[i3] == npermu) obs_pval1[j] = p;
					else pval1[tmp_ptr[i3]*NSUBSCORES+j] = p;
					i3++;
				}
				i3--;
			}
		}

// 			BIOS::printArray(obs_pval1,3, cout);

// 		BIOS::printArray(obs_score2, 2*nmarkers );
// 		cout << endl;
		int best_k;

		obs_score2[side*nmarkers+m] = calc_permu_score2(obs_pval1, vT[marker]->maxPossibleK(), best_k); // Line 9. Algorithm NestedPermutationTest
		vT[marker]->best_k = best_k;
		
		// store the best_k distribution
		if(bestDistribution!=NULL)
			for(int i=0; i<npermu; i++)
				bestDistribution[i]=original_distribution[i*NSUBSCORES+best_k];
		
		
		
		
		//printf("\nmarker: %i, best_k: %i\n", vT[marker]->best_k, best_k);

// 		vT[marker]->printbn();
// 		cerr << "Maximum z in permu_phase1 [k=" << best_k << "]: " << obs_score1[best_k]<<endl;
// 		cout << " -> " << obs_score2[side*nmarkers+m] ;
// 		cout << endl;
		for (int i = 0; i < npermu; i++){
			permu_score2[(2*i+side)*nmarkers+m] = calc_permu_score2(pval1+i*NSUBSCORES, vT[marker]->maxPossibleK() /*best_k*/, best_k);
			//printf("%i, ", best_k);
		}
	}


 /*_________________________________________________________________*/

	void TreeDTMeasure::permu_best_score(int side, long m, double observed_score)
	{
	  //#define debug_TreeDTMeasure_permu_phase1 1

		long i1, j;



		// create permutations
  		if (partialTuCountsTest[0]->getPermutations()==NULL){
		   partialTuCountsTest[0]->totalPermutations = npermu;
  			partialTuCountsTest[0]->setPermutations();
		}

		cout << endl << "Marker: " << m << endl;
		for (i1 = 0; i1 < npermu; i1++)
		{
			// copy tdtable
			TDTtable * tableClone = vectorOfTables1[m].clone();
			TUCounts * permutation = (TUCounts*)partialTuCountsTest[0]->getPermutations()[i1]; // Create a permutation of the tuCountsTest
			if(m==0){
			cout << endl << "Original table: " << endl << * tableClone << endl;
			cout << endl << "parentalHaplotypesList: " << endl << *permutation->parentalHaplotypesList << endl;
			}
			tableClone->update( permutation->parentalHaplotypesList, true, true ); // update table
			if(m==0)
			cout << endl << "Updated table: " << endl << * tableClone << endl;
			permu_score1[i1] = tableClone->getStatisticZ(); // Calculate statistic
			delete tableClone;
		}


// 		BIOS::print(permu_score1, 10, cout);
// 		cout << endl;
// if(m==0){
// 		BIOS::print(permu_score1, npermu, cout);
// 		cout << endl;
// }

// 		BIOS::print(pval1, npermu * NSUBSCORES, cout);
// 		cout << endl;


		for (j = 0; j < 1; j++) // Line 6. Algorithm NestedPermutationTest
		{
			for (int i2 = 0; i2 < npermu; i2++) { tmp_ptr[i2] = i2; tmp_score[i2] = permu_score1[i2]; }
			tmp_ptr[npermu] = npermu; tmp_score[npermu] = observed_score;

			qsort(tmp_ptr, npermu + 1, sizeof(long), cmp_sort);

// 			BIOS::printArray(tmp_ptr, npermu+1, cout);
// 			cout << endl;

// 			if(j==0){
// 			BIOS::printArray(tmp_score+10, 10, cout);
// 			cout << endl;
// 			}

			/*if (j == 0){
				printf("mk %ld\n", m);
				for (i = 0; i < npermu + 1; i++)
				{ printf("%f\n", tmp_score[i]); }
			}*/

			for (int i3 = 0; i3 < npermu + 1; i3++) // Line 7. Algorithm NestedPermutationTest
			{
				long k = i3;
				double p, sc = tmp_score[tmp_ptr[i3]];

				while (k < npermu && tmp_score[tmp_ptr[k+1]] == sc) k++;

				p = 1.0 - pvalue(i3-1, k+1);
				while (i3 <= k)
				{
					if (tmp_ptr[i3] == npermu) obs_pval1[0] = p;
// 					else pval1[tmp_ptr[i3]*NSUBSCORES+j] = p;
					else pval1[tmp_ptr[i3]] = p;
					i3++;
				}
				i3--;
			}
		}

// 			BIOS::printArray(obs_pval1,3, cout);

// 		BIOS::printArray(obs_score2, 2*nmarkers );
// 		cout << endl;

		obs_score2[side*nmarkers+m] = obs_pval1[0];//calc_permu_score2(obs_pval1); // Line 9. Algorithm NestedPermutationTest
		//vT[marker]->best_k = 2;
// 		cout << " -> " << obs_score2[side*nmarkers+m] ;
// 		cout << endl;
		for (int i = 0; i < npermu; i++)
			permu_score2[(2*i+side)*nmarkers+m] = pval1[i];//calc_permu_score2(pval1+i*NSUBSCORES);
	}

	double TreeDTMeasure::getStatistic(TDTtable *tableLeft, HaplotypeTUCountsTree * leftTree, TDTtable *tableRight, HaplotypeTUCountsTree * rightTree)
	{
		if (leftTree==NULL){
			// Use only right tree
			return getStatistic(tableRight, rightTree);
		}
		if (rightTree==NULL)
		{
			// use only left tree
			return getStatistic(tableLeft, leftTree);
		}
		
		return getStatistic(tableRight, rightTree) + getStatistic(tableLeft, leftTree);
		
		
		
	}
	
	double TreeDTMeasure::getStatistic(TDTtable *table, HaplotypeTUCountsTree * tree)
	{
	  		double value;
			TDTtable *t1 = table->newFromTree( tree ); // restrict the table to the best haplotypes in the tree
			
			double TT = table->getTotalTransmissionCount(t);
			double UU = table->getTotalTransmissionCount(u);
			
			//value = t1->getStatisticZ(wholeSampleT, wholeSampleU); // Calculate statistic
			if(statisticUsed==1)
				value = t1->getStatisticZ2(TT, UU); // Calculate statistic
			else
				value = t1->getStatisticZ(TT, UU); // Calculate statistic
			delete t1;
			return value;
	}
	
	double TreeDTMeasure::calculatePvalFromBinomial(TDTtable *table, HaplotypeTUCountsTree * tree)
	{
	  		double value;
			TDTtable *t1 = table->newFromTree( tree ); // restrict the table to the best haplotypes in the tree
			
			double TT = table->getTotalTransmissionCount(t);
			double UU = table->getTotalTransmissionCount(u);
			
			//value = t1->getStatisticZ(wholeSampleT, wholeSampleU); // Calculate statistic
			value = t1->getStatisticZ(TT, UU); // Calculate statistic
			delete t1;
			
			value = Binomial::testBinomial(value, (int)(TT+UU), 0.5f);
			
			return value;
	}	

 /*_________________________________________________________________*/
	
	void TreeDTMeasure::level1Distribution(int side, long m, double observed_score, double * distribution)
		{
		  //#define debug_TreeDTMeasure_permu_phase1 1

			long i1, j;
			
			// Copy distribution
			for(int i=0; i<npermu; i++){
				permu_score1[i] = distribution[i];
			}
			

	// 		BIOS::print(permu_score1, 10, cout);
	// 		cout << endl;
	// if(m==0){
	// 		BIOS::print(permu_score1, npermu, cout);
	// 		cout << endl;
	// }

	// 		BIOS::print(pval1, npermu * NSUBSCORES, cout);
	// 		cout << endl;


			for (j = 0; j < 1; j++) // Line 6. Algorithm NestedPermutationTest
			{
				for (int i2 = 0; i2 < npermu; i2++) { tmp_ptr[i2] = i2; tmp_score[i2] = permu_score1[i2]; }
				tmp_ptr[npermu] = npermu; tmp_score[npermu] = observed_score;

				qsort(tmp_ptr, npermu + 1, sizeof(long), cmp_sort);

	// 			BIOS::printArray(tmp_ptr, npermu+1, cout);
	// 			cout << endl;

	// 			if(j==0){
	// 			BIOS::printArray(tmp_score+10, 10, cout);
	// 			cout << endl;
	// 			}

				/*if (j == 0){
					printf("mk %ld\n", m);
					for (i = 0; i < npermu + 1; i++)
					{ printf("%f\n", tmp_score[i]); }
				}*/

				for (int i3 = 0; i3 < npermu + 1; i3++) // Line 7. Algorithm NestedPermutationTest
				{
					long k = i3;
					double p, sc = tmp_score[tmp_ptr[i3]];

					while (k < npermu && tmp_score[tmp_ptr[k+1]] == sc) k++;

					p = 1.0 - pvalue(i3-1, k+1);
					while (i3 <= k)
					{
						if (tmp_ptr[i3] == npermu) obs_pval1[0] = p;
	// 					else pval1[tmp_ptr[i3]*NSUBSCORES+j] = p;
						else pval1[tmp_ptr[i3]] = p;
						i3++;
					}
					i3--;
				}
			}

	// 			BIOS::printArray(obs_pval1,3, cout);

	// 		BIOS::printArray(obs_score2, 2*nmarkers );
	// 		cout << endl;

			obs_score2[side*nmarkers+m] = obs_pval1[0];//calc_permu_score2(obs_pval1); // Line 9. Algorithm NestedPermutationTest
			//vT[marker]->best_k = 2;
	// 		cout << " -> " << obs_score2[side*nmarkers+m] ;
	// 		cout << endl;
			for (int i = 0; i < npermu; i++)
				permu_score2[(2*i+side)*nmarkers+m] = pval1[i];//calc_permu_score2(pval1+i*NSUBSCORES);
		}	
	

	void TreeDTMeasure::permu_best_score2(int side, long m, HaplotypeTUCountsTree * tree, double observed_score)
	{
	  //#define debug_TreeDTMeasure_permu_phase1 1

		long i1, j;



		// create permutations
  		if (partialTuCountsTest[0]->getPermutations()==NULL){
		   partialTuCountsTest[0]->totalPermutations = npermu;
  			partialTuCountsTest[0]->setPermutations();
		}

		//cout << endl << "Marker: " << m << endl;
		for (i1 = 0; i1 < npermu; i1++)
		{

		  	TDTtable * tableClone = this->tdtTable->clone(); // copy tdtable
			TUCounts * permutation = (TUCounts*)partialTuCountsTest[0]->getPermutations()[i1]; // Create a permutation of the tuCountsTest
			tableClone->update( permutation->parentalHaplotypesList, true, true, m, !side ); // update table
			permu_score1[i1] = getStatistic(tableClone, tree);
			delete tableClone;

		}


// 		BIOS::print(permu_score1, 10, cout);
// 		cout << endl;
// if(m==0){
// 		BIOS::print(permu_score1, npermu, cout);
// 		cout << endl;
// }

// 		BIOS::print(pval1, npermu * NSUBSCORES, cout);
// 		cout << endl;


		for (j = 0; j < 1; j++) // Line 6. Algorithm NestedPermutationTest
		{
			for (int i2 = 0; i2 < npermu; i2++) { tmp_ptr[i2] = i2; tmp_score[i2] = permu_score1[i2]; }
			tmp_ptr[npermu] = npermu; tmp_score[npermu] = observed_score;

			qsort(tmp_ptr, npermu + 1, sizeof(long), cmp_sort);

// 			BIOS::printArray(tmp_ptr, npermu+1, cout);
// 			cout << endl;

// 			if(j==0){
// 			BIOS::printArray(tmp_score+10, 10, cout);
// 			cout << endl;
// 			}

			/*if (j == 0){
				printf("mk %ld\n", m);
				for (i = 0; i < npermu + 1; i++)
				{ printf("%f\n", tmp_score[i]); }
			}*/

			for (int i3 = 0; i3 < npermu + 1; i3++) // Line 7. Algorithm NestedPermutationTest
			{
				long k = i3;
				double p, sc = tmp_score[tmp_ptr[i3]];

				while (k < npermu && tmp_score[tmp_ptr[k+1]] == sc) k++;

				p = 1.0 - pvalue(i3-1, k+1);
				while (i3 <= k)
				{
					if (tmp_ptr[i3] == npermu) obs_pval1[0] = p;
// 					else pval1[tmp_ptr[i3]*NSUBSCORES+j] = p;
					else pval1[tmp_ptr[i3]] = p;
					i3++;
				}
				i3--;
			}
		}

// 			BIOS::printArray(obs_pval1,3, cout);

// 		BIOS::printArray(obs_score2, 2*nmarkers );
// 		cout << endl;

		obs_score2[side*nmarkers+m] = obs_pval1[0];//calc_permu_score2(obs_pval1); // Line 9. Algorithm NestedPermutationTest
		//vT[marker]->best_k = 2;
// 		cout << " -> " << obs_score2[side*nmarkers+m] ;
// 		cout << endl;
		for (int i = 0; i < npermu; i++)
			permu_score2[(2*i+side)*nmarkers+m] = pval1[i];//calc_permu_score2(pval1+i*NSUBSCORES);
	}

 /*_________________________________________________________________*/

	double TreeDTMeasure::permu_phase2_fromModel(TreeDTModel * model)
	{
		long m = model->posMinPlevel3;
		// statistic
		double score = calc_permu_score3(obs_score2, m); 
		
		// distribution
		model->exportDistributionLevel2(tmp_score);
		
		// p-values
		for (int i = 0; i < npermu; i++) tmp_ptr[i] = i;
		tmp_ptr[npermu] = npermu; tmp_score[npermu] = score;
		qsort(tmp_ptr, npermu + 1, sizeof(long), cmp_sort);	
		
		for (int i = 0; i < npermu + 1; i++)
		{
			long k = i;
			double p, sc = tmp_score[tmp_ptr[i]];

			while (k < npermu && tmp_score[tmp_ptr[k+1]] == sc) k++;
			p = pvalue(i-1, k+1);

			while (i <= k)
			{
				if (tmp_ptr[i] == npermu) obs_pval2[m] = p;
				else if (p < min_permu_pval2[tmp_ptr[i]]) min_permu_pval2[tmp_ptr[i]] = p;
				i++;
			}
			i--;
		}
		
		return obs_pval2[m];
	}
	
	void TreeDTMeasure::permu_phase2(long m, double **distributions)
	{
		double score = calc_permu_score3(obs_score2, m);
		double prev = 0;
		long i;

		phase = 2;
		for (i = 0; i < npermu; i++)
		{
			tmp_ptr[i] = i;
			tmp_score[i] = calc_permu_score3(permu_score2 + 2 * i * nmarkers, m);
		}
		tmp_ptr[npermu] = npermu; tmp_score[npermu] = score;

		
		// store distributions
		if(distributions!=NULL){
			
			for(int i=0; i<npermu; i++)
				distributions[m][i] = tmp_score[i];
		}


		qsort(tmp_ptr, npermu + 1, sizeof(long), cmp_sort);

// 		BIOS::printArray(tmp_score, npermu + 1); cout << endl;

		/*printf("mk %ld\n", m);
		for (i = 0; i < npermu + 1; i++)
		{ printf("%ld %f\n", tmp_ptr[i], tmp_score[tmp_ptr[i]]); }*/

#ifdef PRINT_HISTOGRAM_LEVEL2
		stringstream appendix;
		appendix << "M" << m ;
		string distName= "dist" + appendix.str();
		string zName = "z" + appendix.str();

		cout << distName << " = c(";
		for(int i=0; i<npermu;i++){
			cout << tmp_score[i];
			if (i==npermu-1)
				cout << ")";
			else
				cout << " ,";
		}


		cout << ";" << zName << " = " << score;
		cout << "; hist(" << distName <<  ", freq=FALSE,  xlim=c( min(" << distName <<  ", " << zName <<  "), max(" << distName <<  ", " << zName <<  ")))";
		cout << "; lines(c(" << zName << ", " << zName << "), c(0, 100),  col=\"red\")";
		cout << "; lines(density(" << distName << "),  col=\"blue\")";
		cout << endl;
#endif

		for (i = 0; i < npermu + 1; i++)
		{
			long k = i;
			double p, sc = tmp_score[tmp_ptr[i]];

			while (k < npermu && tmp_score[tmp_ptr[k+1]] == sc) k++;
			p = pvalue(i-1, k+1);

			while (i <= k)
			{
				if (tmp_ptr[i] == npermu) obs_pval2[m] = p;
				else if (p < min_permu_pval2[tmp_ptr[i]]) min_permu_pval2[tmp_ptr[i]] = p;
				i++;
			}
			i--;
		}
		
		




	}

 /*_________________________________________________________________*/

	double TreeDTMeasure::total_p(double p)
	{
		long i, n = 0;
		for (i = 0; i < npermu; i++) if (p >= min_permu_pval2[i]) n++;
		return n / (double)npermu;
	}

	int cmp_sort(const void *a, const void *b)
	{
		if (tmp_score[*(long *)a] < tmp_score[*(long *)b]) return -1;
		if (tmp_score[*(long *)a] > tmp_score[*(long *)b]) return 1;
		return 0;
	}

 /*_________________________________________________________________*/

	double TreeDTMeasure::calc_permu_score2(double *p, int maxK, int &best_k)
	{
		if (fixed_k == 0)
		{
			long i;
			double min = p[0];
			best_k = 0;
			for (i = 1; i < NSUBSCORES; i++){
			  if (p[i] < min){
				 min = p[i];

				 if ( i <= maxK)
			 		best_k = i;

			  }
			}
			return min;
		}
		else{
		  	best_k = fixed_k-1;
			return p[fixed_k-1];

		}
	}

 /*_________________________________________________________________*/

	double TreeDTMeasure::calc_permu_score3(double *p, long m)
	{
		double p0, p1; // p0: p-value left; p1: p-value right
		if (m > 0) p0 = p[m-1]; else p0 = 0.5;
		if (m < nmarkers) p1 = p[nmarkers+m]; else p1 = 0.5;
		return p0 * p1;
	}

 /*_________________________________________________________________*/

	/* y = obs. score; max_lt = ix of highest pscore < y; min_gt = ix of lowest pscore > y */

	double TreeDTMeasure::pvalue(long max_lt, long min_gt)
	{
		double minp = (max_lt + 1.0) / (npermu + 1.0);
		double maxp = min_gt / (npermu + 1.0);
		double low, high, obs;

		if (min_gt - max_lt > 2) return (minp + maxp) * 0.5;
		if (max_lt == -1)
		{
			if (phase == 1) return (minp + maxp) * 0.5;
			low = 0;
		}
		else if (min_gt == npermu + 1)
		{
			if (phase == 2) return (minp + maxp) * 0.5;
			return 1.0 - 1.0/(npermu + 1.0) *
					(tmp_score[tmp_ptr[npermu-1]] / tmp_score[tmp_ptr[npermu]]);
		}
		else
		{
			low = tmp_score[tmp_ptr[max_lt]];
		}
		high = tmp_score[tmp_ptr[min_gt]];
		obs = tmp_score[tmp_ptr[max_lt+1]];

		return minp + (obs - low) / (high - low) * (maxp - minp);
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::dispose_data(void)
	{
		struct AllelePool *ap, *ap2;
		long m;

		for (m = 0; m < nmarkers; m++)
		{
			ap = first_apool[m];
			while (ap)
			{
				ap2 = ap->next;
				free(ap);
				ap = ap2;
			}
		}
		free(mdata);
		free(status);
		free(mutation);
		free(maxallele);
// 		//free(location);
		free(first_apool);

		//location = NULL;
	}

	void TreeDTMeasure::write_power(FILE *f)
	{
		long nmin = 0, pos, m, miss = 0;
		double min = 2.0;
		


		for (m = 0; m < nmarkers + 1; m++)
			if (obs_pval2[m] < min) {
				nmin = 1;
				pos = m;
				min = obs_pval2[m];
// 				cout << endl << "new pos: " << pos << endl;
			}
			else
				if (obs_pval2[m] == min)
					if (rand() / (RAND_MAX + 1.0) < 1.0 / ++nmin)
						pos = m;

		if (closest_mk > -1)
			for (m = 0; m < nmarkers + 1; m++)
				if (obs_pval2[m] <= obs_pval2[closest_mk])
					miss++;

// 		fprintf(f, "#Location p-value\n");
// 		for (m = 0; m < nmarkers + 1; m++) fprintf(f, "%9.1f %1.9f\n", m + 0.5, obs_pval2[m]);
// 		fprintf(f, "PREDICTED_LOC %f\n", pos + 0.5);
// 		if (closest_mk > -1) {
// 			fprintf(f, "CORRECT_LOC   %f\n", correct_locus);
// 			fprintf(f, "ERROR_ABS     %f\n", fabs(pos + 0.5 - correct_locus));
// 			fprintf(f, "FALSE_POS     %f\n", miss / (nmarkers + 1.0));
// 			fprintf(f, "CORR_LOC_P    %f\n", obs_pval2[closest_mk]);
// 		}
// 		fprintf(f, "MIN_PVAL      %f\n", obs_pval2[pos]);
// 		fprintf(f, "OVERALL_P     %f\n", total_p(obs_pval2[pos]));

		if (testMode == -1)
		{
			// bonferroni correction
			//overall_p = obs_pval2[pos]*(nmarkers+1);
			overall_p = obs_pval2[pos];
			totalMultipleTest = nmarkers+1;
		}
		else{
			// minP correction
			overall_p = total_p(obs_pval2[pos]);	
		}
		
		this->posMinPlevel3 = pos;
		model->posMinPlevel3 = pos;
		

		#ifdef PRINT_HISTOGRAM_LEVEL3

		cout << "dist = c(";
		for(int i=0; i<npermu;i++){
			cout << min_permu_pval2[i];
			if (i==npermu-1)
				cout << ")";
			else
				cout << " ,";
		}

		cout << "; z = " << obs_pval2[pos];
		cout << "; hist( dist , freq=FALSE,  xlim=c( min(dist, z), max(dist, z)))";
		cout << "; lines(c(z,z), c(0, 100),  col=\"red\")";
		cout << "; lines(density(dist),  col=\"blue\")";
		cout << "; legend(x=\"topright\" ,legend=c(paste(\"z = \" , z), paste(\"p = \" , "<< overall_p << ") ))";
		cout << endl;
		cout << "dev2bitmap(\"level3.pdf\", type=\"pdfwrite\", width=24, height=12)" << endl;

		#endif
	}
	 /*_________________________________________________________________*/

	void TreeDTMeasure::rec_write_tree(FILE *f, struct NodeTreeDT *n, long level, long pos, long shared_length)
	{
		long i;
		struct ListNodeTreeDT *ln = n->first_child;

		for (i = 0; i < shared_length; i++) fprintf(f, "  ");
		if (ln == NULL)
		{
			long max = n->shared_length;
			if (max > shared_length + 10) max = shared_length + 10;

			for (i = shared_length; i < max; i++)
				fprintf(f, "%2d", (int)original_allele(pos + i * dir, mdata[n->chromo * nmarkers + pos + i * dir]));

			if (n->shared_length > max) fprintf(f, " ...");

			fprintf(f, " :status: %c", status[n->chromo]);
			if (muta_info && mutation[n->chromo]) fprintf(f, "X");
			fprintf(f, "  chromo: %ld\n", n->chromo);
		}
		else
		{
			for (i = shared_length; i < n->shared_length; i++)
				fprintf(f, "%2d", (int)original_allele(pos + i * dir, mdata[n->chromo * nmarkers + pos + i * dir]));
			fprintf(f, " :depth: %ld  a/c: %ld/%ld  shared: %ld  mean_shared: %1.2f root_location: %1.2f chromo: %ld\n",
				n->depth, n->na, n->nc, n->shared_length, n->mean_shared, n->loc, n->chromo);

			while (ln)
			{
				rec_write_tree(f, ln->ptr, level+1, pos, n->shared_length);
				ln = ln->next;
			}
		}
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::write_left_tree(FILE *f, struct NodeTreeDT *root, long pos)
	{
		fprintf(f, "Left-side haplotype tree at marker %li\n", pos);

		dir = -1;
		rec_write_tree(f, root, 0, pos, 0);
	}

	void TreeDTMeasure::write_right_tree(FILE *f, struct NodeTreeDT *root, long pos)
	{
		fprintf(f, "Right-side haplotype tree at marker %li\n", pos);

		dir = 1;
		rec_write_tree(f, root, 0, pos, 0);
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::write_sub_pvalues(FILE *f, long m)
	{
		int i;

		fprintf(f, "%5ld", m+1);
		for (i = 0; i < MAX_SUBTREES; i++)
			fprintf(f, " %8.5f", obs_pval1[i]);

		fprintf(f, "\n");
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::finalize_sort(void)
	{
//  		 printf("Finalizing sort..\n");
		free_subtree(root, 1);
		while (first_npool)
		{
			struct NodePool *np = first_npool->next;
			free(first_npool);
			first_npool = np;
		}
		while (first_lnpool)
		{
			struct ListNodePool *lnp = first_lnpool->next;
			free(first_lnpool);
			first_lnpool = lnp;
		}
		first_free_node = NULL; first_free_listnode = NULL;
		/* printf("done\n"); */
	}
	 /*_________________________________________________________________*/

	void TreeDTMeasure::init_right_sort(void)
	{
		init_sort();
		pos = nmarkers - 1;
		root->loc = 0;
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::right_update(void)
	{
		update();
		//root->loc = location[pos];
		pos--;
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::free_sortlist(void)
	{
		free(sortlist);
	}

 /*_________________________________________________________________*/

	void TreeDTMeasure::allocate_sortlist(void)
	{
		sortlist = (long *)malloc(nchromo * nmarkers * sizeof(long));
	}


	  /**
	  * Store Allel in AllelePool

	  * For each marker we have a list of "AllelePool".
	  * Each AllelePool has APOOLSIZE(16) caracters.
	  * When an AllelePool is filled another one is created.

	  * @param m Marker
	  * @param a Alelle (0 denotes missing value)
	  * @return
	  */
	  char TreeDTMeasure::map_allele(long m, int a)
	  {
		  register int found = 0, ix = 0, i;
		  register struct AllelePool *ap = first_apool[m], *ap2 = NULL;

		  /* printf("Mk = %ld, orig: %d; ", m, a); */

		  if (a == 0) return 0;
		  a--;
		  while (found == 0 && ap)
		  {
			  /* printf("cnt = %ld; ", ap->cnt); */
			  for (i = 0; i < ap->cnt; i++, ix++)
				  if (ap->key[i] == a) { found = 1; break; }
			  if (i == APOOLSIZE) { ap2 = ap; ap = ap->next; }
			  else break;
		  }
		  /* if (found) printf("i = %d; ", i); */
		  if (found == 0)
		  {
			  if (ap == NULL)
			  {
				  /* printf("Allocate pool; "); */
				  ap = (struct AllelePool *)malloc(sizeof(struct AllelePool));
				  if (first_apool[m] == NULL) { first_apool[m] = ap; /* printf("head; "); */ }
				  else ap2->next = ap;
				  ap->next = NULL; ap->cnt = 0;
			  }
			  /* printf("cnt = %d; ", ap->cnt); */
			  ap->key[ap->cnt++] = a;
			  maxallele[m]++;
			  /* printf("(not found); mapped: %d -> %d\n", ap->key[ap->cnt-1] + 1, ix+1); */
		  }
		  /* else printf("(found); mapped: %d -> %d\n", ap->key[i] + 1, ix+1); */
		  return ix + 1;
	  }

 /*_________________________________________________________________*/

	TreeOfHaplotypeTUCounts * TreeDTMeasure::translateTree(struct NodeTreeDT *n)
	{
try
{
// 	  	#define debug_TreeDTMeasure_translateTree

// 		if ( copyHaplotypeTUCountsVector != NULL)
// 		  HaplotypeTUCountsVector::Delete(copyHaplotypeTUCountsVector);
// 		copyHaplotypeTUCountsVector = tuCounts->haplotypeTUCountsVector->clone();
		tuCounts->copyHaplotypeTUCountsVector->copyFrequencies( tuCounts->expandedHaplotypeVector );


		// Tree to be returned
		TreeOfHaplotypeTUCounts * tree;

		struct ListNodeTreeDT *ln = n->first_child;

		if (ln) /* internal node */
		{

			// Create a tree with an empty node
			HaplotypeTUCounts *h = new HaplotypeTUCounts(); // memoria perdida
			tree = new TreeOfHaplotypeTUCounts(h);
//cout << "tree is: " << *tree << "\n";
//cout << "po\n";
tuCounts->treeEmtpyNodes->push_back(h); // to keep track and free memory

			#ifdef debug_TreeDTMeasure_translateTree
			cout << "Tree: "<< endl << *tree << endl;
			#endif

			typedef  Set<HaplotypeTUCounts*>::Class::iterator local_iter;
			pair< local_iter ,bool> ret;
			local_iter node;


			// For each child of the original tree, create a subtree and add it as a child
			while (ln)
			{
				TreeOfHaplotypeTUCounts * child = translateTree( ln->ptr );
				node = tree->getRoot();
					 #ifdef debug_TreeDTMeasure_translateTree
					 cout << "Child is : " << endl;
					 cout << *child << endl;
					 cout << " Root is: [" << *node << "]" << **node << endl;
					 #endif

				tree->addChild( node , 0, child );
					 #ifdef debug_TreeDTMeasure_translateTree
					 cout << "Fusion is: " << endl;
					 cout << *tree << endl;
					 #endif

				delete child; //////////////// JOSE: BORRA LA LINEA CUANDO ACTUALICES EL PAQUETE ML/Graph

				ln = ln->next;
			}

		}
		else
		{
//cout << "DDEDD\n";
			// Create a tree with only this node
// 			HaplotypeTUCounts * h = (*tuCounts->haplotypeTUCountsVector)[n->chromo];
//cout << "ch is:" << n->chromo <<"\n";
//cout << "
			HaplotypeTUCounts * h = (*tuCounts->copyHaplotypeTUCountsVector)[n->chromo];
			tree = new TreeOfHaplotypeTUCounts(h);
				#ifdef debug_TreeDTMeasure_translateTree
				cout << "leaf tree: "<< endl << *tree << endl;
				#endif
		}
		return tree;
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TreeOfHaplotypeTUCounts * TreeDTMeasure::translateTree(struct NodeTreeDT *n)" ); throw;};
	}



	HaplotypeTUCountsTree * TreeDTMeasure::translateTree_b(struct NodeTreeDT *n)
	{
		tuCounts->copyHaplotypeTUCountsVector->copyFrequencies( tuCounts->expandedHaplotypeVector );

		// Tree to be returned
		HaplotypeTUCountsTree * tree;

		struct ListNodeTreeDT *ln = n->first_child;

		if (ln) /* internal node */
		{
			// Create a tree with an empty node
			HaplotypeTUCounts *h = new HaplotypeTUCounts(); // memoria perdida
			tuCounts->treeEmtpyNodes->push_back(h); // to keep track and free memory
			tree = new HaplotypeTUCountsTree();

			HaplotypeTUCountsTree::iterator hIt;

			hIt = tree->insert(tree->begin(), h);
// 			cout << tree->size() << endl;

// 			kptree::print_subtreeOfPointers_bracketed(*tree, tree->begin() );


			// For each child of the original tree, create a subtree and add it as a child
			while (ln)
			{
				HaplotypeTUCountsTree * child = translateTree_b( ln->ptr );
// 				kptree::print_subtreeOfPointers_bracketed(*child, child->begin() );

				HaplotypeTUCountsTree::iterator newNodeIterator;
				newNodeIterator = tree->append_child( tree->begin() );
				tree->insert_subtree( newNodeIterator , child->begin() );
				tree->erase(newNodeIterator);

// 				kptree::print_subtreeOfPointers_bracketed(*tree, tree->begin() ); cout << endl;
				delete child;

				ln = ln->next;
			}


		}
		else
		{
			HaplotypeTUCounts * h = (*tuCounts->copyHaplotypeTUCountsVector)[n->chromo];
// 			tree = new TreeOfHaplotypeTUCounts(h);
			tree = new HaplotypeTUCountsTree();
			tree->insert(tree->begin(), h);
// 			kptree::print_subtreeOfPointers_bracketed(*tree, tree->begin() );
		}


		return tree;

	}



 /*_________________________________________________________________*/

	 TDTtable*  TreeDTMeasure::set(TUCounts* aTUCounts){
			throw NonImplemented("TreeDTMeasure::set");
	 };
	 void TreeDTMeasure::onePrint( ostream&, TUCounts* aTuCounts, TDTtable* aTDTtable, bool whole){
	 	throw NonImplemented("TreeDTMeasure::onePrint");
	 };
	 
	 
	 TreeDTMeasure*	TreeDTMeasure::inferMeasure(TUCounts* tuCounts)
	 {
		 if (tuCounts==NULL) 
			 throw NullValue("TreeDTMeasure*	TreeDTMeasure::inferMeasure(TUCounts* tuCounts)");

		 TreeDTMeasure* result=(TreeDTMeasure*)this->clone();

		 if (result->model!=NULL) 
		 {
			 updateModel(result->model, tuCounts);
		 }
		 result->tuCounts = tuCounts;

		 return result;		 
		 
	 }
	 
	 void TreeDTMeasure::updateModel(TreeDTModel *m, TUCounts * t)
	 {
		 if(model->posMinPlevel3 > 0)
			 m->leftTable->update( t->parentalHaplotypesList, true, true, model->posMinPlevel3-1, true ); 
		 if(model->posMinPlevel3 < nmarkers)
			 m->rightTable->update( t->parentalHaplotypesList, true, true, model->posMinPlevel3, false ); 
	 }


};

#endif

