#ifndef __TreeDTModel_h__
#define __TreeDTModel_h__

namespace BIOS {

class TreeDTModel{
		
		public:
			AssociationTable *leftTable;
			AssociationTable *rightTable;
			
			HaplotypeTUCountsTree *leftTree; // Leaves point to measure->tuCounts->copyHaplotypeTUCountsVector. Intermediate nodes point to newly created nodes.
			HaplotypeTUCountsTree *rightTree;
			
			double *distributionLevel1left;
			double *distributionLevel1right;
			double *distributionLevel3;
			double *distributionLevel2;
			int nPermu;
			
			long posMinPlevel3;
		
		
			TreeDTModel(){ 
				leftTable=NULL; 
				rightTable=NULL;
				
				leftTree=NULL;
				rightTree=NULL;
				
				// Probability distributions
				nPermu=0;
				distributionLevel3=NULL;
				distributionLevel2=NULL;
				distributionLevel1left=NULL;
				distributionLevel1right=NULL;
			};
			
			~TreeDTModel(){ 
				if (leftTable!=NULL){
					delete leftTable;
					leftTable=NULL;
				}
					 
				if (rightTable!=NULL){
					delete rightTable;
					rightTable=NULL;
				}
					
				if(leftTree!=NULL){
					delete leftTree;
					leftTree=NULL;
				}
				if(rightTree!=NULL){
					delete rightTree;
					rightTree=NULL;
				}
				
				if(distributionLevel3!=NULL){
					delete [] distributionLevel3;
					distributionLevel3=NULL;
				}
				
				if(distributionLevel2!=NULL){
					delete [] distributionLevel2;
					distributionLevel2=NULL;
				}	
				
				if(distributionLevel1left!=NULL){
					delete [] distributionLevel1left;
					distributionLevel1left=NULL;
				}
				
				if(distributionLevel1right!=NULL){
					delete [] distributionLevel1right;
					distributionLevel1right=NULL;
				}				
			};
			
			TreeDTModel * clone(){
				if (this == NULL)
					return NULL;
				TreeDTModel * m = new TreeDTModel();
				
				m->posMinPlevel3 = this->posMinPlevel3;
				if (leftTable!=NULL)
					m->leftTable = this->leftTable->clone();
				if (rightTable!=NULL)
					m->rightTable = this->rightTable->clone();
				if (leftTree!=NULL)
					//m->leftTree = new HaplotypeTUCountsTree( *this->leftTree );
					m->leftTree = leftTree->getCloneDuplicatingLeaves();
				if (rightTree!=NULL)
					m->rightTree = rightTree->getCloneDuplicatingLeaves();
					//m->rightTree = new HaplotypeTUCountsTree( *this->rightTree );		
				if (distributionLevel3!=NULL)
					m->fillDistributionLevel3(distributionLevel3, nPermu);
				if (distributionLevel2!=NULL)
					m->fillDistributionLevel2(distributionLevel2, nPermu);			
				if (distributionLevel1left!=NULL)
					m->fillDistributionLevel1(distributionLevel1left, nPermu, 0);	
				if (distributionLevel1right!=NULL)
					m->fillDistributionLevel1(distributionLevel1right, nPermu, 1);				
				
				return m;
			}
			
			void fillDistributionLevel3(double *d, int npermu){
				this->nPermu = npermu;
				distributionLevel3 = new double[npermu];
				for(int i=0; i<npermu; i++){
					distributionLevel3[i] = d[i];
				}
			}
				
				void exportDistributionLevel3(double *target){
					for(int i=0; i<nPermu; i++){
						 target[i] = distributionLevel3[i];
					}					
				}
				
				
				void fillDistributionLevel2(double *d, int npermu){
					this->nPermu = npermu;
					distributionLevel2 = new double[npermu];
					for(int i=0; i<npermu; i++){
						distributionLevel2[i] = d[i];
					}
				}
					
					void exportDistributionLevel2(double *target){
						for(int i=0; i<nPermu; i++){
							 target[i] = distributionLevel2[i];
						}					
					}	
					
					// side 0 == left
					void fillDistributionLevel1(double *d, int npermu, bool side=0){
						this->nPermu = npermu;
						
						if (side==0){
							distributionLevel1left = new double[npermu];
							for(int i=0; i<npermu; i++)
								distributionLevel1left[i] = d[i];
						}
						else
						{
							distributionLevel1right = new double[npermu];
							for(int i=0; i<npermu; i++)
								distributionLevel1right[i] = d[i];								
						}
						
					}
						
						void exportDistributionLevel1(double *target, bool side=0){
							
							if (side==0){
								for(int i=0; i<nPermu; i++){
									 target[i] = distributionLevel1left[i];
								}			
							}
							else{
								for(int i=0; i<nPermu; i++){
									 target[i] = distributionLevel1right[i];
								}
							}
						}					
			
			void printDistro(double *d){
				int i=0;
				cout << "(";
				for(i=0; i<nPermu-1; i++)
				{
					cout << d[i] << ", ";
				}
				cout << d[i] << ")" << endl;
				
			}
	
	};

};

#endif
