#ifndef __TreeDTSimpleMeasure_cpp__
#define __TreeDTSimpleMeasure_cpp__

namespace BIOS {


template<class T>	TreeDTSimpleMeasure<T>::TreeDTSimpleMeasure(TreeDTSimpleMeasure<T> & other)
	{
		this->permutations = true;
		this->k = other.k;
		this->useMaxK = useMaxK;
		this->counts = other.counts;
		if ( other.tdtTable != NULL )
			this->tdtTable = other.tdtTable->clone();
		else
			this->tdtTable = NULL;

	}


/*_____________________________________________________________*/

template<class T>		TreeDTSimpleMeasure<T>::TreeDTSimpleMeasure(TUCounts* tuCounts, int k, bool useMaxK, double minFreq):Chi2TDTMeasure<T>(minFreq)
	{
		this->permutations = true;
		
		this->k = k;
		this->useMaxK = useMaxK;
		this->minFreq = minFreq;		

		if ( tuCounts != NULL)
			setTUCounts(tuCounts);
	};
/*_____________________________________________________________*/


template<class T>		TreeDTSimpleMeasure<T>::TreeDTSimpleMeasure(int k, bool useMaxK, double minFreq)
	{
		//TreeDTSimpleMeasure(NULL, K, minFreq);
		this->permutations = true;
		this->k = k;
		this->useMaxK = useMaxK;
		this->minFreq = minFreq;
	}

/*_____________________________________________________________*/

template<class T>		void TreeDTSimpleMeasure<T>::setTUCounts(TUCounts* tuCounts)
	{
		double max_z=-9999, last_z; // z value of the tdttable selected
		SetOfPartitions * partitions; // Set of all possible partitions 

		AssociationTable * minTable=NULL;

		this->counts = tuCounts;

		if ( this->tdtTable != NULL){
			delete this->tdtTable;
			this->tdtTable = NULL;
		}


		if (useMaxK){

			int maxK=2;
			for(int k_i=2; k_i<=k; k_i++){
 				//cout << endl<< "Checking k..." << k_i << endl;
				partitions = SetOfPartitions::splitVector( tuCounts->haplotypeCountsVector, k_i);	
				if ( partitions->size()){
					minTable = partitions->getTDTtableForMaxZ(last_z);
					if( last_z > max_z){
						if( this->tdtTable != NULL)
							delete this->tdtTable;
						this->tdtTable = minTable->clone();
						max_z = last_z;
						//cout << "z updated to: " << max_z << endl;
						maxK=k_i;
					}
					delete minTable;					
				}
				delete partitions;
			}
			//cout << "  maxK = " << maxK << endl;

		}
		else{

			partitions = SetOfPartitions::splitVector( tuCounts->haplotypeCountsVector, k);	
			if ( partitions->size() == 0)
				this->tdtTable = NULL;
			else
				this->tdtTable = partitions->getTDTtableForMaxZ(max_z);	

			delete partitions;	

		}

		
		
	};

// 	void TreeDTSimpleMeasure::createRandomizationDistribution()
// 	{
// 		rd = new RandomizationDistribution();
// 		double z;
// 		for (int j=0;j<tuCounts->getTotalPermutations();j++)
// 		{
// 			TUCounts * permutation = ( tuCounts->getPermutations() )[j];
// 			z = TreeDT::getMaxZstatistic(permutation->haplotypeCountsVector,  this->k);
// 			rd->values->insertElement( z );
// 		}
// 		rd->sort();
// 		//cout << "RD: " << *rd << endl;
// 
// 	};

/*_____________________________________________________________*/

	template<class T>	TreeDTSimpleMeasure<T>::~TreeDTSimpleMeasure(){
// 		if ( rd!=NULL)
// 			delete rd;
	};
/*_____________________________________________________________*/


template<class T>		double TreeDTSimpleMeasure<T>::getStatistic(){

		//return TreeDT::getMaxZstatistic(tuCounts->haplotypeCountsVector,k);
		if (this->tdtTable!=NULL)
			return this->tdtTable->getStatisticZ();
		else return 0;

	};

// 	double TreeDTSimpleMeasure::getPVal()
// 	{
// 		if ( tuCounts->getPermutations() == NULL){
// 			// Create this->permutations
// 			tuCounts->setPermutations();
// 		}
// 		createRandomizationDistribution();
// 
// 		return TreeDT::getPvalueForK(tuCounts->haplotypeCountsVector,k,rd);
// 	}

/*_____________________________________________________________*/

template<class T>		TreeDTSimpleMeasure<T>* TreeDTSimpleMeasure<T>::clone(){
		return new TreeDTSimpleMeasure<T>(*this);
	};

/*_____________________________________________________________*/

template<class T>		string TreeDTSimpleMeasure<T>::getName(){
		

		if (useMaxK)
			return string("TreeDTSimpleMK"  + tos(k) );
		else
			return string("TreeDTsimple"  + tos(k) );

	};

/*_____________________________________________________________*/

template<class T>		  TreeDTSimpleMeasure<T>* TreeDTSimpleMeasure<T>::getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test)
	{
		return new TreeDTSimpleMeasure((TUCounts*)tuCounts, k, this->minFreq);
	}
/*_____________________________________________________________*/


	template<class T>	TreeDTSimpleMeasure<T>::TreeDTSimpleMeasure()
	{

		throw NonImplemented("TreeDTSimpleMeasure::TreeDTSimpleMeasure()");
	
	};
/*_____________________________________________________________*/


template<class T>		stringList* TreeDTSimpleMeasure<T>::getHeadFile(){
		throw NonImplemented("TreeDTSimpleMeasure::getHeadFile()");
	};

/*_____________________________________________________________*/

template<class T>		TUCounts* TreeDTSimpleMeasure<T>::getTUCounts(){
		  return (TUCounts*) this->counts;
	};

/*_________________________________________________________________*/

template<class T>			void TreeDTSimpleMeasure<T>::print(ostream& out){
 throw NonImplemented(" TreeDTSimpleMeasure::print(ostream& out)");
		};


/*_____________________________________________________________*/

template<class T>	  TreeDTSimpleMeasure<T>* TreeDTSimpleMeasure<T>::fromString(string s){throw NonImplemented("TreeDTSimpleMeasure::fromString(string s)");};


};

#endif
