#ifndef __TreeDTSimpleMeasure_h__
#define __TreeDTSimpleMeasure_h__

namespace BIOS {
	
	/**
		@memo TreeDTSimpleMeasure
		@doc
		Definition:

		TreeDT algorithm inspired in Sevon et al. "TreeDT: Tree Pattern Mining for Gene Mapping" (2006)

		@author Jose J. Moreno
		@version 1.0
	*/	
	


class TreeDTSimpleMeasure: public Chi2TDTMeasure{

		//! level k
		int k;
		//! If true, analyze k={2,3,...,k-1,k}. If false, analyze k={k}
		bool useMaxK;

		//! haplotype vector
		//HaplotypeTUCountsVector* v;
		//! Statistic distribution
		//RandomizationDistribution * rd;

		//TUCounts* tuCounts;

		//void createRandomizationDistribution();

		public:

		/**
		*	Constructor
		*/		
		TreeDTSimpleMeasure();

		/**
		*	Constructor
		*	@param maxK Maximum level k
		*/	

		TreeDTSimpleMeasure(SampleGeneticCounts* tuCounts, int k, bool useMaxK=false, double minFreq=10);

		TreeDTSimpleMeasure(int k, bool useMaxK=false, double minFreq=10);

		TreeDTSimpleMeasure(TreeDTSimpleMeasure & other);


		/**
		*	Destructor
		*/		
		virtual ~TreeDTSimpleMeasure();

		virtual TreeDTSimpleMeasure* clone();


		/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		virtual double getStatistic();

		/**
		*	Calculates the p-value of the sample set as the minimum p_k. 
		*	A p_k value is calculated for each k.
		*	@see getPvalueForK()
		*	@return p-value		
		*/

// 		virtual double getPVal();


		virtual string getName();

		virtual stringList* getHeadFile();

		virtual TreeDTSimpleMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);

		SampleGeneticCounts* getTUCounts();
		void setTUCounts(TUCounts* tuCounts);

		TreeDTSimpleMeasure* fromString(string s);

	//	friend ostream& operator<<(ostream& out, TreeDTSimpleMeasure& l){};
		
		virtual void print(ostream&);

	};



/*
{

}
*/

};

#endif
