#ifndef __WeightedTDTMeasure_cpp__
#define __WeightedTDTMeasure_cpp__





namespace BIOS {

		WeightedTDTMeasure::WeightedTDTMeasure(TUCounts* tuCounts, double minFreq, bool  equalWeights, bool permutations, bool left):Chi2TDTMeasure(tuCounts, minFreq, permutations, left)
{

weights=NULL;
this->equalWeights=equalWeights;
if (tdtTable!=NULL) 
if (equalWeights)
{
weights=new doubleList();
for (int i=0; i<tdtTable->getYDim(); i++)
 weights->insertElement(1/(double)tdtTable->getYDim());
		}
else
weights=tdtTable->getHapFreqs();
}
/*_________________________________________________________________*/

		WeightedTDTMeasure::WeightedTDTMeasure(double minFreq, bool  equalWeights, bool permutations, bool left):Chi2TDTMeasure(minFreq, permutations, left)
{
weights=NULL;
this->equalWeights=equalWeights;
		};

/*_________________________________________________________________*/

		WeightedTDTMeasure::WeightedTDTMeasure(WeightedTDTMeasure& other):Chi2TDTMeasure(other)
{
if (other.weights!=NULL) weights=other.weights->clone();
else weights=NULL;
equalWeights=other.equalWeights;
		};

/*_________________________________________________________________*/

		WeightedTDTMeasure::~WeightedTDTMeasure(){
  zap(weights);
 zap(tdtTable);
		};

/*_________________________________________________________________*/

		WeightedTDTMeasure* WeightedTDTMeasure::clone(){
  return new WeightedTDTMeasure(*this);
		};

/*_________________________________________________________________*/

 string WeightedTDTMeasure::getName()
{
 string result=string("mTDTW");
if (equalWeights) result=result+string("_equalW");
 if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
 if (permutations) result=result+addPermutationsInName();
 return result;

};
/*_______________________________________________________________________________*/


		double WeightedTDTMeasure::getStatistic()
		{
double variance=0;		
if (weights!=NULL) 
{
for (int i=0; i<tdtTable->getYDim(); i++)
{
variance=variance+2*weights->getElement(i);
for (int j=i+1; j<tdtTable->getYDim(); j++)
{
variance=variance+4*weights->getElement(i)*weights->getElement(j)*
std::pow(getGenotypeCount(tdtTable->partition->getElement(j)->getElement(0), tdtTable->partition->getElement(i)->getElement(0)),2)/(tdtTable->getHeteroHapCount(i,ut)*tdtTable->getHeteroHapCount(j,ut));
}
}
return std::pow(tdtTable->getWeightedStatistic(weights)-1,2)/variance;
}
else return 0;
		};

/*_________________________________________________________________*/

  WeightedTDTMeasure* WeightedTDTMeasure::getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test)
{
return new WeightedTDTMeasure((TUCounts*)tuCounts, minFreq, equalWeights, this->permutations);
}
/*_____________________________________________________________________________________________________________*/



		doubleList* WeightedTDTMeasure::getWeights()
		{
		return weights;
		};





/*_____________________________________________________________*/

	double WeightedTDTMeasure::getPVal()
  {
  if (weights!=NULL)
  return pdfTestChiSquare(getStatistic(), 1); 
  else return 1;
  }

/*_____________________________________________________________*/

WeightedTDTMeasure* WeightedTDTMeasure::inferMeasure(TUCounts* tuCounts)
{
throw NonImplemented("WeightedTDTMeasure* WeightedTDTMeasure::inferMeasure(TUCounts* tuCounts)");
}


/*_____________________________________________________________*/


void WeightedTDTMeasure::print(ostream& out)
{
if (weights!=NULL)
out <<"Hap freqs:" << *getWeights() <<"\n";
this->Chi2TDTMeasure::print(out);
}

};

#endif
