#ifndef __TDT1Measure_h__
#define __TDT1Measure_h__

namespace BIOS {
	
  /**
     @memo TDT1Measure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class TDT1Measure: public GroupBasedTDTMeasure {
    
		public:
	

		/**
		*	Constructor
		*/		
	//	TDT1Measure();

		/**
		*	Destructor
		*/		
virtual		~TDT1Measure();

virtual TDT1Measure* clone();


Transmission transmission;

  virtual TDT1Measure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		TDT1Measure(TUCounts* tuCounts, int transmission=1, double minFreq=10, int testMode=2, SampleTUCounts** partialTuCountsTraning=NULL, SampleTUCounts** partialTuCountsTest=NULL, bool useDistances=true, bool lengthDistance=false);
// transmission codes: {ut=0, t=1, u=2}
// testMode is 0 if usual testing (low specificity because of ad-hoc grouping
// testMode is -1 when Bonferroni correction is used (low power because it is an overcorrection)
// testMode is 1 for holdout
// testMode is >= when cross-validation fold testMode is used

		TDT1Measure(int transmission=1, double minFreq=10, int testMode=2, bool useDistances=true, bool lengthDistance=false);

	
				TDT1Measure(TDT1Measure& other);

	 virtual	TDTtable* set (TUCounts* aTUCounts=NULL);

 string getName();//{return string("mTDT1T");};
 
virtual void onePrint( ostream& , SampleTUCounts* aTuCounts, TDTtable* aTDTtable, int subsample, int position=-1);
		/**
		*	Calculate statistic from the tables 
		*/

// virtual	double getStatistic();

// virtual	double getPVal();

//virtual ostream& print(ostream&);





	};




};

#endif
