#ifndef __TreeDT_h__
#define __TreeDT_h__

namespace BIOS {
	
  /**
     @memo TreeDT
     @doc
     Definition:
     TreeDT algorithm inspired in Sevon et al. "TreeDT: Tree Pattern Mining for Gene Mapping" (2006)

     @author Jose Moreno
     @version 1.0
	
	*/	
	class TreeDT{

		public:

			/**
			* Constructor
			*/	
			TreeDT(){};

			/**
			*	Calculate the pValue for the sample set. All possible values of k
			*
			*	@param TM Sample set
			*	@param rds Z distribution to calculate p-value. One distribution for each k 
			*	@return p-value
			*/
			//static double getPvalue(TrioCountersHapUAndT* TM, std::vector<RandomizationDistribution *> & rds); 

			/**
			*	Calculates the p-value of the sample set as the minimum p_k. 
			*	A p_k value is calculated for each k.
			*	@see getPvalueForK()
			*	@param v List of haplotypes extracted from a TrioCountersHapUAndT
			*	@param maxK Maximum level k
			*	@param rds Z distribution to calculate p-value. One distribution for each k 	
			*	@return p-value		
			*/
			static double getPvalue(HaplotypeTUCountsVector* v, int maxK, std::vector<RandomizationDistribution *> & rds); 

			/**
			*	Calculates p-value for a specific k. The z used to extract the p-value is the maximum z calculated on all possible partitions of k.
			*	@see getMaxZstatistic()
			*	@param v List of haplotypes extracted from a TrioCountersHapUAndT
			*	@param k Specific k
			*	@param rds Z distribution to calculate p-value. One distribution for each k 	
			*	@return p-value		
			*/	
			static double getPvalueForK(HaplotypeTUCountsVector* v, int k, std::vector<RandomizationDistribution *> & rds); 

			static double getPvalueForK(HaplotypeTUCountsVector* v, int k, RandomizationDistribution * rd); 

			/**
			*	Generates all partitions of k. Calculates the z of each one and returns the maximum z.
			*	@param k Specific k
			*	@param v List of haplotypes extracted from a TrioCountersHapUAndT
			*	@return Z statistic
			*/
			static double getMaxZstatistic(HaplotypeTUCountsVector* v, int k);


			/**
				Calculate the pValue for the sample set 
				This one uses "static double getPvalue(HaplotypeVector* v);"

				@param TM Sample set
				@param pdf Z distribution to calculate p-value. One distribution for each k 
				@return p-value
			*/
			//static double getPvalue(TrioCountersHapUAndT* TM, doubleList** pdf);

			/**
			*	Calculate the pValue for the sample set  (for all possible values of k)
			*	@param v List of haplotypes (T/U) 
			*	@param pdf Z distribution to calculate p-value. One distribution for each k 
			*	@return p-value
			*/
			//static double getPvalue(HaplotypeVector* v, doubleList**pdf);

			/**
			*	Calculate the pValue for the sample set  (for all possible values of k from 1 to maxK)
			*	@param v List of haplotypes (T/U) 
			*	@param pdf Z distribution to calculate p-value. One distribution for each k 
			*	@return p-value
			*/
			//static double getPvalue(HaplotypeVector* v, int maxK, doubleList** pdf);

			/**
			*	Calculates p-value by looking at the z distribution given
			*	@param pdf Z distribution
			*	@param z Calculate p-value for this z.
			*	@return p-value
			*/
			//static double PfromZ(doubleList * pdf, double z);

			/**
				Calculate the pValue for the sample set for a specific value of k
			*/
			//static double getPvalueForK(HaplotypeVector* v, int k, doubleList**pdf);




	

	};

};

#endif
