/* File: Trio.cpp */


#ifndef __Trio_cpp__
#define __Trio_cpp__


#include "Trio.h"


namespace BIOS {




/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


///////////////////
//// public ///////
///////////////////

/*____________________________________________________________ */

Trio::Trio (PhenotypeSample* phenotypeSample, GenotypeSample* genotypeSample)
{
try
{
trioGenotype=new TrioGenotype(genotypeSample);
trioPhenotype=new TrioPhenotype(phenotypeSample);
this->genotypeSample=genotypeSample;
this->phenotypeSample=phenotypeSample;
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Trio::Trio (PhenotypeSample* phenotypeSample, GenotypeSample* genotypeSample)" ); throw;};
}

/*____________________________________________________________ */

Trio::Trio (PhenotypeSample* phenotypeSample, PhenotypePointer FatherP, PhenotypePointer MotherP, PhenotypePointer ChildP, GenotypeSample* genotypeSample, GenotypePointer FatherG, GenotypePointer MotherG, GenotypePointer ChildG)
{
trioGenotype=new TrioGenotype(genotypeSample, FatherG, MotherG, ChildG);
trioPhenotype=new TrioPhenotype(phenotypeSample, FatherP, MotherP, ChildP);
this->phenotypeSample=phenotypeSample;
this->genotypeSample=genotypeSample;
}
/*____________________________________________________________ */

Trio* Trio::clone()
{
return new Trio(*this);
}

/*____________________________________________________________ */

PhenotypeSample::iterator Trio::getChildPhenotype()
{
return trioPhenotype->GetChildPhenotype();
}
/*____________________________________________________________ */

PhenotypeSample::iterator Trio::getMotherPhenotype()
{
return trioPhenotype->GetMotherPhenotype();
}
/*____________________________________________________________ */

PhenotypeSample::iterator Trio::getFatherPhenotype()
{
return trioPhenotype->GetFatherPhenotype();
}
/*____________________________________________________________ */

PhenotypeSample::iterator Trio::getPhenotype(IndCategory ic)
{
return trioPhenotype->GetPhenotype(ic);
}
/*____________________________________________________________ */

GenotypeSample::iterator Trio::getGenotype(IndCategory ic)
{
return trioGenotype->getGenotype(ic);
}
/*____________________________________________________________ */

GenotypeSample::iterator Trio::getChildGenotype()
{
return trioGenotype->GetChildGenotype();
}
/*____________________________________________________________ */

GenotypeSample::iterator Trio::getMotherGenotype()
{
return trioGenotype->GetMotherGenotype();
}
/*____________________________________________________________ */

GenotypeSample::iterator Trio::getFatherGenotype()
{
return trioGenotype->GetFatherGenotype();
}
/*____________________________________________________________ */
/*
Trio::Trio (PhenotypeSample *ps, GenotypeSample *gs, PhenotypePointer IndPhenotype, GenotypePointer IndGenotype)
{
Phenotype P=ps->getElement(IndPhenotype);
Genotype G=gs->getElement(IndGenotype);
if (P.IsAChild())
  {
  SetChildPhenotype(P);
  SetChildGenotype(G);
  SetFatherPhenotype(ps->GetFather(IndPhenotype));
  SetFatherGenotype(gs->getNode(ps->GetPos(GetFatherPhenotype()));
  SetMotherPhenotype(ps->GetMother(IndPhenotype));
  SetMotherGenotype((gs->getNode(ps->GetPos(GetMotherPhenotype()));
  }
  if (P.IsAFather()) 
  {
  SetFatherPhenotype(P);
  SetFatherGenotype(G);
  SetChildPhenotype(ps->getFirstChild(IndPhenotype));
  SetChildGenotype(gs->getNode(ps->GetPos(GetChildPhenotype()));
  SetMotherPhenotype(ps->GetCouple(IndPhenotype));
  SetMotherGenotype(gs->getNode(ps->GetPos(GetMotherPhenotype()));
  }
  if (P.IsAMother())
  {
  SetMotherPhenotype(P);
  SetMotherGenotype(G);
  SetChildPhenotype(ps->getFirstChild(IndPhenotype));
  SetChildGenotype(gs->getNode(ps->GetPos(GetChildPhenotype()));
  SetFatherPhenotype(ps->GetCouple(IndPhenotype));
  SetFatherGenotype(gs->getNode(ps->GetPos(GetFatherPhenotype()));
  }
}
*/
/*____________________________________________________________ */

void Trio::printUsingAlleleNumbers (ostream& out)
{
out << *trioPhenotype->phenotypeSample->getElement(trioPhenotype->FatherPhenotype) <<" ";
trioGenotype->genotypeSample->getElement(trioGenotype->FatherGenotype)->printUsingAlleleNumbers(out); 
out << *trioPhenotype->phenotypeSample->getElement(trioPhenotype->MotherPhenotype) <<" " ;
trioGenotype->genotypeSample->getElement(trioGenotype->MotherGenotype)->printUsingAlleleNumbers(out); 
out << *trioPhenotype->phenotypeSample->getElement(trioPhenotype->ChildPhenotype) <<" " ;
trioGenotype->genotypeSample->getElement(trioGenotype->ChildGenotype)->printUsingAlleleNumbers(out); 
}
/*______________________________________________________*/

  ostream& operator<<(ostream& out, Trio& trio)
    {
out << *trio.trioPhenotype->phenotypeSample->getElement(trio.trioPhenotype->FatherPhenotype) <<" " << *trio.trioGenotype->genotypeSample->getElement(trio.trioGenotype->FatherGenotype) <<"\n";
out << *trio.trioPhenotype->phenotypeSample->getElement(trio.trioPhenotype->MotherPhenotype) <<" " << *trio.trioGenotype->genotypeSample->getElement(trio.trioGenotype->MotherGenotype) <<"\n";
out << *trio.trioPhenotype->phenotypeSample->getElement(trio.trioPhenotype->ChildPhenotype) <<" " << *trio.trioGenotype->genotypeSample->getElement(trio.trioGenotype->ChildGenotype) <<"\n";
    return out;
    }


};  // End of Namespace

#endif

/* End of file: Genotype.h */




