/* File: TrioCounters.h */

#ifndef __TrioCounters_h__
#define __TrioCounters_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S TrioCounters DEFINITION */
/************************/


/**
        @memo TrioCounters for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class TrioCounters: public GenotypeCounters {


public:

    /** @name Declaration of class TrioCounters
        @memo Private part.
    */

	 
private:

       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

 

		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:

double** SNPAbsFreqsFather, **SNPAbsFreqsMother;


 
longLongList* genotypeCountsFather,* genotypeCountsMother; // there are as many genotypes (each genotype being a long long)) in each list as the number of parents
//intList* fatherPedigrees,* motherPedigrees; // there are as many pedigrees in each list as the number of parents

      /** @name Operations on TrioCounters 
        @memo Operations on a TrioCounters 
    */
	//TrioCounters(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation=allAffectation) ;

TrioCounters(SNPPos Pos[], SNPPos totalPos, VectorOfParentalGenotypes * samp, int affectation=allAffectation) ;

	
 TrioCounters(TrioCounters& source);
 TrioCounters();

	
	//TrioCounters(TrioSample * samp);

//TrioCounters<T>* convertToKnownGenotypes(MultidimensionalTable<double>* haplotypeFreqsTab, MultidimensionalTable<double>* haplotypeFreqsTabU);

 void empty();


	~TrioCounters()
	{
empty();
	};

//void setGenotypeFreqs ();

//void setGenotypeTable();


MultidimensionalTable<longLongList*>* getPointersToPartnerGenotypes(IndCategory ic);

longLongList* permuteInParent(bool father);



MultidimensionalTable<double>* getGenotypeAbsFreqs(IndCategory ic); //, BayesType Bayes, float distance, float alpha);

//virtual void setCounters (GenomaSample* sample, int affectation);  
virtual void setCounters (VectorOfParentalGenotypes* sample, int affectation);
	
//longLongList* updatePermutationsInChildren(longLongList* genotypeCountsFather, longLongList* genotypeCountsMother);

//	void GetSampleFrequencies(IndPos & bnAB, IndPos & bnAb,IndPos & bnaB,IndPos & bnab);

	 TrioCounters* clone();

virtual void setSNPFreqs();

	 //void set(TrioSample* sample, int affectation) ;


virtual TrioCounters * getPermutation ();



SampleTUCounts * getPermutationTUCounts (HapExtractionConfiguration* hapExtractionConfiguration);


};  // End of class TrioCounters

ostream& operator<<(ostream& out, TrioCounters& pm)
       {

out <<"pos: ";
for (int i=0; i<pm.totalPos; i++)
 out << pm.pos[i] <<" ";

out <<"\n";
//out << "sizae is:"<< pm.genotypeCountsFather->size() <<"\n";
//out <<" first:" << pm.genotypeCountsFather->getFirstElement() <<"\n";

if (pm.genotypeCountsFather!=NULL)
{
pm.genotypeCountsFather->setOutputSeparator('\n');
out <<"\npaternal genotypes: \n" << *pm.genotypeCountsFather;
}
if (pm.genotypeCountsMother!=NULL)
{
pm.genotypeCountsMother->setOutputSeparator('\n');
out <<"\nmaternal genotypes: \n" << *pm.genotypeCountsMother;
}

return out;
};



};  // End of Namespace

#endif

/* End of file: TrioCounters.h */




