/* File: PhylogeneticDistance.h */

#ifndef __TrioCountersHapUAndT_h__
#define __TrioCountersHapUAndT_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:

       Class used to obtain haplotypes from genotypes. 

       With this purpose, the data structures required is:
 
       Container vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/



 
class	TrioCountersHapUAndT: public HapCounters {

//MultimarkerMeasureHap<TrioSample> *multimarkerMeasureTransmitted, *multimarkerMeasureUntransmitted;

private:


public:
//EMRestriction emRestriction;
//EMDistributions emDistributions;


//TrioCounters* trioCounters;
FreqAndKeyVector *hapByFreqsT, *hapByFreqsU;
	//   double** SNPAbsFreqsFatherT, **SNPAbsFreqsFatherU, ** SNPAbsFreqsMotherT, **SNPAbsFreqsMotherU;
//   double** SNPFreqs;
ParentalHaplotypesList* haplotypeCounts; // the number of parental haplotypes is the same of the number of trios for phaseAlg= onlyKnown or phaseAlg=maxFreq. For phaseAlg=weighted, there can be more parental haplotypes than the number of trios 
//double totalDifferentHaplotypes, totalUsedDifferentHaplotypes, totalMeiosis;
//MultidimensionalEmptyTable<int>* haplotypeTable;




/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      public:



//	TrioCountersHapUAndT(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation=allAffectation, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, bool includeMissing=false, bool onlyHetero=true, int minFreq=10);
	
 TrioCountersHapUAndT(TrioCountersHapUAndT& source);
 
TrioCountersHapUAndT(TrioCounters* source, PhaseAlg phaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, BayesType  Bay=MLE, float alphaBayes=0, float distance=0.0);

 TrioCountersHapUAndT();

virtual void setTU(TrioCountersHapUAndT& source);
long long int getHapAtPosition (int hapPosition=1, Transmission transmissionHapPosition=t);

virtual void setHapByFreqsTU();


VectorOfParentalHaplotypes* getVectorOfParentalHaplotypes();

VectorOfParentalHaplotypes* getVectorOfParentalHaplotypes ( HeteroPair<HaplotypeTUCountsList*, map<long long int, int>* > * result1 );

HeteroPair<HaplotypeTUCountsList*, map<long long int, int>* > * getHaplotypeTUCountsList();

//void setSNPFreqs();

virtual void setHaplotypeCounts();
MultidimensionalTable<double>*  getKnownHaplotypeFreqs();
long long int getHap(const long long int value, bool left);
MultidimensionalTable<double>* getHaplotypeFreqsTab();
//double getNormalizationValue(int totalConfigurations, long long int ambiguousPosFather, long long int ambiguousPosMother, Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother);

double getNormalizationValue (MultidimensionalTable<double>* haplotypeFreqsTab, int totalConfigurations, long long int ambiguousPosFather, long long int ambiguousPosMother);

ParentalHaplotypes* getParentalHaplotypes(long long int ambiguousConfFather, long long int ambiguousConfMother, int binaryKnownConfiguration);
double getCurrentFrequency(MultidimensionalTable<double>* haplotypeFreqsTab, ParentalHaplotypes *parentalHaplotype);
MultidimensionalTable<double>* getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab, MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes);
//double getIndependentLociFrequency (long long int key);
virtual ~TrioCountersHapUAndT()
{
empty();
	};

TrioCounters* getTrioCounters();
virtual void empty ();
//void setTotalHaplotypes();
BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans, IndCategory ic=parent);
TrioCountersHapUAndT* clone();
double getTotalHaplotypesTU (long long int hap, Transmission trans, IndCategory ic=parent, Homozygosity h=allHomozygosity);
double getTotalHomoGenotypes (long long int hap, IndCategory ic);
double getTotalHeteroGenotypes (long long int hap, IndCategory ic);
//virtual TrioCounters* getPermutation(); //{throw NonImplemented("getPermutation");};

HeteroPair<HaplotypeTUCountsList*,VectorOfParentalHaplotypes*>* getTUCounts();
double getCurrentFrequency (MultidimensionalTable<double>* haplotypeFreqsTab, long long int  fatherT, long long int  fatherU, long long int  motherT, long long int  motherU);


};  // End of class MultimarkerMeasure




ostream& operator<<(ostream& out, TrioCountersHapUAndT& pm)
{
if (pm.haplotypeCounts!=NULL)
 out << *pm.haplotypeCounts << "\n";
return out;
};

};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */







