/* File: MultimarkerMeasure.h */

#ifndef __TrioCountersHapUAndTKnownHaps_h__
#define __TrioCountersHapUAndTKnownHaps_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class	TrioCountersHapUAndTKnownHaps: public TrioCountersHapUAndT {


private:


//protected:

//MultimarkerMeasure<TrioSample> *parentMeasures;

public:

//longLongList* fatherCountsT, *motherCountsT, * fatherCountsU, *motherCountsU;

//HeteroListPair<long long int, double>* haplotypeFreqs, *haplotypeFreqsU, *hapFreqs;

       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


public:

//void empty();

//	TrioCountersHapUAndTKnownHaps(MultimarkerMeasure<TrioSample>*parentMeasures);

	TrioCountersHapUAndTKnownHaps(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation=allAffectation)  throw (OutOfRange<long long int>);

	
 TrioCountersHapUAndTKnownHaps(TrioCountersHapUAndTKnownHaps& source);

 TrioCountersHapUAndTKnownHaps(TrioCounters* source);




~TrioCountersHapUAndTKnownHaps()
	{
	};

TrioCountersHapUAndTKnownHaps* clone();

TrioCountersHapUAndTKnownHaps(TrioCountersHapUAndT& source);

void set();

Pair<longLongList*>* removeSameHaplotypes(longLongList* transList, longLongList *untransList);


//void setHaplotypeFreqs();

//void setHaplotypeFreqs(longLongList* fatherCountsT, longLongList* fatherCountsU, longLongList* motherCountsT, longLongList* motherCountsU);

//TrioCountersHapUAndTKnownHaps* filter(SNPPos a, SNPPos b);
//double getGenericTDT (int test, IndCategory ic=parent);


//	double getStandardizedSimilarityMeasure (IndCategory ic=parent);

//	double getSignedRankTest(bool wilcoxon=true, IndCategory ic=parent);

//	double getSimilarityMeasure (IndCategory ic=parent);

//double getTest (int testType, IndCategory ic=parent);


//HeteroListPair<long long int, double>* getComposedList(longLongList *fatherHaps, longLongList* motherHaps);

//BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);

//double getSignedTDT ();

//longLongList* getHaplotypeCountsFromGenotypes(IndCategory ic, Transmission trans);

Pair<MultidimensionalTable<double>*>* getHaplotypeFreqsTab();



long long int getHap(const long long int gene, bool left);

TrioCountersHapUAndTKnownHaps * getPermutation ();

};  // End of class MultimarkerMeasure
/*
ostream& operator<<(ostream& out, TrioCountersHapUAndTKnownHaps& pm)
{
   out << pm.fatherCountsT <<"\n";
   out << pm.motherCountsT << "\n";
	 out << pm.fatherCountsU <<"\n";
   out << pm.motherCountsU;
   return out;
};

*/

};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




