/* File: TrioGenotype.h */


#ifndef __TrioGenotype_cpp__
#define __TrioGenotype_cpp__





namespace BIOS
{

	ostream& operator<< ( ostream& out,TrioGenotype& trio )
	{

		out << *trio.genotypeSample->getElement ( trio.FatherGenotype );
		out << *trio.genotypeSample->getElement ( trio.MotherGenotype );
		out << *trio.genotypeSample->getElement ( trio.ChildGenotype );
		return out;
	}


	/************************/
	/* SNP'S GENOTYPE DEFINITION */
	/************************/


	/**
	        @memo GenotypePointer for SNPs

		@doc
	        Definition:
	        A unordered pair of SNPs values for an individual and a genetic position.
	        One has been transmitted from the father, one for the mother. Who transmits
	        each one of them does not matter.

	        Memory space: O(1).

	        @author Maria M. Abad
		@version 1.0
	*/





	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/


///////////////////
//// public ////////
///////////////////

	/*____________________________________________________________ */

	TrioGenotype::TrioGenotype ( GenotypeSample * genotypeSample )
	{
		try
		{
			this->genotypeSample=genotypeSample;

			motherGenotype=NULL;
			fatherGenotype=NULL;
			childGenotype=NULL;
			MotherGenotype=genotypeSample->end();
			FatherGenotype=genotypeSample->end();
			ChildGenotype=genotypeSample->end();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TrioGenotype::TrioGenotype ( GenotypeSample * genotypeSample )" ); throw;};
	}

	/*____________________________________________________________ */

	TrioGenotype::TrioGenotype ( GenotypeSample* genotypeSample, GenotypePointer  FatherG, GenotypePointer  MotherG, GenotypePointer  ChildG )
	{
		try
		{
			this->genotypeSample=genotypeSample;

			if ( FatherG==genotypeSample->end() || MotherG==genotypeSample->end() || ChildG==genotypeSample->end() )
				throw NullValue();

			FatherGenotype=FatherG;
			MotherGenotype=MotherG;
			ChildGenotype=ChildG;


			motherGenotype=genotypeSample->getElement ( MotherGenotype );
			fatherGenotype=genotypeSample->getElement ( FatherGenotype );
			childGenotype=genotypeSample->getElement ( ChildGenotype );
		}
		catch ( NullValue nv ) {nv.PrintMessage ( " TrioGenotype::constructor" );}

	}

	/*____________________________________________________________ */

	int TrioGenotype::getInconsistencies ( SNPPos SNP, IndCategory ic )
	{
throw NonImplemented("TrioGenotype::getInconsistencies ( SNPPos SNP, IndCategory ic )");
		if ( ic!=mother && ic!=father && ic!=parent ) throw BadFormat ( "int TrioGenotype::getInconsistencies (SNPPos SNP, IndCategory ic)" );
		Genotype *motherGenotype=genotypeSample->getElement ( GetMotherGenotype() );
		Genotype *fatherGenotype=genotypeSample->getElement ( GetFatherGenotype() );
		Genotype *childGenotype=genotypeSample->getElement ( GetChildGenotype() );

//cout <<"next\n ";
		allele leftC, rightC, leftF, rightF, leftM, rightM;
		int result=0;


		leftC=childGenotype->DiplotypeArray[0][SNP]; rightC=childGenotype->DiplotypeArray[1][SNP]; leftF=fatherGenotype->DiplotypeArray[0][SNP]; rightF=fatherGenotype->DiplotypeArray[1][SNP]; leftM=motherGenotype->DiplotypeArray[0][SNP]; rightM=motherGenotype->DiplotypeArray[1][SNP];


		if ( Diplotype::isANonMissingSNP ( childGenotype->DiplotypeArray[0][SNP], childGenotype->DiplotypeArray[1][SNP] ) )
		{
			if ( ic== father || ic==parent )
				if ( Diplotype::isANonMissingSNP ( fatherGenotype->DiplotypeArray[0][SNP], fatherGenotype->DiplotypeArray[1][SNP] ) )
					if ( abs ( leftC ) !=abs ( leftF ) && abs ( rightC ) !=abs ( leftF ) && abs ( leftC ) !=abs ( rightF ) && abs ( rightC ) !=abs ( rightF ) )
						result++;
//if (leftC==leftF || leftC==rightF) leftC=NA; else rightC=NA;

			if ( ic==mother || ic==parent )
				if ( Diplotype::isANonMissingSNP ( motherGenotype->DiplotypeArray[0][SNP], motherGenotype->DiplotypeArray[1][SNP] ) )
					if ( abs ( leftC ) !=abs ( leftM ) && abs ( rightC ) !=abs ( leftM ) && abs ( leftC ) !=abs ( rightM ) && abs ( rightC ) !=abs ( rightM ) )
						result++;
		}
		return result;
	}
	/*____________________________________________________________ */


	bool TrioGenotype::isMissing ( SNPPos SNP )
	{
		if ( childGenotype==NULL || fatherGenotype==NULL || motherGenotype==NULL )
			throw NullValue ( "bool TrioGenotype::isMissing (SNPPos SNP)" );
		return ( !Diplotype::isANonMissingSNP ( childGenotype->DiplotypeArray[0][SNP], childGenotype->DiplotypeArray[1][SNP] ) )
		       || ( !Diplotype::isANonMissingSNP ( fatherGenotype->DiplotypeArray[0][SNP], fatherGenotype->DiplotypeArray[1][SNP] ) )
		       || ( !Diplotype::isANonMissingSNP ( motherGenotype->DiplotypeArray[0][SNP], motherGenotype->DiplotypeArray[1][SNP] ) );
	}

	/*____________________________________________________________ */

	PairGenotype* TrioGenotype::getPairGenotype ( IndCategory ic )
	{
		PairGenotype* PG=NULL;
		switch ( ic )
		{
			case offspring:
				PG=new PairGenotype ( fatherGenotype, motherGenotype );
				break;
			case father:
				PG=new PairGenotype ( childGenotype, motherGenotype );
				break;
			case mother:
				PG=new PairGenotype ( childGenotype, fatherGenotype );
		}
		return PG;
	}
	/*____________________________________________________________ */
	/*
	Genotype* TrioGenotype::getGenotype(IndCategory ic)
	{
	switch (ic)
	{
	case offspring: return childGenotype; break;
	case father: return fatherGenotype; break;
	case mother: return childGenotype; break;
	}
	}
	/*____________________________________________________________ */


	void TrioGenotype::completeMissing ( SNPPos SNP )
	{
		try
		{
			//cout << "\nCompleting missing...";
			Diplotype* D, *relative1D, *relative2D;
			Genotype* G;
			PairGenotype* PG;
			for ( int i=0; i<3; i++ )
			{
				G=genotypeSample->getElement ( getGenotype ( ( IndCategory ) i ) );
				PG=getPairGenotype ( ( IndCategory ) i );
				if ( !Diplotype::isANonMissingSNP ( G->DiplotypeArray[0][SNP], G->DiplotypeArray[1][SNP] ) )
				{
					switch ( i )
					{
						case 2: // offspring
							if ( Diplotype::isANonMissingSNP ( PG->getFirstGenotype()->DiplotypeArray[0][SNP], PG->getFirstGenotype()->DiplotypeArray[1][SNP] ) )
								if ( PG->getFirstGenotype()->isHomozygous ( SNP ) )
									G->setLeftAllele ( SNP, PG->getFirstGenotype()->getLeftAllele ( SNP ) );

							if ( Diplotype::isANonMissingSNP ( PG->getSecondGenotype()->DiplotypeArray[0][SNP], PG->getSecondGenotype()->DiplotypeArray[1][SNP] ) )
								if ( PG->getSecondGenotype()->isHomozygous ( SNP ) )
									G->setRightAllele ( SNP, PG->getSecondGenotype()->getLeftAllele ( SNP ) );
							break;
						case 0: // father
						case 1: //mother
							if ( Diplotype::isANonMissingSNP ( PG->getFirstGenotype()->DiplotypeArray[0][SNP], PG->getFirstGenotype()->DiplotypeArray[1][SNP] ) )
								if ( PG->getFirstGenotype()->isHomozygous ( SNP ) )
									if ( i==0 ) // father
										G->setLeftAllele ( SNP, PG->getFirstGenotype()->getLeftAllele ( SNP ) );
									else // mother
										G->setLeftAllele ( SNP, PG->getFirstGenotype()->getRightAllele ( SNP ) );
								else
									if ( Diplotype::isANonMissingSNP ( PG->getSecondGenotype()->DiplotypeArray[0][SNP], PG->getSecondGenotype()->DiplotypeArray[1][SNP] ) )
										if ( PG->IsHomozygousHeterozygous ( SNP, genotypeSample->allAlleles ) ) // child hetero, partner homo
											if ( PG->getSecondGenotype()->isHomozygous1 ( SNP, genotypeSample->allAlleles[SNP][0] ) ) // partner Homo1
												G->setLeftAllele ( SNP, genotypeSample->allAlleles[SNP][1] );
											else // partner Homo2
												G->setLeftAllele ( SNP, genotypeSample->allAlleles[SNP][0] );
							break;
					}
					/*
									if ( Diplotype::isANonMissingSNP ( PG->getFirstGenotype()->DiplotypeArray[0][SNP], PG->getFirstGenotype()->DiplotypeArray[1][SNP] ) && Diplotype::isANonMissingSNP ( PG->getSecondGenotype()->DiplotypeArray[0][SNP], PG->getSecondGenotype()->DiplotypeArray[1][SNP] ) )
										if ( PG->IsHomozygousHeterozygous ( SNP, genotypeSample->allAlleles ) )
										{
											switch ( i )
											{
												case 2: // offspring
													if ( PG->getFirstGenotype()->isHomozygous ( SNP ) )
														G->setLeftAllele ( SNP, PG->getFirstGenotype()->getLeftAllele ( SNP ) );
													else  G->setRightAllele ( SNP, PG->getSecondGenotype()->getLeftAllele ( SNP ) );
													break;
												case 0: // father or mother
												case 1:
													if ( PG->getFirstGenotype()->isHomozygous ( SNP ) ) // child homo
														G->setLeftAllele ( SNP, PG->getFirstGenotype()->getLeftAllele ( SNP ) );
													else  //partner homo
														if ( PG->getSecondGenotype()->isHomozygous1 ( SNP, genotypeSample->allAlleles[SNP][0] ) ) // mother Homo1
															G->setLeftAllele ( SNP, genotypeSample->allAlleles[SNP][1] );
														else // mother Homo2
															G->setLeftAllele ( SNP, genotypeSample->allAlleles[SNP][0] );
													break;
											}
										}
					*/
				}
				zap ( PG );

			}
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void TrioGenotype::completeMissing ( SNPPos SNP )" ); throw;};
	}

	/*____________________________________________________________ */
	/*
	TrioSNPGenotype TrioGenotype::getSNPGenotype (SNPPos SNP)
	{
		TrioSNPGenotype r=TrioSNPGenotype(this, SNP);
		return r;
	}

	/*____________________________________________________________ */

	GenotypePointer TrioGenotype::getGenotype ( IndCategory ic )
	{
		switch ( ic )
		{
			case father: 	return FatherGenotype; break;
			case mother: return MotherGenotype; break;
			case offspring: return ChildGenotype; break;
		}
	}
	/*____________________________________________________________ */

	GenotypePointer TrioGenotype::GetFatherGenotype ()
	{
		return FatherGenotype;
	}
	/*____________________________________________________________ */

	GenotypePointer TrioGenotype::GetMotherGenotype ()
	{
		return MotherGenotype;
	}
	/*____________________________________________________________ */

	void TrioGenotype::SetFatherGenotype ( GenotypePointer genotype )
	{
		try
		{
			FatherGenotype=genotype;
			fatherGenotype=genotypeSample->getElement ( genotype );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void TrioGenotype::SetFatherGenotype ( GenotypePointer genotype )" ); throw;};

	}
	/*____________________________________________________________ */

	void TrioGenotype::SetMotherGenotype ( GenotypePointer genotype )
	{
		try
		{
			MotherGenotype=genotype;
			motherGenotype=genotypeSample->getElement ( genotype );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void TrioGenotype::SetMotherGenotype ( GenotypePointer genotype )" ); throw;};

	}
	/*____________________________________________________________ */

	void TrioGenotype::SetChildGenotype ( GenotypePointer genotype )
	{
		try
		{
			ChildGenotype=genotype;
			childGenotype=genotypeSample->getElement ( genotype );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void TrioGenotype::SetChildGenotype ( GenotypePointer genotype )" ); throw;};

	}

	/*____________________________________________________________ */

	bool TrioGenotype::isMendelianError ( SNPPos SNP )
	{
		Genotype *motherGenotype=genotypeSample->getElement ( GetMotherGenotype() );
		Genotype *fatherGenotype=genotypeSample->getElement ( GetFatherGenotype() );
		Genotype *childGenotype=genotypeSample->getElement ( GetChildGenotype() );
//cout <<"next\n ";
		allele leftC, rightC, leftF, rightF, leftM, rightM;
		int leftCI, rightCI, leftFI, rightFI, leftMI, rightMI;
		int result=0;
		leftC=childGenotype->DiplotypeArray[0][SNP]; leftCI=abs ( leftC ); rightC=childGenotype->DiplotypeArray[1][SNP]; rightCI=abs ( rightC ); leftF=fatherGenotype->DiplotypeArray[0][SNP]; leftFI=abs ( leftF ); rightF=fatherGenotype->DiplotypeArray[1][SNP]; rightFI=abs ( rightF ); leftM=motherGenotype->DiplotypeArray[0][SNP]; leftMI=abs ( leftM ); rightM=motherGenotype->DiplotypeArray[1][SNP]; rightMI=abs ( rightM );
		bool fatherMissing=!Diplotype::isANonMissingSNP ( fatherGenotype->DiplotypeArray[0][SNP], fatherGenotype->DiplotypeArray[1][SNP]);
		                   bool motherMissing=!Diplotype::isANonMissingSNP ( motherGenotype->DiplotypeArray[0][SNP], motherGenotype->DiplotypeArray[1][SNP]);

		                                      if ( !Diplotype::isANonMissingSNP ( childGenotype->DiplotypeArray[0][SNP], childGenotype->DiplotypeArray[1][SNP] ) ) return false;

		                                      if ( fatherMissing && motherMissing ) return false;

			                                      if ( ( ( leftCI==leftFI || leftCI==rightFI || fatherMissing ) && ( rightCI==leftMI || rightCI==rightMI || motherMissing ) ) ||
				                                              ( ( ( leftCI==leftMI || leftCI==rightMI || motherMissing ) && ( rightCI==leftFI || rightCI==rightFI || fatherMissing ) ) ) ) // if no mendelian error
				                                      return false;
				                                      return true;

			                                      };


                   /*____________________________________________________________ */

                   void TrioGenotype::solveMIUsingChild ( SNPPos SNP )
	{
throw NonImplemented("TrioGenotype::solveMIUsingChild ( SNPPos SNP )");
		if ( isMendelianError ( SNP ) )
		{
			Genotype *motherGenotype=genotypeSample->getElement ( GetMotherGenotype() );
			Genotype *fatherGenotype=genotypeSample->getElement ( GetFatherGenotype() );
			Genotype *childGenotype=genotypeSample->getElement ( GetChildGenotype() );
//cout <<"next\n ";
			allele leftC, rightC, leftF, rightF, leftM, rightM;
			int result=0;
			leftC=childGenotype->DiplotypeArray[0][SNP]; rightC=childGenotype->DiplotypeArray[1][SNP]; leftF=fatherGenotype->DiplotypeArray[0][SNP]; rightF=fatherGenotype->DiplotypeArray[1][SNP]; leftM=motherGenotype->DiplotypeArray[0][SNP]; rightM=motherGenotype->DiplotypeArray[1][SNP];
			if ( Diplotype::isANonMissingSNP ( childGenotype->DiplotypeArray[0][SNP], childGenotype->DiplotypeArray[1][SNP] ) &&  Diplotype::isANonMissingSNP ( fatherGenotype->DiplotypeArray[0][SNP], fatherGenotype->DiplotypeArray[1][SNP] ) && ( leftC!=leftF && rightC!=leftF && leftC!=rightF && rightC!=rightF ) ) // father inconsistent
			{
				if ( leftC==leftM || leftC==rightM ) fatherGenotype->DiplotypeArray[0][SNP]=rightC;
				else if ( rightC==leftM || rightC==rightM ) fatherGenotype->DiplotypeArray[0][SNP]=leftC;
			}
			if ( Diplotype::isANonMissingSNP ( childGenotype->DiplotypeArray[0][SNP], childGenotype->DiplotypeArray[1][SNP] ) && ( Diplotype::isANonMissingSNP ( motherGenotype->DiplotypeArray[0][SNP], motherGenotype->DiplotypeArray[1][SNP] )  && ( leftC!=leftM && rightC!=leftM && leftC!=rightM && rightC!=rightM ) ) ) // mother inconsistent
			{
				if ( leftC==leftF || leftC==rightF ) motherGenotype->DiplotypeArray[0][SNP]=rightC;
				else if ( rightC==leftF || rightC==rightF ) motherGenotype->DiplotypeArray[0][SNP]=leftC;
			}
		}
	};
	/*____________________________________________________________ */

	void TrioGenotype::removeMI ( SNPPos SNP )
	{
		if ( isMendelianError ( SNP ) )
		{
			Genotype *motherGenotype=genotypeSample->getElement ( GetMotherGenotype() );
			Genotype *fatherGenotype=genotypeSample->getElement ( GetFatherGenotype() );
			Genotype *childGenotype=genotypeSample->getElement ( GetChildGenotype() );
//cout <<"next\n ";

				fatherGenotype->DiplotypeArray[0][SNP]=NA;
				fatherGenotype->DiplotypeArray[1][SNP]=NA;
				childGenotype->DiplotypeArray[0][SNP]=NA;
				childGenotype->DiplotypeArray[1][SNP]=NA;
				motherGenotype->DiplotypeArray[0][SNP]=NA;
				motherGenotype->DiplotypeArray[1][SNP]=NA;
			
		}
	};
	/*____________________________________________________________ */

	GenotypePointer TrioGenotype::GetChildGenotype ()
	{
		return ChildGenotype;
	}






}
;  // End of Namespace

#endif

/* End of file: GenotypePointer.h */




