/* File: TrioSample.h */


#ifndef __TrioSample_cpp__
#define __TrioSample_cpp__

//#include <string.h>
//#include <cstdio>


//#include "GenomaSample.cpp"

//#include "CoupleGenotype.h"
namespace BIOS
{


	/*****************************/
	/* SNP'S GENOTYPE DEFINITION */
	/*****************************/


	/**
	        @memo Genotype for SNPs

			@doc
	        Definition:
	        A unordered pair of SNPs values for an individual and a genetic position.
	        One has been transmitted from the father, one for the mother. Who transmits
	        each one of them does not matter.

	        Memory space: O(1).

	        @author Maria Mar Abad Grau
		@version 1.0
	*/
	template <> Trio* Container<vector<Trio*>, Trio*>::readElement ( ifstream * source, const char* tokens, int* pos, int size )
	{
		cout << "Trio* Container<vector, Trio*>::readElement not implemented  yet";
		end();
	};

	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/

//////////// privates /////////////
	/*____________________________________________________________ */

	void TrioSample::InitializeTrioSample ()
	{
		try
		{
			bool *children=NULL;
			if ( TrioList!=NULL )
			{
				if ( phenotypeSample!=NULL && genotypeSample!=NULL )
				{
					switch ( genotypeSample->AlleleOrderMode )
					{
						case NotChanged:
							break;
						case MajorFirst:
							break; // already done in GenotypeSample
						case random:
							break;
						case LeftRight: // for this mode, OrderLeftRight() only checks if they are correctly ordered
						case incompleteLeftRight: // for this mode, OrderLeftRight() change unphased to missing
						case LeftRightUsingTrios:
							OrderLeftRight();
							break;
					};
					if ( solveMIUsingChildren ) solveMendelianInconsistenciesUsingChildren();
					else removeMendelianInconsistencies();
					CheckInconsistenciesFromParents();

					if ( CompleteMissing ) completeMissing();

					IndPos TotalInds=phenotypeSample->size();
					setMarked ( parent );

					children=Initialize ( phenotypeSample->size(), true );

					phenotypeSample->SetMarked ( children, offspring );


					genotypeSample->setAllAlleles ( Marked, children );	// children are used to keep missing if children have a missing value


					zaparr ( children );
				}
			}
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::initializeTrioSample" );
			throw;
		};
	}

	/*____________________________________________________________ */

	void TrioSample::removeParentsWithNoOffspringOrOffSpringWithoutParents ()
	{
		try
		{
			bool remove;
			if ( !completeFamily )
			{

				intList * gList=new  intList ();

				if ( genotypeSample!=NULL )
				{
					GenotypeSample::iterator IndGenotype=genotypeSample->getFirst();
					PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst(), fatherIt, motherIt;
					while ( IndGenotype!=genotypeSample->end() && IndPhenotype!=phenotypeSample->end() )
					{
						remove=false;
						if ( ! phenotypeSample->getElement ( IndPhenotype )->isAChild ( )  && ( ! phenotypeSample->getElement ( IndPhenotype )->hasOffspring ( phenotypeSample ) ) )
							remove=true;

						if ( phenotypeSample->getElement ( IndPhenotype )->isAChild ( ) )
						{

							fatherIt=phenotypeSample->GetFather ( IndPhenotype );
							motherIt=phenotypeSample->GetMother ( IndPhenotype );

							if ( fatherIt==phenotypeSample->end() && motherIt==phenotypeSample->end() )
								remove=true;
						}

						if ( remove ) gList->insertElement ( genotypeSample->getPosition ( IndGenotype ) );


						IndGenotype=genotypeSample->getNext ( IndGenotype );
						IndPhenotype=phenotypeSample->getNext ( IndPhenotype );
					}
					genotypeSample->Container<vector<Genotype*>, Genotype*>::removeElementsWithPositionsIn ( gList );
					phenotypeSample->Container<vector<Phenotype*>, Phenotype*>::removeElementsWithPositionsIn ( gList );
				}
				//cout << "phenotypes at pos: " << *gList << " removed\n";
				zap ( gList );
			}
			//  cout << "new size phenotypes:" << phenotypeSample->size() <<"\n";
			//      cout << "new size genotypes:" << genotypeSample->size() <<"\n";
		}

		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from void TrioSample::removeParentsWithNoOffspringOrOffSpringWithoutParentsg ()" );
			throw;
		};
	}
	/*____________________________________________________________ */

	void TrioSample::CreateTrioList ()
	{
		try
		{
//cout <<"bfff\n";
			Trio *T; //=new Trio(phenotypeSample, genotypeSample);
			//cout << "total genotypes is:" << genotypeSample->size() << "\n";
			//cout << "total phenotypes is:" << phenotypeSample->size() << "\n";
			if ( genotypeSample!=NULL )
			{
				TrioList=new Container<vector<Trio*>, Trio*>();
				GenotypeSample::iterator IndGenotype=genotypeSample->getFirst();
				PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst();
				while ( IndGenotype!=genotypeSample->end() && IndPhenotype!=phenotypeSample->end() )
				{
					if ( phenotypeSample->getElement ( IndPhenotype )->isAChild ( ) )

//if ( ! alreadyChosen(phenotypeSample->getElement ( IndPhenotype )->getCode2() ))
					{
//cout << "F: " << *genotypeSample->getElement(IndGenotype)->getDiplotype(7) <<" and " << *genotypeSample->getElement(IndGenotype)->getDiplotype(8) <<"\n";
						T=getTrioMembers ( IndPhenotype, IndGenotype );
						//   cout << *T->trioPhenotype <<"\n";
//if (						atoi(phenotypeSample->getElement ( IndPhenotype )->getPedigree().c_str())==1047)
//{
//cout <<*T <<"\n";
//exit(0);
//}
						if ( T==NULL )
						{
							if ( !completeFamily && exitWhenIncompleteFamily )
							{
								cout << "Member " << phenotypeSample->getElement ( IndPhenotype )->getCode() << " from family " << phenotypeSample->getElement ( IndPhenotype )->getPedigree() <<" lacks some family members\n";
								throw BadFormat ( "void TrioSample::CreateTrioList ()" );
								exit ( 0 );
							}

						}
						else TrioList->insertElement ( T );
					}
//else cout <<"non a father\n";
// if (phenotypeSample->getElement(IndPhenotype)->IsAMother())
//  cout << ":M " << *genotypeSample->getElement(IndGenotype)->getDiplotype(7) <<" and " << *genotypeSample->getElement(IndGenotype)->getDiplotype(8) <<"\n";
					IndGenotype=genotypeSample->getNext ( IndGenotype );
					IndPhenotype=phenotypeSample->getNext ( IndPhenotype );
				}
//cout <<"end\n";
//exit(0);
			}

			//	cout << "total genotypes at the end is:" << genotypeSample->size() << "\n";

//cout <<"las\n";
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::CreateTrioList()" );
			throw;
		};
	}

	/*____________________________________________________________ */

	TrioSample::TrioSample ( char* filename, int*pos, int size, AlleleOrderType AlleleOrderMode, bool CompleteMis, bool allowRecombination, bool solveMIUsingChildren, bool completeFamily, bool exitWhenIncompleteFamily, int verbose ) : GenomaSample ( filename, pos, size, parent, AlleleOrderMode, 1, verbose )
	{
		try
		{
			this->exitWhenIncompleteFamily=exitWhenIncompleteFamily;
			this->completeFamily=completeFamily;
			this->solveMIUsingChildren=solveMIUsingChildren;
			TrioList=NULL;
			CompleteMissing=CompleteMis;
			inconsistencies=NULL;
			fatherInconsistencies=NULL;
			motherInconsistencies=NULL;
			nonHeteroParents=NULL;
			parentsNotInHWE=NULL;
			childrenNotInHWE=NULL;
			this->allowRecombination=allowRecombination;
			init();

		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::TrioSample (char * filename,..." );
			throw;
		};
	}

	/*____________________________________________________________ */

	TrioSample::TrioSample ( TrioSample& source, Container<vector<string>, string>* selectedPositions, char* filePos, bool missingData )  : GenomaSample ( source, selectedPositions, filePos, missingData )
	{
		try
		{
			copy ( source );
		}
		catch ( Inconsistent& ic )
		{
			ic.addMessage ( "\ncalled from TrioSample::TrioSample (TrioSample& source, Container<set<string>, string>* selectedPositions, char* filePos)" );
			throw;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::TrioSample (TrioSample& source, Container<set<string>, string>* selectedPositions, char* filePos)" );
			throw;
		};
	}

	/*____________________________________________________________ */

	GenomaSample* TrioSample::selectPositions ( Container<vector<string>, string>* selectedPositions, char* filePos, bool missingData )
	{
		return new TrioSample ( *this, selectedPositions, filePos, missingData );

	}

	/*____________________________________________________________ */

	TrioSample::TrioSample ( TrioSample& source, Container<vector<SNPPos>, SNPPos>* Sampling, bool selectInds ) : GenomaSample()
	{
		intList* samp2=Sampling;
		if ( selectInds )
		{
			samp2=new intList();
			intList *trioP, *trioG;
			for ( Container<vector<Trio*>, Trio*>::iterator it=source.TrioList->begin(); it!=source.TrioList->end(); it++ )
				if ( Sampling->findElement ( source.TrioList->getPosition ( it ) ) !=Sampling->end() )
				{
					samp2->insertElement ( source.genotypeSample->getPosition ( ( ( Trio* ) *it )->getFatherGenotype() ) );
					samp2->insertElement ( source.genotypeSample->getPosition ( ( ( Trio* ) *it )->getMotherGenotype() ) );
					samp2->insertElement ( source.genotypeSample->getPosition ( ( ( Trio* ) *it )->getChildGenotype() ) );
				}
		}
		GenomaSample::copy ( source, samp2, selectInds );
		if ( selectInds ) zap ( samp2 );
		copy ( source );
	}
	/*____________________________________________________________ */

	void TrioSample::copy ( TrioSample& source )
	{
		try
		{
			TrioList=NULL;
			inconsistencies=NULL;
			fatherInconsistencies=NULL;
			motherInconsistencies=NULL;
			nonHeteroParents=NULL;
			parentsNotInHWE=NULL;
			childrenNotInHWE=NULL;
			allowRecombination=source.allowRecombination;
			CompleteMissing=source.CompleteMissing;
			exitWhenIncompleteFamily=source.exitWhenIncompleteFamily;
			solveMIUsingChildren=source.solveMIUsingChildren;
			completeFamily=source.completeFamily;
			CreateTrioList();
			checkInconsistentPhenotypes();
		}
		catch ( Inconsistent& ic )
		{
			ic.addMessage ( "\ncalled from TrioSample::copy(TrioSample& source" );
			throw;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::copy(TrioSample& source" );
			throw;
		};
	}

	/*____________________________________________________________ */

	TrioSample* TrioSample::clone()
	{
		return new TrioSample ( *this );
	}

	/***************************************************/

	TrioSample::~TrioSample ()
	{
		zap ( TrioList );
		zaparr ( inconsistencies );
		zaparr ( fatherInconsistencies );
		zaparr ( motherInconsistencies );
		zaparr ( nonHeteroParents );
		zaparr ( parentsNotInHWE );
		zaparr ( childrenNotInHWE );
	};

	/*____________________________________________________________ */

	void TrioSample::init()
	{
		try
		{

//cout <<"complete family is:" << completeFamily <<"\n";

			removeParentsWithNoOffspringOrOffSpringWithoutParents();
//cout <<"before creating trio list\n";
			CreateTrioList();
//cout <<"size after creating is:" << TrioList->size();

			checkInconsistentPhenotypes();

//cout <<"size after checking is:" << TrioList->size();

			InitializeTrioSample();
//cout <<"size after initializing is:" << TrioList->size();

		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::init()" );
			throw;
		};
	}
	/*__________________________________________________________________*/


	SNPPos TrioSample::getTotalSNPs()
	{
		try
		{
			return genotypeSample->GetTotalSNPs();
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::getTotalSNPs()" );
			throw;
		};
	}
	/*__________________________________________________________________*/

	void TrioSample::OrderLeftRight ()
	{
		try
		{

			int cont=0;
			if ( TrioList!=NULL )
			{
//cout <<"there are " << TrioList->size() << " trios\n";
// if LeftRightUsingTrios, order alleles in the trio for offspring to be consistent with parents
// if LeftRight, it checks if they are correctly ordered
				Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
				Genoma* G;
				SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
				while ( TrioPos!=TrioList->end() )
				{
					for ( unsigned short int i=0;i<3;i++ )
					{
//cout <<"before Genoma\n";
						G=new Genoma ( TrioList->getElement ( TrioPos ), ( IndCategory ) i );
						for ( SNPPos SNP=0; SNP<TotalSNPs;SNP++ )
							if ( genotypeSample->AlleleOrderMode==LeftRightUsingTrios )
							{
								if ( Diplotype::isANonMissingSNP ( G->getGenotype()->DiplotypeArray[0][SNP], G->getGenotype()->DiplotypeArray[1][SNP] ) )
									if ( G->CanBeInferred ( SNP, NotChanged ) ) // if not missing and at least one person is homozygotic
									{
//cout << "canbeinferred\n";
										if ( G->MustBeChanged ( SNP ) )
{
//cout <<"mustbe changed\n";
											G->ChangeAlleles ( SNP );
//cout <<"was changed\n";
}
									}
									else
{
//cout << "cannotbe inferred\n";

										if ( Diplotype::isHeterozygous ( G->getGenotype()->DiplotypeArray[0][SNP], G->getGenotype()->DiplotypeArray[1][SNP] ) )
{
//cout <<"has tobe marked\n";
											G->markAlleles ( SNP );
//cout <<"was marked\n";
}
}

							}
							else // LeftRight or incompleteLeftRight
							{

								if ( G->getGenotype()->DiplotypeArray[0][SNP]<0 || G->getGenotype()->DiplotypeArray[1][SNP]<0 )
									if ( genotypeSample->AlleleOrderMode==LeftRight )
										throw UnsolvedPhase ( G->getGenotype()->DiplotypeArray[0][SNP],G->getGenotype()->DiplotypeArray[1][SNP], "TrioSample::OrderLeftRight" );
									else G->getGenotype()->setDiplotype ( NA, NA, SNP );

								if ( !allowRecombination  && ( IndCategory ) i==offspring )
								{
									if ( !G->getGenotype()->isMissing ( SNP ) && !G->getPairGenotype()->getFirstGenotype()->isMissing ( SNP ) )
										if ( G->getGenotype()->DiplotypeArray[0][SNP]!=G->getPairGenotype()->getFirstGenotype()->DiplotypeArray[0][SNP] )
										{
											cout <<"Child genotype: ";
											cout << G->getGenotype()->DiplotypeArray[0][SNP] <<" " << G->getGenotype()->DiplotypeArray[1][SNP] << ", father: " ;
											cout << G->getPairGenotype()->getFirstGenotype()->DiplotypeArray[0][SNP] << " ";
											cout << G->getPairGenotype()->getFirstGenotype()->DiplotypeArray[1][SNP] <<" and mother: ";
											cout << G->getPairGenotype()->getSecondGenotype()->DiplotypeArray[0][SNP] << " ";
											cout << G->getPairGenotype()->getSecondGenotype()->DiplotypeArray[1][SNP];
											cout <<"\nfamily:" << G->getPhenotype()->getPedigree() <<" and SNP: " << SNP+1;
											throw Inconsistent ( "TrioSample::OrderLeftRightFather" );
										}
									if ( !G->getGenotype()->isMissing ( SNP ) && !G->getPairGenotype()->getSecondGenotype()->isMissing ( SNP ) )
										if ( G->getGenotype()->DiplotypeArray[1][SNP]!=G->getPairGenotype()->getSecondGenotype()->DiplotypeArray[0][SNP] )
										{
											/*cout <<"Child genotype: ";
											cout << G->getGenotype()->DiplotypeArray[0][SNP] <<" " << G->getGenotype()->DiplotypeArray[1][SNP] << ", father: " ;
											cout << G->getPairGenotype()->getFirstGenotype()->DiplotypeArray[0][SNP] << " ";
											cout << G->getPairGenotype()->getFirstGenotype()->DiplotypeArray[1][SNP] <<" and mother: ";
											cout << G->getPairGenotype()->getSecondGenotype()->DiplotypeArray[0][SNP] << " ";
											cout << G->getPairGenotype()->getSecondGenotype()->DiplotypeArray[1][SNP];
*/
											cout <<"\nfamily:" << G->getPhenotype()->getPedigree() <<" and SNP: " << SNP+1;
											throw Inconsistent ( "TrioSample::OrderLeftRightMother" );
										}

								}
							}
						zap ( G );
					}
					TrioPos=TrioList->getNext ( TrioPos );
					cont++;
				}
			}
else throw NullValue("void TrioSample::OrderLeftRight ()");
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::OrderLeftRight()" );
			throw;
		};
	}

/*__________________________________________________________________*/

	bool TrioSample::alreadyChosen (string code2)
	{
		try
		{

		if ( TrioList==NULL ) return false;
		for (Container<vector<Trio*>, Trio*>::iterator trioPos=TrioList->getFirst(); trioPos<TrioList->end(); trioPos++)
{
if ((phenotypeSample->getElement(TrioList->getElement(trioPos)->getChildPhenotype())->getCode2()==code2)
|| (phenotypeSample->getElement(TrioList->getElement(trioPos)->getMotherPhenotype())->getCode2()==code2)
|| (phenotypeSample->getElement(TrioList->getElement(trioPos)->getFatherPhenotype())->getCode2()==code2))
return true;
}
return false;

				
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::alreadyChosen(string code2)" );
			throw;
		};
	}

	/*____________________________________________________________ */
	/*
	void TrioSample::setWithSelection(TrioSample& source, Container<set<IndPos>, IndPos>* Sampling)
	{

	Trio*T;
	intList *trioP, *trioG;
	for (int i=TrioList->size()-1; i>=0; i--)
	if (Sampling->findElement(i)==Sampling->end())
	{
	T=TrioList->getElement(i);
	trioP=new intList();
	trioG=new intList();
	if (T->getFatherGenotype()==genotypeSample->end()) cout <<"fathernul\n";
	trioG->insertElement(genotypeSample->getPosition(T->getFatherGenotype()));
	trioG->insertElement(genotypeSample->getPosition(T->getMotherGenotype()));
	trioG->insertElement(genotypeSample->getPosition(T->getChildGenotype()));
	trioG->sort(false);
	trioP->insertElement(phenotypeSample->getPosition(T->getFatherPhenotype()));
	trioP->insertElement(phenotypeSample->getPosition(T->getMotherPhenotype()));
	trioP->insertElement(phenotypeSample->getPosition(T->getChildPhenotype()));
	trioP->sort(false);
	for (int c=0; c<3; c++)
	{
		genotypeSample->removeNode(trioG->getElement(c));
		phenotypeSample->removeNode(trioP->getElement(c));
	}
		TrioList->removeNode(i);
	delete(trioG);
	delete trioP;
	}
	if (currentIc!=nobody)
	setMarked(currentIc);
	}



	/*____________________________________________________________ */

	bool TrioSample::groupedFamilies ()
	{
		try
		{
			stringList *pedigrees=NULL;
			if ( phenotypeSample!=NULL )
				for ( PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst(); IndPhenotype!=phenotypeSample->end(); IndPhenotype++ )
				{
					if ( phenotypeSample->getPosition ( IndPhenotype ) %3==0 )
					{
						if ( pedigrees!=NULL )
						{
							if ( pedigrees->size() !=3 ) throw BadFormat ( "	bool TrioSample::groupedFamilies ()" );

							/*
							cout << "accesing first element as a vector:\n";
							cout <<  (*pedigrees)[0] <<"\n";

							cout << "accesing first element:\n";
							cout <<  pedigrees->getElement ( 0 ) <<"\n";
							*/
							if ( pedigrees->getElement ( 0 ) !=pedigrees->getElement ( 1 ) || pedigrees->getElement ( 0 ) !=pedigrees->getElement ( 2 ) || pedigrees->getElement ( 2 ) !=pedigrees->getElement ( 1 ) )
							{
								zap ( pedigrees );
								return false;
							}
						}
						zap ( pedigrees );
						pedigrees=new stringList();
					}
					pedigrees->insertElement ( phenotypeSample->getElement ( IndPhenotype )->getPedigree() );
				}
			zap ( pedigrees );
			return true;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::CreateTrioList()" );
			throw;
		};
	}

	/*____________________________________________________________ */

	void TrioSample::setAffectationRandomly ()
	{
		GenomaSample::setAffectationRandomly();
	}


	/*____________________________________________________________ */

	TrioSample* TrioSample::permute ()
	{
		TrioSample* trioSample=this->clone();
		if ( trioSample->TrioList==NULL || trioSample->genotypeSample==NULL  || ( trioSample->genotypeSample->AlleleOrderMode!=LeftRight && trioSample->genotypeSample->AlleleOrderMode!=LeftRightUsingTrios ) ) return trioSample;
		Container<vector<Trio*>, Trio*>::iterator TrioPos=trioSample->TrioList->getFirst();
		Genoma*childG, *G;
		SNPPos TotalSNPs=trioSample->genotypeSample->GetTotalSNPs();
		int recomb;
		while ( TrioPos!=trioSample->TrioList->end() )
		{
			for ( unsigned short int i=0;i<2;i++ ) // only for parents
			{
				recomb=ranbinom ( 1, 0.5 );
				if ( recomb )
				{
					childG=new Genoma ( trioSample->TrioList->getElement ( TrioPos ), offspring );
					G=new Genoma ( trioSample->TrioList->getElement ( TrioPos ), ( IndCategory ) i );
					for ( SNPPos SNP=0; SNP<TotalSNPs;SNP++ )
					{
						if ( G->CanBeInferred ( SNP, NotChanged ) ) // if not missing and at least one person is homozygotic
							if ( G->getGenotype()->isHeterozygous ( SNP ) )
							{
								/*
								if (i==1)
								{
								cout <<"\bfefore SNP:"  << SNP << "\n:";
								cout << *childG->getDiplotype(SNP) << " and father: " << *childG->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP)
								<< " and mother: " << *childG->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP);

								cout <<"\n";
								}
								*/
								childG->changeTransmittedAlleles ( SNP, !i );
								/*
								if (i==1)
								{
								cout <<"\nafter\n:";
								cout << *childG->getDiplotype(SNP) << " and father: " << *childG->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP)
								<< " and mother: " << *childG->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP);
								cout <<"\n";
								exit(0);
								}
								*/
							}

					}
					zap ( childG );
					zap ( G );
				}
			}
			TrioPos=trioSample->TrioList->getNext ( TrioPos );
		}
		return trioSample;
	}
	/*____________________________________________________________ */

	void TrioSample::CheckParentsHWE ()
	{
		SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
		double observed[2], expected[2];
		if ( parentsNotInHWE==NULL ) parentsNotInHWE=Initialize ( TotalSNPs, 0 );
		for ( SNPPos SNP=0;SNP<TotalSNPs;SNP++ )
		{
			observed[0]=GetTotalAllele ( SNP, ( allele ) 1, father );
			observed[1]=GetTotalAllele ( SNP, ( allele ) 1, mother );
			expected[0]= ( observed[0]+observed[1] ) / ( double ) 2;
			expected[1]= ( observed[0]+observed[1] ) / ( double ) 2;
			if ( chiTest ( observed, expected, 1 ) <0.05 ) parentsNotInHWE[SNP]=1;
		}
	}
	/*____________________________________________________________ */

	void TrioSample::CheckChildrenHWE ()
	{
		SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
		if ( childrenNotInHWE==NULL ) childrenNotInHWE=Initialize ( TotalSNPs, 0 );
		for ( SNPPos SNP=0;SNP<TotalSNPs;SNP++ )
			if ( parentsNotInHWE==NULL || parentsNotInHWE[SNP]==0 )
			{
				if ( getChildrenHWETest ( SNP ) <0.05 ) childrenNotInHWE[SNP]=1;
			}
			else childrenNotInHWE[SNP]=2;
	}

	/*____________________________________________________________ */

	double TrioSample::getChildrenHWETest ( SNPPos SNP )
	{
		SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
		double observed[3], expected[3], allele[2];
		double allele1, allele2, total1, total2;
		observed[0]=GetTotalHomozygous1 ( SNP, offspring );
		observed[1]=GetTotalHomozygous2 ( SNP, offspring );
		observed[2]=GetTotalHeterozygous ( SNP, offspring );
		total1=observed[0]+observed[1]+observed[2];
//if (total1==0) throw NanValue("TrioSample::getChildrenHWETest");
		allele[0]=GetTotalAllele ( SNP, genotypeSample->allAlleles[SNP][0], parent );
		allele[1]=GetTotalAllele ( SNP, genotypeSample->allAlleles[SNP][1], parent );
		total2=allele[0]+allele[1];
		expected[0]=total1*std::pow ( allele[0]/total2,2 );
		expected[1]=total1*std::pow ( allele[1]/total2,2 );
		expected[2]=total1* ( allele[0]/total2 ) * ( allele[1]/total2 ) *2;
		if ( expected[0]==0 || expected[1]==0 || expected[2]==0 )
			throw NanValue ( " TrioSample2::getChildrenHWETest" );
		return chiTest ( observed, expected, 2 );
	}
	/*____________________________________________________________ */

	void TrioSample::missData ( int missingPercentage )
	{
		Trio *T;
		Genotype* gF, *gM, *gC;
		Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
		while ( TrioPos!=TrioList->end() )
		{
			T=TrioList->getElement ( TrioPos );
			gF=T->genotypeSample->getElement ( T->getFatherGenotype() );
			gM=T->genotypeSample->getElement ( T->getMotherGenotype() );
			gC=T->genotypeSample->getElement ( T->getChildGenotype() );
			gF->missData ( missingPercentage );
			gM->missData ( missingPercentage );
			gC->missData ( 100 );
			TrioPos=TrioList->getNext ( TrioPos );
		}
	}

	/*____________________________________________________________ */

	int TrioSample::getNonHeteroParents ( SNPPos SNP )
	{
		int nonHeteroParents=0;
		Trio *T;
		Genotype* gF, *gM, *gC;
		Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
		while ( TrioPos!=TrioList->end() )
		{
			T=TrioList->getElement ( TrioPos );
			gF=T->genotypeSample->getElement ( T->getFatherGenotype() );
			gM=T->genotypeSample->getElement ( T->getMotherGenotype() );
			gC=T->genotypeSample->getElement ( T->getChildGenotype() );
			if ( Diplotype::isANonMissingSNP ( gF->DiplotypeArray[0][SNP], gF->DiplotypeArray[1][SNP] ) &&
			        Diplotype::isANonMissingSNP ( gM->DiplotypeArray[0][SNP], gM->DiplotypeArray[1][SNP] ) &&
			        Diplotype::isANonMissingSNP ( gC->DiplotypeArray[0][SNP], gC->DiplotypeArray[1][SNP] ) )
			{
				if ( !Diplotype::isHeterozygous ( gF->DiplotypeArray[0][SNP], gF->DiplotypeArray[1][SNP] ) )
					nonHeteroParents++;
				if ( !Diplotype::isHeterozygous ( gM->DiplotypeArray[0][SNP], gM->DiplotypeArray[1][SNP] ) ) nonHeteroParents++;
			}
			TrioPos=TrioList->getNext ( TrioPos );
		}
		return nonHeteroParents;
	}
	/*____________________________________________________________ */

	void TrioSample::addParent ( PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype, PhenotypeSample::iterator partnerPhenotypeIt, GenotypeSample::iterator partnerGenotypeIt )
	{
// add phenotype
		try
		{
			Phenotype* childPhenotype=phenotypeSample->getElement ( IndPhenotype );
			Phenotype *partnerPhenotype=*partnerPhenotypeIt;
			Phenotype *newPhenotype=new Phenotype ( *partnerPhenotype );
			if ( !partnerPhenotype->isAFounder ( phenotypeSample ) ) 
{
cout <<"child " << *childPhenotype << " has only one parent with phenotype " << *partnerPhenotype << " but it seems it is not a founder and it should be\n";
throw BadFormat ( "void TrioSample::addParent (PhenotypeSample::iterator IndPhenotypeIt, PhenotypeSample::iterator partnerPhenotypeIt)" );
}
			newPhenotype->setAffectation ( unknownAff ); // unknown
			if ( partnerPhenotype->isAMother ( phenotypeSample ) )
			{
				if ( childPhenotype->getCode() !=childPhenotype->getMother()+string("-1") )
					newPhenotype->setCode ( childPhenotype->getMother()+string("-1") );
				else newPhenotype->setCode ( childPhenotype->getMother()+string("+1") );
				newPhenotype->setGender ( male );
				childPhenotype->setFather ( newPhenotype->getCode() );
			}
			else
			{
				if ( childPhenotype->getCode() !=childPhenotype->getFather() +string("+1") )
					newPhenotype->setCode ( childPhenotype->getFather()+string("+1" ));
				else   newPhenotype->setCode ( childPhenotype->getFather()+string("-1") );
				newPhenotype->setGender ( female );
				childPhenotype->setMother ( newPhenotype->getCode() );
			}
			newPhenotype->setCode2 ( newPhenotype->getCode() );
			phenotypeSample->insertElement ( newPhenotype );
// add genotype
			Genotype* newGenotype=new Genotype ( genotypeSample->GetTotalSNPs() );
			genotypeSample->insertElement ( newGenotype );
//cout << "phenotype " << *newPhenotype << " has been added in order to complete family with child and partner respectively:\n";
//cout << **IndPhenotype << " and " << **partnerPhenotypeIt << "\n";

		}
		catch ( BasicException& be )
		{
			be.addMessage ( string ( "\ncalled from void TrioSample::addParent ( PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype, PhenotypeSample::iterator partnerPhenotypeIt, GenotypeSample::iterator partnerGenotypeIt )" ) );
			throw;
		};
	}

	

	/*____________________________________________________________ */

	Trio* TrioSample::getTrioMembers ( PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype )
	{
// it returns the whole trio given a phenotype and a genotype
		try
		{
			Trio *T=new Trio ( phenotypeSample, genotypeSample );
			PhenotypeSample::iterator fatherIt, motherIt, childIt, partnerIt;
			GenotypeSample::iterator fatherG, motherG;
// bool fatherExists, motherExists, childExists;
			// cout << "reading in gettriomembers phenotype "<< *phenotypeSample->getElement ( IndPhenotype ) <<"\n";
			if ( phenotypeSample->getElement ( IndPhenotype )->isAChild() )
			{
				T->trioPhenotype->SetChildPhenotype ( IndPhenotype );
				T->trioGenotype->SetChildGenotype ( IndGenotype );
				fatherIt=phenotypeSample->GetFather ( IndPhenotype );
				motherIt=phenotypeSample->GetMother ( IndPhenotype );
				//			if ( fatherIt==phenotypeSample->end() || motherIt==phenotypeSample->end() )
//					throw BadFormat ( "Trio* GenomaSample::GetTrioMembers (PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype)" );
//cout << "GGRcomplete" << completeFamily << "\n";

				if ( fatherIt==phenotypeSample->end() && motherIt==phenotypeSample->end() )
				{
					return NULL;
					//cout << " no parents for child " << *phenotypeSample->getElement(IndPhenotype) <<"\n";
					//throw BadFormat("Trio* TrioSample::getTrioMembers ( PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype )");
				}

				if ( completeFamily &&  fatherIt==phenotypeSample->end() && motherIt!=phenotypeSample->end() )
				{

					addParent ( IndPhenotype, IndGenotype, motherIt, genotypeSample->getNode ( phenotypeSample->getPosition ( motherIt ) ) );
					//   cout << "fatheradded\n";
				}
				if ( completeFamily && motherIt==phenotypeSample->end() && fatherIt!=phenotypeSample->end() )
				{
					addParent ( IndPhenotype, IndGenotype, fatherIt, genotypeSample->getNode ( phenotypeSample->getPosition ( fatherIt ) ) );
					//  cout << "mother added\n";
				}
				T->trioPhenotype->SetFatherPhenotype ( phenotypeSample->GetFather ( IndPhenotype ) );
				T->trioGenotype->SetFatherGenotype ( genotypeSample->getNode ( phenotypeSample->getPosition ( fatherIt ) ) );
				T->trioPhenotype->SetMotherPhenotype ( phenotypeSample->GetMother ( IndPhenotype ) );
				T->trioGenotype->SetMotherGenotype ( genotypeSample->getNode ( phenotypeSample->getPosition ( motherIt ) ) );
				// cout << "trio phen:" << *T->trioPhenotype <<"\n";

			}
			else // not a child
			{

				//	cout << "no\n";
				childIt=phenotypeSample->getFirstChild ( IndPhenotype );
				if ( childIt==phenotypeSample->end() )
					if ( !completeFamily )
					{
						cout << "family with code " << phenotypeSample->getElement ( IndPhenotype )->getPedigree() << " does not have a child\n";
						throw BadFormat ( "Trio* TrioSample::getTrioMembers (PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype)-B" );
					} // parent without children
					else
					{
						// cout << "phenotype "<< *phenotypeSample->getElement ( IndPhenotype ) << "was removed\n";
						zap(T);
return NULL;
					}
				T->trioPhenotype->SetChildPhenotype ( childIt );
				//		cout << "pos is:" <<  phenotypeSample->getPosition ( IndPhenotype ) << "\n";
				T->trioGenotype->SetChildGenotype ( genotypeSample->getNode ( phenotypeSample->getPosition ( childIt ) ) );
				partnerIt=phenotypeSample->GetPartner ( IndPhenotype );
				//			cout << "noa\n";
				if ( completeFamily &&  partnerIt==phenotypeSample->end() && childIt!=phenotypeSample->end() ) addParent ( childIt, genotypeSample->getNode ( phenotypeSample->getPosition ( childIt ) ), IndPhenotype, IndGenotype );
				//		cout << "nob\n";
				if ( phenotypeSample->getElement ( IndPhenotype )->isAFather ( phenotypeSample ) )
				{
					T->trioPhenotype->SetFatherPhenotype ( IndPhenotype );
					T->trioGenotype->SetFatherGenotype ( IndGenotype );
					T->trioPhenotype->SetMotherPhenotype ( partnerIt );
					T->trioGenotype->SetMotherGenotype ( genotypeSample->getNode ( phenotypeSample->getPosition ( partnerIt ) ) );
				}
//cout << "tt\n";
				if ( phenotypeSample->getElement ( IndPhenotype )->isAMother ( phenotypeSample ) )
				{
					T->trioPhenotype->SetMotherPhenotype ( IndPhenotype );
					T->trioGenotype->SetMotherGenotype ( IndGenotype );
					T->trioPhenotype->SetFatherPhenotype ( partnerIt );
					T->trioGenotype->SetFatherGenotype ( genotypeSample->getNode ( phenotypeSample->getPosition ( partnerIt ) ) );
				}
			}
			return T;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from Trio* GenomaSample::GetTrioMembers (PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype)" );
			throw;
		};
	}

	/*____________________________________________________________ */
	/*
	bool TrioSample::hasCompleteFamily ( PhenotypeSample::iterator IndPhenotype )
	{
	    try
	    {
	        Trio *trio=getTrioMembers ( IndPhenotype, genotypeSample->getNode ( phenotypeSample->getPosition ( IndPhenotype ) ) );
	        if ( trio==NULL )
	        {
	            zap ( trio );
	            return false;
	        }
	        else
	        {
	            zap ( trio );
	            return true;
	        }
	    }
	    catch ( BasicException& be ) {
	        be.addMessage ( "\ncalled from Trio* GenomaSample::GetTrioMembers (PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype)" );
	        throw;
	    };
	}


	/*____________________________________________________________ */

	void TrioSample::solveMendelianInconsistenciesUsingChildren ()
	{
		try
		{
			Trio *T;
			SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
			for ( SNPPos SNP=0;SNP<TotalSNPs;SNP++ )
			{
				Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
				while ( TrioPos!=TrioList->end() )
				{
					T=TrioList->getElement ( TrioPos );
					T->trioGenotype->solveMIUsingChild ( SNP );
					TrioPos=TrioList->getNext ( TrioPos );
				}
			}
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from void TrioSample::solveMendelianInconsistenciesUsingChildren ()" );
			throw;
		};
	}
	/*____________________________________________________________ */

	void TrioSample::removeMendelianInconsistencies ()
	{
		Trio *T;
		SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
		for ( SNPPos SNP=0;SNP<TotalSNPs;SNP++ )
		{
			for ( Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst(); TrioPos!=TrioList->end(); TrioPos++ )
			{
				T=TrioList->getElement ( TrioPos );
//cout << "found inconsitencies\n";


				

					T->trioGenotype->removeMI ( SNP );

				//if ( T->trioGenotype->getInconsistencies ( SNP ) >0 ) throw BadFormat("void TrioSample::removeMendelianInconsistencies ()");
			}
		}
}

	/*____________________________________________________________ */

	int TrioSample::getInconsistenciesFromParents ( SNPPos SNP, IndCategory ic )
	{
		try
		{
			if ( ic!=mother && ic!=father && ic!=parent ) throw BadFormat ( "int TrioSample::getInconsistenciesFromParents ( SNPPos SNP, IndCategory ic )" );
			Trio *T;
			int totalInconsistencies=0, current;
			for ( Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst(); TrioPos!=TrioList->end(); TrioPos++ )
			{
				T=TrioList->getElement ( TrioPos );
				current=T->trioGenotype->isMendelianError ( SNP );
				if ( ! solveMIUsingChildren )
						if ( current==1 )
						{
							cout << current << " inconsistencies at SNP " << SNP << " were found for family:\n ";


							cout << "child " << * ( ( Phenotype* ) *T->getChildPhenotype() ) <<  ", genotype: " << ( ( Genotype* ) *T->getChildGenotype() )->getLeftAllele ( SNP ) << ( ( Genotype* ) *T->getChildGenotype() )->getRightAllele ( SNP ) << " ";
							cout << "mother " << * ( ( Phenotype* ) *T->getMotherPhenotype() ) << ", genotype: " << ( ( Genotype* ) *T->getMotherGenotype() )->getLeftAllele ( SNP ) << ( ( Genotype* ) *T->getMotherGenotype() )->getRightAllele ( SNP ) << " ";
							cout << "father " << * ( ( Phenotype* ) *T->getFatherPhenotype() ) << ", genotype: " << ( ( Genotype* ) *T->getFatherGenotype() )->getLeftAllele ( SNP ) << ( ( Genotype* ) *T->getFatherGenotype() )->getRightAllele ( SNP ) << " ";
							throw Inconsistent ( "TrioSample::getInconsistenciesFromParents ( SNPPos SNP, IndCategory ic )" );
						}


				totalInconsistencies=totalInconsistencies+current;
			}
			return totalInconsistencies;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from TrioSample::OrderLeftRight()" );
			throw;
		}
	}

	/*____________________________________________________________ */

	void TrioSample::CheckInconsistenciesFromParents ()
	{
		try
		{
//cout << "Checking inconsistencies from parents...\n";
			SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
			inconsistencies=Initialize ( TotalSNPs, 0 );
			fatherInconsistencies=Initialize ( TotalSNPs, 0 );
			motherInconsistencies=Initialize ( TotalSNPs, 0 );
			nonHeteroParents=Initialize ( TotalSNPs, 0 );
			int totalFatherInc=0, totalMotherInc=0;
			for ( SNPPos SNP=0;SNP<TotalSNPs;SNP++ )
			{
				inconsistencies[SNP]=getInconsistenciesFromParents ( SNP );
				fatherInconsistencies[SNP]=getInconsistenciesFromParents ( SNP, father );
				motherInconsistencies[SNP]=getInconsistenciesFromParents ( SNP, mother );
				totalFatherInc=totalFatherInc+fatherInconsistencies[SNP];
				totalMotherInc=totalMotherInc+motherInconsistencies[SNP];
//   cout << "total inconsistencies for snp " << SNP << ": " << inconsistencies[SNP] << ", from father: " << fatherInconsistencies[SNP]  <<  ", from mother " << motherInconsistencies[SNP] << "\n";
				nonHeteroParents[SNP]=getNonHeteroParents ( SNP );
			}
			//cout << "total Mendelian inconsistencies father-offspring: " << totalFatherInc <<  "\n";
			//cout << "total Mendelian inconsistencies mother-offspring: " << totalMotherInc <<  "\n";
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from void TrioSample::CheckInconsistenciesFromParents ()" );
			throw;
		};
	}

	/*____________________________________________________________ */

	void TrioSample::checkInconsistentPhenotypes ()
	{
		try
		{

			Trio* trio;
			TrioPhenotype* trioPhenotype;
			for ( Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst(); TrioPos!=TrioList->end(); TrioPos++ )
			{
				trio=TrioList->getElement ( TrioPos );
				trioPhenotype=trio->trioPhenotype;
//cout << *trioPhenotype <<"\n";
				if ( trioPhenotype->checkPhenotypes() ==false )
				{
					cout << "phenotypes are inconsistent for family trio:\n";
					cout << *trioPhenotype <<"\n";
					throw BadFormat ( "void TrioSample::checkInconsistPhenotypes ()" );
				}
			}
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from void TrioSample::CheckInconsistenciesFromParents ()" );
			throw;
		};
	}
	/*____________________________________________________________ */
	/*
		void TrioSample::completeMissingOld ()
		{
	//cout << "\nCompleting missing...";
			SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();

			Trio *T;
	//allele MinorAllele;
			Diplotype* D, *relative1D, *relative2D;
			Genoma* G;
			PairGenotype* PG;
			for ( Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();TrioPos!=TrioList->end(); TrioPos++ )
			{
				T=TrioList->getElement ( TrioPos );
				for ( int i=0; i<3; i++ )
				{
					G=new Genoma ( TrioList->getElement ( TrioPos ), ( IndCategory ) i );
					PG=G->getPairGenotype();
					for ( SNPPos SNP=0;SNP<TotalSNPs;SNP++ )
					{

						if ( !Diplotype::isANonMissingSNP ( G->getGenotype()->DiplotypeArray[0][SNP], G->getGenotype()->DiplotypeArray[1][SNP] ) )
						{

							if ( 1==0 )
								if ( SNP==7695 )
								{
									cout << "total inconsistencies: " << inconsistencies[7695] << "\n";
									cout << "before completing:\nchild " << * ( ( Phenotype* ) *T->getChildPhenotype() ) <<  ", genotype: " << ( ( Genotype* ) *T->getChildGenotype() )->getLeftAllele ( 7695 ) << ( ( Genotype* ) *T->getChildGenotype() )->getRightAllele ( 7695 ) << " ";
									cout << "mother " << * ( ( Phenotype* ) *T->getMotherPhenotype() ) << ", genotype: " << ( ( Genotype* ) *T->getMotherGenotype() )->getLeftAllele ( 7695 ) << ( ( Genotype* ) *T->getMotherGenotype() )->getRightAllele ( 7695 ) << " ";
									cout << "father " << * ( ( Phenotype* ) *T->getFatherPhenotype() ) << ", genotype: " << ( ( Genotype* ) *T->getFatherGenotype() )->getLeftAllele ( 7695 ) << ( ( Genotype* ) *T->getFatherGenotype() )->getRightAllele ( 7695 ) << " ";
								}



							if ( 1==0 )
								if ( SNP==7695 ) cout << "\nmissing for member " << i << "\n";
							if ( Diplotype::isANonMissingSNP ( PG->getFirstGenotype()->DiplotypeArray[0][SNP], PG->getFirstGenotype()->DiplotypeArray[1][SNP] ) && Diplotype::isANonMissingSNP ( PG->getSecondGenotype()->DiplotypeArray[0][SNP], PG->getSecondGenotype()->DiplotypeArray[1][SNP] ) )
							{
								if ( 1==0 )		if ( SNP==7695 ) cout << "\nthe other members have the data\n";
								if ( PG->IsHomozygous1Homozygous1 ( SNP, genotypeSample->allAlleles ) )
								{
									if ( 1==0 ) if ( SNP==7695 ) cout << "\nboth fam members are homo1\n";
									if ( i==2 ) // offspring
										G->getGenotype()->SetAlleles ( genotypeSample->allAlleles[SNP][0], genotypeSample->allAlleles[SNP][0], SNP );
									else G->getGenotype()->setLeftAllele ( SNP, genotypeSample->allAlleles[SNP][0] );
								}
								if ( PG->IsHomozygous2Homozygous2 ( SNP, genotypeSample->allAlleles ) )
								{
									if ( SNP==7695 ) cout << "\nboth fam members are homo2\n";
									if ( i==2 ) // offspring
										G->getGenotype()->SetAlleles ( genotypeSample->allAlleles[SNP][1], genotypeSample->allAlleles[SNP][1], SNP );
									else G->getGenotype()->setLeftAllele ( SNP, genotypeSample->allAlleles[SNP][1] );
								}
								if ( PG->IsHomozygous1Homozygous2 ( SNP, genotypeSample->allAlleles ) )
								{
									if ( SNP==7695 ) cout << "\none member is homo1 and the other is homo2\n";

									if ( i==2 ) // offspring
										G->getGenotype()->SetAlleles ( genotypeSample->allAlleles[SNP][0], genotypeSample->allAlleles[SNP][1], SNP );

								}


								if ( PG->IsHomozygousHeterozygous ( SNP, genotypeSample->allAlleles ) )
								{
									if ( 1==0 )						if ( SNP==7695 ) cout << "\none member is homo1 and the other is homo2\n";
									switch ( i )
									{
										case 2: // offspring
											if ( PG->getFirstGenotype()->isHomozygous ( SNP ) )
												G->getGenotype()->setLeftAllele ( SNP, PG->getFirstGenotype()->getLeftAllele ( SNP ) );
											else  G->getGenotype()->setRightAllele ( SNP, PG->getSecondGenotype()->getLeftAllele ( SNP ) );
											break;
										case 0: // father or mother
										case 1:
											if ( PG->getFirstGenotype()->isHomozygous ( SNP ) ) // child homo
												G->getGenotype()->setLeftAllele ( SNP, PG->getFirstGenotype()->getLeftAllele ( SNP ) );
											else  //mother homo
												if ( PG->getSecondGenotype()->isHomozygous1 ( SNP, genotypeSample->allAlleles[SNP][0] ) ) // mother Homo1
													G->getGenotype()->setLeftAllele ( SNP, genotypeSample->allAlleles[SNP][1] );
												else // mother Homo2
													G->getGenotype()->setLeftAllele ( SNP, genotypeSample->allAlleles[SNP][0] );
											break;
									}
								}
							}
							if ( 1==0 ) if ( SNP==7695 )
								{
									cout << "after completing:\nchild genotype: " << ( ( Genotype* ) *T->getChildGenotype() )->getLeftAllele ( 7695 ) << ( ( Genotype* ) *T->getChildGenotype() )->getRightAllele ( 7695 ) << " ";
									cout << "mother genotype: " << ( ( Genotype* ) *T->getMotherGenotype() )->getLeftAllele ( 7695 ) << ( ( Genotype* ) *T->getMotherGenotype() )->getRightAllele ( 7695 ) << " ";
									cout << "father genotype: " << ( ( Genotype* ) *T->getFatherGenotype() )->getLeftAllele ( 7695 ) << ( ( Genotype* ) *T->getFatherGenotype() )->getRightAllele ( 7695 ) << " ";
								}

						} // end for each missing SNP



					}
					zap ( G );
				}
			} // end for each trio
	//cout <<"\nMissing data have been completed from parents\n";
		}

		/*____________________________________________________________ */

	void TrioSample::completeMissing ()
	{
		try
		{
			Trio *T;
			SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
			for ( SNPPos SNP=0;SNP<TotalSNPs;SNP++ )
			{
				for ( Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->begin(); TrioPos!=TrioList->end(); TrioPos++ )
				{
					T=TrioList->getElement ( TrioPos );
					if ( T->trioGenotype->isMissing ( SNP ) )
						T->trioGenotype->completeMissing ( SNP );
				}
			}
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from void TrioSample::completeMissing ()" );
			throw;
		};
	}

	/*__________________________________________________________*/

	SNPPos TrioSample::getTotalType ( SNPPos SNP, IndCategory ic, int genotypeValue, int gender, int affectation )
	{
		bool Marked[phenotypeSample->size() ];
		setMarked ( ic, gender, affectation );
		return genotypeSample->getTotalType ( SNP, genotypeValue, Marked );
	}
	/*___________________________________________________________*/

	SNPPos TrioSample::GetTotalHomozygous1 ( SNPPos SNP, IndCategory ic, int gender, int affectation )
	{
		allele allele1=getMajorAllele ( SNP, ic, gender, affectation );
		return getTotalType ( SNP, ic, getPosGenotype ( ( int ) allele1, ( int ) allele1, genotypeSample->totalAlleles[SNP] ), gender, affectation );
	}
	/*___________________________________________________________*/

	SNPPos TrioSample::GetTotalHomozygous2 ( SNPPos SNP, IndCategory ic, int gender, int affectation )
	{
		allele allele1=getMinorAllele ( SNP, ic, gender, affectation );

		return getTotalType ( SNP, ic, getPosGenotype ( ( int ) allele1, ( int ) allele1, genotypeSample->totalAlleles[SNP] ), gender, affectation );
	}
	/*___________________________________________________________*/

	SNPPos TrioSample::GetTotalHeterozygous ( SNPPos SNP, IndCategory ic, int gender, int affectation )
	{
		allele allele1=getMajorAllele ( SNP, ic, gender, affectation );
		allele allele2=getMinorAllele ( SNP, ic, gender, affectation );
		return getTotalType ( SNP, ic, getPosGenotype ( ( int ) allele1, ( int ) allele2, genotypeSample->totalAlleles[SNP] ), gender, affectation );
	}
	/*___________________________________________________________*/
	/*
	SNPPos TrioSample::GetTotalMissing (SNPPos SNP, IndCategory ic, int gender, int affectation)
	{
		return GetTotalType (SNP, ic, missing, gender, affectation);
	}
	/*___________________________________________________________*/
	/*
	SNPPos TrioSample::GetTotalNonMissing (SNPPos SNP, IndCategory ic, int gender, int affectation)
	{
		return GetTotalHomozygous1 (SNP, ic, gender, affectation)+GetTotalHomozygous2(SNP, ic)+GetTotalHeterozygous(SNP, ic, gender, affectation);
	}
	/*__________________________________________________________*/

	SNPPos TrioSample::GetTotalAllele ( SNPPos SNP, allele allele1, IndCategory ic, int gender, int affectation )
	{
//bool Marked[phenotypeSample->size()];
		setMarked ( ic, gender, affectation );
//for (int i=0;i<GetTotalSNPs();i++)
//cout <<"\n" << Marked[i];
//cout <<"total al:" << genotypeSample->GetTotalAllele(SNP, false, Marked);
//end();
		return genotypeSample->GetTotalAllele ( SNP, allele1, Marked );
	}
	/*__________________________________________________________*/

	SNPPos TrioSample::getTotalTrios ()
	{
		return TrioList->size();
	}

	/*__________________________________________________________*/

	SNPPos TrioSample::size ()
	{
		return getTotalTrios();
	}


	/*____________________________________________________________ */
	/*
	SNPPos TrioSample::GetDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic=everybody, int gender, int affectation)
	{
	//bool Marked[phenotypeSample->size()];
	setMarked(ic, gender, affectation);
	return genotypeSample->getDoubleHeterozygous(FirstSNP, LastSNP, i, j, Marked);
	}
	/*____________________________________________________________ */
	/*
	SNPPos TrioSample::GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, bool IsPartiallySolved, int gender, int affectation)
	{
	setMarked(ic, gender, affectation);
	IndPos TotalInds=0;
	TotalInds=genotypeSample->GetUnsolvedDoubleHeterozygous(FirstSNP, LastSNP, i, j, genotypeSample->AlleleOrderMode, Marked);
	//cout <<" totalidns is\n";
	//cout  << TotalInds <<" \n" ;
	if (TotalInds>0)
	{
	Container<vector, Trio*>::iterator TrioPos=TrioList->getFirst();
	Genoma* G;
	Phenotype *phen;
	bool coupleAffectation=false;
	while (TrioPos!=TrioList->end())
	{
	for (int k=0; k<=2; k++)
	{
	if (ic==(IndCategory)k || ic==everybody || (ic==parent && k<2))
	{
	switch (k)
	{
	case 0: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype());
	if ((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype())->getAffectation()==phen->getAffectation())
	|| affectation==allAffectation) coupleAffectation=true;
	break;
	case 1: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype());
	if ((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype())->getAffectation()==phen->getAffectation())
	|| affectation==allAffectation) coupleAffectation=true;
	break;
	case 2: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getChildPhenotype());
	if (((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype())->getAffectation()==phen->getAffectation())
	&& (phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype())->getAffectation()==phen->getAffectation()))
	|| affectation==allAffectation) coupleAffectation=true;
	break;
	}
	if (phen->GetPhenotype().Gender==gender || gender==everyGender)
	if (phen->getAffectation()==affectation || affectation==allAffectation)
	{
		G=new Genoma(TrioList->getElement(TrioPos), (IndCategory)k);
	        if (G->getGenotype()->IsHeterozygousHeterozygous (FirstSNP, LastSNP, i, j, genotypeSample->allAlleles[FirstSNP], genotypeSample->allAlleles[LastSNP], genotypeSample->totalAlleles[FirstSNP], genotypeSample->totalAlleles[LastSNP]))
		if (G->CanBeInferred(FirstSNP, LastSNP, genotypeSample->AlleleOrderMode) || (gender==everyGender && coupleAffectation && G->CanBePartiallySolved(FirstSNP, LastSNP, IsPartiallySolved)))
		TotalInds--;
		delete G;
	}
	}
	}
	TrioPos=TrioList->getNext(TrioPos);
	}
	}
	return TotalInds;
	}
	/*____________________________________________________________ */

	TrioSample* TrioSample::shuffleTransmissions ()
	{
// solve phase assigning that with maxFreq (PhaseAlg=maxFreq)
		try
		{
			TrioSample* result=new TrioSample ( *this );
			if ( result->TrioList!=NULL )
			{
				Container<vector<Trio*>, Trio*>::iterator TrioPos=result->TrioList->getFirst();
				GenotypeSample::iterator GFather, GMother, GChild, G;
				SNPPos TotalSNPs=result->genotypeSample->GetTotalSNPs();
				allele parentAllele;

				bool shuffleFather, shuffleMother;
				while ( TrioPos!=result->TrioList->end() )
				{
					shuffleFather= ( bool ) ranbinom ( 1, 0.5 );
					shuffleMother= ( bool ) ranbinom ( 1, 0.5 );
					GFather=result->TrioList->getElement ( TrioPos )->getFatherGenotype();
					GMother=result->TrioList->getElement ( TrioPos )->getMotherGenotype();
					GChild=result->TrioList->getElement ( TrioPos )->getChildGenotype();
					for ( unsigned short int i=0;i<3;i++ )
					{
						switch ( i )
						{
							case 0:
								G=GFather;
								break;
							case 1:
								G=GMother;
								break;
							case 2:
								G=GChild;
								break;
						}
						for ( SNPPos SNP=0; SNP<TotalSNPs;SNP++ )
						{
							if ( ( i==0 && shuffleFather ) || ( i==1 && shuffleMother ) )
								result->genotypeSample->getElement ( G )->ChangeAlleles ( SNP );
							if ( i==2 && shuffleFather ) result->genotypeSample->getElement ( G )->DiplotypeArray[0][SNP]=result->genotypeSample->getElement ( GFather )->DiplotypeArray[0][SNP];
							if ( i==2 && shuffleMother ) result->genotypeSample->getElement ( G )->DiplotypeArray[1][SNP]=result->genotypeSample->getElement ( GMother )->DiplotypeArray[1][SNP];
						}
					}
					TrioPos=result->TrioList->getNext ( TrioPos );
				}

//   cout <<"Sorting left right has finished\n";
			}
			return result;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from TrioSample::shuffleTransmissions" );
			throw;
		};
	}


	/*____________________________________________________________ */

	TrioSample* TrioSample::solvePhase ( EMDistributions emDistributions, EMRestriction emRestriction, int windowSize )
	{
// solve phase assigning that with maxFreq (PhaseAlg=maxFreq)
		try
		{

			VectorOfParentalGenotypes*parentalGenotypes=NULL;
//cout <<"inisolvephase\n";
			SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
			bool onlyHetero=false, includeMissing=true;
//cout <<"inisolvephase2\n";
			TrioSample* result=new TrioSample ( *this );

			TrioCountersHapUAndT*TM=NULL;
			int *pos=NULL, size, trioCont=0, * motherT, *motherU, *fatherT, *fatherU;
			Genotype* G;
			SNPPos SNP=0, SNP2=0;
			ParentalHaplotypes* haplotypes;
			SlidingWindows *sw=new SlidingWindows ( windowSize, windowSize, TotalSNPs );
			int totalWindows=sw->getTotalWindows();
			TrioCounters* tc;
//cout <<"toatlwiowis:" << totalWindows <<"\n";
//cout <<"inisolvephase4\n";
//cout << "total snos:" << TotalSNPs <<"\ntotal windows: " << totalWindows <<"\n";
//cout <<"totalcompletewindows:" << sw->getTotalCompleteWindows() <<"\n";;
			for ( int i=0; i<totalWindows;i++ )
			{
				//	cout <<"\nwin: " << i+1 <<" out of " << totalWindows;
				trioCont=0;
				size=sw->getSizeOfWindow ( i );
				pos=new int[size];
//cout <<"size:" << size <<"\n";
				for ( int j=0; j<size; j++ )
				{
					pos[j]=SNP+j;
//cout <<pos[j] <<" ";
					if ( pos[j]<0 || pos[j]>=TotalSNPs ) throw OutOfBounds ( pos[j], TotalSNPs, "1. TrioSample::solvePhase" );
				}

				parentalGenotypes=result->getGenotypeCounts ( pos, size, LeftRightUsingTrios, maxFreq, emDistributions, emRestriction, includeMissing );


				tc=new TrioCounters ( NULL, 0, parentalGenotypes, allAffectation );

				TM = new TrioCountersHapUAndT ( tc, maxFreq, emDistributions, emRestriction );
				if ( TM->haplotypeCounts==NULL )
				{
					cout <<"nullhapcounts:\n";
					cout <<"tricounters:"<< *tc <<"\n";
					exit ( 0 );
				}
				if ( TM->haplotypeCounts!=NULL )
					for ( Container<vector<Trio*>, Trio*>::iterator it=result->TrioList->getFirst(); it<result->TrioList->end(); it++ )
					{
						if ( TM->haplotypeCounts->getElement ( trioCont ) !=NULL )
						{
							haplotypes=TM->haplotypeCounts->getElement ( trioCont );
							motherT=TM->haplotypeTable->getPositions ( haplotypes->motherT );
							fatherT=TM->haplotypeTable->getPositions ( haplotypes->fatherT );
							motherU=TM->haplotypeTable->getPositions ( haplotypes->motherU );
							fatherU=TM->haplotypeTable->getPositions ( haplotypes->fatherU );
							for ( int ind=0; ind<3; ind++ ) // father, mother, offspring
							{
								SNP2=SNP;
								G=result->getGenotype ( it, ( IndCategory ) ind );
								for ( int j=0; j<size; j++ )
								{
									if ( SNP2<0 || SNP2>=TotalSNPs ) throw OutOfBounds ( SNP2, TotalSNPs, "2. TrioSample::solvePhase" );
									if ( fatherT[j]<0 || fatherT[j]>=genotypeSample->totalAlleles[SNP2] )
									{
										cout << "ind " << ** ( ( ( Trio* ) *it )->getFatherPhenotype() ) << "\n";
										cout << "ind partner" << ** ( ( ( Trio* ) *it )->getMotherPhenotype() ) << "\n";
										cout << "ind child" << ** ( ( ( Trio* ) *it )->getChildPhenotype() ) << "\n";
										cout << "fatherT at SNP " << SNP2 << " is: " << fatherT[j] << " while there are only " << genotypeSample->totalAlleles[SNP2] <<"\n";
										BIOS::print ( genotypeSample->allAlleles[SNP2], genotypeSample->totalAlleles[SNP2], cout );
										throw OutOfBounds ( fatherT[j], genotypeSample->totalAlleles[SNP2], "3. TrioSample::solvePhase" );
									}
									if ( fatherU[j]<0 || fatherU[j]>=genotypeSample->totalAlleles[SNP2] )
									{
										cout << "ind " << ** ( ( ( Trio* ) *it )->getFatherPhenotype() ) << "\n";
										cout << "ind partner" << ** ( ( ( Trio* ) *it )->getMotherPhenotype() ) << "\n";
										cout << "ind child" << ** ( ( ( Trio* ) *it )->getChildPhenotype() ) << "\n";
										cout << "fatherU at SNP " << SNP2 << " is: " << fatherU[j] << " while there are only " << genotypeSample->totalAlleles[SNP2] <<"\n";
										BIOS::print ( genotypeSample->allAlleles[SNP2], genotypeSample->totalAlleles[SNP2], cout );
										throw OutOfBounds ( fatherU[j], genotypeSample->totalAlleles[SNP2], "4. TrioSample::solvePhase" );
									}
									if ( motherT[j]<0 || motherT[j]>=genotypeSample->totalAlleles[SNP2] )
									{
										cout << "ind " << ** ( ( ( Trio* ) *it )->getMotherPhenotype() ) << "\n";
										cout << "ind partner" << ** ( ( ( Trio* ) *it )->getFatherPhenotype() ) << "\n";
										cout << "ind child" << ** ( ( ( Trio* ) *it )->getChildPhenotype() ) << "\n";
										cout << "motherT at SNP " << SNP2 << " is: " << motherT[j] << " while there are only " << genotypeSample->totalAlleles[SNP2] <<"\n";
										cout << "mother hap is: " << haplotypes->motherT;
										cout << "mother pos:";
										BIOS::print ( motherT, size, cout );
										cout << " with conflicting pos being " << j;
										cout << " and the whole tabla is:\n"  << *TM->haplotypeTable <<" and allAlleles are:\n";
										BIOS::print ( genotypeSample->allAlleles[SNP2], genotypeSample->totalAlleles[SNP2], cout );
										cout << "\nwhile all alleles in GenotypeArray are:\n";
										BIOS::print ( tc->genotypeArray->allAlleles[j], tc->genotypeArray->totalAlleles[j], cout );
										cout << "\nwhile all alleles in result are:\n";
										BIOS::print ( result->genotypeSample->allAlleles[SNP2], result->genotypeSample->totalAlleles[SNP2], cout );

										throw OutOfBounds ( motherT[j], genotypeSample->totalAlleles[SNP2], "5. TrioSample::solvePhase" );
									}
									if ( motherU[j]<0 || motherU[j]>=genotypeSample->totalAlleles[SNP2] )
									{
										cout << "ind " << ** ( ( ( Trio* ) *it )->getMotherPhenotype() ) << "\n";
										cout << "ind partner" << ** ( ( ( Trio* ) *it )->getFatherPhenotype() ) << "\n";
										cout << "ind child" << ** ( ( ( Trio* ) *it )->getChildPhenotype() ) << "\n";
										cout << "motherU at SNP " << SNP2 << " is: " << motherU[j] << " while there are only " << genotypeSample->totalAlleles[SNP2] <<"\n";
										BIOS::print ( genotypeSample->allAlleles[SNP2], genotypeSample->totalAlleles[SNP2], cout );
										throw OutOfBounds ( motherU[j], genotypeSample->totalAlleles[SNP2], "6. TrioSample::solvePhase" );
									}

									if ( genotypeSample->allAlleles[SNP2][fatherT[j]]<0 || genotypeSample->allAlleles[SNP2][fatherU[j]]<0 ) throw UnsolvedPhase ( genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][fatherU[j]], "7. TrioSample::solvePhase" );
									if ( genotypeSample->allAlleles[SNP2][motherT[j]]<0 || genotypeSample->allAlleles[SNP2][motherU[j]]<0 ) throw UnsolvedPhase ( genotypeSample->allAlleles[SNP2][motherT[j]], genotypeSample->allAlleles[SNP2][motherU[j]], "8. TrioSample::solvePhase" );
									switch ( ind )
									{
										case 0: // father
											G->SetAlleles ( genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][fatherU[j]], SNP2 );
											break;
										case 1: // mother
											G->SetAlleles ( genotypeSample->allAlleles[SNP2][motherT[j]], genotypeSample->allAlleles[SNP2][motherU[j]], SNP2 );
											break;
										case 2: // offspring
											G->SetAlleles ( genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][motherT[j]], SNP2 );
											break;
									}
									SNP2++;
								}
							}
							zaparr ( motherT );
							zaparr ( fatherT );
							zaparr ( motherU );
							zaparr ( fatherU );
						}
						trioCont++;
						if ( it== ( result->TrioList->end()-1 ) ) SNP=SNP+size;
					}
				zap ( TM );
				zap ( tc );
				zap ( parentalGenotypes );
				zaparr ( pos );
			}
			zap ( sw );
			return result;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from TrioSample::solvePhase" );
			throw;
		};
	}
	/*_______________________________________________________________*/

	stringSample* TrioSample::ExportToBeagle ( stringList* Pos )
	{
	//	removeMendelianInconsistencies();
		stringSample* l=new stringSample();
		SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
		cout <<"Exporting to Beagle\n";
// heading
		stringList* row=new stringList();
		string s;
		s=string ( "I" );
		row->insertElement ( s );
		s=string ( "id" );
		row->insertElement ( s );
		for ( int i=0; i<genotypeSample->size(); i++ )
			for ( int j=0; j<2; j++ )
			{
				s=tos ( i );
				row->insertElement ( s );
			}
		l->insertElement ( row );
// affectation row
		row=new stringList ();
		s=string ( "A" );
		row->insertElement ( s );
		s=string ( "affectation" );
		row->insertElement ( s );
		Phenotype* phen;
		Trio *t;
		for ( Container<vector<Trio*>, Trio*>::iterator it=TrioList->begin(); it!=TrioList->end(); it++ )
		{
			t=TrioList->getElement ( it );
			for ( int i=0; i<3; i++ )
			{
				phen=*t->getPhenotype ( ( IndCategory ) i );
				for ( int j=0; j<2; j++ )
				{
					s=tos ( phen->getAffectation() );
					row->insertElement ( s );
				}
			}
		}
		l->insertElement ( row );
// genotype rows
		Genotype* gen;
		for ( SNPPos i=0; i<genotypeSample->GetTotalSNPs(); i++ )
		{
			row=new stringList ();
			s=string ( "M" );
			row->insertElement ( s );
			s=Pos->getElement ( i );
			row->insertElement ( s );
			for ( Container<vector<Trio*>, Trio*>::iterator it=TrioList->begin(); it!=TrioList->end(); it++ )
			{
				t=TrioList->getElement ( it );
				for ( int j=0; j<3; j++ )
				{
					gen=*t->getGenotype ( ( IndCategory ) i );
					s=gen->printAllele ( i, true );
					row->insertElement ( s );
					s=gen->printAllele ( i, false );
					row->insertElement ( s );
				}
			}
			l->insertElement ( row );
		}
		return l;
	}
	/*____________________________________________________________ */

	Genotype* TrioSample::getGenotype ( Container<vector<Trio*>, Trio*>::iterator TrioPos, IndCategory ind )
	{
		return ( ( GenotypeSample* ) this )->getElement ( TrioList->getElement ( TrioPos )->getGenotype ( ind ) );
	}
	/*____________________________________________________________ */

	void TrioSample::importFromBeagle ( char* filename )
	{
		char* resultFile;
		resultFile=removeExtension ( filename );
		strcat ( resultFile, "Beagle.gou" );
		stringList *row=NULL;
		TextFile *tf=new TextFile ( filename );
		int col, genRowId=2;
		allele left, right;
		if ( tf->getTotalLines() !=genotypeSample->GetTotalSNPs() +2 ) throw BadFormat ( "void TrioSample::importFromBeagle ( char* filename )" );
		// reading heading
		row=tf->readLine();
		if ( row->size() !=genotypeSample->size() +2 ) throw BadFormat ( "void TrioSample::importFromBeagle ( char* filename )-2" );
		// reading affectation
		row=tf->readLine();
		row=tf->readLine();
		Trio*t;
		Genotype* gen;
		while ( !tf->eof() )
		{
			col=2;

			for ( Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();TrioPos!=TrioList->end(); TrioPos++ )
			{
				t=TrioList->getElement ( TrioPos );
				for ( int i=0; i<3; i++ )
				{
					gen=genotypeSample->getElement ( t->getGenotype ( ( IndCategory ) i ) );
					left=ConvertAllele ( row->getElement ( col ).c_str() );
					col++;
					right=ConvertAllele ( row->getElement ( col ).c_str() );
					col++;
					if ( !gen->isMissing ( genRowId ) )
						if ( gen->getLeftAllele ( genRowId ) !=left && gen->getLeftAllele ( genRowId ) !=right ) throw BadFormat ( "void TrioSample::importFromBeagle ( char* filename )" );
					if ( gen->getRightAllele ( genRowId ) !=left && gen->getRightAllele ( genRowId ) !=right ) throw BadFormat ( "void TrioSample::importFromBeagle ( char* filename )" );
					gen->SetAlleles ( left, right, genRowId );
				}
			}
			row=tf->readLine();
			genRowId++;
		}
	}
	/*____________________________________________________________ */

	longLongList* TrioSample::getGenotypeCounts ( const SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation, AmbiguousArray* tableGenotypes, bool onlyHetero, bool includeMissing )
	{
// It returns a list of the genotype codes of all the individuals in the sample who match ic, gender, affectation, onlyHetero and includeMissing
		try
		{
			long long int position;
			longLongList* result=new longLongList();
			Genotype* G;
			Phenotype *phen;
			int current=0, SNP;
			Trio* T;
			bool missing;
			for ( Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst(); TrioPos!=TrioList->end(); TrioPos++ )
			{
				T=TrioList->getElement ( TrioPos );
				for ( int i=0; i<=2; i++ ) // 0 is father, 1 is mother
				{
					if ( ic== ( IndCategory ) i || ic==everybody || ( ic==parent && i<2 ) )
					{
						phen=phenotypeSample->getElement ( T->getPhenotype ( ( IndCategory ) i ) );
						if ( phen->GetPhenotype().Gender==gender || gender==everyGender )
							if ( phen->getAffectation() ==affectation || affectation==allAffectation )
							{
								G=getGenotype ( TrioPos, ( IndCategory ) i );
								position=G->getGenotypeCounts ( pos, totalPos, genotypeSample->allAlleles, genotypeSample->totalAlleles, tableGenotypes, genotypeSample->AlleleOrderMode, onlyHetero, includeMissing );
								result->insertElement ( position );
							}
					}
				}
				current++;
			}
			return result;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from TrioSample::getGenotypeCounts" );
			throw;
		};
	}



	/*____________________________________________________________ */

	VectorOfParentalGenotypes* TrioSample::getGenotypeCounts ( const SNPPos *pos, int totalPos, AlleleOrderType alleleOrderType, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, bool includeMissing )
	{
		HapExtractionConfiguration* hapExtractionConfiguration= new HapExtractionConfiguration ( alleleOrderType, phaseAlg, emDistributions, emRestriction );
		VectorOfParentalGenotypes* result= getGenotypeCounts ( pos, totalPos, hapExtractionConfiguration, includeMissing );
		zap ( hapExtractionConfiguration );
		return result;
	}
	/*____________________________________________________________ */

	VectorOfParentalGenotypes* TrioSample::getGenotypeCounts ( const SNPPos *pos, int totalPos, HapExtractionConfiguration* hapExtractionConfiguration, bool includeMissingOrUnphased )
	{
// It returns a list of parental genotypes
		try
		{
			int permutations=0;
//BIOS::print((int*)pos, totalPos, cout);
			allele** allAlleles=new allele*[totalPos];
			int *totalAlleles=new int[totalPos], *pos2=new int[totalPos];
			for ( int i=0; i<totalPos; i++ )
			{
				totalAlleles[i]=genotypeSample->totalAlleles[pos[i]];
				allAlleles[i]=new allele[totalAlleles[i]];
				pos2[i]=i;
				for ( int j=0; j<totalAlleles[i]; j++ )
					allAlleles[i][j]=genotypeSample->allAlleles[pos[i]][j];
			}
			VectorOfParentalGenotypes* result=new VectorOfParentalGenotypes ( ( int* ) pos2, totalPos,  hapExtractionConfiguration, verbose, 0, allAlleles, totalAlleles );
			zaparr ( pos2 );
			
				for ( int i=0; i<totalPos;i++ )
				zaparr ( allAlleles[i] );
		zaparr ( totalAlleles );
		zaparr ( allAlleles );
			
			
			ParentalGenotypesUsingPointers* pg;
			Genotype* motherG, *fatherG;
			for ( Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst(); TrioPos!=TrioList->end(); TrioPos++ )
			{
				motherG=getGenotype ( TrioPos, mother )->filter ( pos,totalPos );
				fatherG=getGenotype ( TrioPos, father )->filter ( pos,totalPos );
				// cout << "mathergenotype is:" << *motherG<<"\n";
				// 	    cout << "fathergenotype is:" << *fatherG<<"\n";
				if ( includeMissingOrUnphased || ( !motherG->hasMissingSNPs() && !fatherG->hasMissingSNPs() && !motherG->hasUnphasedSNPs() && !fatherG->hasUnphasedSNPs()) )
				{
					// cout << "phen for family " << TrioList->getPosition ( TrioPos ) <<": " << **TrioList->getElement(TrioPos)->getPhenotype(mother) <<"\n";
					pg=new ParentalGenotypesUsingPointers ( fatherG, motherG, TrioList->getPosition ( TrioPos ) );

					result->insertElement ( pg );
				}
									zap(fatherG); zap(motherG);
			}
//cout <<"vecttor:" << *result << "\n";
			return result;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from TrioSample::getGenotypeCounts" );
			throw;
		};
	}



	/*____________________________________________________________ */
	/*
	int TrioSample::CountAlleles (SNPPos SNP, unsigned int Basis[5], IndCategory ic=parent, int gender, int affectation)
	{
	//bool Marked[phenotypeSample->size()];
	setMarked(ic, gender, affectation);
	return genotypeSample->CountAlleles(SNP, Basis, Marked);

	}
	*/
	/*_________________________________________________________________________*/

	stringList* TrioSample::getPedigreeID ( IndCategory ic )
	{
		stringList* result=new stringList();
		Phenotype* phen;
		Trio* T;
		for ( Container<vector<Trio*>, Trio*>::iterator it=TrioList->begin(); it!=TrioList->end(); it++ )
		{
			T=TrioList->getElement ( it );
			for ( int i=0; i<2;i++ )
				if ( ic== ( IndCategory ) i || ic==everybody || ( ic==parent && i<2 ) )
				{
					phen=phenotypeSample->getElement ( T->getPhenotype ( ( IndCategory ) i ) );
					result->insertElement ( phen->getPedigree() );
				}
		}
		return result;
	}
	/*____________________________________________________________ */

	allele TrioSample::getMajorAllele ( SNPPos SNP, IndCategory ic=parent, int gender, int affectation )
	{
//cout <<GenomaSample::getGenotypeSample->MajorAllele(SNP, ic) <<"";

		return GenomaSample::getMajorAllele ( SNP, ic, gender, affectation );
	}
	/*____________________________________________________________ */

	allele TrioSample::getMinorAllele ( SNPPos SNP, IndCategory ic=parent, int gender, int affectation )
	{
//cout <<GenomaSample::getMinorAllele(SNP, ic) <<"\n";
		return GenomaSample::getMinorAllele ( SNP, ic, gender, affectation );
	}

	/*____________________________________________________________ */
	/*
	TrioSample* TrioSample::copyElementsWithPositionsIn(intSet* positions, bool inThis)
	{
	GenomaSample* genomaResult=this->GenomaSample::copyElementsWithPositionsIn(positions, inThis);
	TrioSample* result= new  TrioSample(*genomaResult, false);
	zap(genomaResult);
	return result;
	}



	/*____________________________________________________________ */


	SampleGeneticCounts* TrioSample::getTUCounts ( int *pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, bool includeMissing )
	{
		try
		{


			VectorOfParentalGenotypes* ts=getGenotypeCounts ( pos, length, hapExtractionConfiguration, true );
//cout <<" vevtor is:" << *ts <<"\n";
			int* pos2=initializeFrom ( 0, length );
			SampleTUCounts* results= (SampleTUCounts*)ts->getSampleTUCounts ( hapExtractionConfiguration, totalPermutations, pos2, length, includeMissing );
			zaparr ( pos2 );
			zap ( ts );
//cout << "res is:" << *results << "\n";
//exit(0);
			return results;


		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from SampleTUCounts* TrioSample::getTUCounts(int *pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, bool onlyHetero, int totalPermutations)" );
			throw;
		};
	}

	/*____________________________________________________________ */


	SampleGeneticCounts* TrioSample::getTUCounts ( int *pos, int length,AlleleOrderType alleleOrderType, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, int totalPermutations, bool includeMissing )
	{
		try
		{
			HapExtractionConfiguration* hapExtractionConfiguration= new HapExtractionConfiguration ( alleleOrderType, phaseAlg, emDistributions, emRestriction );


			VectorOfParentalGenotypes* ts=getGenotypeCounts ( pos, length, hapExtractionConfiguration, true );
//cout <<" vevtor is:" << *ts <<"\n";
			int* pos2=initializeFrom ( 0, length );
			SampleTUCounts* results= (SampleTUCounts*) ts->getSampleTUCounts ( hapExtractionConfiguration, totalPermutations, pos2, length, includeMissing );
			zaparr ( pos2 );
			zap ( ts );
//cout << "res is:" << *results << "\n";
//exit(0);
			zap ( hapExtractionConfiguration );
			return results;


		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from SampleTUCounts* TrioSample::getTUCounts(int *pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, bool onlyHetero, int totalPermutations)" );
			throw;
		};
	}



	/*______________________________________________________*/

	void TrioSample::printUsingAlleleNumbers ( ostream& out )
	{
		for ( Container<vector<Trio*>, Trio*> ::iterator it=TrioList->begin(); it!=TrioList->end(); it++ )
		{
			TrioList->getElement ( it )->printUsingAlleleNumbers ( out );
		};
	}
	/*______________________________________________________*/

	void TrioSample::print ( ostream& out )
	{
		TrioList->setDelimiters ( '\0', '\0' );
		TrioList->setOutputSeparator ( '\0' );
		out << *TrioList;
	};

	/*____________________________________________________________ */


};
// End of Namespace

#endif

/* End of file: TrioSample.h */




