/* File: VectorOfParentalGenotypesUsingPointers.h */

#ifndef __VectorOfParentalGenotypes_cpp__
#define __VectorOfParentalGenotypes_cpp__

//using namespace stats;

namespace BIOS
{



	VectorOfParentalGenotypes::VectorOfParentalGenotypes ( int* absolutePositions, int length, HapExtractionConfiguration* hapExtractionConfiguration, int verbose, int totalPermutations,  allele** allAlleles, int* totalAlleles, char outputSeparator, char leftDelimiter, char rightDelimiter) :ParentalGenotypesUsingPointersList(outputSeparator, leftDelimiter, rightDelimiter), GenericSample(verbose)
	{
		try
		{
			this->hapExtractionConfiguration=hapExtractionConfiguration;
			if ( absolutePositions==NULL ) throw NullValue ( "VectorOfParentalGenotypes::VectorOfParentalGenotypes(int* absolutePositions, int length, int totalPermutations):ParentalGenotypesUsingPointersList(), GenericSample()" );
		
			this->length=length;
					
			
			this->allAlleles=NULL;
			this->totalAlleles=NULL;

			if ( allAlleles!=NULL && totalAlleles!=NULL)
			{
				this->allAlleles=new allele*[length];
				this->totalAlleles=new int[length];
				this->absolutePositions=new int[length];
				if (verbose>0)  cout <<"absolute positions-totalAlleles are:\n";
				for ( int i=0; i<length;i++ )
				{
				this->absolutePositions[i]=absolutePositions[i];
				this->allAlleles[i]=new allele[totalAlleles[absolutePositions[i]]];
				this->totalAlleles[i]=totalAlleles[absolutePositions[i]];
				if (verbose>0) cout << this->absolutePositions[i] << " - " << this->totalAlleles[i] << " with allele values:\n";
				for ( int j=0; j<totalAlleles[absolutePositions[i]];j++ )
				{
				  this->allAlleles[i][j]=allAlleles[absolutePositions[i]][j];
				  if (verbose>0) cout <<this->allAlleles[i][j];
				  if (verbose>0) if (j<totalAlleles[absolutePositions[i]]-1) cout <<","; else cout <<"\n";
				}
				}
			  }

				


			
			this->totalPermutations=totalPermutations;
			this->permutations=NULL;

		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  VectorOfParentalGenotypes::VectorOfParentalGenotypes ( int* absolutePositions, int length, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations,  allele** allAlleles, int* totalAlleles )" ); throw;};



	}


	/*______________________________________________________*/
/*

	VectorOfParentalGenotypes::VectorOfParentalGenotypes ( int* absolutePositions, int length, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations,  allele** allAlleles, int* totalAlleles ) :ParentalGenotypesUsingPointersList(), GenericSample()
	{
		try
		{
			this->hapExtractionConfiguration=hapExtractionConfiguration;
			if ( absolutePositions==NULL ) throw NullValue ( "VectorOfParentalGenotypes::VectorOfParentalGenotypes(int* absolutePositions, int length, int totalPermutations):ParentalGenotypesUsingPointersList(), GenericSample()" );
			this->length=length;
			this->absolutePositions=new int[length];
			this->allAlleles=NULL;
			this->totalAlleles=NULL;
			if ( allAlleles!=NULL )
			{
				this->allAlleles=new allele*[length];
				this->totalAlleles=new int[length];
			}
			for ( int i=0; i<length;i++ )
			{
				this->absolutePositions[i]=absolutePositions[i];
				if ( allAlleles!=NULL )
				{
					this->allAlleles[i]=new allele[totalAlleles[absolutePositions[i]]];
					this->totalAlleles[i]=totalAlleles[absolutePositions[i]];
					for ( int j=0; j<totalAlleles[absolutePositions[i]];j++ )
{
						this->allAlleles[i][j]=allAlleles[absolutePositions[i]][j];
				}

				}

				


			}
			this->totalPermutations=totalPermutations;
			this->permutations=NULL;

		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  VectorOfParentalGenotypes::VectorOfParentalGenotypes ( int* absolutePositions, int length, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations,  allele** allAlleles, int* totalAlleles )" ); throw;};



	}
	/*______________________________________________________*/

	VectorOfParentalGenotypes* VectorOfParentalGenotypes::filter ( int* selectedPositions, int newLength )
	{
		try
		{
			if ( selectedPositions==NULL ) throw NullValue ( "VectorOfParentalGenotypes::VectorOfParentalGenotypes(int* absolutePositions, int length, int totalPermutations):ParentalGenotypesUsingPointersList(), GenericSample()" );

			if (verbose>0) cout <<"allocating memory for new positions, totalAlleles and alleles arrays\n";
		/*
			int *newTotalAlleles=new int[length];
			allele** newAlleles=new allele*[length];
			
			if (verbose>0) cout <<"setting values in filtered positions, totalAlleles and alleles arrays\n";
			
			for ( int i=0; i<length;i++ )
			{
				newTotalAlleles[i]=this->totalAlleles[i];
				newAlleles[i]=new allele[totalAlleles[i]];
				for ( int j=0; j<totalAlleles[selectedPositions[i]];j++ )
					newAlleles[i][j]=this->allAlleles[i][j];

			}
			*/
			
			if (verbose>0) cout <<"Creating filtered object VectorOfParentalGenotypes\n";
			VectorOfParentalGenotypes* result=new VectorOfParentalGenotypes ( selectedPositions, newLength, hapExtractionConfiguration, verbose, totalPermutations, allAlleles, totalAlleles );
			if (verbose>0) cout <<"Deallocating memory for new positions, totalAlleles and alleles arrays\n\n";
/*
			for ( int i=0; i<newLength;i++ )
				zaparr ( newAlleles[i] );
			zaparr ( newAlleles );
			zaparr ( newTotalAlleles );
			*/
			result->totalPermutations=totalPermutations;
			result->permutations=NULL;
			ParentalGenotypesUsingPointers* element, *filteredElement;
			Genotype *filteredMother, *filteredFather;

			for ( VectorOfParentalGenotypes::iterator it=this->begin(); it<this->end(); it++ )
			{
				element=this->getElement ( it );
				if (verbose>0) cout <<"Filtering father and mother genotypes at vector position " << this->getPosition(it) <<"\n";
				filteredMother=element->mother->filter ( selectedPositions, newLength );
				filteredFather=element->father->filter ( selectedPositions, newLength );
				if (verbose>0) cout <<"Creating filtered ParentalGenotypesUsingPointers\n";
				filteredElement=new ParentalGenotypesUsingPointers ( filteredFather, filteredMother,element->trioCount, ' ', true );
				if (verbose>0) cout <<"Deallocating father and mother genotypes\n";
				zap(filteredMother);
				zap(filteredFather);
				if (verbose>0) cout <<"Adding new filtered ParentalGenotypesUsingPointers to result vector\n";
				result->insertElement ( filteredElement );
			}
			return result;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  VectorOfParentalGenotypes* VectorOfParentalGenotypes::filter ( int* selectedPositions, int newLength )" ); throw;};

	}
	/*______________________________________________________*/

	VectorOfParentalHaplotypes* VectorOfParentalGenotypes::solvePhase ( EMDistributions emDistributions, EMRestriction emRestriction )
	{
		try
		{
			int trioCont=0;
			TrioCounters *tc=new TrioCounters ( NULL, 0, this, allAffectation );
			TrioCountersHapUAndT* TM = new TrioCountersHapUAndT ( tc, maxFreq, emDistributions, emRestriction );
			if ( TM->haplotypeCounts==NULL ) throw NullValue ( "VectorOfParentalGenotypes* VectorOfParentalGenotypes::solvePhase()" );
			VectorOfParentalHaplotypes* result=TM->getVectorOfParentalHaplotypes();
			zap ( TM );
			zap ( tc );
			return result;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  VectorOfParentalHaplotypes* VectorOfParentalGenotypes::solvePhase ( EMDistributions emDistributions, EMRestriction emRestriction )" ); throw;};
	}
	/*____________________________________________________________ */

	longLongList* VectorOfParentalGenotypes::getGenotypeCounts ( SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation, GenotypeArray* tableGenotypes, bool onlyHetero, bool includeMissing )
	{
// It returns a list of the genotype codes of all the individuals in the sample who match ic, gender, affectation, onlyHetero and includeMissing
		try
		{
			if ( gender!=male && gender!=female ) throw BadFormat ( "longLongList* VectorOfParentalGenotypes::getGenotypeCounts ( const SNPPos *pos, int totalPos, int gender, int affectation, AmbiguousArray* tableGenotypes, bool onlyHetero, bool includeMissing )" );
			long long int position;
			longLongList* result=new longLongList();
			Genotype* G;
			//Phenotype *phen;
			//int current=0, SNP;
			//Trio* T;
			//bool missing;
			ParentalGenotypesUsingPointers* element;
			for ( VectorOfParentalGenotypes::iterator it=this->begin(); it<this->end(); it++ )
			{
				element=getElement ( it );
				if ( gender==male ) G=element->father; else G=element->mother;

				position=G->getGenotypeCounts ( pos, totalPos, allAlleles, totalAlleles, tableGenotypes, hapExtractionConfiguration->alleleOrderType, onlyHetero, includeMissing );
				result->insertElement ( position );
			}
			return result;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  VectorOfParentalGenotypes::getGenotypeCounts (  SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation, GenotypeArray* tableGenotypes, bool onlyHetero, bool includeMissing )" ); throw;};
	}
	/*______________________________________________________*/

	VectorOfParentalGenotypes::VectorOfParentalGenotypes ( VectorOfParentalGenotypes& other ) : ParentalGenotypesUsingPointersList ( other ), GenericSample(other.verbose)
	{
		this->length=other.length;
		this->verbose=other.verbose;
		this->absolutePositions=NULL;
//if (absolutePositions==NULL) throw NullValue("VectorOfParentalGenotypes::VectorOfParentalGenotypes(VectorOfParentalGenotypes& other): ParentalGenotypesUsingPointersList(other), GenericSample()");


		if ( other.absolutePositions!=NULL )
		{
			this->absolutePositions=new int[other.length];
			for ( int i=0; i<other.length;i++ )
				this->absolutePositions[i]=other.absolutePositions[i];
		}


		this->allAlleles=NULL;
		this->totalAlleles=NULL;
		if ( other.allAlleles!=NULL )
		{
			this->allAlleles=new allele*[other.length];
			this->totalAlleles=new int[other.length];
		}

		if ( allAlleles!=NULL )
			for ( int i=0; i<other.length;i++ )
			{
				allAlleles[i]=new allele[other.totalAlleles[i]];
				for ( int j=0; j<other.totalAlleles[i];j++ )
					this->allAlleles[i][j]=other.allAlleles[i][j];
				this->totalAlleles[i]=other.totalAlleles[i];
			}
		this->totalPermutations=0;
		this->permutations=NULL;
		this->hapExtractionConfiguration=other.hapExtractionConfiguration;
	};
	/*______________________________________________________*/

	VectorOfParentalGenotypes::~VectorOfParentalGenotypes()
	{
		zaparr ( permutations, totalPermutations );
		zaparr ( absolutePositions );

		if ( allAlleles!=NULL )
			for ( int i=0; i<length;i++ )
				zaparr ( allAlleles[i] );
		zaparr ( totalAlleles );
		zaparr ( allAlleles );



	};
	/*______________________________________________________*/

	VectorOfParentalGenotypes* VectorOfParentalGenotypes::clone()
	{
		return new VectorOfParentalGenotypes ( *this );
	};

/*______________________________________________________*/
/*
	void VectorOfParentalGenotypes::copyPaste ( GenericSample* other)
	{
throw NonImplemented("void VectorOfParentalGenotypes::copyPaste ( GenericSample* other )");
}
	/*______________________________________________________*/

	void VectorOfParentalGenotypes::copyPaste (  GenericSample* other )
	{
try
{
VectorOfParentalGenotypes* source=(VectorOfParentalGenotypes*)other;
		//VectorOfParentalGenotypes* m= other->clone();
// cout << "size of the other is:" << other->size() <<"\n";
//    cout << "size of the othernow  is:" <<m->size() <<"\n";



//ParentalGenotypesUsingPointersList*source=(ParentalGenotypesUsingPointersList*)other, * m= new ParentalGenotypesUsingPointersList();



//m->init ( source->outputSeparator, source->leftDelimiter, source->rightDelimiter );

//cout <<"basiccopy2\n";

		for ( VectorOfParentalGenotypes::iterator it=source->begin(); it!=source->end(); it++ )
{
//cout <<"element is: " << **it <<"\n";
this->insertHardElement(*it);
		//	m->ParentalGenotypesUsingPointersList::insertHardElement (*it );
}
//exit(0);
 // clone does not work because it calls to clone of each VectorOfParentalGenotypes instead of each ParentalGenotypesUsingPointers

//cout <<"endcheck\n";

//		ParentalGenotypesUsingPointersList::copyPaste ((ParentalGenotypesUsingPointersList* )m);

//zap(m);
//cout <<"last\n";
//zap(m);

//  cout << "size of this now is:" << size() <<"\n";
}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  void VectorOfParentalGenotypes::copyPaste (  GenericSample* other )" ); throw;};
	};
	/*______________________________________________________*/

	SampleGeneticCounts* VectorOfParentalGenotypes::getSampleTUCounts ( HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, int* relativePositions, int totalPos, bool includeMissing )
	{
		try
		{
//if (hapExtractionConfiguration->alleleOrderType!=LeftRight) throw NonImplemented("TUCounts* TrioSample::getTUCounts(int *pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, bool onlyHetero, int totalPermutations). Phase has to be already solved");

//BIOS::print(relativePositions, totalPos, cout);

		if ( relativePositions==NULL ) throw NullValue ( "	TUCounts* VectorOfParentalGenotypes::getSampleTUCounts ( HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, int* relativePositions, int totalPos, bool includeMissing )" );
//cout << "before filtering\n";
		if (verbose>0) cout <<"Filtering genotypes for given windows\n";
			VectorOfParentalGenotypes* filteredGenotypes=this->filter ( relativePositions, totalPos );
			//cout << "fitlered genorypes:" << *filteredGenotypes <<"\n";
//cout << "getting parental haps\n";

				if (verbose>0) cout <<"getting haplotypes from filtered genotypes\n";
			VectorOfParentalHaplotypes* parentalHaplotypesList=filteredGenotypes->getParentalHaplotypesList ( includeMissing, hapExtractionConfiguration );
//cout << "parentalHaplist:"<< *parentalHaplotypesList << "\n";			
	//cout << "getting hapcountslist\n";
			
				if (verbose>0) cout <<"getting haplotype counts from filtered haplotypes\n";
			GeneticUnitCountsList* haplotypeTUCountsVector=parentalHaplotypesList->getHaplotypeCountsList ( includeMissing );
		//	cout << "hapTUCountsVector: " << *haplotypeTUCountsVector << endl;

		//cout << "conf:"<< *hapExtractionConfiguration << endl;
		//cout << "total perms:" << totalPermutations << endl;
		//cout << "filtered gens:" << *filteredGenotypes << endl;
		//		cout << "parentalhaplist:"<< *parentalHaplotypesList << endl;
		//cout << "haptucountsvector:" << *haplotypeTUCountsVector << endl;
//				cout << "new filtered sampleTUCounts\n";
				
				if (verbose>0) cout <<"getting sampleTUCounts from filtered genotypes and haplotypes\n";
			SampleTUCounts* result=new SampleTUCounts ( filteredGenotypes, hapExtractionConfiguration, haplotypeTUCountsVector, parentalHaplotypesList, totalPermutations );

//cout << "end  VectorOfParentalGenotypes::getSampleTUCounts \n";
//cout << "zaping gens\n";
zap(filteredGenotypes);
//cout << "zaping counts\n";
zap(haplotypeTUCountsVector); 
//cout << "zaping haps\n";
zap(parentalHaplotypesList);
//cout << "end zap\n";
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from SampleTUCounts* VectorOfParentalGenotypes::getSampleTUCounts(HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, int* relativePositions, int totalPos)" ); throw;};
	}

	/*______________________________________________________*/

	void VectorOfParentalGenotypes::setPermutations ( int totalPermutations )
	{
		if ( permutations!=NULL )
		{
			if ( totalPermutations!=this->totalPermutations )
				throw BadFormat ( "VectorOfParentalGenotypes::setPermutations(int totalPermutations)" );
			return;
		}
		this->totalPermutations=totalPermutations;
		permutations=new VectorOfParentalGenotypes*[totalPermutations];
		for ( int i=0; i<totalPermutations;i++ )
		{
//if (i%10==0) cout <<"setting permutation " << i << " in genotypes\n";
			permutations[i]=getOnePermutation();
		}
	}
	/*______________________________________________________*/

	VectorOfParentalGenotypes* VectorOfParentalGenotypes::getOnePermutation ( int* chosenPos, int chosenLength )
	{
		VectorOfParentalGenotypes* result;
		if ( chosenPos==NULL ) result=new VectorOfParentalGenotypes ( absolutePositions, length, hapExtractionConfiguration, verbose );
		else result=new VectorOfParentalGenotypes ( chosenPos, chosenLength,  hapExtractionConfiguration, verbose );
		ParentalGenotypesUsingPointers* pg, *pg2;
		Genotype* father, *mother, *father2, *mother2;
		int transmitted;
		for ( VectorOfParentalGenotypes::iterator it=begin(); it<end(); it++ )
		{
			pg=getElement ( it );
			transmitted=ranbinom ( 1, 0.5 );
			if ( chosenPos==NULL ) father2=pg->father->clone(); else father2=pg->father->filter ( chosenPos, chosenLength );
			if ( !transmitted ) father2->changePhase();
			transmitted=ranbinom ( 1, 0.5 );
			if ( chosenPos==NULL ) mother2=pg->mother->clone(); else mother2=pg->mother->filter ( chosenPos, chosenLength );
			if ( !transmitted ) mother2->changePhase();
			pg2=new ParentalGenotypesUsingPointers ( father2, mother2, pg->trioCount );
			result->insertElement ( pg2 );
		}
		return result;
	}
	/*______________________________________________________*/

	void VectorOfParentalGenotypes::removePermutations()
	{
		zaparr ( permutations, totalPermutations );
	}
	/*______________________________________________________*/

	int* VectorOfParentalGenotypes::getPositions()
	{
		return absolutePositions;
	}
	/*______________________________________________________*/

	int VectorOfParentalGenotypes::getTotalPositions()
	{
		return length;
	}
	/*______________________________________________________*/

	int* VectorOfParentalGenotypes::getTotalAlleles()
	{
		return totalAlleles;
	}
	/*______________________________________________________*/

	allele** VectorOfParentalGenotypes::getAllAlleles()
	{
		return allAlleles;
	}
	/*______________________________________________________*/

	int VectorOfParentalGenotypes::getTotalPermutations()
	{
		return totalPermutations;
	}
	/*______________________________________________________*/

	VectorOfParentalGenotypes** VectorOfParentalGenotypes::getPermutations()
	{
		return permutations;
	}

	/*______________________________________________________*/

	VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getVectorOfParentalHaplotypes ( bool includeMissingOrUnphased )
	{
try
{
		int*positions=initializeFrom ( 0, length );
		VectorOfParentalHaplotypes* result=new VectorOfParentalHaplotypes ( positions, length );
		zaparr ( positions );
		ParentalGenotypesUsingPointers*element;
		Haplotype* motherT, *fatherT, *motherU, *fatherU;

//result->setPositions(relativePositions);
//result->setLength(totalPos);
		for ( ParentalGenotypesUsingPointersList::iterator it=begin(); it<end();it++ )
		{
			element=getElement ( it );
			motherT=element->mother->getLeftHaplotype ( includeMissingOrUnphased );
			motherU=element->mother->getRightHaplotype ( includeMissingOrUnphased );
			fatherT=element->father->getLeftHaplotype ( includeMissingOrUnphased );
			fatherU=element->father->getRightHaplotype ( includeMissingOrUnphased );
			result->insertElement ( new ParentalHaplotypesUsingPointers ( fatherT, fatherU, motherT, motherU, getPosition ( it ), ( double ) 1, ' ' ) );
			zap(motherT); zap(motherU); zap(fatherT); zap(fatherU);
		}
		return result;
	}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getVectorOfParentalHaplotypes ( bool includeMissingOrUnphased ) " ); throw;};
	}
	/*______________________________________________________*/

	VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getParentalHaplotypesList ( bool includeMissingOrUnphased, HapExtractionConfiguration *hapExtractionConfiguration )
	{
		try
		{
	
			VectorOfParentalHaplotypes* result;

//if (hapExtractionConfiguration!=NULL)
//cout << *hapExtractionConfiguration <<"\n";
//else cout <<"hap is null\n";
//exit(0);
			if ( hapExtractionConfiguration==NULL ) result=getVectorOfParentalHaplotypes ( includeMissingOrUnphased );
			else if ( hapExtractionConfiguration->alleleOrderType==LeftRightUsingTrios )
				switch ( hapExtractionConfiguration->phaseAlg )
				{
					case weighted:
						throw NonImplemented ( "VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getParentalHaplotypesList(int* relativePositions, int totalPos, bool allowUnphased, HapExtractionConfiguration *hapExtractionConfiguration). weighted-EM not implemented yet" ); break;
					case onlyKnown: 	result=getVectorOfParentalHaplotypes ( includeMissingOrUnphased ); break;
					case maxFreq: 		result=solvePhase ( hapExtractionConfiguration->emDistributions, hapExtractionConfiguration->emRestriction ); break;
				}
			else if (( hapExtractionConfiguration->alleleOrderType==LeftRight ) || (hapExtractionConfiguration->alleleOrderType==incompleteLeftRight ))
				result=getVectorOfParentalHaplotypes(includeMissingOrUnphased);
			else throw NonImplemented ( "VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getParentalHaplotypesList(int* relativePositions, int totalPos, bool allowUnphased, HapExtractionConfiguration *hapExtractionConfiguration).  not implemented yet-2" );





			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getParentalHaplotypesList(int* relativePositions, int totalPos) " ); throw;};
	}

	/*______________________________________________________*/


	void VectorOfParentalGenotypes::print ( ostream& out )
	{
//cout <<"PRINTING\n";
		out <<"size is:" << length <<"\n";
if (absolutePositions==NULL) cout <<"EERRRRR\n";
for (int i=0; i<length;i++)
{
out <<"pos at " << i << ": " << absolutePositions[i] <<"\n";
out <<"total alleles at " << i <<": " << totalAlleles[i] <<" with vals:\n";
for (int j=0; j<totalAlleles[i];j++)
{
  cout << allAlleles[i][j];
if (j<(totalAlleles[i]-1)) cout << ","; else cout <<"\n";
}
}
cout << "there are " << this->ParentalGenotypesUsingPointersList::size() << " genotypes in the sample\n";
		this->ParentalGenotypesUsingPointersList::print(out);
	}

	/*______________________________________________________*/


	ostream& operator<< ( ostream& out, VectorOfParentalGenotypes& lista )
	{
		lista.print ( out );
		return out;
	}

	/*______________________________________________________*/


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




