/* File: VectorOfParentalHaplotypesUsingPointers.h */

#ifndef __VectorOfParentalHaplotypes_cpp__
#define __VectorOfParentalHaplotypes_cpp__

//using namespace stats;

namespace BIOS {



VectorOfParentalHaplotypes::VectorOfParentalHaplotypes(int* pos, int length, char outputSeparator, char leftDelimiter, char rightDelimiter):ParentalHaplotypesUsingPointersList(outputSeparator, leftDelimiter, rightDelimiter)
{
if (pos==NULL) throw NullValue("VectorOfParentalHaplotypes::VectorOfParentalHaplotypes(int* pos, int length)");
this->pos=new int[length];
this->length=length;
for (int i=0; i<length;i++)
this->pos[i]=pos[i];
}

/*______________________________________________________*/

VectorOfParentalHaplotypes::VectorOfParentalHaplotypes(int length, char outputSeparator, char leftDelimiter, char rightDelimiter):ParentalHaplotypesUsingPointersList(outputSeparator, leftDelimiter, rightDelimiter)
{
this->pos=initializeFrom ( 0, length );
this->length=length;
}


/*______________________________________________________*/

VectorOfParentalHaplotypes::VectorOfParentalHaplotypes(VectorOfParentalHaplotypes& other):ParentalHaplotypesUsingPointersList(other)
{
this->pos=new int[other.length];
this->length=other.length;
for (int i=0; i<length;i++)
this->pos[i]=other.pos[i];
}
/*______________________________________________________*/

VectorOfParentalHaplotypes::~VectorOfParentalHaplotypes()
{
zaparr(pos);
};
/*______________________________________________________*/

VectorOfParentalHaplotypes* VectorOfParentalHaplotypes::clone()
{
return new VectorOfParentalHaplotypes(*this);
};
/*______________________________________________________*/

int VectorOfParentalHaplotypes::getLength()
{
return length;
};
/*______________________________________________________*/

int* VectorOfParentalHaplotypes::getPositions()
{
return pos;
};
/*______________________________________________________*/

void VectorOfParentalHaplotypes::setLength(int length)
{
this->length=length;
};
/*______________________________________________________*/

void VectorOfParentalHaplotypes::setPositions(int* positions)
{
this->pos=positions;
};

/*______________________________________________________*/

GeneticUnitCountsList* VectorOfParentalHaplotypes::getHaplotypeCountsList(bool includeMissing)
{
try
{
HapCounts *v=NULL;
Container<vector<HapCounts*>, HapCounts*>* freqs=new Container<vector<HapCounts*>, HapCounts*>();
GeneticUnitCountsList* result=new GeneticUnitCountsList();
HaplotypeVector* haplotypeVector=new HaplotypeVector();
Haplotype* left, *right, *orl, *orr;
ParentalHaplotypesUsingPointers* p;
HaplotypeVector::iterator it2, it3;
int index1, index2;
for (VectorOfParentalHaplotypes::iterator it=begin(); it<end();it++)
{
p=getElement(it);
for (int parent=0; parent<2; parent++)
{
if (parent==0) {orl=p->fatherT; orr=p->fatherU;} else {orl=p->motherT; orr=p->motherU;}
left=(Haplotype*)orl->clone();
right=(Haplotype*)orr->clone();
it2=haplotypeVector->findEqualElement(left);
it3=haplotypeVector->findEqualElement(right);
index1=haplotypeVector->getPosition(it2);
index2=haplotypeVector->getPosition(it3);
if (*left==*right) // homo
if (index1!=-1) // already there, 
freqs->getElement(index1)->homo+=(p->freq)*2;
else
{
v=new HapCounts(0, 0, (p->freq)*2);
freqs->insertElement(v); 
haplotypeVector->insertHardElement(left);
}
else // hetero
{
if (index1!=-1) // already there, 
freqs->getElement(index1)->left+=(p->freq);
else
{
v=new HapCounts(p->freq, 0, 0);
freqs->insertElement(v); 
haplotypeVector->insertHardElement(left);
}
if (index2!=-1) // already there, 
freqs->getElement(index2)->right+=(p->freq);
else
{
v=new HapCounts(0, p->freq, 0);
freqs->insertElement(v); 
haplotypeVector->insertHardElement(right);
}
}
zap(right); zap(left);
}
}
//cout << "found " << freqs->size() << "different haps\n";
for (Container<vector<HapCounts*>, HapCounts*>::iterator it=freqs->begin(); it<freqs->end();it++)
{
v=freqs->getElement(it);
//cout << "hap at pos " << freqs->getPosition(it) << " is: " << *v << endl;
if (includeMissing || !haplotypeVector->getElement(freqs->getPosition(it))->hasAMissingPosition())
{
result->insertElement(new HaplotypeTUCounts(haplotypeVector->getElement(freqs->getPosition(it)), v->left, v->right, v->homo));
//cout << "inserting hapcount " << *result->getLastElement() << endl;
}
}
zap(freqs);
zap(haplotypeVector);


return result;
}
catch (BasicException& be){be.addMessage("\ncalled from HaplotypeTUCountsVector* VectorOfParentalHaplotypes::getHaplotypeCountsVector(bool includeMissing)"); throw;};

}

	
	/*______________________________________________________*/


   ostream& operator<<(ostream& out, VectorOfParentalHaplotypes& lista)
   {
   out <<"size is:" << lista.length <<"\n";
for (int i=0; i<lista.length;i++)
out <<"pos at " << i << ": " << lista.pos[i] <<"\n";
   out << (ParentalHaplotypesUsingPointersList&)lista;
   return out;
   }
  
  
	/*______________________________________________________*/
	
	
	void VectorOfParentalHaplotypes::print(std::ostream& out){
		out << *this;
	}


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




