/* File: hapmap.h */

#ifndef __hapmap_h__
#define __hapmap_h__

#include <string>

//#include "../commonc++/basic.cpp"

//#include "Exceptions.h"
//#include "SNP.cpp"


namespace BIOS {



   

//   const short unsigned int male=1;
//   const short unsigned int female=2;
//   const short unsigned int unaffected=0;
//   const short unsigned int affected=2;


/************************/
/* hapmap DEFINITION */
/************************/


/**
        @memo hapmap for SNPs

	@doc
        Definition:
        A set of phenotype's features and genotypes for an hapmap

        Memory space: O(TotalSNPs), which TotalSNPs being the number of SNPs in the sample
        Each hapmap in a sample has been genotyped for the same TotalSNPs SNPs.

        @author Maria M. Abad
	@version 1.0
*/

	class hapmap
	 {

  public:
    /** @name Implementation of class hapmap
        @memo Private part.
    */

  struct position
  {
  long unsigned int pos;
  string rsNumber;
  unsigned int filepos;
  position *Next;
  position *Previous; 
      position()
	{
Next=NULL;
Previous=NULL;
}
string print()
{
string s=string("");
if (Next==NULL) s=s+string("Next is null\n");
if (Previous==NULL) s=s+string("Previous is null\n");
return s;
}
  };

  position *TheFirstPosition;

  struct dup
  {
  bool IsDup;
  unsigned int ID;
  dup *Next;
  dup *Previous;
      dup()
	{
Next=NULL;
Previous=NULL;
}
string print()
{
string s=string("");
s=s+tos(ID); if (IsDup) s=s+string(" (duplicado)"); 
//cout <<this->ID <<"\n";
s=s+string("\n");
if (Next==NULL) { s=s+string("null\n"); } else {s=s+Next->print();}
//s=s+string("Previous:\n");
//if (Previous==NULL) s=s+string("null\n");  else {s=s+Previous->print();}
return s;
}
  };

  dup *TheFirstDup;



   struct InverseGenotype {
      /**
      @memo A pointer to the vector of left alleles for the same position of all individuals
      @doc  Each left allele contains a value {0,1,2,3,4}
      */
      allele *Left;
      /**
      @memo A pointer to the vector of right alleles for the same positions of all individuals
      @doc Each right allele contains a value {0,1,2,3,4}
      */
      allele *Right;
	   /**
      @memo next
      @doc It contains a pointer to the following position
      */
      InverseGenotype *Next;
	  /**
      @memo next
      @doc It contains a pointer to the previous position
      */
      InverseGenotype *Previous;

      InverseGenotype()
	{
Left=NULL;
Right=NULL;
Next=NULL;
Previous=NULL;
}

string print()
{
string s=string("");
if (Left==NULL) s=s+string("Left is null\n");
if (Right==NULL) s=s+string("Right is null\n");
if (Next==NULL) s=s+string("Next is null\n");
if (Previous==NULL) s=s+string("Previous is null\n");
return s;
}

   };  // end structure genotype



/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/




  ifstream InputFile;

  unsigned int totalIndividuals, TotalSNPs, Sizedup;

public:
    InverseGenotype * TheFirstInverseGenotype;

bool checkSamples;
//  char *genotypebuf;

        
//	 typefile tf;


/***************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


/////////////////////////
  /// PRIVATE ////////
  /////////////////////
private:

void destroy(position * Position, InverseGenotype * IG, dup * Dup);

void ReadInfo (ifstream * origen, InverseGenotype *target, position *targetpos, bool phased=false);

void GetIDs (char * IDs, bool phased=false);

void ConvertFormat (char* filePhenotypes, char* filename, bool phased=false);

void GetInfo(ifstream *filename, bool phased=false);



      /* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /**
         @memo Write a new file with resolved phase.
         @param filename: the filename where results will be written
         Time complexity O(TotalSNPs*Size)

      */
	/*  void WriteResults (char* filename);   
    /**
	 @memo Destructor
	 @doc
           Deallocate memory used by hapmap.
           Time complexity O(1).

      */
	  ~hapmap ();


	   /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */
	  hapmap();


  /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */

//hapmap(const hapmap& origen, IndCategory ic); 

//	  hapmap(const phenotype& porigen, const genotype& gorigen, IndCategory ic);

 /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */

		hapmap(char* filename, unsigned int Size, bool phased=false, bool checkSamples=false); 


		  
	  /**
         @memo Creates a new hapmap objet with the phase resolved.
         @param Origen: the origianl hapmap object 
         Time complexity O(TotalSNPs*Size*Size)

      */
		 void OrderByPosition ();   


	  	  
	  /**
         @memo Increase the count the total number of known haplotypes between two positions.
         @param comb: pointer to a 5-integer array: 1: 11, 2:12, 3: 21, 4: 22
         @param IndGenotype: hapmap whose haplotype is going to be checked
         @param FirstSNP, LastSNP: the two loci
         @param MajorAllele: pointer to a a TotalSNPs allele table with the major allele for each SNP
     */

	     ofstream TransformID (char* FirstRow);


 /**
         @memo Resolve the phase between two consequtive heterozygous position for an hapmap.
         @param comb: pointer to a 5-integer array: 1: 11, 2:12, 3: 21, 4: 22
         @param ForPhase: pointer to the genotypes of all hapmaps
         @param FirstSNP, LastSNP: the two loci
         @param MajorAllele: pointer to a a TotalSNPs allele table with the major allele for each SNP
	     @param ic: 0: if phase has to be resolved only for parents, 1: only for children, 2 for everybody
*/

	     ofstream GetSNPs (istream InputFile);


/**
         @memo Resolve the phase for a data set.
         @param ic: 0: if phase has to be resolved only for parents, 1: only for children, 2 for everybody
*/
		 ofstream  TransformPairs (istream SNPs);




/**
         @memo Compute the more frequent allele for each SNP.
         @param ic: 0: if phase has to be resolved only for parents, 1: only for children, 2 for everybody
		 @ return: pointer to a table of TotalSNPs alleles with the more frequent value
*/

		 ofstream AddIds(istream Dataset, istream ID);

/**
         @memo Compute the less frequent allele for each SNP.
         @param ic: 0: if phase has to be resolved only for parents, 1: only for children, 2 for everybody
		 @ return: pointer to a table of TotalSNPs alleles with the less frequent value
*/

		 ofstream RemoveDuplicates (istream Dataset);



/**
         @memo Order all the SNPs genotypes in the sample so that when a genotype for a hapmap is
		 heterozygous, the one in the Left positions must be the Major allele.
         @param ic: 0: if phase has to be resolved only for parents, 1: only for children, 2 for everybody
         @param MajorAllele: pointer to a a TotalSNPs allele table with the major allele for each SNP
*/

		 void ProcessHapmap (char* filephenotype, char* filename, bool phased=false);


		void PrintPositions (char* filename);

		void PrintRSNumbers (char* filename);

	        /**
         @memo Obtain the number of SNPs.
         @return the number of SNPs
         @doc Return the number of SNPs. This value
         is in the variable TotalSNPs.
         Time complexity O(1)

      */
        unsigned int GetTotalSNPs ();          



/**
         @memo Resolve phase for every pair of consecutive heterozygous positions for every hapmap in the sample
         @param ic: 0: if phase has to be resolved only for parents, 1: only for children, 2 for everybody
         @param MajorAllele: pointer to a a TotalSNPs allele table with the major allele for each SNP
*/


};  // End of class hapmap


ostream& operator<<(ostream& out, struct hapmap::InverseGenotype& hm)
       {
out <<"InverseGenotype:\n";
       out <<hm.print();
							return out;
                                                         }

ostream& operator<<(ostream& out, struct hapmap::dup& hm)
       {
out <<"dup:\n";
       out <<hm.print();
							return out;
                                                         }

ostream& operator<<(ostream& out, struct hapmap::position& hm)
       {
out <<"position:\n";
       out <<hm.print();
							return out;
                                                         }



};  // Fin del Namespace

#endif

/* Fin Fichero: hapmap.h */
