/***************************************************************************
 *   Copyright (C) 2008 by María del Mar Abad Grau   *
 *   mabad@ugr.es   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "simulationtdtDiff.h"



#include "../commonc++/Fachade.cpp"


//#include <qlabel.h>

//#include <kmainwindow.h>
//#include <klocale.h>

// from a population of haplotypes POP with diseaseLocus1 and diseaseLocus2, nuclear families with one affected offspring are selected by using different relative genotype risks (RR), the current frequency for allele diseases in both genes qD and qE, different models and different tests:
//tests:
// 1: unlinked two-locus disease model
// 2: linked two-locus disease model
// 3: unlinked single locus disease model

// genotype models:
// 1: additive model
// 2: dom-or-dom model
// 3: dom-and-dom model
// 4: rec-or-rec model
// 5: threshold model
// 6: modified model

// RR is set to go from 2 to 5

namespace BIOS
{



  SimulationTDT::SimulationTDT ( int totalSamples, int sampleSize, int totalInds, double mutationRate, double mafDPOP1, double mafDPOP2, double mafEPOP1, double mafEPOP2, double pp, double recProbWithinBlock, double recProbBetweenDiseaseLoci, int diseaseLocus1, int diseaseLocus2, int iniUnlinkedLocus, int totalSNPs, int relativeRisk, int genotypeModel, int test, char* filename, double margin)
  {
  double recProbOutsideBlock=0.5;
  if (test==1 && recProbBetweenDiseaseLoci>recProbWithinBlock)
  recProbOutsideBlock=recProbBetweenDiseaseLoci; 
    try
    {
      srand (1000);
      double pAffDD1=0.3, pAffDd1=0.16, pAffdd1=0.02; // POP1
      double pAffDD2=0.2, pAffDd2=0.11, pAffdd2=0.02; // POP2

      double freqMut1=0, freqMut2=0;
      BidimensionalTable<bool> * POP1=NULL, *POP2=NULL, *sample=NULL, *motherSample=NULL, *fatherSample=NULL,  *sample2=NULL, *motherSample2=NULL, *fatherSample2=NULL;
      for ( int i=0; i<totalSamples;i++ )
      {
        cout << "sample " << i+1 <<"\n";

        while ( sample==NULL )
        {

          while ( POP1==NULL || freqMut1<=maxi (0.0,mafDPOP1-margin) || ( (test!=0 && test!=3 && freqMut2<=maxi (0.0,mafEPOP1-margin)) || freqMut1>= (mini (0.5,mafDPOP1+margin) )) || ((test!=0 && test!=3 && freqMut2>=mini (0.5,mafEPOP1+margin) )))
{
            setPop ( 150, totalSNPs, totalInds, test, mafDPOP1, mafEPOP1, POP1, freqMut1, freqMut2, diseaseLocus1, diseaseLocus2, iniUnlinkedLocus, recProbWithinBlock, recProbOutsideBlock, mutationRate, margin );

}
          if (test==0) getSampleFromStratPop ( POP1, sample, fatherSample, motherSample, (int) round (sampleSize*pp), totalSNPs, diseaseLocus1, diseaseLocus2, mafDPOP1, recProbOutsideBlock, iniUnlinkedLocus,  pAffDD1, pAffDd1, pAffdd1);
          else 
{
getSampleFromPop ( POP1, sample, fatherSample, motherSample, sampleSize, test, relativeRisk, genotypeModel, totalSNPs, recProbBetweenDiseaseLoci, diseaseLocus1, diseaseLocus2, mafDPOP1, mafEPOP1);
}
        zap ( POP1 );
        };
        if ( test==0 )
        {

          while ( sample2==NULL )
          {
            freqMut1=0, freqMut2=0;
            while ( POP2==NULL || freqMut1<=maxi (0.0,mafDPOP2-margin)  || freqMut1>= (mini (0.5,mafDPOP2+margin) )) 
              setPop ( 150, totalSNPs, totalInds, test, mafDPOP2, mafEPOP2, POP2, freqMut1, freqMut2, diseaseLocus1, diseaseLocus2, iniUnlinkedLocus, recProbWithinBlock, recProbOutsideBlock, mutationRate, margin );
            getSampleFromStratPop ( POP2, sample2, fatherSample2, motherSample2, sampleSize- (int) round (sampleSize*pp), totalSNPs, diseaseLocus1, diseaseLocus2, mafDPOP2, recProbOutsideBlock, iniUnlinkedLocus, pAffDD2, pAffDd2, pAffdd2 );
        zap ( POP2 );
          }
          joinSamples (sample, fatherSample, motherSample, sample2, fatherSample2, motherSample2);
        }
        printSample ( sample, fatherSample, motherSample, string ( filename ) +string ( "_" ) +tos ( i ) +string ( ".gou" ), diseaseLocus1, diseaseLocus2, totalSNPs, sampleSize );
        zap ( motherSample );
        zap ( fatherSample );
        zap ( sample );
      }
    }
    catch (OutOfRange<int> ori) {ori.PrintMessage ("simulationTDT()");}
    catch (OutOfRange<double> wm) {wm.PrintMessage ("simulationTDT()");}
  catch( bad_alloc a) { cout << a.what() << "\n";};
}
 

  /*__________________________________________*/

  void SimulationTDT::joinSamples ( BidimensionalTable<bool>*& childSample,BidimensionalTable<bool>*& fatherSample,BidimensionalTable<bool>*& motherSample, BidimensionalTable<bool>*& childSample2,BidimensionalTable<bool>* &fatherSample2,BidimensionalTable<bool>*& motherSample2)
  {
    int sampleSize=childSample->getXDim() +childSample2->getXDim();
    int offset=0;
    BidimensionalTable<bool>*childSample3=new BidimensionalTable<bool> (sampleSize, childSample->getYDim() ), *childPointer=childSample;
    BidimensionalTable<bool>*fatherSample3=new BidimensionalTable<bool> (sampleSize, childSample->getYDim() ), *fatherPointer=fatherSample;
    BidimensionalTable<bool>*motherSample3=new BidimensionalTable<bool> (sampleSize, childSample->getYDim() ), *motherPointer=motherSample;
    for (int s=0; s<2; s++)
    {
      if (s==1) {childPointer=childSample2; fatherPointer=fatherSample2; motherPointer=motherSample2; offset=childSample->getXDim();}
      for (int i=0; i<childPointer->getXDim(); i++)
        for (int j=0; j<childSample->getYDim(); j++)
        {
          fatherSample3->setValue (i+offset, j, fatherPointer->getValue (i, j) );
          motherSample3->setValue (i+offset, j, motherPointer->getValue (i, j) );
          childSample3->setValue (i+offset, j, childPointer->getValue (i, j) );
        }
    }
    zap (childSample);
    zap (motherSample);
    zap (fatherSample);
    zap (childSample2);
    zap (motherSample2);
    zap (fatherSample2);
    fatherSample=fatherSample3;
    motherSample=motherSample3;
    childSample=childSample3;
  }

  /*__________________________________________*/

  void SimulationTDT::printSample ( BidimensionalTable<bool>* childSample,BidimensionalTable<bool>* fatherSample,BidimensionalTable<bool>* motherSample, string filename, int diseaseLocus1, int diseaseLocus2, int totalSNPs, int sampleSize )
  {
    BidimensionalTable<bool>* sample=NULL;
    int alle1, alle2;
    OpenOutput ( filename.c_str(), &OutputFile );
    int c;
double tD=0, tE=0, uD=0, uE=0;
    for ( int i=0; i<sampleSize; i++ )
      for ( int member=0; member<3; member++ )
      {
        switch ( member )
        {
          case 0: sample=childSample; OutputFile << i << " 0 1 2 1 1"; break;
          case 1: sample=fatherSample; OutputFile << i << " " << member << " 0 0 1 0"; break;
          case 2: sample=motherSample; OutputFile << i << " " << member << " 0 0 2 0"; break;
        }
        OutputFile << " " << i << " ";
        c=0;
        for ( int j=0; j<sample->getYDim(); j++ )
          if ( j!=diseaseLocus1 && j!=diseaseLocus2 && c<(totalSNPs-2))
          {
            alle1=sample->getValue ( i*2, j ) +1;
            alle2=sample->getValue ( i*2+1, j ) +1;
            OutputFile << alle1 << " " << alle2;
            if ( c<totalSNPs-3 ) OutputFile << " "; else OutputFile << "\n";
            c++;
          }
else 
if (j==diseaseLocus1) 
{
if (member>0)
{
if (sample->getValue(i*2,j)==1) tD++;
if (sample->getValue(i*2+1,j)==1) uD++;
}
}
else
{
if (member>0)
if (sample->getValue(i*2,j)==1) tE++;
if (sample->getValue(i*2+1,j)==1) uE++;
}
}
    OutputFile.close();
  };
  /*___________________________________________________________________*/

  BidimensionalTable<double>* SimulationTDT::setTransmittedHaplotypeParentsFreqsGivenAffectedChild ( int model, int RR, int test, double pde, double pdE, double pDe, double pDE )
  {
// it computes p(h_f, h_m|f_c=affected) where h_f and h_m are the father and mother transmitted haplotypes to the child respectively
// which is propto p(h_f) p(h_m)*p(f_c=affected|h_f, h_m)
// the first two factors are computed with setHaplotypeFreqs, the third with setHaplotypeRisks or setHaplotypeRisksSingleModel
    double* freqs=setHaplotypeFreqs ( pde, pdE, pDe, pDE, test );
    double *risks;
    int genotype;
    if ( test==3 || test==0) risks=setGenotypeRisksSingleModel ( model, RR );
    else risks=setGenotypeRisks ( model, RR );
    BidimensionalTable<double> *result=new BidimensionalTable<double> ( 4, 4 );
    double total=0;
    for ( int father=0; father<4; father++ ) //  de/dE/De/DE
      for ( int mother=0; mother<4; mother++ ) //  de/dE/De/DE
      {
        genotype=4; // pdDpeE when (father==1 && mother==2) || (father=2 && mother==1) || (father==0 && mother==3) || (father==3 && mother==0): four cases
        if ( father==0 && mother==0 ) genotype=0; // pddee;
        if ( father==1 && mother==1 ) genotype=2; // pddEE
        if ( father==2 && mother==2 ) genotype=6; // pDDee
        if ( father==3 && mother==3 ) genotype=8; // pDDEE
        if ( ( father+mother ) ==1 ) genotype=1; // pddeE two cases
        if ( ( father==0 && mother==2 ) || ( father==2 && mother==0 ) ) genotype=3; //pdDee; two cases
        if ( ( father==1 && mother==3 ) || ( father==3 && mother==1 ) ) genotype=5; // pdDEE; two cases
        if ( ( father==3 && mother==2 ) || ( father==2 && mother==3 ) ) genotype=7; // pDDeE; two cases
        result->setValue ( father, mother, freqs[father]*freqs[mother]*risks[genotype]);//freqs[father]*freqs[mother]*
        total=total+result->getValue ( father, mother );
       }
    for ( int father=0; father<4; father++ )
      for ( int mother=0; mother<4; mother++ )
        {
result->setValue ( father, mother, result->getValue ( father, mother ) / (double) total );
}
return result;
};
 
  	/*___________________________________________________________________*/

  BidimensionalTable<double>* SimulationTDT::setConditionalChildGenotypeFreqs ( BidimensionalTable<double>* parentGens )
  {
// It computes p(g_c|g_f, g_m)
    BidimensionalTable<double> *probs=new BidimensionalTable<double> ( 9, 81 );
    int pos, geneFamily[2][3], phas, // locus D and E; child, father, mother
    pointer, alleleFromFather[2], alleleFromMother[2], alleleTransFather[2], alleleTransMother[2];// locus D and E;   t/u
    double partialProb, total;

    int totalPairs[3];
    for ( int father=0; father<9; father++ )
      for ( int mother=0; mother<9; mother++ )
      {
        pos=parentGens->getPos ( father, mother );
        total=0;
        for ( int child=0; child<9; child++ )
        {
          for ( int member=0; member<3; member++ )
          {
            switch ( member )
            {
              case 0: pointer=child; break;
              case 1: pointer=father; break;
              case 2: pointer=mother; break;
            }
            geneFamily[0][member]=1;
            geneFamily[1][member]=1;
            if ( pointer<3 ) geneFamily[0][member]=0;
            if ( pointer>5 ) geneFamily[0][member]=2;
            if ( pointer==0 || pointer==3 || pointer==6 ) geneFamily[1][member]=0;
            if ( pointer==2 || pointer==5 || pointer==8 ) geneFamily[1][member]=2;
            totalPairs[member]=getTotalPairs ( geneFamily[0][member], geneFamily[1][member] );
          }


          for ( int t0=0; t0<totalPairs[0]; t0++ )
            for ( int t1=0; t1<totalPairs[1]; t1++ )
              for ( int t2=0; t2<totalPairs[2]; t2++ )
              {
                partialProb=1;
                for ( int locus=0; locus<2; locus++ )
                {
                  alleleFromFather[locus]=getAllele ( geneFamily[locus][0], geneFamily[1-locus][0], locus, t0*2 ); // 0 transmitted from trans
                  alleleFromMother[locus]=getAllele ( geneFamily[locus][0], geneFamily[1-locus][0], locus, t0*2+1 ); // 1 transmitted from !trans
                  alleleTransFather[locus]=getAllele ( geneFamily[locus][1],geneFamily[1-locus][1], locus, t1*2 ); // 0 transmitted from father
                  alleleTransMother[locus]=getAllele ( geneFamily[locus][2], geneFamily[1-locus][2], locus, t2*2 ); // 0 transmitted from mother

                  partialProb=partialProb* ( ( ( alleleFromFather[locus]==alleleTransFather[locus] ) ) * ( ( alleleFromMother[locus]==alleleTransMother[locus] ) ) );

                }

                probs->setValue ( child, pos, probs->getValue ( child, pos ) +partialProb/ ( totalPairs[0]*totalPairs[1]*totalPairs[2] ) );
              }
          total=total+probs->getValue ( child, pos );

        }
        for ( int child=0; child<9; child++ )
          probs->setValue ( child, pos, probs->getValue ( child, pos ) /total );

      }

    return probs;
  };

  /*___________________________________________________________________*/

  int SimulationTDT::getTotalPairs ( int genotypeLocus1, int genotypeLocus2 )
  {
    int totalHapPairs=1;
    if ( genotypeLocus1!=1 && genotypeLocus2!=1 ) // both homozygous
      return 1;
    if ( genotypeLocus1==1 && genotypeLocus2==1 ) // both homozygous
      return 4;
    return 2;
  }
  /*___________________________________________________________________*/

  int SimulationTDT::getAllele ( int genotype, int genotype2, int locus, int hapPos )
  {
    int allele;
    if ( genotype==0 ) return 0;
    if ( genotype==2 ) return 1;
    switch ( hapPos/2 )
    {
      case 0: // 00/11 if 4 happairs, 00/10 if 2 pairs and locus 0; 00/01 if 2 happairs and locus 1
        if ( hapPos%2==0 ) return 0; else return 1; break;
      case 1: // 11/00  if 4 happairs, 10/00 if 2 happairs and locus 0; 01/00 if 2 pairs and locus 1
        if ( hapPos%2==1 ) return 0; else return 1; break;
      case 2: // 01/10
        if ( hapPos%2==0 ) return locus; else return !locus; break;
      case 3: // 10/01
        if ( hapPos%2==0 ) return !locus; else return locus; break;
    }
  }
  /*___________________________________________________________________*/

  double* SimulationTDT::setGenotypeFreqs ( double pdDeE, double pddee,double pDDEE,double pDDee,double pddEE,double pddeE,double pDDeE,double pdDEE,double pdDee )
  {
    double *probs=new double[9];
    probs[0]=pddee;
    probs[1]=pddeE;
    probs[2]=pddEE;
    probs[3]=pdDee;
    probs[4]=pdDeE;
    probs[5]=pdDEE;
    probs[6]=pDDee;
    probs[7]=pDDeE;
    probs[8]=pDDEE;
    return probs;
  };
  /*___________________________________________________________________*/

  double* SimulationTDT::setHaplotypeFreqs ( double pde, double pdE, double pDe, double pDE, int test )
  {
    double *probs=new double[4];
    if (test!=3)
    {
    probs[0]=pde;
    probs[1]=pdE;
    probs[2]=pDe;
    probs[3]=pDE;
    }
    else
    {
    probs[0]=(pde+pdE)/2;
    probs[1]=(pdE+pde)/2;
    probs[2]=(pDe+pDE)/2;
    probs[3]=(pDE+pDe)/2;
    }
    return probs;
  };
  /*___________________________________________________________________*/

  BidimensionalTable<double>* SimulationTDT::setGenotypeParentsFreqs ( double* probs )
  {
    BidimensionalTable<double> *parentProbs=new BidimensionalTable<double> ( 9, 9 );

    for ( int i=0; i<9; i++ )
      for ( int j=0; j<9; j++ )
        parentProbs->setValue ( i, j, probs[i]*probs[j] );
    return parentProbs;
  };
  /*___________________________________________________________________*/

  double* SimulationTDT::setGenotypeRisksSingleModel ( int model, int RR )
  {
    double *risks=Initialize ( 9, 0.0 ), total=0;
    for ( int i=0; i<9; i++ )
    {
      if (i<3) risks[i]=1;
      else if (i<=5 ) risks[i]=1+0.5* ( RR-1 ); else risks[i]=RR;
      total=total+risks[i];
    }
    for ( int i=0; i<9; i++ )
      risks[i]=risks[i]/total;
    return risks;
  };
  /*___________________________________________________________________*/

  double* SimulationTDT::setGenotypeRisks ( int model, int RR )
  {
    double *pGen=Initialize ( 9, 0.0 );
    switch ( model )
    {
      case 1: //additive model
        pGen[0]=1;
        pGen[1]= 1+0.25* ( RR-1 ) ;//*pddeE
        pGen[2]= 1+0.5* ( RR-1 ) ;//*pddEE
        pGen[3]= 1+0.25* ( RR-1 ) ;//*pdDee
        pGen[4]= 1+0.5* ( RR-1 ) ;//*pdDeE
        pGen[5]= 1+0.75* ( RR-1 ) ;// *pdDEE  (in Yu et al it says 0.5)
        pGen[6]= 1+0.5* ( RR-1 ) ;//*pDDee
        pGen[7]= 1+0.75* ( RR-1 ) ;//*pDDeE
        pGen[8]=RR;break;//*pDDEE
      case 2: //dom-or-dom model
        pGen[0]=1;//*pddee;
        for ( int i=1; i<9; i++ ) pGen[i]=RR;
        break;
      case 3: //dom-and-dom model
          for ( int i=0; i<9; i++ ) if ( i==4 || i==5 || i==7 ||i==8 ) pGen[i]=RR; else pGen[i]=1;
        break;
      case 4: //rec-or-rec model
          for ( int i=0; i<9; i++ ) if ( i==0 || i==1 || i==3 ||i==4 ) pGen[i]=1; else pGen[i]=RR;
        break;
      case 5: //threshold model
          for ( int i=0; i<9; i++ ) if ( i==5 || i==7 || i==8 ) pGen[i]=RR; else pGen[i]=1;
        break;
      case 6: //modified model
          for ( int i=0; i<9; i++ ) if ( i==5 || i==6 || i==7 ||i==8 ) pGen[i]=RR; else pGen[i]=1;
        break;
    };
    double total=0;
    for ( int i=0; i<9;i++ )
      total=total+pGen[i];
    for ( int i=0; i<9; i++ )
      pGen[i]=pGen[i]/total;
    return pGen;
  };
  /*___________________________________________________________________*/

  void SimulationTDT::setParentTransmittedAlleles ( int &fatherTransmittedDiseaseLocus1, int &fatherTransmittedDiseaseLocus2, int& motherTransmittedDiseaseLocus1, int &motherTransmittedDiseaseLocus2, int &childGenotype, int recomb )
  {
// mother and father are interchangeable
    switch ( childGenotype )
    {
      case 0: //ddee
        fatherTransmittedDiseaseLocus1=0;
        fatherTransmittedDiseaseLocus2=0;
        motherTransmittedDiseaseLocus1=0;
        motherTransmittedDiseaseLocus2=0;
        break;
      case 1: //ddeE
        fatherTransmittedDiseaseLocus1=0;
        fatherTransmittedDiseaseLocus2=0;
        motherTransmittedDiseaseLocus1=0;
        motherTransmittedDiseaseLocus2=1;
        break;
      case 2: //ddEE
        fatherTransmittedDiseaseLocus1=0;
        fatherTransmittedDiseaseLocus2=1;
        motherTransmittedDiseaseLocus1=0;
        motherTransmittedDiseaseLocus2=1;
        break;
      case 3: //dDee
        fatherTransmittedDiseaseLocus1=0;
        fatherTransmittedDiseaseLocus2=0;
        motherTransmittedDiseaseLocus1=1;
        motherTransmittedDiseaseLocus2=0;
        break;
      case 4: //dDeE
        fatherTransmittedDiseaseLocus1=0;
        fatherTransmittedDiseaseLocus2=recomb-0;
        motherTransmittedDiseaseLocus1=1;
        motherTransmittedDiseaseLocus2=1-recomb;
        break;
      case 5: //dDEE
        fatherTransmittedDiseaseLocus1=0;
        fatherTransmittedDiseaseLocus2=1;
        motherTransmittedDiseaseLocus1=1;
        motherTransmittedDiseaseLocus2=1;
        break;
      case 6: //DDee
        fatherTransmittedDiseaseLocus1=1;
        fatherTransmittedDiseaseLocus2=0;
        motherTransmittedDiseaseLocus1=1;
        motherTransmittedDiseaseLocus2=0;
        break;
      case 7: //DDeE
        fatherTransmittedDiseaseLocus1=1;
        fatherTransmittedDiseaseLocus2=0;
        motherTransmittedDiseaseLocus1=1;
        motherTransmittedDiseaseLocus2=1;
        break;
      case 8: //DDEE
        fatherTransmittedDiseaseLocus1=1;
        fatherTransmittedDiseaseLocus2=1;
        motherTransmittedDiseaseLocus1=1;
        motherTransmittedDiseaseLocus2=1;
        break;
    }

  };
  /*___________________________________________________________________*/

  bool SimulationTDT::isAffected ( int totalMajor1, int totalMajor2, double *risk )
  {
    int pos;
    switch ( totalMajor1 )
    {
      case 2:
        switch ( totalMajor2 )
        {
          case 2:  pos=8; break;
          case 1:  pos=7; break;
          case 0:  pos=6; break;
        }
        break;
      case 1:
        switch ( totalMajor2 )
        {
          case 2:  pos=5; break;
          case 1:  pos=4; break;
          case 0:  pos=3; break;
        }
        break;
      case 0:
        switch ( totalMajor2 )
        {
          case 2:  pos=2; break;
          case 1:  pos=1; break;
          case 0:  pos=0; break;
        }
        break;
    }
    return ranbinom ( 1, risk[pos] );
  };
  /*___________________________________________________________________*/

  bool SimulationTDT::isHetero ( BidimensionalTable<bool>* POP, int pos )
  {
    bool hetero=false;
    for ( int i=0; i<POP->getYDim(); i++ )
      if ( POP->getValue ( pos, i ) !=POP->getValue ( pos+1, i ) ) return true;
    return false;
  }
  /*___________________________________________________________________*/
 
  BidimensionalTable<double>* SimulationTDT::getFreqs (double mafD, double mafE, int genotypeModel, int RR, int test, double recProb)
  {
    double q1Max=1-mafD, q2Max=1-mafE;

// We compute haplotype frequencies considering recombination fraction between the two disease loci recProb. If recProb is 0.5, as in unlinked, it is equivalent to linkage equilibrium pAB=pA*pB. If recProb=0, as completely linked, it would be equivalent to perfect LD

    double pA=mini (q1Max,q2Max),
              pa=1-pA,
                 pB=maxi (q1Max, q2Max),
                    pb=1-pB,
                       pAB= (1-recProb) *pA+recProb*pA*pB,
                            pAb=recProb*pA*pb,
                                paB= ( 1-recProb ) * ( pB-pA ) +recProb*pa*pB,
                                     pab= ( 1-recProb ) *pb+recProb*pa*pb;
{change ( pAB, paB ); change ( pab, pAb ); }
{change ( pAB, pAb ); change ( paB, pab ); }

    BidimensionalTable<double>* result=setTransmittedHaplotypeParentsFreqsGivenAffectedChild ( genotypeModel, RR, test, pab, paB, pAb, pAB );


    return result;
  }
  /*___________________________________________________________________*/

  bool SimulationTDT::setSampleHaplotype (BidimensionalTable<bool>* parentSample, BidimensionalTable<bool>* childSample, int parentLocus1, int parentLocus2, int test, intSample* deHaps, intSample* dEHaps, intSample* DeHaps, intSample* DEHaps, int& deP, int& dEP, int&DeP, int& DEP, int &cont,  int*dePos, int* dEPos, int* DePos, int* DEPos)
  {
    bool found=false;
    intList* row=NULL, *row2=NULL;
    if (test==0 || test==3) parentLocus2=0;
    if ( parentLocus1==0 && parentLocus2==0 && deP<deHaps->size() ) {row=deHaps->getElement ( dePos[deP]);deP++; found=true;};
    if ( parentLocus1==0 && parentLocus2==1 && dEP<dEHaps->size() ) {row=dEHaps->getElement ( dEPos[dEP]);dEP++; found=true;};
    if ( parentLocus1==1 && parentLocus2==0 && DeP<DeHaps->size() ) {row=DeHaps->getElement ( DePos[DeP]);DeP++; found=true;};
    if ( parentLocus1==1 && parentLocus2==1 && DEP<DEHaps->size() ) {row=DEHaps->getElement ( DEPos[DEP]);DEP++; found=true;};
    if (!found) return false;
if (row==NULL) throw NullValue("SimulationTDT::setSampleHaplotype ");
    for (int i=0; i<childSample->getYDim();i++)
    {
      childSample->setValue (cont, i, row->getElement ( i ) );
      parentSample->setValue (cont- (cont%2==1), i, row->getElement ( i ) );
    }
    cont=cont+1;
    return true;
  }
/*___________________________________________________________________*/

  bool SimulationTDT::setSampleUntransmittedHaplotype (BidimensionalTable<bool>* parentSample, intSample* originalHaps, int &oP, int &cont,  int*originalPos)
  {
    intList* row=NULL;
    if (oP< (originalHaps->size())) {row=originalHaps->getElement ( originalPos[oP]); oP++;}
    else return false;
    if (row==NULL) throw NullValue("SimulationTDT::setSampleUntransmittedHaplotype ");
    for (int i=0; i<parentSample->getYDim();i++)
      parentSample->setValue (cont+1- (cont%2==1), i, row->getElement (i) );
    cont=cont+1;
    return true;
  }
  /*___________________________________________________________________*/

  intSample* SimulationTDT::getHaps (BidimensionalTable<bool>* POP, int firstLocus, int secondLocus, int diseaseLocus1, int diseaseLocus2)
  {
    intList* row;
    intSample* result=new intSample();
    for ( int i=0; i<POP->getXDim(); i++ )
     if (firstLocus==-1 ||  POP->getValue ( i, diseaseLocus1 ) ==firstLocus )
      if (secondLocus==-1 ||  POP->getValue ( i, diseaseLocus2 ) ==secondLocus )
      { 
      row=new intList();
      for ( int j=0; j<POP->getYDim(); j++ ) row->insertElement ( POP->getValue ( i, j ) );
        result->insertElement ( row );
    }
    return result;
  }
  /*___________________________________________________________________*/

  void SimulationTDT::getSampleFromPop ( BidimensionalTable<bool>* POP,BidimensionalTable<bool>*& sample,BidimensionalTable<bool>*& fatherSample,BidimensionalTable<bool>*& motherSample, int sampleSize, int test, int RR, int genotypeModel, int totalSNPs, double recProb, int diseaseLocus1, int diseaseLocus2, double mafDPOP, double mafEPOP)
  {
  Sampling* sampling=new Sampling ( sampleSize*2 , false ), *deSamp=NULL, *dESamp=NULL, *DeSamp=NULL, *DESamp=NULL, *originalSamp;
  int pos, * positions=sampling->getPositionsTable(), *pos2=NULL, *dePos=NULL, *dEPos=NULL, *DePos=NULL, *DEPos=NULL, *originalPos=NULL, deP=0, dEP=0, DeP=0, DEP=0, oP=0, cont=0,  untransmittedCounter=0, locus2=-1, parentHap;
  bool found=true, found2;
  Multinomial* multinomial=NULL;
  intSample* deHaps=NULL, * dEHaps=NULL,* DeHaps=NULL, * DEHaps=NULL, *originalHaps=NULL;
  intList* row=NULL, *row2=NULL;
  BidimensionalTable<bool>* pointerSample;
  BidimensionalTable<double>* pParentHapPOP=getFreqs (mafDPOP, mafEPOP, genotypeModel, RR, test, recProb);
  double* pParentsTablePOP=Initialize ( 16, 0.0 );
//cout <<"fffrec\n";
   for ( int i=0; i<4;i++ ) // transmitted by father
    for ( int j=0; j<4;j++ ) // transmitted by mother
      pParentsTablePOP[pParentHapPOP->getPos ( i, j ) ]=pParentHapPOP->getValue ( i, j );
    try
    {
      sample=new BidimensionalTable<bool> ( sampleSize*2, POP->getYDim() );
      motherSample=new BidimensionalTable<bool> ( sampleSize*2, POP->getYDim() ),
      fatherSample=new BidimensionalTable<bool> ( sampleSize*2, POP->getYDim() );
      multinomial=new Multinomial (sampleSize, 16, pParentsTablePOP );
if (test!=3 && test!=0) locus2=0; else locus2=-1;
      deHaps=getHaps (POP, 0, locus2, diseaseLocus1, diseaseLocus2);
      DeHaps=getHaps (POP, 1, locus2, diseaseLocus1, diseaseLocus2);
      if (test!=3 && test!=0) 
      {
      dEHaps=getHaps (POP, 0, locus2, diseaseLocus1, diseaseLocus2);
      DEHaps=getHaps (POP, 1, locus2, diseaseLocus1, diseaseLocus2);
      } 
  originalHaps=getHaps (POP, -1, -1, diseaseLocus1, diseaseLocus2);
      deSamp=new Sampling ( deHaps->size() , false );      dePos=deSamp->getPositionsTable();
      if (test!=3 && test!=0) {dESamp=new Sampling ( dEHaps->size() , false );      dEPos=dESamp->getPositionsTable();}
      DeSamp=new Sampling ( DeHaps->size() , false );      DePos=DeSamp->getPositionsTable();
      if (test!=3 && test!=0) { DESamp=new Sampling ( DEHaps->size() , false );      DEPos=DESamp->getPositionsTable();}
      originalSamp=new Sampling ( originalHaps->size() , false );
      originalPos=originalSamp->getPositionsTable();
if (originalSamp->getPositionsList()->size()!=originalHaps->size()) throw BadFormat(string("ff\n"));
for (int trans=0; trans<2; trans++)
if (found)
{
cont=0;
      while (cont<sampleSize*2 && found) // Meanwhile sample is not completely generated
      {
if (trans==1)
{
        parentHap=multinomial->getNextValue();
        pos2=pParentHapPOP->getPositions (parentHap);
}
        for ( int parent=0; parent<2; parent++ )
          if (found)
          {
            pointerSample=fatherSample;
            if (parent==1) pointerSample=motherSample;
            if (trans==0) found=setSampleUntransmittedHaplotype (pointerSample, originalHaps, oP, cont, originalPos);
 else found=setSampleHaplotype (pointerSample, sample, pos2[parent]/2, pos2[parent]%2, test,  deHaps, dEHaps, DeHaps, DEHaps, deP, dEP, DeP, DEP, cont, dePos, dEPos, DePos, DEPos);
          }
if (trans==1) zaparr(pos2);
      }//end while
}
      zap (sampling);
      zap (deSamp);	zap (dESamp);	zap (DeSamp);	zap (DESamp);	zap (originalSamp); zap (deHaps);	zap (dEHaps);	zap (DeHaps);	zap (DEHaps);
      zap (originalHaps);
      zap (multinomial);
      if (cont<sampleSize*2  || !found)
      {
        zap ( fatherSample );
        zap ( motherSample );
        zap ( sample );
        return;
      }
    }
    catch (OutOfRange<int> ori) {ori.PrintMessage ("getSampleFromPop()");}
    catch (OutOfRange<double> wm) {wm.PrintMessage ("getSampleFromPop()");};
  }
  /*___________________________________________________________________*/

bool SimulationTDT::sameSNPs(intList* row1, intList* row2, int diseaseLocus1, int diseaseLocus2)
{
          for (int i=0; i<row1->size();i++)
					 if (i!=diseaseLocus1 && i!=diseaseLocus2)
{
              if (row1->getElement (i) !=row2->getElement (i) ) return false;
}
return true;
          }
 /*___________________________________________________________________*/

  intList* SimulationTDT::findDifferentUHap(intSample* haps, int& count, int*countPos, intList*rowT, int diseaseLocus1, int diseaseLocus2)
{
// given a transmitted haplotype rowT, it finds an untransmitted haplotype rowU with at least one different SNP
// if not found, it returns null
int result=0, it=0; 
intList* rowU;
// 0: no error, 1: eof, 2: not found
 
          while (1==1)
          {
 					    if (count<haps->size()) {rowU=haps->getElement (countPos[count]); count++;} else return NULL;
          if (!sameSNPs(rowT, rowU, diseaseLocus1, diseaseLocus2)) return rowU;
          count--;
          if (count==haps->size()-1-it) return NULL; 
          change(countPos[count], countPos[haps->size()-1-it]); 
          it++;
          }
}
 /*___________________________________________________________________*/

  bool SimulationTDT::findDifferentUTHaps(intSample* hapsT, int& countT, int*countPosT,
intSample* hapsU, int& countU, int*countPosU, intList*&rowT, intList*& rowU, int diseaseLocus1, int diseaseLocus2)
{
// it finds a pair of trans/ untransmitted haplotypes with at least one different SNP
// if not found, it returns 0, if found it returns 1 
// 0: no error, 1: found
 rowU=NULL;
          while (rowU==NULL)
          {
if (countT==hapsT->size()) return false;
rowT=hapsT->getElement (countPosT[countT]); 
countT++;
rowU=findDifferentUHap(hapsU, countU, countPosU, rowT, diseaseLocus1, diseaseLocus2);
}
return true;
}
 
  /*___________________________________________________________________*/

  void SimulationTDT::getSampleFromStratPop ( BidimensionalTable<bool>* POP, BidimensionalTable<bool>*& sample,BidimensionalTable<bool>*& fatherSample,BidimensionalTable<bool>*& motherSample,int sampleSize, int totalSNPs, int diseaseLocus1, int diseaseLocus2, double mafDPOP,  double recProb, int iniUnlinkedLocus, double pAffDD, double pAffDd, double pAffdd)
  {
// from a stratified population from 2 populations POP1 and POP2, nuclear families with
// one affected offspring are selected by using the following penetrances: (Zhang et al. 2003
//cout <<"\nsample size is:" << sampleSize;
    double maxP=maxi (pAffDD,pAffDd);
    maxP=maxi (maxP, pAffdd);
    double pD=mafDPOP;
    BidimensionalTable<bool> *parentSample;
    sample=new BidimensionalTable<bool> ( sampleSize*2, POP->getYDim() );
    motherSample=new BidimensionalTable<bool> ( sampleSize*2, POP->getYDim() );
    fatherSample=new BidimensionalTable<bool> ( sampleSize*2, POP->getYDim() );
// and sampleSize x pp families are randomly chosen from the first population and sampleSize x (1-pp) from the second one.
    Sampling *DSamp=NULL, *dSamp=NULL;
    intSample* dHaps=NULL, * DHaps=NULL, *hapsT, *hapsU;
    int cont=0, totalMajor, pos, trans, trans2, t, u, fatherTrans, motherTrans,fatherTrans2, motherTrans2, *dPos, *DPos, dP, DP, it, countT, countU, *countPosT, *countPosU;
    intList *rowT, *rowU, *fatherT, *fatherU, *motherU, *motherT, *parentT, *parentU;
    bool affected, found, still, eof=false;
    cont=0;
    dHaps=getHaps (POP, 0, -1, diseaseLocus1, diseaseLocus2);
    DHaps=getHaps (POP, 1, -1, diseaseLocus1, diseaseLocus2);
    DSamp=new Sampling ( DHaps->size() , false );
    dSamp=new Sampling ( dHaps->size() , false );
    DPos=DSamp->getPositionsTable();
    dPos=dSamp->getPositionsTable();
    dP=0; DP=0;
    found=true;
    while (cont<sampleSize*2 && found) // Meanwhile sample is not completely generated
    {
// first find haplotypes with different snps between trans and untrans
      found=true;
affected=false;
      totalMajor=0;
      for ( int parent=0; parent<2; parent++ )
        if (found)
        {
 t=ranbinom (1, pD); 
 u=ranbinom (1, pD);
  if (t==0) {hapsT=dHaps; countT=dP; countPosT=dPos;}
 else  {hapsT=DHaps; countT=DP; countPosT=DPos;}
  if (u==0) {hapsU=dHaps; countU=dP; countPosU=dPos;}
 else {hapsU=DHaps; countU=DP; countPosU=DPos;};
found=findDifferentUTHaps(hapsT, countT, countPosT,hapsU, countU, countPosU, parentT, parentU, diseaseLocus1, diseaseLocus2);
trans=ranbinom (1, 0.5);
trans2=ranbinom (1, recProb);
if (found)
if (trans==trans2) totalMajor=totalMajor+parentT->getElement (diseaseLocus1);
else totalMajor=totalMajor+parentU->getElement (diseaseLocus1);
if (parent==0) {fatherTrans=trans; fatherTrans2=trans2; fatherU=parentU; fatherT=parentT;}
else {motherTrans=trans; motherTrans2=trans2; motherU=parentU; motherT=parentT;}
}
if (found)
        switch ( totalMajor )
        {
          case 2: affected=ranbinom ( 1, (1/maxP) *pAffDD ); break;
          case 1: affected=ranbinom ( 1, (1/maxP) *pAffDd ); break;
          case 0: affected=ranbinom ( 1, (1/maxP) *pAffdd ); break;
        }
        if (affected)
          for ( int parent=0; parent<2; parent++ )
          {
            if (parent==0) {parentT=fatherT; parentU=fatherU; trans=fatherTrans; trans2=fatherTrans2; parentSample=fatherSample;}
            else {parentT=motherT; parentU=motherU; trans=motherTrans; trans2=motherTrans2; parentSample=motherSample;}
            for ( int i=0; i<sample->getYDim();i++ )
            {
              if ( (i<iniUnlinkedLocus && trans==0) || (i>=iniUnlinkedLocus && trans==trans2) )
                sample->setValue ( cont, i, parentT->getElement ( i ) );
              else 	sample->setValue ( cont, i, parentU->getElement ( i ) );
              if (trans==0)
              {
              parentSample->setValue ( cont-parent, i, parentT->getElement ( i ) );
              parentSample->setValue ( cont-parent+1, i, parentU->getElement ( i ) );
              }
              else
              {
              parentSample->setValue ( cont-parent+1, i, parentT->getElement ( i ) );
              parentSample->setValue ( cont-parent, i, parentU->getElement ( i ) );
              }
            }
            cont=cont+1;
          }
    }//end while
    zap (DHaps);
    zap (dHaps);
    if ( cont<sampleSize*2 )
    {
      zap ( sample );
      zap (fatherSample);
      zap (motherSample);
      return;
    }
  }

  /*_____________________________________________________________________________*/

  void SimulationTDT::setInitialPop ( int totalInds, int totalSNPs, int diseaseLocus1, int diseaseLocus2, int test, BidimensionalTable<bool>*& POP, double mafOrig )
  {
//if (test==0) {diseaseLocus1=totalSNPs-2; diseaseLocus2=totalSNPs-1;}
// first generation haplotypes (200) randomly generated from MAF at every marker independently

// MAF for the first generation haplotypes for snps is independently chosen from a uniform distribution over the interval 0.1-0.5.
//cout << "SNP " << j << ": ";
// 50 first generations constant size of 100 individuals (200 haplotypes)
// last 100 generations exponential grow till 10,000 indvs. (20,000 haplotypes):
// lastInd(t)=lastInd x exp(r x t) // r being ln(100)/100
//  Evolution: at any given generation, individual are paired at random.
// #offpsring for a couple follows a Poisson distribution with mean being the exponential growth rate of the current generation

    POP=new BidimensionalTable<bool> ( totalInds*2, totalSNPs );
    double maf;
    for ( int i=0; i<totalInds*2; i++ )
{
      for ( int j=0; j<totalSNPs;j++ )
      {
        if ( j!=diseaseLocus1 && j!=diseaseLocus2 )
        {
          if ( test>0 ) maf=uniform ( 0.1, 0.5 );
          else  maf=mafOrig;
          POP->setValue ( i, j, ranbinom ( 1, maf ) );
        }
        else POP->setValue ( i, j, 0 );
      }
}
  }
  /*_____________________________________________________________________________*/

  double SimulationTDT::getAlleleFreq ( BidimensionalTable<bool>* POP, int position )
{
double freq=0;
  for ( int i=0; i<POP->getXDim();i++ )
        if ( POP->getValue ( i, position ) !=0 ) freq++;
   return freq/POP->getXDim();     
}
  
  /*_____________________________________________________________________________*/

  bool SimulationTDT::testTotalInds ( BidimensionalTable<bool>*& POP, int newTotalInds, int* father, int*mother, int* numberOfChildren )
  {
    if ( newTotalInds==0)
    {
      zap ( POP );
      zaparr ( father );
      zaparr ( mother );
      zaparr ( numberOfChildren );
      return false;
    }
    else return true;

  }

  /*_____________________________________________________________________________*/

  int SimulationTDT::getNumberOfChildren ( int gene, int totalInds, int fatherT, int fatherU, int motherT, int motherU, int chosenAffected, int totalGenerations,  BidimensionalTable<bool>*& POP, int diseaseLocus1, int diseaseLocus2, int test, double mafD, double mafE)
  {
int iniGeneGrowing=50;
int steps=totalGenerations-iniGeneGrowing;
// size grows following exponential function lastSize=totalIndsConstant*growthRate^steps=2^(log2(lastSize/totalIndsConstant)/steps)=(using log10 instead:) 10^0.02=1.047128545


    int totalIndsConstant=100, lastSize=10000;
    double expectedSize=totalIndsConstant;
    double growthRate=std::pow(2,log2(lastSize/totalIndsConstant)/steps);//power(10,0.02);
//cout <<"lll\n";
    if ( gene<50 ) 
return 2*poisson( std::pow(2,log2(expectedSize/totalInds)));
    if (gene==totalGenerations-1) return 1;
   
steps=gene-iniGeneGrowing;

expectedSize=totalIndsConstant*std::pow(growthRate, steps);

// now we have to compute growthrate in order to obtain allele frequencies for disease loci approx. to mafD and mafE respectively
double freqMut1=getAlleleFreq(POP, diseaseLocus1);
double freqMut2=getAlleleFreq(POP, diseaseLocus2);

if (freqMut1==0 || freqMut2==0) 
return 0;

double DDDDprop=std::pow(mafD,4), EEEEprop=std::pow(mafE,4), currentDDDDprop=std::pow(freqMut1,4), currentEEEEprop=std::pow(freqMut2,4);

if (test==0 || test==3) //to ignore differences
{EEEEprop=1;currentEEEEprop=1;}

int trans;
for (int i=0; i<4; i++)
{
switch (i)
{
case 0: trans=fatherT; break;
case 1: trans=fatherU; break;
case 2: trans=motherT; break;
case 3: trans=motherU; break;
}
if (POP->getValue(trans, diseaseLocus1)==0) 
{
DDDDprop=DDDDprop*(1-mafD)/mafD;
if (freqMut1>0) currentDDDDprop=currentDDDDprop*(1-freqMut1)/freqMut1;
}
if (test!=0 && test!=3)
if (POP->getValue(trans, diseaseLocus2)==0) 
{ 
EEEEprop=EEEEprop*(1-mafE)/mafE;
currentEEEEprop=currentEEEEprop*(1-freqMut2)/freqMut2;
}
}
return 2*poisson(expectedSize*DDDDprop*EEEEprop/(totalInds*currentDDDDprop*currentEEEEprop));


  }
  /*_____________________________________________________________________________*/

  void SimulationTDT::chooseParents ( int totalInds,  int*& father, int*& mother )
  {

    Sampling *sampling=new Sampling ( totalInds, false );
    int* positions=sampling->getPositionsTable();
    father=Initialize ( totalInds/2, totalInds );
    mother=Initialize ( totalInds/2, totalInds );
    for ( int i=0; i<totalInds/2;i++ ) // half fathers, half mothers,
    {
      father[i]=positions[i*2];
      mother[i]=positions[i*2+1];
    }
    zap ( sampling );
  }
   /*_____________________________________________________________________________*/

  int* SimulationTDT::getNumberOfChildrenArray ( int totalInds, int gene,int*  father, int* mother, int chosenAffected, int totalGenerations, int &newTotalInds,  BidimensionalTable<bool>*& POP, int diseaseLocus1, int diseaseLocus2, int test, double mafD, double mafE)
  {
    int*numberOfChildren=Initialize ( totalInds/2, 0 );
    newTotalInds=0;
 

    for ( int i=0; i<totalInds/2; i++ ) // for each couple
    {
   numberOfChildren[i]=getNumberOfChildren ( gene, totalInds, father[i]*2, father[i]*2+1, mother[i]*2, mother[i]*2+1, chosenAffected, totalGenerations,  POP, diseaseLocus1, diseaseLocus2, test, mafD, mafE );
    newTotalInds=newTotalInds+numberOfChildren[i];
    }
    return numberOfChildren;
  }
  /*_____________________________________________________________________________*/

  void SimulationTDT::chooseTransmittedHaplotypes ( int& motherT, int& motherU, int& fatherT, int& fatherU, int mother, int father )
  {
    int trans=ranbinom ( 1, 0.5 );
    motherT=mother*2+trans;
    motherU=mother*2+1-trans;
    trans=ranbinom ( 1, 0.5 );
    fatherT=father*2+trans;
    fatherU=father*2+1-trans;
  }

  /*_____________________________________________________________________________*/

  void SimulationTDT::setChildrenHaplotypes ( int parentT, int parentU, BidimensionalTable<bool>* POP, BidimensionalTable<bool>* childrenPOP, double recProb, double recProb2, int position, int iniUnlinkedLocus, int totalSNPs, int gene, int totalGenerations, double mutationRate, int diseaseLocus1, int diseaseLocus2 )
  {
    int outsideBlockRec=ranbinom ( 1, recProb2 ), SNPpos, parentP=0, ini=0, last, mutant;
    intList* recombSNPs=NULL;
    double totalRecs=poisson ( recProb );
    if ( totalRecs>0 )
    {
      recombSNPs=new intList();
      for ( int r=0; r<totalRecs; r++ )
      {
        SNPpos=rand() %iniUnlinkedLocus;
        while ( recombSNPs->findElement ( SNPpos ) !=recombSNPs->end() )
          SNPpos=rand() %iniUnlinkedLocus;
        recombSNPs->insertElement ( SNPpos );
      };
      recombSNPs->order();
      parentP=0; ini=0, last;
 
for ( intList::iterator it=recombSNPs->begin(); it<=recombSNPs->end(); it++ )
      {
        if (it>recombSNPs->begin() ) ini=last;
        if (it<recombSNPs->end() ) last=recombSNPs->getElement (it);
        else last=iniUnlinkedLocus;
        for (int j=ini; j<last; j++)
        {
          if ( parentP==0 ) childrenPOP->setValue ( position, j, POP->getValue ( parentT, j ) );
          else childrenPOP->setValue ( position, j, POP->getValue ( parentU, j ) );
}
        parentP=1-parentP;
      }
      parentP=1-parentP;
      zap ( recombSNPs );
   }
    else for ( int j=0;j<iniUnlinkedLocus; j++ ) childrenPOP->setValue ( position, j, POP->getValue ( parentT, j ) );
    for ( int j=iniUnlinkedLocus;j<totalSNPs; j++ )
      if ( outsideBlockRec==parentP ) childrenPOP->setValue ( position, j, POP->getValue ( parentT, j ) );
      else childrenPOP->setValue ( position, j, POP->getValue ( parentU, j ) );



// mutations
    for ( int j=0;j<totalSNPs; j++ )
      if ( j!=diseaseLocus1 && j!=diseaseLocus2)
      {
        mutant=ranbinom ( 1, mutationRate );
        if ( mutant )
          if ( childrenPOP->getValue ( position, j ) ==0 )
            childrenPOP->setValue ( position, j, 1 );
      }

  }
  	/*_____________________________________________________________________________*/

  void SimulationTDT::setHaplotypes ( int totalInds, int* numberOfChildren, int totalGenerations, int gene, int iniUnlinkedLocus, BidimensionalTable<bool>* POP, BidimensionalTable<bool>* childrenPOP, double recProb, double recProb2, int* father, int* mother, double mutationRate, int diseaseLocus1, int diseaseLocus2, int totalSNPs)
  {
    int fatherT, fatherU, motherT, motherU;
    int cont=0;
    for ( int i=0; i<totalInds/2; i++ ) // for each couple
    {
      for ( int c=0; c<numberOfChildren[i]; c++ ) // for each child
      {
        chooseTransmittedHaplotypes ( motherT, motherU, fatherT, fatherU, mother[i], father[i] );
        setChildrenHaplotypes ( fatherT, fatherU, POP, childrenPOP, recProb, recProb2, cont, iniUnlinkedLocus, totalSNPs, gene, totalGenerations, mutationRate, diseaseLocus1, diseaseLocus2 );
        setChildrenHaplotypes ( motherT, motherU, POP, childrenPOP, recProb, recProb2, cont+1, iniUnlinkedLocus, totalSNPs, gene, totalGenerations, mutationRate, diseaseLocus1, diseaseLocus2 );
        cont=cont+2;
      } // for each child
    } // for each couple
  }
  /*_____________________________________________________________________________*/

  void SimulationTDT::setPop ( int totalGenerations, int totalSNPs, int totalInds, int test, double mafD, double mafE, BidimensionalTable<bool>*& POP, double &freqMut1, double &freqMut2, int diseaseLocus1, int diseaseLocus2, int iniUnlinkedLocus, double recProb, double recProb2, double mutationRate, double margin )
  {
    BidimensionalTable<bool>* childrenPOP=NULL;
    int *numberOfChildren=NULL, *father=NULL, *mother=NULL, cont, chosenAffected,  newTotalInds;
    setInitialPop ( totalInds, totalSNPs, diseaseLocus1, diseaseLocus2, test, POP, mafD );
totalGenerations=150;
    for ( int gene=1; gene<totalGenerations;gene++ )
    {

      if ( gene==50 )
      {
        chosenAffected=rand() % ( totalInds*2 );
        POP->setValue ( chosenAffected, diseaseLocus1, 1 );
        POP->setValue ( chosenAffected, diseaseLocus2, 1 );
      }
freqMut1=getAlleleFreq(POP, diseaseLocus1);
freqMut2=getAlleleFreq(POP, diseaseLocus2);
      chooseParents ( totalInds, father, mother );
      numberOfChildren=getNumberOfChildrenArray ( totalInds, gene, father, mother, chosenAffected, totalGenerations, newTotalInds, POP, diseaseLocus1, diseaseLocus2, test, mafD, mafE );
     if ( testTotalInds ( POP, newTotalInds, father, mother, numberOfChildren ) ==false ) return;
      childrenPOP=new BidimensionalTable<bool> ( newTotalInds*2, totalSNPs );

 setHaplotypes ( totalInds, numberOfChildren, totalGenerations, gene, iniUnlinkedLocus, POP, childrenPOP, recProb, recProb2, father, mother, mutationRate, diseaseLocus1, diseaseLocus2, totalSNPs );
      totalInds=newTotalInds;
      zaparr ( father );
      zaparr ( mother );
      zap ( POP );
      POP=childrenPOP;
      zaparr ( numberOfChildren );
    } // end for each generation

    if ( totalInds<totalGenerations ) {zap ( POP );}
  }


} // end namespace  BIOS


