/* File: UndirectedBN.h */


#ifndef __UndirectedBN_h__
#define __UndirectedBN_h__









//using namespace std;

namespace BIOS {


/************************/
/* UndirectedBN DEFINITION */
/************************/


/**
        @memo UndirectedBN 

	@doc

    @author Maria Mar Abad Grau
	@version 1.0
*/


class Node;

	 class UndirectedBN {


     private:

 
	  intMLSample* sample;
	  
		VerbosityClass* verbosity;
	  

    int totalAttributes, totalSelectedAttributes;

  CPT** probTables;
          
          intList** commonConditionals;
          
          NodeSet* getNodeList();



 

  JunctionTree* junctionTree;

	  PotentialList* createPotential (Set<Node>* varList, bool isSeparator, intList** remainingParents=NULL, int cliqueNumber=-1);

	  PotentialList* createPotentialSeparator (intList* varList);
	  
	  void marginalizeSeparator(JunctionTree* junctionTree2, DirectedSeparatorOfCliques* separator, SetOfCliques::iterator cliqueSource, intList* inputPattern);
	
	 
	  PotentialList* addRelativePotentials (intList* commonVars, SetOfCliques::iterator firstClique, SetOfCliques::iterator secondClique);


	  PotentialList* createPotentialClique (intList* varList, intList** remainingParents);
	
	  void setJunctionTreePontentials();
	  
	  SimpleDAG* getDAG(); 

	  void setPotentials(int classPosition);

void finalUpdate(JunctionTree* junctionTree2, DirectedSeparatorOfCliques* separator, SetOfCliques::iterator pointer1, SetOfCliques::iterator pointer2, intList* inputPattern);


	 protected:

		   void updateEvidence(JunctionTree* junctionTree2, SetOfCliques::iterator pointer, bool collect, intList* inputPattern) ;
 
 Set<intList*>* getRelativeVarPotentials (intList* commonVars, SetOfCliques::iterator firstClique, SetOfCliques::iterator secondClique);
 

        float alpha;
	
	    void removeInconsistenciesWithEvidence(int att, intList* inputPattern, JunctionTree* junctionTree2);

		intList** parents; // it is an array of pointers to lists of integers



		void setJunctionTreePotentials();


      /* PUBLIC FUNCTIONS (INTERFACE) */


      public:
		void setJunctionTree();

		double* getPosteriorProb(int attribute, intList* inputPattern); 
  
  		JunctionTree* getJunctionTree();
 	
  		UndirectedBN();

	    UndirectedBN(intMLSample* sample, float alpha, intList** parents,   CPT** probTables, VerbosityClass *verbosity);

		//void report();

		
		void set();

		~UndirectedBN();

void setJunctionTreeNB(int classPosition);


void setJunctionTreeTAN(int classPosition);

	  



	
};  // End of class UndirectedBN



};  // Fin del Namespace

#endif
