/* File: UndirectedBN.h */


#ifndef __UndirectedBN_h__
#define __UndirectedBN_h__









//using namespace std;

namespace BIOS {


/************************/
/* UndirectedBN DEFINITION */
/************************/


/**
        @memo UndirectedBN 

	@doc

    @author Maria Mar Abad Grau
	@version 1.0
*/


	 class UndirectedBN {


     private:

 
	  intMLSample* sample;
	  
	  Set<Node>* nodeList;
	  
	  Set<Clique>* cliques;

    int totalAttributes, totalSelectedAttributes;
          
          void setNodeList();

	  Tree<Separator, Clique>* junctionTree;

	  PotentialTable* createPotential (Set<Node>* varList, bool isSeparator);

	  PotentialTable* createPotentialSeparator (intList* varList);

	  PotentialTable* createPotentialClique (intList* varList);
	
	  void setJunctionTreePontentials();
	  
	  DAG<DirectedArc<Node>, Node>* setDAG(); 

	  void setPotentials();

void finalUpdate(Tree<Separator,Clique>* junctionTree2, Separator* separator, Clique* clique1, Clique* clique2);


	 protected:

		   void updateEvidence(Tree<Separator,Clique>* junctionTree2, Clique* pointer, bool collect);


        float alpha;
	
	    void removeInconsistenciesWithEvidence(int att, intList* inputPattern, Tree<Separator,Clique>* junctionTree2);

		intList** parents; // it is an array of pointers to lists of integers

		void setJunctionTree();

		void setJunctionTreePotentials();


      /* PUBLIC FUNCTIONS (INTERFACE) */


      public:

		double* getPosteriorProb(int attribute, intList* inputPattern);
  
  		Tree<Separator, Clique>* getJunctionTree();
 	
  		UndirectedBN();

	    UndirectedBN(intMLSample* sample, float alpha, intList** parents);
		
		void set();

		~UndirectedBN();
	  



	
};  // End of class UndirectedBN



};  // Fin del Namespace

#endif
