/***************************************************************************
 *   Copyright (C) 2007 by M. Mar Abad Grau and Paola Sebastiani	   *	
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This file is part of Genics.					   *
 *   Genics is free software; you can redistribute it and/or modify  	   *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with Genics; if not, see <http://www.gnu.org/licenses/>.        *
 ***************************************************************************/

#ifndef __Genics_cpp__
#define __Genics_cpp__

#include "MI.h"//

namespace BIOS
{

void error(char *argv[])
{
 cerr << "Error: you have to especify the following information:" << endl;
        cerr  << argv[0] << " <source file> " <<" <missing imputation method (1: NB1 with MDL_GA; 2: NB1 with Bayes_GA; 3: C4.5 with MDL_GA; 4: C4.5 with Bayes_GA)>"  << endl;
	cout <<"\nThe source file must be a text file with extension \".all\" and rows representing  instances. Values for each instance must be separated by either a blank character or a comma. Missing values must be represented by a question mark (?)";	


        end();
}

  /*_________________________________________________________________________*/

MI::MI(int argc, char *argv[])
{
if(argc!=3) error(argv);
     
char fileSample[256], outputFile[256];
int method;


 strcpy (fileSample, argv[1]);
 
 method=atoi(argv[2]); 

 if (method<1 || method > 4) error(argv);

 floatList* selection=new floatList(), *algorithmParameters=new floatList(), *discretization=new floatList();
 SelMode selMode;
bool stochastic=true;
SelSubmodeClass selSubmodeClass=SelSubmodeClass();
 
switch (method)
{
case 1: // NB1 with MDL_GA
case 3: // 4.5 with MDL_GA
selMode=oneByOneMDL;
selection->insertElement(0);
selection->insertElement(0);
break;
case 2: // NB1 with Bayes_GA
case 4: // C4.5 with Bayes_GA
selMode=oneByOneBayesScore;
selection->insertElement(1);
selection->insertElement(1);
break;
}

DiscMode discMode=PEPEME;
AlgType algType;
switch (method)
{
case 1: // NB1 with MDL_GA
case 2: // NB1 with Bayes_GA
algType=aNB;
algorithmParameters->insertElement(0); 
algorithmParameters->insertElement(0);
algorithmParameters->insertElement(1);
algorithmParameters->insertElement(1);
break;
case 3: // 4.5 with MDL_GA
case 4: // C4.5 with Bayes_GA
algType=aC45;
algorithmParameters->insertElement(4);
break;
}

switch (method)
{
case 1: // NB1 with MDL_GA
cout   << "\nAlgorithm NB1 with MDL_GA will be used for missing data imputation";
break;
case 2: // NB1 with Bayes_GA
cout   << "\nAlgorithm NB1 with Bayes_GA will be used for missing data imputation";
break;
case 3: // 4.5 with MDL_GA
cout   << "\nAlgorithm C4.5 with MDL_GA will be used for missing data imputation";
break;
case 4: // C4.5 with Bayes_GA
cout   << "\nAlgorithm C4.5 with Bayes_GA will be used for missing data imputation";
break;
}


TestMode testMode=tTraining;  


floatSample* completedSample=NULL;
ifstream InputFile;
ClassifierTest *classifierTest=NULL;
LossFunction* lossFunction;
floatMLSample* sample=NULL, *testSample=NULL; 
ListOfAttributes* listOfAttributes=NULL;
ClassificationResults* currentTasaAciertos;


strcpy(outputFile, fileSample);
ofstream OutputFile;
strcat(outputFile, "Completed");
OpenOutput(outputFile, &OutputFile);



VerbosityClass verbosity=VerbosityClass();
verbosity.verbosityR.completeSample=true;

listOfAttributes=new ListOfAttributes(fileSample, verbosity);
int classPosition=0;
sample=new floatMLSample(fileSample, verbosity);
bool noSelection=true;
CompleteMissing* completeMissing=NULL;
completeMissing=new CompleteMissing(sample->sample);



for (int currentClass=0;currentClass<listOfAttributes->GetSize();currentClass++)
{  

lossFunction=new LossFunction(false, listOfAttributes->GetElement(currentClass)->GetTotalModalidades(), fileSample);


classifierTest=new ClassifierTest(sample, NULL, NULL, testMode, 0, verbosity, currentClass, lossFunction);

currentTasaAciertos=classifierTest->getAveragedAccuracy(algType, discMode, algorithmParameters, discretization, selMode, selection, selSubmodeClass.selectionFile, stochastic);



 completeMissing->completeAttribute(currentClass, classifierTest->completedClasses);



zap(classifierTest);
zap(lossFunction);
//if (inputTUI->verbosity.verbosityR.progress)
cout   << "\nMissing data for attribute " << currentClass+1 << " has been imputed";
}

end();

zap(listOfAttributes);
zap(sample);



OutputFile << *completeMissing->completedSample  << "\n";
zap(completeMissing);
OutputFile.close();
cout <<"\nResults have been saved in file " << outputFile <<"\n";


};

}

using namespace BIOS;

int main(int argc, char *argv[])
{

  MI *genics;

  genics=new MI(argc, argv);

};



#endif




