/* File: Arc.h */


#ifndef __Arc_h__
#define __Arc_h__



using namespace std;


namespace BIOS
{
  /************************/
  /* Arc DEFINITION */
  /************************/


  /**
          @memo Arc 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */
  template <class T, class U=int> class Arc
  {


   typedef  typename Set<T>::Class::iterator PNode;



  


    protected:
    
   

    float weight;
    PNode first;
    PNode second;
    U* description; 
    bool directed;

  public:


   // Arc(){this->first; this->second; weight=0;};

    void set (float w, PNode f, PNode s, U* description=NULL){this->weight=w; this->first=f; this->second=s; this->description=description; directed=false;};

    Arc(float w, PNode f, PNode s, U* description=NULL) {set(w, f, s, description); directed=false;};
    Arc(Arc<T, U> & a)
    {
      set(a.weight, a.getFirst(), a.getSecond(), a.getDescription()); directed=false;
    };
  /*   Arc(Arc<T> & a, PNode p1, PNode p2)
    {
     set(a.weight, p1, p2);
    };
*/
 virtual ~Arc(){this->empty();};
    void empty(){zap(description);};
    PNode getFirst(){return this->first;};
    PNode getSecond(){return this->second;};
   
    float getWeight(){return this->weight;};
		U* getDescription(){return this->description;};
    void setFirst(PNode f){this->first=f;};
    void setSecond(PNode s){this->second=s;};
    void setWeight(float w){this->weight=w;};
		void setDescription(U* description){this->description=description;};
    void invertNodes(){change(this->first, this->second);};
    bool isDirected(){return directed;};
    virtual bool operator==(Arc & arc)
    {
      return ((arc.first==this->first && arc.second==this->second)
             || (arc.first==this->second && arc.second==this->first))
	     && arc.weight==this->weight;
    };




bool hasSameNodes(Arc * arc, bool anyway)
{
if (anyway) return this->Arc<T, U>::hasSameNodes(arc); // (static link)
else return this->hasSameNodes(arc);// virtual (dynamic link)
};

  virtual bool hasSameNodes(Arc * arc)
    {
      return (arc->first==this->first && arc->second==this->second)
             || (arc->first==this->second && arc->second==this->first);
    };


    /*____________________________________________________________________________________ */
    /*
        bool hasSameOrderedNodes(Arc<T> * arc)
        {
          if (arc->first==this->first && arc->second==this->second) return true;
          else return false;
        }
        /*____________________________________________________________________________________ */

    bool hasNode(PNode node)
    {
      if (this->first==node || this->second==node) return true;
      else return false;
    }

    /*____________________________________________________________________________________ */

    bool operator>(Arc & a)
    {
      return (this->weight > a.weight);
    };
    /*____________________________________________________________________________________ */

    bool operator<(Arc & a)
    {
      return (this->weight < a.weight);
    };
  
/*____________________________________________________________________________________ */

    string print()
    {
      string result;
      char line[50];

      sprintf(line, "%2.4f\0", this->weight);
      result=string(line);
      return result;
    }

int size()
{
//cout <<"no sense";
return 0;
}


/*________________________________________________________________________________________*/

Arc* fromString (string source)
{
throw NonImplemented("Arc::fromString (string source)");
 };



  };  // End of class Arc


/*______________________________________________________*/

   template <class T, class U> ostream& operator<<(ostream& out, Arc<T, U>& p)
{
	out << "first element: " << *p.getFirst();
out << "second element: " << *p.getSecond();
	out <<"weight: " << p.getWeight()  <<"\n";;
	return out;
}

class Node;
typedef Arc<Node*, void>* SimpleArc;
};  // Fin del Namespace

#endif

/* Fin Fichero: Arc.h */
