#ifndef ClassifierTest_cpp//
#define ClassifierTest_cpp//


#include "ClassifierTest.h"



//using namespace UTILS;

namespace BIOS {


/*___________________________________________________________ */
/*
template<class T, class U> ClassifierTest<T, U>::ClassifierTest(char filenam[128], intList*parameterL=NULL)
{
strcpy(filename, filenam);
clase=dependiente;
parameterList=parameterL;
sample=new list<list<U> >(filename);
sampleSize=testMLSample->size();

};
/*___________________________________________________________ */

ClassifierTest::ClassifierTest(char filename[256], TestMode testMod, int numberOfFolds)
{

trainingSample=NULL;
listOfAttributes=NULL;
sample=NULL;
classAttribute=NULL;

strcpy(this->filename, filename);
testMode=testMod;

this->numberOfFolds=numberOfFolds;

char fileTraining[256], fileMas[256];
ChangeExtension(filename, fileMas, "mas");
ChangeExtension(filename, fileTraining, "data");

listOfAttributes=new ListOfAttributes(filename);
if (strcmp(filename, fileTraining)==0) 
{
trainingSample=new floatMLSample(fileTraining, listOfAttributes, NULL);
testMode=tHoldout;
}
else
if (testMode==tHoldout)
{
testMode=tCrossValidation;
this->numberOfFolds=2;
}
sample=new floatMLSample(filename, listOfAttributes, NULL);
clase=sample->GetPointerToElement(sample->getFirst())->size()-1;
sampleSize=sample->size();
classAttribute=(ClassAttribute*)listOfAttributes->GetPointerToElement(clase);
};

/*___________________________________________________________ */

Pair<double> ClassifierTest::GetAveragedAccuracy(AlgType algType, DiscMode discMod, SelMode selMode, floatList* algorithm, floatList* discretization, intList*selection)
{


Pair<double> accuracy;
//

//cout << testMode;
switch(testMode)
{
case tLeaveOneOut: accuracy=LeaveOneOut(algType, discMod, selMode, algorithm, discretization, selection); break;
case tCrossValidation: accuracy=CrossValidation(algType, discMod, selMode, algorithm, discretization, selection); break;
case tHoldout: 
accuracy=Holdout(trainingSample, sample, algType, discMod, selMode, algorithm, discretization, selection); break;
case tTraining: accuracy=Training(algType, discMod, selMode, algorithm, discretization, selection); break;
}


return accuracy;
};
/*___________________________________________________________________*/

ClassifierTest::~ClassifierTest()
{ 
//	if (trainingSample==NULL) cout <<"trainisNULL";
//		if (sample==NULL) cout <<"sampleisNULL";
//	if (listOfAttributes==NULL) cout <<"listOfAttributesisNULL";

zap(trainingSample);
zap(sample);
//	if (listOfAttributes==NULL) cout <<"listOfAttributesisNULL";

zap(listOfAttributes);

};
/*____________________________________________________________________________________ */

Pair<double> ClassifierTest::CrossValidation(AlgType algType, DiscMode discMod, SelMode selMode, floatList* algorithm, floatList* discretization, intList*selection)
{
Pair<double> accuracy;
int aciertos=0, foldSize, resto, last;
floatMLSample*testSample=NULL, *trainingSample=NULL;
char fileTest[128], fileTraining[128];
Pair<double> tasaAciertos[numberOfFolds];
resto=sampleSize%numberOfFolds;
 last=0;
 Sampling *sampling;
 sampling=new Sampling(sampleSize, false);

//cout <<sampleSize;

for (int i=0;i<numberOfFolds;i++)
 {
 foldSize=sampleSize/numberOfFolds;
 if ((resto>0) && (i<resto)) foldSize=foldSize+1;
 long int indexVector[foldSize];
 for (int j=0;j<foldSize;j++) 
{
  indexVector[j]=sampling->Pos[i*foldSize+j];
//cout <<"\n" << indexVector[j];
}
 trainingSample=new floatMLSample(*sample);

testSample=(floatMLSample*)trainingSample->ExtractList(indexVector, foldSize);
//cout <<trainingSample->size();
//cout << testSample->size();
 
tasaAciertos[i]=Holdout(trainingSample, testSample, algType, discMod, selMode, algorithm, discretization, selection);
//cout << trainingSample->print();

//exit(0);
zap(trainingSample);
zap(testSample);
//if (testSample->List!=NULL) testSample->destroy(testSample->List);
//exit(0);
  }
zap(sampling);
 accuracy.First=GetMean(tasaAciertos, numberOfFolds);
//exit(0);
 accuracy.Second=GetMean(tasaAciertos, numberOfFolds, false);
return accuracy;
}
/*____________________________________________________________________________________ */

Pair<double> ClassifierTest::Holdout(floatMLSample* trainingSample, floatMLSample* testSample, AlgType algType, DiscMode discMod, SelMode selMode, floatList* algorithm, floatList* discretization, intList*selection)
{

	//MLSample<U>* testMLSample;
Pair<double> accuracy;

//accuracy=new Pair<double>();

//listOfAttributes->print();
listOfAttributes->selectAll();

if (selection->getFirst()==NULL)
 listOfAttributes->select(trainingSample, selMode);
else listOfAttributes->select(selection);
 

 listOfAttributes->removeIntervals();
 listOfAttributes->setIntervals(trainingSample, discMod);


Classifier* classifier=NULL;


switch (algType)
{
case aNB:  classifier=new NB (trainingSample, classAttribute, algorithm); break;
case aTAN: classifier=new TAN(trainingSample, classAttribute, algorithm); break;
case aC45: classifier=new C45(filename, trainingSample, classAttribute); break;
case aNN: classifier=new KNN(trainingSample, classAttribute, algorithm); break;
case aContinuousC45: classifier=new C45(filename, trainingSample, classAttribute, algorithm); break;
}

//cout <<"\n" << selection->print(); 

//testSample->HardCopy("c", listOfAttributes, true);

float num;
num=classifier->GetMatches(testSample);
cout <<"num" << num;
accuracy.First=num/testSample->size();
accuracy.Second=0;



//testSample->HardCopy("mm", listOfAttributes, true);
//trainingSample->HardCopy("tt", listOfAttributes, true);
//cout <<"\nacc:" << accuracy.First;
//cout <<"num:" << num;
//cout <<"sampleTrainingsize:" << trainingSample->size();
//cout <<"samplesize:" << testSample->size();

//cout<<"\n";
//exit(0);

  
zap(classifier);
//exit(0);
return accuracy;
}
/*____________________________________________________________________________________ */

Pair<double> ClassifierTest::Training(AlgType algType, DiscMode discMod, SelMode selMode, floatList* algorithm, floatList* discretization, intList*selection)
{
floatMLSample* sample2=NULL;
sample2=new floatMLSample(*sample);
Pair<double> p;
p=Holdout(sample, sample2, algType, discMod, selMode, algorithm, discretization, selection);
zap(sample2);
return p;
}

/*____________________________________________________________________________________ */

Pair<double> ClassifierTest::LeaveOneOut(AlgType algType, DiscMode discMod, SelMode selMode, floatList* algorithm, floatList* discretization, intList*selection)
{
numberOfFolds=sampleSize;
return CrossValidation(algType, discMod, selMode, algorithm, discretization, selection);
}
/*____________________________________________________________________________________ */

char* ClassifierTest::print()

{
  switch (testMode) //
  { //
   case tLeaveOneOut: strcpy(line, "Leave one out"); break;  //
   case tCrossValidation: strcpy(line, "CrossValidation"); sprintf (line, "%s fold=%d", line, numberOfFolds);break; //
   case tHoldout: strcpy(line, "Holdout"); break; //
   case tTraining: strcpy(line, "Training"); break; //
     } //
return line;
}
/*____________________________________________________________________________________ */

char* ClassifierTest::printAlgType()
{
return line2;
}

} // end namespace
#endif
