/* File: Clique.cpp */


#ifndef __Clique_cpp__
#define __Clique_cpp__

using namespace std;

namespace BIOS
{

  /************************/
  /* Clique DEFINITION */
  /************************/

  /**
          @memo Clique 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */
  

//class ProbabilityTable;
    
    Clique::Clique():NodeSet()
	{
		potentialList=NULL;
	};

/*________________________________________________*/

    Clique::Clique (Clique& clique):NodeSet(clique)
	{
if (&clique==NULL) return;
	if (clique.potentialList==NULL)
		this->potentialList=NULL;
else
{
	setPotentialList(clique.potentialList);
} 
	};
/*________________________________________________*/

    Clique::Clique (NodeSet& group):NodeSet(group)
	{
	potentialList=NULL;
	};
/*________________________________________________*/
	
    Clique::~Clique(){zap(potentialList);};
/*________________________________________________*/

    Clique* Clique::clone()
	{
	return new Clique(*this);
	};
/*________________________________________________*/

    bool Clique::operator== (Clique& group)
	{
return ((Set<Node*>::Class&)*this==(Set<Node*>::Class&) group);
	};

/*________________________________________________*/
	/*
    template <> SetOfCliques::~Container()
    {
cout <<"HERESETOFCLIQUESAREDESTROYED";
for (SetOfCliques::iterator it1=begin(); it1!=end(); it1++)
{
cout <<"INSIDE\n";
cout <<"clique is:" << **it1 <<"\nletsee\n";
zap((Clique*&)*it1);
}
    };


/*________________________________________________*/

	void Clique::setPotentialList(PotentialList* potentialList)
    {
if (potentialList==NULL)
throw NullValue("Clique::setPotentialList(PotentialList* potentialList)");
       this->potentialList=new PotentialList(*potentialList);
  }
/*________________________________________________*/
    
	PotentialList* Clique::getPotentialList()
    {
      return potentialList;
    }
	
 /*
________________________________________________________________________________
____*/
 
 double* Clique::getProbs(intList* selectedAtts)
  {
if (potentialList==NULL) return NULL;
PotentialTable* pt=potentialList->productTable(), *pt2;
pt2=pt->marginalize(selectedAtts);
double *result=new double[pt2->getSize()];//pt2->getSize()];

if (pt2->getTotalCounts()==0)
{
for (int i=0;i<pt2->getSize();i++)
result[i]=1/(double)pt2->getSize();
zap(pt);
zap(pt2);
return result;
}
try
{
pt2->normalize();
}
catch (ZeroValue &zv)
{
cout <<"pt2 is" << *pt2 <<"\n";
zv.addMessage("\ncalled from Clique::getProbs(intList* selectedAtts)"); throw;
};
zap(pt);
for (int i=0;i<pt2->getSize();i++)
result[i]=pt2->getValue(&i);
zap(pt2);
return result;

}
/*_________________________________________________________________________________*/

//template <template <class, class> class Cont2, class T2, template<class> class STL2B> 
// template<> 
//template <template <class, class> class Cont, class T, template<class> class STL2> 
/*
template<>
template<> 
Container<set, Clique*, std::less>::iterator Container<set, Clique*, std::less>::findElementContainingInternalElement(Node* internalNode)
{
return Container<set, Set<Node*>::Class*, std::less>::findElementContainingInternalElement(internalNode);
}
 /*
________________________________________________________________________________
____*/
 

 /*
ProbabilityTable* marginalize(intList* vars, intList* inputPattern,
ListOfAttributes* listOfAttributes, PotentialList::iterator p=NULL,
PotentialList::iterator p2=NULL)
{
 if (getPotential()==NULL) return NULL;
 
if (p==NULL && p2==NULL) 
{
p=getPotential()->getFirst();
p2=getPotential()->GetLast();
}
if (p==NULL || p2==NULL)
{
cout <<"Error in UndirectedBN::marginalize";
end();
}

intList*
extendedVarlist2=vars->copyElementsIn(getPotential()->getElement(p)->varList),
*extendedVarlist;
extendedVarlist=getPotential()->getElement(p)->addMissingVarList(
extendedVarlist2, inputPattern, listOfAttributes);
zap(extendedVarlist2);
ProbabilityTable* pT, *pT2, *pT3;

if (p!=p2)
{
pT=marginalize(extendedVarlist, inputPattern, listOfAttributes,
getPotential()->getNext(p), p2);
//zap(extendedVarlist);
pT2=*getPotential()->getElement(p)*pT;
zap(pT);
 if (p==getPotential()->getFirst())
 {
cout <<"b" <<*extendedVarlist;
pT=pT2->marginalize(vars);
zap(pT2);
pT2=pT;
}
return pT2;
}
else 
{

pT=new ProbabilityTable(*getPotential()->getElement(p));

if (!pT->varList->includes(extendedVarlist))
{

intList* dimensionList=listOfAttributes->getDimensionList(extendedVarlist);
//cout <<"alpha:" <<  getPotential()->getElement(p)->alpha <<"\nvarlist:" <<
*extendedVarlist <<", \ndimlist:" << *dimensionList;
pT3=new ProbabilityTable(extendedVarlist, dimensionList,
getPotential()->getElement(p)->alpha);
//cout <<"yes\n";
 //  end();
pT3->initialize(1);

pT2=*pT3*pT;

zap(pT3);
zap(pT);
pT=pT2;
zap(dimensionList);
}
//cout <<"here";
 //  end();
cout <<"g";
pT2=pT->marginalize(extendedVarlist);
zap(pT);
zap(extendedVarlist);
return pT2;
}
}
 class Clique
*/


   /*______________________________________________________*/


template <>
template <class U>   
SetOfCliques::iterator SetOfCliques::findElementContainingInternalElement(U element)
{
throw NonImplemented("SetOfCliques::iterator SetOfCliques::findElementContainingInternalElement(U& element)");
cout << "this is eqwuivalent to Container function findElementContainingEqualInternalElement, please call to that function and remove this\n";
Clique * clique;
for (SetOfCliques::iterator p=this->getFirst();p!=this->end();p++)
{
clique=*p;
for (Clique::iterator p2=clique->getFirst();p2!=clique->end();p2++)
	if (**p2==*element) return p;
}
return this->end();
//return this->at(position);
//return this->getElement(this->getNode(position));
};


   /*______________________________________________________*/

ostream& operator<<(ostream& out, Clique& p)
{
out << (Set<Node*>::Class&) p <<"\n";
//   out << p.Set<Node>::print();
   if (p.getPotentialList()!=NULL)
    out << "\nPotentials:\n" << *p.getPotentialList();

	return out;
}



};  // Fin del Namespace

#endif

/* Fin Fichero: Clique.h */
