/* File: CompleteGraph.cpp */


#ifndef __CompleteGraph_cpp__
#define __CompleteGraph_cpp__

//using namespace UTILS;

namespace BIOS
{
  /************************/
  /* CompleteGraph DEFINITION */
  /************************/
  /**
          @memo CompleteGraph 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */

template <template<class T, class U> class Link, class T, class U> CompleteGraph<Link, T, U>::CompleteGraph():Graph<Link, T, U>(){};

template <template<class T, class U> class Link, class T, class U> CompleteGraph<Link, T, U>::~CompleteGraph(){};


template <template<class T, class U> class Link, class T, class U> void CompleteGraph<Link, T, U>::insertElement(Link<T, U>* arc)
  {

    cout <<"Error, arc insertion is not allowed in CompleteGraph::insertElement";
    end();
  }
  
  /*_________________________________________________________________*/

template <template<class T, class U> class Link, class T, class U> void CompleteGraph<Link, T, U>::insertNode(T node, floatList* weightList)
  {
    if (existNode(node))
    {
      cout <<"Error, node already exists in CompleteGraph::insertNode";
      end();
    }
     if (this->nodes==NULL) this->nodes=new typename Set<T>::Class::Container();
        if (weightList->size()!=this->nodes->size())
    {
      cout <<"error in CompleteGraph::insertNode, there are " << weightList->size() << " weights and " << this->nodes->size() << " nodes";
      end();
    }
    float weight;
    this->nodes->insertElement(node);
    typename Set<T>::Class::iterator p=this->nodes->getFirst(), p2;
    typename floatList::iterator pW=weightList->getFirst();

    Link<T, U>* arc=NULL;
    p2=this->nodes->getLast();

    while (p!=p2 && pW!=weightList->end())
    {
      weight=weightList->getElement(pW);
      arc=new Link<T, U>(weight, p, p2);
      if (existArc(arc)==true)
      {
        cout <<"Error, arc " << *arc << " already exists in CompleteGraph::insertNode:";
        cout << *this;
        end();
      };
      UGraph<T,U>::Class::insertElement(arc);
      zap(arc);
      p=this->nodes->getNext(p);
      pW=weightList->getNext(pW);
    }
  };
  
  //     template<class T, class U> void CompleteGraph<T,U>::insertNode(U* node, floatList* weightList, ListOfPointers<intList >* separationLists);


  /*_________________________________________________________________*/

template <template<class T, class U> class Link, class T, class U> typename UTree<T, U>::Class* CompleteGraph<Link, T, U>::getMWST()
  {
    //Kruskal algorithm

    typename Set<T>::Class::iterator pN=this->nodes->getFirst(), pN1, pN2;
    typename Set<T>::Class* bag=NULL;
   Link<T, U>* arc=NULL, *newArc=NULL;
    typename UTree<T, U>::Class::iterator p;
    T first, second;
    struct SetSample<T>::Class::iterator pBag1, pBag2;
    bool found;

// It creates a temporal mWST and result mWST with no nodes
    typename UTree<T, U>::Class *mWST=new typename UTree<T, U>::Class::AcyclicGraph();
    typename UTree<T, U>::Class *newMWST=new typename UTree<T, U>::Class::AcyclicGraph();

//    this->sortPointer(false); // descendent order
    // It creates a bag of bags, each bag starting with one node of the current graph
cout <<" da error linea this->sortPointer(false); arreglar\n";
    struct SetSample<T>::Class* bags2;
    struct SetSample<T>::Class* bags;//=new typename Sample<vector, vector, T>::Sample();
    while(pN!=this->nodes->end())
    {
      bag=new typename Set<T>::Class::Container();
      bag->insertElement(this->nodes->getElement(pN));
      bags->insertElement(bag);
      pN=this->nodes->getNext(pN);
    };


// It finds whether there is an arc with nodes not in mWST and add nodes to it. If they are in different bags, it creates an arc for mWST and bags are joined. The process is repeated this->nodes->size() times.
    for (int i=0;i<=this->nodes->size();i++)
    {
      p=this->getFirst();
      found=false;
      while (p!=this->end() && !found)
      {
        arc=this->getElement(p);
        pN1=arc->getFirst();
        pN2=arc->getSecond();
				first=this->nodes->getElement(pN1);
 				second=this->nodes->getElement(pN2);
        if (mWST->size()==0 || mWST->nodes->findElement(first)!=mWST->nodes->end() || mWST->nodes->findElement(second)!=mWST->nodes->end()) // review
        {
          if (mWST->nodes->findElement(first)==mWST->nodes->end())
            mWST->nodes->insertElement(first);
          if (mWST->nodes->findElement(second)==mWST->nodes->end())
            mWST->nodes->insertElement(first);
           pBag1=bags->findElementContainingInternalElement(this->nodes->getElement(pN1));
          pBag2=bags->findElementContainingInternalElement(this->nodes->getElement(pN2));

          if (pBag1==bags->end() || pBag2==bags->end())
          {
            cout <<"error in CompleteGraph::getMWST";
            end();
          }
           if (pBag1!=pBag2)
          {
            arc=new Link<T, U>(*arc);
            mWST->insertElement(arc);
            bag=bags->getElement(pBag1);
            bag->copyPaste(bags->getElement(pBag2));
            bags->removeNode(pBag2);
            found=true;
          }
        }
        p=this->getNext(p);
      }
}

    zap(bags);
    newMWST->nodes=this->nodes;// it is newMWST required, review, mWST may no t contain all nodes, why?
    newMWST->copyArcs(mWST);
    zap(mWST);
    return newMWST;
  };
  /*______________________________________________________________________________________*/
/*
  template<> CompleteGraph<Separator, Clique>::CompleteGraph(Set<Clique>* cliques):UGraph<Separator, Clique>()
  {
    floatList* weightList=NULL;
    Set<Clique>::iterator p1=NULL, p2=NULL;
    Set<Node>* commonNodes=NULL;
    ListOfPointers<Set<Node> >* listOfCommonNodes=NULL;
     CompleteGraph<Separator, Clique> *ug2=new CompleteGraph<Separator, Clique>(); 
     ug2->nodes=new Set<Clique>();
    for (int j=0; j<cliques->size(); j++)
    {
      p1=cliques->GetNode(j);
       if (p1==NULL || cliques->getElement(p1)==NULL)
	 {
	 cout <<"EEE";
	 end();
	 }
      cout <<"\nvals:" << cliques->getElement(p1)->print();
      weightList=new floatList();
      listOfCommonNodes=new ListOfPointers<Set<Node> >();
      
      for (int k=0; k<j; k++)
      {
        p2=cliques->GetNode(k);
	cliques->getElement(p2)->print(); 
       	//commonNodes=cliques->getElement(p1)->getCommonNodes(cliques->getElement(p2));
	 cout <<" - int:" << cliques->getElement(p1)->print();
    
	
	commonNodes=new Set<Node>(*cliques->getElement(p1));
	weightList->insertElement(commonNodes->size());
        listOfCommonNodes->insertElement(commonNodes);
	//cout <<"common nodes" << commonNodes->print() <<" has been inserted in list:\n " << listOfCommonNodes->print();
	//zap(commonNodes);
	//listOfCommonNodes->insertElement(new Set<Node>());
      }
   //   cout <<"common nodes:" << listOfCommonNodes->print();
      //cout <<"af";
        ug2->insertNode(cliques->getElement(p1), weightList, listOfCommonNodes);
	
        cout << ug2->print()<<"\n";
    
    //  zap(listOfCommonNodes);
      zap(weightList);
      }
      end();
      if (*cliques!=*ug2->nodes)
      {
      cout <<"Error in CompleteGraph(Set<Clique>* cliques), cliques are\n" << cliques->print() << " while nodes are \n" << ug2->nodes->print();
      end();
      }
      cout << ug2->print()<<"\n";
      //cout<<"LLL";
       end();

      this->nodes=cliques;
      this->UGraph<Separator, Clique>::copyArcs(ug2);
      zap(ug2->nodes);
      zap(ug2);
      cout <<this->print();
      end();

    }
 /*______________________________________________________________________________________*/

 //template <template<class T, class U> class Link, class T, class U>
template<>   
CompleteDGOfCliques::CompleteGraph(SetOfCliques* cliques):DirectedGraphOfCliques()
  {
  this->nodes=cliques;
  NodeSet* commonNodes=NULL;
  DirectedSeparatorOfCliques *s;
  SetOfCliques::iterator p1, p2;
  Clique *c1, *c2;
  SeparatorContent* separatorContent;
  for (int i=1;i<cliques->size();i++)
  {
   p1=this->nodes->getNode(i);
   c1=this->nodes->getElement(i);
   for (int j=0;j<i;j++)
   {
   p2=this->nodes->getNode(j);
   c2=this->nodes->getElement(j);
   commonNodes=c1->getCommonNodes(c2);
   separatorContent=new SeparatorContent(NULL, commonNodes);
   s=new DirectedSeparatorOfCliques(commonNodes->size(), p1, p2, separatorContent);
   this->Graph<DirectedArc, Clique*, SeparatorContent>::insertElement(s);
   }
 }
  }
};  // Fin del Namespace

#endif

/* Fin Fichero: CompleteGraph.h */
