/* File: CompleteGraph.h */


#ifndef __CompleteGraph_h__
#define __CompleteGraph_h__


namespace BIOS
{
  /************************/
  /* CompleteGraph DEFINITION */
  /************************/
  /**
          @memo CompleteGraph 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */
 template <template<class T, class U=int> class Link, class T, class U> 
class CompleteGraph: public Graph<Link, T, U>
  {
   typedef  typename Set<T>::Class::iterator PNode;
  public:

 CompleteGraph();
 ~CompleteGraph();
 CompleteGraph(typename Set<T>::Class* u);
 void insertNode(T node, floatList* weightList,  vector<typename Set<T>::Class >*listOfCommonNodes);
 void insertElement(Link<T, U>* arc);
 void insertNode(T node, floatList* weightList);
 typename UTree<T, U>::Class* getMWST();
  };  // End of class CompleteGraph




template<class T, class U>
  struct CompleteDG
  {
    typedef CompleteGraph<DirectedArc, T, U> Class;
  };


typedef CompleteDG<Clique*, SeparatorContent>::Class CompleteDGOfCliques;










};  // Fin del Namespace

#endif

/* Fin Fichero: CompleteGraph.h */
