/* File: DirectedArc.h */


#ifndef __DirectedArc_h__
#define __DirectedArc_h__


using namespace std;


namespace BIOS
{


  /************************/
  /* DirectedArc DEFINITION */
  /************************/


  /**
          @memo DirectedArc 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */


class SeparatorContent;

	template <class T, class U=int> class DirectedArc: public Arc<T, U>
  {

  public:

    typedef  typename Set<T>::Class::iterator PNode;



	  DirectedArc():Arc<T, U>(){this->directed=true;};


    DirectedArc(float w, PNode f, PNode s, U* description=NULL);
    DirectedArc(DirectedArc<T, U> & a);
   // DirectedArc(Arc<T> & a, PNode p1, PNode p2):Arc<T>(a, p1, p2){};
  
    virtual ~DirectedArc(){};

    virtual DirectedArc* clone();

    bool operator==(DirectedArc & directedArc)
    {
      return directedArc.first==this->first && directedArc.second==this->second && directedArc.weight==this->weight; 
    };

    bool hasSameNodes(DirectedArc * arc)
    {
      return (arc->first==this->first && arc->second==this->second);
     };

DirectedArc* fromString (string source)
{
throw NonImplemented("UndirectedArc::fromString (string source)");
 };



  };  // End of class DirectedArc

typedef DirectedArc<Node*, void>* SimpleDirectedArc;

//typedef DirectedArc<Clique*, SeparatorContent> DirectedSeparatorOfCliques;



/*
template<class T, class U>
  struct GrossDirectedArc
  {
    typedef DirectedArc<T, U> Class;
  };

typedef GrossDirectedArc<Clique*, SeparatorContent>::Class DirectedArcOfCliques;
*/


};  // Fin del Namespace

#endif

/* Fin Fichero: DirectedArc.h */
