/* File: Graph.h */


#ifndef __Graph_h__
#define __Graph_h__








//using namespace UTILS;


namespace BIOS
{


  /************************/
  /* Graph DEFINITION */
  /************************/


  /**
          @memo Graph 
   
  	@doc This is a restrictive class, in which only 1 arc is allowed between the same pair of vertex. Vertex are considered shared among different graphs. Thus, a graph is actually a set of arcs.

 Template Link can be matched with Arc.Thus, directed and undirected arcs will be allowed.
 Or they can be matched with UndirectedArc or with DirectedArc. 

 So far, two subclasses are defined: CompleteGraph (a graph with an arc between every pair of vertex) and AcyclicGraph (a graph with no cycles) 





      @author Maria Mar Abad Grau
  	@version 1.0
  */


  
  template <template<class T, class U> class Link, class T, class U=int> class Graph: public Set<Link<T, U>*>::Class
// U is to notate nodes
// ej: templates can be instantiated as Arc, int, int
  {
public:
  

   typedef  typename Set<T>::Class::iterator PNode;
   typedef  typename Graph<Link,T, U>::iterator PArc;

 

  public:
    typename Set<T>::Class* nodes;

  
    Graph();
    Graph(Graph & source);
    virtual ~Graph();
//    bool existUnweightedArc(Link<T, U>* arc);
    bool existArc(Link<T, U>* arc, bool anyway=false);

//    string print(bool forward=true);
  //  string print(T*arc);

    bool existNode(T node);
    void checkArc(Link<T, U>* arc);
    void insertElement(Link<T, U>* arc);
    bool existSecondNode(Link<T, U>* arc);
    bool formALoop(Link<T, U>* arc);
    bool formAChord(Link<T, U>* arc);
    bool existPath(PNode first, PNode second, bool anyway=false);
    void removeGraphNode(PNode node);
    void removeArc(Link<T, U>* arc);
    typename Set<T>::Class* getNodes();
			 void setNodes(typename Set<T>::Class* nodes);
//    T getFirst(Link<T, U>* arc);
//    T getSecond(Link<T, U>* arc);
    PArc getFirst();
    void complete(typename Set<T>::Class* nodes);
    typename Set<T>::Class* getNeighborhood(PNode node);
//    void removeNodeLinks(PNode node);
void copyArcs(Graph<Link, T, U>* target);
typename Set<T>::Class* getParents(PNode node);
typename Set<T>::Class* getChildren(PNode node);
typename Set<T>::Class* getNeighborhood(PNode node, int type);
int getTotalMissingConnections(PNode node);
intList* getTotalMissingConnections();
bool isAClique();
  };



template<class T, class U>
  struct DirectedGraph
  {
    typedef Graph<DirectedArc, T, U> Class;
  };


typedef DirectedGraph<Clique*, SeparatorContent>::Class DirectedGraphOfCliques;





 
};  // Fin del Namespace

#endif

/* Fin Fichero: Graph.h */
