/* File: Separator.h */


#ifndef __Separator_h__
#define __Separator_h__


using namespace std;


namespace BIOS
{


  /************************/
  /* EnrichedDirectedArc DEFINITION */
  /************************/


  /**
          @memo EnrichedDirectedArc 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */

// We wanted to use:
//template <class T>  typedef typename EnrichedDirectedArc<T, SeparatorContent> DirectedSeparator<T>;
//  template <class T>  EnrichedUndirectedArc<T, SeparatorContent>  UndirectedSeparator<T>;
// As Template Typedef is not allowed we use this trick
template<class T>
  struct DirectedSeparator
  {
    typedef DirectedArc<T, SeparatorContent> Class;
  };

template<class T>
  struct UndirectedSeparator
  {
    typedef UndirectedArc<T, SeparatorContent> Class;
  };


typedef UndirectedSeparator<Clique*>::Class UndirectedSeparatorOfCliques;
typedef DirectedSeparator<Clique*>::Class DirectedSeparatorOfCliques;
//typedef DirectedSeparatorOfCliques Separator;

template<> DirectedSeparatorOfCliques::DirectedArc(DirectedSeparatorOfCliques& ds):Arc<Clique*, SeparatorContent>(ds)
{
this->description=new SeparatorContent(*ds.description);
};
/*__________________________________________________________________________________*/


template<> DirectedArc<Clique*, SeparatorContent>::DirectedArc(float w, PNode f, PNode s, SeparatorContent* description):Arc<Clique*, SeparatorContent>(w, f, s, description)
{
this->description=new SeparatorContent(*description);
};

/*______________________________________________________*/

   ostream& operator<<(ostream& out, DirectedSeparatorOfCliques& p)
{
	out << "first clique: " << **p.getFirst();
if (*p.getSecond()==NULL) cout <<"NUUUU\n"; else
	out <<"weight: " << p.getWeight() <<"\n";
if (p.getDescription()==NULL)
throw NullValue("ostream& operator<<(ostream& out, DirectedSeparatorOfCliques& p)");
else
out <<"separatorContent: " << *p.getDescription() <<"\n";

	return out;
}

}
;  // Fin del Namespace

#endif

/* Fin Fichero: EnrichedDirectedArc.h */
