/* File: 
SingleAncestorGraph.cpp */


#ifndef __SingleAncestorGraph_cpp__
#define __SingleAncestorGraph_cpp__







//using namespace UTILS;


namespace BIOS
{


  /************************/
  /* SingleAncestorGraph DEFINITION */
  /************************/


  /**
          @memo SingleAncestorGraph 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */




 template <template<class T, class U> class Link, class T, class U>  class SingleAncestorGraph: public UnchordGraph<Link, T, U>
  {

   typedef typename Set<T>::Class::iterator PNode;

  private:


    
    PNode root;
  
  public:

    SingleAncestorGraph();
    virtual ~SingleAncestorGraph(){};
    void checkArc(Link<T, U>* arc);
    SingleAncestorGraph (UnchordGraph<Link, T, U> & pt, PNode root);
    SingleAncestorGraph (SingleAncestorGraph<Link, T, U> & pt);
   // SingleAncestorGraph(Set<Clique*>* cliques);
    bool isRoot(PNode node);
    PNode getRoot();
    void setRoot(PNode node);
    PNode getParent(PNode node);
		void insertElement(Link<T, U>* arc);
 //   void copyArcs(Tree<Link, T, U>* target);

  };


	 template <template<class T, class U> class Link, class T, class U>  SingleAncestorGraph<Link, T, U>::SingleAncestorGraph():UnchordGraph<Link, T, U>() 
{
this->nodes=new typename Set<T>::Class();
this->root=this->nodes->end();
};

/*______________________________________________________________________________________*/

	  template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::insertElement(Link<T, U>* arc)
    {
this->UnchordGraph<Link, T, U>::insertElement(arc);

          if (arc->getSecond()==root) root=arc->getFirst();
};
/*______________________________________________________________________________________*/

	  template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::checkArc(Link<T, U>* arc)
    {
      if (this->List==NULL)
      {
        root=arc->getFirst();
        SingleAncestorGraph<Link, T, U>::insertElement(arc);
      }
      else
        if (!existArc(arc))
        {
          if (existSecondNode(arc))
            {
              cout <<"Error, two parents are not allowed in SingleAncestorGraph::insertElement";
              exit(0);
              };
          if (!existNode(arc->getSecond()) && !existNode(arc->getFirst()))
            {
              cout <<"Error, isolated nodes are not allowed in SingleAncestorGraph::insertElement";
              exit(0);
            }
          

         }
     };
     /*__________________________________________________________________*/
/*
  template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::copyArcs(SingleAncestorGraph<Link, T, U>* target)
  {
    Graph<Link,T, U>::copyArcs(target);
    this->setRoot(target->getRoot());
    }
    /*______________________________________________________________________________________*/

	 template <template<class T, class U> class Link, class T, class U>  SingleAncestorGraph<Link, T, U>::SingleAncestorGraph(UnchordGraph<Link, T, U> & pt, PNode root): UnchordGraph<Link, T, U>(pt)
	  {
this->root=this->nodes->findEqualElement(*root);
//int rootPos=pt.nodes->getPosition(root);
  //    this->root=this->nodes->getNode(rootPos);  
	  };

    /*______________________________________________________________________________________*/

	 template <template<class T, class U> class Link, class T, class U>  SingleAncestorGraph<Link, T, U>::SingleAncestorGraph(SingleAncestorGraph<Link, T, U> & pt): UnchordGraph<Link, T, U>(pt)
	  {
this->root=this->nodes->findEqualElement(*pt.root);
	  };
  
    /*______________________________________________________________________________________*/

   template <template<class T, class U> class Link, class T, class U>  bool SingleAncestorGraph<Link, T, U>::isRoot(PNode node)
    {
     return (node==root);
    };
    	/*______________________________________________________________________________________*/

	 template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::setRoot(PNode node)
    {
     root=node;
    };
	/*______________________________________________________________________________________*/

	 template <template<class T, class U> class Link, class T, class U>  typename Set<T>::Class::iterator SingleAncestorGraph<Link, T, U>::getRoot()
    {
     return (root);
    };
    
    /*______________________________________________________________________________________*/

     template <template<class T, class U> class Link, class T, class U>  typename Set<T>::Class::iterator SingleAncestorGraph<Link, T, U>::getParent(PNode node)
     {
    typename Set<T>::Class* parents=getParents(node);
    PNode result=parents->getFirst();
    zap(parents);
    return result;
     };
 /*______________________________________________________________________________________*/
/*
     template <template<class T, class U> class Link, class T, class U>  int SingleAncestorGraph<Link, T, U>::getParent(int value)
     {
   //   typename Set<U>::iterator pN=this->nodes->findElement(node);
      typename SingleAncestorGraph<Link, T, U>::iterator p=this->getFirst();
      T* arc;
      while (p!=this->end())
      {
      arc=this->getElement(p);
      if (this->getSecond(arc)->getValue()==value)
       return this->getFirst(arc)->getValue();              
      p=getNext(p);
      }
	  return -1;
	  //cout <<"error in SingleAncestorGraph::getParent(node), it could be the root";
      //exit(0);
     };
    
     /*______________________________________________________________________________________*/
/*
  template<> SingleAncestorGraph<DirectedSeparator, Clique*>::SingleAncestorGraph(Set<Clique*>* cliques):UnchordGraph<Separator, Clique*>()
	  {// construct a junction SingleAncestorGraph
    CompleteUG<UndirectedSeparator, Clique*>* completeUGraph=new CompleteUG<UndirectedSeparator, Clique*>();
	  intList* cliqueList1, *cliqueList2, *commonCliques;
	  floatList* weightList=NULL;
	  Set<Clique*>::iterator p=cliques->getFirst(), p2;
          Set<Set<Node*>*>* separationList=NULL;
	  intList::iterator cP;
	  int c, i=0;
	  Clique* clique=NULL;	  
	  Set<Node*>* commonNodes=NULL; 
	  end();
	  while (p!=cliques->end())
	  {
	  p2=cliques->getFirst();
	  while (p2!=p && p2!=cliques->end())
	  {
	  weightList=new floatList();
	  commonNodes=cliques->getElement(p)->getCommonNodes(cliques->getElement(p2));
	  weightList->insertElement(commonNodes->size());
	  zap(commonNodes);
	  p2=cliques->getNext(p2);
	  }
	  completeUGraph->insertNode(clique, weightList);
	  zap(weightList);
	  p=cliques->getNext(p);
	  }
	  USingleAncestorGraph<UndirectedSeparator, Clique*>* uSingleAncestorGraph=completeUGraph->getMWST();
	  SingleAncestorGraph<DirectedSeparator, Clique*>* SingleAncestorGraph=uSingleAncestorGraph->getDirectedSingleAncestorGraph(uSingleAncestorGraph->nodes->getFirstElement(), DirectedSeparatorOfCliques);
	  zap(uSingleAncestorGraph);
	  zap(completeUGraph);
}
/*
  template<> SingleAncestorGraph<Separator, Clique>::SingleAncestorGraph(ListOfPointers<intList >* cliques)
	  {// construct a junction SingleAncestorGraph
          CompleteUG<Separator, Clique>* completeUGraph=new CompleteUG<Separator, Clique>();
	  intList* cliqueList1, *cliqueList2, *commonCliques;
	  floatList* weightList=NULL;
	  ListOfPointers<intList >::iterator p=cliques->getFirst(), p2=NULL;
          ListOfPointers<intList >* separationList=NULL;
	  intList::iterator cP;
	  int c, i=0;
	  Clique* clique=NULL;	  
	  ////////
	  while(p!=NULL)
	  {
	  p2=cliques->getFirst();
	  weightList=new floatList();
	  separationList=new ListOfPointers<intList >();
	  while(p2!=p)
	  {
	  cliqueList1=cliques->getElement(p);
	  cliqueList2=cliques->getElement(p2);
	  cP=cliqueList1->getFirst();
	  c=0;
	  commonCliques=new intList();
	  while (cP!=NULL)
	  {
	  if (cliqueList2->findElement(cliqueList1->getElement(cP))) 
	  {
	   commonCliques->insertElement(cliqueList1->getElement(cP));    
	   c++;
	  }
	  cP=cliqueList1->getNext(cP);
	  } 
	  weightList->insertElement(c);
	  separationList->insertElement(commonCliques);
  	  clique=new Clique(i, );
 	  p2=cliques->getNext(p2);
	  }	
          completeUGraph->insertNode(clique, weightList, separationList);
	  i++;
	  p=cliques->getNext(p);
	  }
	  ///////////////
	  USingleAncestorGraph<Separator, Clique>* uSingleAncestorGraph=completeUGraph->getMWST();
	  SingleAncestorGraph<Separator, Clique>* SingleAncestorGraph=uSingleAncestorGraph->getDirectedSingleAncestorGraph(uSingleAncestorGraph->nodes->getFirst());
	  zap(uSingleAncestorGraph);
	  zap(completeUGraph);
}
*/
}
;  // Fin del Namespace

#endif

/* Fin Fichero: SingleAncestorGraph.h */
