/* File:
Tree.h */


#ifndef __Tree_h__
#define __Tree_h__

//using namespace UTILS;


namespace BIOS
{
  /************************/
  /* Tree DEFINITION */
  /************************/
  /**
          @memo Tree 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */




// We wanted to use:
//template <class T>  typedef typename SingleAncestorGraph<DirectedArc, T> Tree<T>;
// As Template Typedef is not allowed we use this trick
template<class T, class U>
  struct Tree
  {
    typedef SingleAncestorGraph<DirectedArc, T, U> Class;
  };


typedef Tree<Clique*, SeparatorContent>::Class JunctionTree;

typedef Tree<Node*, void>::Class TANG;

/*______________________________________________________*/

/*
	 template <>  SingleAncestorGraph<DirectedArc, Clique*, SeparatorContent>::~SingleAncestorGraph()
   {
    for (SingleAncestorGraph<DirectedArc, Clique*, SeparatorContent>::iterator it=begin(); it!=end(); it++)
    zap(getElement(it)->getDescription());
   };
*/


/*______________________________________________________*/

ostream& operator<<(ostream& out, JunctionTree& p)
{
for (JunctionTree::iterator it=p.begin(); it!=p.end(); it++)
	out << *p.getElement(it);
	if (p.nodes!=NULL) 
 for (SetOfCliques::iterator it=p.nodes->begin(); it!=p.nodes->end(); it++)
out << *p.nodes->getElement(it);
	return out;
}





};
;  // Fin del Namespace

#endif

/* Fin Fichero: Tree.h */
