/* File: UnchordGraph.h */


#ifndef __UnchordGraph_h__
#define __UnchordGraph_h__



namespace BIOS
{


  /************************/
  /* UnchordGraph DEFINITION */
  /************************/


  /**
          @memo UnchordGraph 


	An UnchodGraph is an AcyclicGraph that after changing all directed arcs by undirected ones, still remains acyclic  


It has a subclass:  SingleAncestorGraph: those UnchodGraphs with only one ancestor (ancestors only have sense in directed arcs) 


 Some known topologies are defined using typedef:
 Tree: an UnchordGraph with only DirectedArc-s


   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */

template <template<class T, class U> class Link, class T, class U> 
 class UnchordGraph: public AcyclicGraph<Link, T, U>
  {


    /* PUBLIC FUNCTIONS (INTERFACE) */


  public:
  


	  UnchordGraph():AcyclicGraph<Link, T, U>(){};
	    UnchordGraph(UnchordGraph<Link, T, U>& uG):AcyclicGraph<Link, T, U>(uG){};

	  virtual ~UnchordGraph(){};


void checkArc(Link<T, U>* arc)
  {
try {
this->AcyclicGraph<Link, T, U>::checkArc(arc);

    if (this->formALoop(arc)==true)

    {
      cout <<"Error in Graph::insertElement, arc for nodes " << *arc->getFirst()  << " and " << *arc->getSecond() << " will form a chord in an Acyclic Graph, i.e., it will form a cycle if all directed arcs are changed by undirected arcs";
      cout << *this;
      exit(0);
    };
      }
      
     catch (NullValue NV ) {NV.PrintMessage("in UnchordGraph<T, U>::checkArc");}


  };


  } ;  // End of class UnchordGraph



}
;  // Fin del Namespace

#endif

/* Fin Fichero: UnchordGraph.h */
